/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate.reference;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.concurrent.Executor;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.reactive.Disposable;
import ninja.leaping.configurate.reactive.Subscriber;
import ninja.leaping.configurate.reference.ConfigurationReference;
import ninja.leaping.configurate.reference.ManualConfigurationReference;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class WatchingConfigurationReference<N extends ConfigurationNode>
extends ManualConfigurationReference<N>
implements Subscriber<WatchEvent<?>> {
    private volatile boolean saveSuppressed = false;
    private @MonotonicNonNull Disposable disposable;

    WatchingConfigurationReference(ConfigurationLoader<? extends N> loader, Executor taskExecutor) {
        super(loader, taskExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(N newNode) throws IOException {
        ConfigurationLoader configurationLoader = this.getLoader();
        synchronized (configurationLoader) {
            try {
                this.saveSuppressed = true;
                super.save(newNode);
            }
            finally {
                this.saveSuppressed = false;
            }
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.disposable != null) {
            this.disposable.dispose();
        }
    }

    @Override
    public void submit(WatchEvent<?> item) {
        if (!this.saveSuppressed || item.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
            try {
                this.load();
            }
            catch (Exception e) {
                this.errorListener.submit(Maps.immutableEntry(ConfigurationReference.ErrorPhase.LOADING, e));
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        this.errorListener.submit(Maps.immutableEntry(ConfigurationReference.ErrorPhase.UNKNOWN, e));
    }

    @Override
    public void onClose() {
        this.close();
    }

    void setDisposable(Disposable disposable) {
        this.disposable = disposable;
    }
}

