/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.backup;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.protocol.ecc.Curve;
import org.signal.libsignal.protocol.ecc.ECPrivateKey;
import org.signal.libsignal.protocol.kdf.HKDF;
import org.whispersystems.signalservice.api.backup.BackupId;
import org.whispersystems.signalservice.api.backup.MediaId;
import org.whispersystems.signalservice.api.backup.MediaName;
import org.whispersystems.signalservice.api.push.ServiceId;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0002$%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001b\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 J\u0018\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0014\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006&"}, d2={"Lorg/whispersystems/signalservice/api/backup/BackupKey;", "", "value", "", "([B)V", "getValue", "()[B", "deriveAnonymousCredentialPrivateKey", "Lorg/signal/libsignal/protocol/ecc/ECPrivateKey;", "aci", "Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;", "deriveBackupId", "Lorg/whispersystems/signalservice/api/backup/BackupId;", "deriveBackupId-yoT_BB8", "(Lorg/whispersystems/signalservice/api/push/ServiceId$ACI;)[B", "deriveBackupSecrets", "Lorg/whispersystems/signalservice/api/backup/BackupKey$BackupKeyMaterial;", "deriveMediaId", "Lorg/whispersystems/signalservice/api/backup/MediaId;", "mediaName", "Lorg/whispersystems/signalservice/api/backup/MediaName;", "deriveMediaId-dldBjvA", "(Ljava/lang/String;)[B", "deriveMediaSecrets", "Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial;", "mediaId", "deriveMediaSecrets-HAJV6QU", "([B)Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial;", "deriveMediaSecrets-C5cge48", "(Ljava/lang/String;)Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial;", "deriveMediaSecretsFromMediaId", "base64MediaId", "", "deriveThumbnailTransitKey", "thumbnailMediaName", "deriveThumbnailTransitKey-C5cge48", "BackupKeyMaterial", "MediaKeyMaterial", "signal-service-java"})
@SourceDebugExtension(value={"SMAP\nBackupKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupKey.kt\norg/whispersystems/signalservice/api/backup/BackupKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public final class BackupKey {
    @NotNull
    private final byte[] value;

    public BackupKey(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        if (!(this.value.length == 32)) {
            boolean bl = false;
            String string = "Backup key must be 32 bytes!";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] getValue() {
        return this.value;
    }

    @NotNull
    public final byte[] deriveBackupId-yoT_BB8(@NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        byte[] byArray = aci.toByteArray();
        String string = "20231003_Signal_Backups_GenerateBackupId";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = HKDF.deriveSecrets((byte[])this.value, (byte[])byArray, (byte[])byArray2, (int)16);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"deriveSecrets(...)");
        return BackupId.constructor-impl(byArray3);
    }

    @NotNull
    public final BackupKeyMaterial deriveBackupSecrets(@NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        byte[] backupId = this.deriveBackupId-yoT_BB8(aci);
        Object object = "20231003_Signal_Backups_EncryptMessageBackup";
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] extendedKey = HKDF.deriveSecrets((byte[])this.value, (byte[])backupId, (byte[])byArray, (int)80);
        Intrinsics.checkNotNull((Object)extendedKey);
        object = extendedKey;
        int n = 0;
        int n2 = 32;
        byte[] byArray2 = ArraysKt.copyOfRange((byte[])object, (int)n, (int)n2);
        object = extendedKey;
        n = 32;
        n2 = 64;
        return new BackupKeyMaterial(backupId, byArray2, ArraysKt.copyOfRange((byte[])object, (int)n, (int)n2), null);
    }

    @NotNull
    public final ECPrivateKey deriveAnonymousCredentialPrivateKey(@NotNull ServiceId.ACI aci) {
        Intrinsics.checkNotNullParameter((Object)aci, (String)"aci");
        byte[] byArray = aci.toByteArray();
        String string = "20231003_Signal_Backups_GenerateBackupIdKeyPair";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] material = HKDF.deriveSecrets((byte[])this.value, (byte[])byArray, (byte[])byArray2, (int)32);
        ECPrivateKey eCPrivateKey = Curve.decodePrivatePoint((byte[])material);
        Intrinsics.checkNotNullExpressionValue((Object)eCPrivateKey, (String)"decodePrivatePoint(...)");
        return eCPrivateKey;
    }

    @NotNull
    public final byte[] deriveMediaId-dldBjvA(@NotNull String mediaName) {
        Intrinsics.checkNotNullParameter((Object)mediaName, (String)"mediaName");
        byte[] byArray = MediaName.toByteArray-impl(mediaName);
        String string = "20231003_Signal_Backups_Media_ID";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = HKDF.deriveSecrets((byte[])this.value, (byte[])byArray, (byte[])byArray2, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"deriveSecrets(...)");
        return MediaId.constructor-impl(byArray3);
    }

    @NotNull
    public final MediaKeyMaterial deriveMediaSecrets-C5cge48(@NotNull String mediaName) {
        Intrinsics.checkNotNullParameter((Object)mediaName, (String)"mediaName");
        return this.deriveMediaSecrets-HAJV6QU(this.deriveMediaId-dldBjvA(mediaName));
    }

    @NotNull
    public final MediaKeyMaterial deriveMediaSecretsFromMediaId(@NotNull String base64MediaId) {
        Intrinsics.checkNotNullParameter((Object)base64MediaId, (String)"base64MediaId");
        return this.deriveMediaSecrets-HAJV6QU(MediaId.constructor-impl(base64MediaId));
    }

    @NotNull
    public final byte[] deriveThumbnailTransitKey-C5cge48(@NotNull String thumbnailMediaName) {
        Intrinsics.checkNotNullParameter((Object)thumbnailMediaName, (String)"thumbnailMediaName");
        byte[] byArray = this.deriveMediaId-dldBjvA(thumbnailMediaName);
        String string = "20240513_Signal_Backups_EncryptThumbnail";
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        byte[] byArray3 = HKDF.deriveSecrets((byte[])this.value, (byte[])byArray, (byte[])byArray2, (int)64);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"deriveSecrets(...)");
        return byArray3;
    }

    private final MediaKeyMaterial deriveMediaSecrets-HAJV6QU(byte[] mediaId) {
        Object object = "20231003_Signal_Backups_EncryptMedia";
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] extendedKey = HKDF.deriveSecrets((byte[])this.value, (byte[])mediaId, (byte[])byArray, (int)80);
        Intrinsics.checkNotNull((Object)extendedKey);
        object = extendedKey;
        int n = 0;
        int n2 = 32;
        byte[] byArray2 = ArraysKt.copyOfRange((byte[])object, (int)n, (int)n2);
        object = extendedKey;
        n = 32;
        n2 = 64;
        byte[] byArray3 = ArraysKt.copyOfRange((byte[])object, (int)n, (int)n2);
        object = extendedKey;
        n = 64;
        n2 = 80;
        return new MediaKeyMaterial(mediaId, byArray2, byArray3, ArraysKt.copyOfRange((byte[])object, (int)n, (int)n2), null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\r"}, d2={"Lorg/whispersystems/signalservice/api/backup/BackupKey$BackupKeyMaterial;", "", "id", "Lorg/whispersystems/signalservice/api/backup/BackupId;", "macKey", "", "cipherKey", "([B[B[BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCipherKey", "()[B", "getId-KN-5nHc", "[B", "getMacKey", "signal-service-java"})
    public static final class BackupKeyMaterial {
        @NotNull
        private final byte[] id;
        @NotNull
        private final byte[] macKey;
        @NotNull
        private final byte[] cipherKey;

        private BackupKeyMaterial(byte[] id, byte[] macKey, byte[] cipherKey) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)macKey, (String)"macKey");
            Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
            this.id = id;
            this.macKey = macKey;
            this.cipherKey = cipherKey;
        }

        @NotNull
        public final byte[] getId-KN-5nHc() {
            return this.id;
        }

        @NotNull
        public final byte[] getMacKey() {
            return this.macKey;
        }

        @NotNull
        public final byte[] getCipherKey() {
            return this.cipherKey;
        }

        public /* synthetic */ BackupKeyMaterial(byte[] id, byte[] macKey, byte[] cipherKey, DefaultConstructorMarker $constructor_marker) {
            this(id, macKey, cipherKey);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0010"}, d2={"Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial;", "", "id", "Lorg/whispersystems/signalservice/api/backup/MediaId;", "macKey", "", "cipherKey", "iv", "([B[B[B[BLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCipherKey", "()[B", "getId-tbqpaXg", "[B", "getIv", "getMacKey", "Companion", "signal-service-java"})
    public static final class MediaKeyMaterial {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final byte[] id;
        @NotNull
        private final byte[] macKey;
        @NotNull
        private final byte[] cipherKey;
        @NotNull
        private final byte[] iv;

        private MediaKeyMaterial(byte[] id, byte[] macKey, byte[] cipherKey, byte[] iv) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)macKey, (String)"macKey");
            Intrinsics.checkNotNullParameter((Object)cipherKey, (String)"cipherKey");
            Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
            this.id = id;
            this.macKey = macKey;
            this.cipherKey = cipherKey;
            this.iv = iv;
        }

        @NotNull
        public final byte[] getId-tbqpaXg() {
            return this.id;
        }

        @NotNull
        public final byte[] getMacKey() {
            return this.macKey;
        }

        @NotNull
        public final byte[] getCipherKey() {
            return this.cipherKey;
        }

        @NotNull
        public final byte[] getIv() {
            return this.iv;
        }

        @JvmStatic
        @NotNull
        public static final MediaKeyMaterial forMedia(@NotNull byte[] id, @NotNull byte[] keyMac, @NotNull byte[] iv) {
            return Companion.forMedia(id, keyMac, iv);
        }

        public /* synthetic */ MediaKeyMaterial(byte[] id, byte[] macKey, byte[] cipherKey, byte[] iv, DefaultConstructorMarker $constructor_marker) {
            this(id, macKey, cipherKey, iv);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007\u00a8\u0006\t"}, d2={"Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial$Companion;", "", "()V", "forMedia", "Lorg/whispersystems/signalservice/api/backup/BackupKey$MediaKeyMaterial;", "id", "", "keyMac", "iv", "signal-service-java"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final MediaKeyMaterial forMedia(@NotNull byte[] id, @NotNull byte[] keyMac, @NotNull byte[] iv) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)keyMac, (String)"keyMac");
                Intrinsics.checkNotNullParameter((Object)iv, (String)"iv");
                byte[] byArray = keyMac;
                int n = 32;
                int n2 = 64;
                byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
                byArray = keyMac;
                n = 0;
                n2 = 32;
                return new MediaKeyMaterial(MediaId.constructor-impl(id), byArray2, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2), iv, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

