/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.jsonrpc;

import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.asamk.signal.jsonrpc.SignalJsonRpcDispatcherHandler;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.output.JsonWriterImpl;
import org.asamk.signal.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketHandler
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(SocketHandler.class);
    private static final AtomicInteger threadNumber = new AtomicInteger(0);
    private final ServerSocketChannel serverChannel;
    private Thread listenerThread;
    private final List<AutoCloseable> channels = new ArrayList<AutoCloseable>();
    private final Consumer<SocketChannel> socketHandler;
    private final boolean noReceiveOnStart;

    public SocketHandler(ServerSocketChannel serverChannel, Manager m, boolean noReceiveOnStart) {
        this.serverChannel = serverChannel;
        this.socketHandler = channel -> this.getSignalJsonRpcDispatcherHandler((SocketChannel)channel).handleConnection(m);
        this.noReceiveOnStart = noReceiveOnStart;
    }

    public SocketHandler(ServerSocketChannel serverChannel, MultiAccountManager c, boolean noReceiveOnStart) {
        this.serverChannel = serverChannel;
        this.socketHandler = channel -> this.getSignalJsonRpcDispatcherHandler((SocketChannel)channel).handleConnection(c);
        this.noReceiveOnStart = noReceiveOnStart;
    }

    public void init() {
        SocketAddress socketAddress;
        if (this.listenerThread != null) {
            throw new AssertionError((Object)"SocketHandler already initialized");
        }
        try {
            socketAddress = this.serverChannel.getLocalAddress();
        }
        catch (IOException e) {
            logger.debug("Failed to get socket address: {}", (Object)e.getMessage());
            socketAddress = null;
        }
        Object address = socketAddress == null ? "<Unknown socket address>" : socketAddress;
        logger.debug("Starting JSON-RPC server on {}", address);
        this.listenerThread = Thread.ofPlatform().name("daemon-listener").start(() -> this.lambda$init$3((Serializable)address));
    }

    @Override
    public void close() throws Exception {
        if (this.listenerThread == null) {
            return;
        }
        this.serverChannel.close();
        for (AutoCloseable c : new ArrayList<AutoCloseable>(this.channels)) {
            c.close();
        }
        this.listenerThread.join();
        this.channels.clear();
        this.listenerThread = null;
    }

    private SignalJsonRpcDispatcherHandler getSignalJsonRpcDispatcherHandler(SocketChannel c) {
        Supplier<String> lineSupplier = IOUtils.getLineSupplier(Channels.newReader((ReadableByteChannel)c, StandardCharsets.UTF_8));
        JsonWriterImpl jsonOutputWriter = new JsonWriterImpl(Channels.newWriter((WritableByteChannel)c, StandardCharsets.UTF_8));
        return new SignalJsonRpcDispatcherHandler(jsonOutputWriter, lineSupplier, this.noReceiveOnStart);
    }

    private /* synthetic */ void lambda$init$3(Serializable address) {
        try (ExecutorService executor = Executors.newCachedThreadPool();){
            logger.info("Started JSON-RPC server on {}", (Object)address);
            while (true) {
                String clientString;
                SocketChannel channel;
                int connectionId = threadNumber.getAndIncrement();
                try {
                    channel = this.serverChannel.accept();
                    clientString = String.valueOf(channel.getRemoteAddress()) + " " + IOUtils.getUnixDomainPrincipal(channel);
                    logger.info("Accepted new client connection {}: {}", (Object)connectionId, (Object)clientString);
                }
                catch (ClosedChannelException ignored) {
                    logger.trace("Listening socket has been closed");
                    break;
                }
                catch (IOException e) {
                    logger.error("Failed to accept new socket connection", (Throwable)e);
                    break;
                }
                this.channels.add(channel);
                executor.submit(() -> {
                    try (SocketChannel c = channel;){
                        this.socketHandler.accept(c);
                    }
                    catch (IOException e) {
                        logger.warn("Failed to close channel", (Throwable)e);
                    }
                    catch (Throwable e) {
                        logger.warn("Connection handler failed, closing connection", e);
                    }
                    logger.info("Connection {} closed: {}", (Object)connectionId, (Object)clientString);
                    this.channels.remove(channel);
                });
            }
        }
    }
}

