/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.argparse4j.inf.Namespace;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdFormatException;
import org.asamk.signal.manager.api.InvalidNumberException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.ReceiveConfig;
import org.asamk.signal.manager.api.RecipientIdentifier;
import org.asamk.signal.util.DateUtils;

public class CommandUtil {
    private CommandUtil() {
    }

    public static Set<RecipientIdentifier> getRecipientIdentifiers(Manager m, boolean isNoteToSelf, List<String> recipientStrings, List<String> groupIdStrings, List<String> usernameStrings) throws UserErrorException {
        HashSet<RecipientIdentifier> recipientIdentifiers = new HashSet<RecipientIdentifier>();
        if (isNoteToSelf) {
            recipientIdentifiers.add((RecipientIdentifier)RecipientIdentifier.NoteToSelf.INSTANCE);
        }
        if (recipientStrings != null) {
            String localNumber = m.getSelfNumber();
            recipientIdentifiers.addAll(CommandUtil.getSingleRecipientIdentifiers(recipientStrings, localNumber));
        }
        if (groupIdStrings != null) {
            recipientIdentifiers.addAll(CommandUtil.getGroupIdentifiers(groupIdStrings));
        }
        if (usernameStrings != null) {
            recipientIdentifiers.addAll(CommandUtil.getUsernameIdentifiers(usernameStrings));
        }
        if (recipientIdentifiers.isEmpty()) {
            throw new UserErrorException("No recipients given");
        }
        return recipientIdentifiers;
    }

    public static Set<RecipientIdentifier.Group> getGroupIdentifiers(Collection<String> groupIdStrings) throws UserErrorException {
        if (groupIdStrings == null) {
            return Set.of();
        }
        HashSet<RecipientIdentifier.Group> groupIds = new HashSet<RecipientIdentifier.Group>();
        for (String groupIdString : groupIdStrings) {
            groupIds.add(new RecipientIdentifier.Group(CommandUtil.getGroupId(groupIdString)));
        }
        return groupIds;
    }

    public static Set<GroupId> getGroupIds(Collection<String> groupIdStrings) throws UserErrorException {
        if (groupIdStrings == null) {
            return Set.of();
        }
        HashSet<GroupId> groupIds = new HashSet<GroupId>();
        for (String groupIdString : groupIdStrings) {
            groupIds.add(CommandUtil.getGroupId(groupIdString));
        }
        return groupIds;
    }

    public static GroupId getGroupId(String groupId) throws UserErrorException {
        if (groupId == null) {
            return null;
        }
        try {
            return GroupId.fromBase64((String)groupId);
        }
        catch (GroupIdFormatException e) {
            throw new UserErrorException("Invalid group id: " + e.getMessage());
        }
    }

    public static Set<RecipientIdentifier.Single> getSingleRecipientIdentifiers(Collection<String> recipientStrings, String localNumber) throws UserErrorException {
        if (recipientStrings == null) {
            return Set.of();
        }
        HashSet<RecipientIdentifier.Single> identifiers = new HashSet<RecipientIdentifier.Single>();
        for (String recipientString : recipientStrings) {
            identifiers.add(CommandUtil.getSingleRecipientIdentifier(recipientString, localNumber));
        }
        return identifiers;
    }

    public static RecipientIdentifier.Single getSingleRecipientIdentifier(String recipientString, String localNumber) throws UserErrorException {
        try {
            return RecipientIdentifier.Single.fromString((String)recipientString, (String)localNumber);
        }
        catch (InvalidNumberException e) {
            throw new UserErrorException("Invalid phone number '" + recipientString + "': " + e.getMessage(), e);
        }
    }

    public static Set<RecipientIdentifier.Username> getUsernameIdentifiers(Collection<String> usernameIdStrings) {
        if (usernameIdStrings == null) {
            return Set.of();
        }
        HashSet<RecipientIdentifier.Username> usernameIds = new HashSet<RecipientIdentifier.Username>();
        for (String usernameIdString : usernameIdStrings) {
            usernameIds.add(new RecipientIdentifier.Username(usernameIdString));
        }
        return usernameIds;
    }

    public static String getCaptchaRequiredMessage(CaptchaRequiredException e, boolean captchaProvided) {
        Object message = !captchaProvided ? "Captcha required for verification, use --captcha CAPTCHA\nTo get the token, go to https://signalcaptchas.org/registration/generate.html\nAfter solving the captcha, right-click on the \"Open Signal\" link and copy the link." : "Invalid captcha given.";
        if (e.getNextAttemptTimestamp() > 0L) {
            message = (String)message + "\nNext Captcha may be provided at " + DateUtils.formatTimestamp(e.getNextAttemptTimestamp());
        }
        return message;
    }

    public static String getRateLimitMessage(RateLimitException e) {
        Object message = "Rate limit reached";
        if (e.getNextAttemptTimestamp() > 0L) {
            message = (String)message + "\nNext attempt may be tried at " + DateUtils.formatTimestamp(e.getNextAttemptTimestamp());
        }
        return message;
    }

    public static ReceiveConfig getReceiveConfig(Namespace ns) {
        boolean ignoreAttachments = Boolean.TRUE.equals(ns.getBoolean("ignore-attachments"));
        boolean ignoreStories = Boolean.TRUE.equals(ns.getBoolean("ignore-stories"));
        boolean sendReadReceipts = Boolean.TRUE.equals(ns.getBoolean("send-read-receipts"));
        return new ReceiveConfig(ignoreAttachments, ignoreStories, sendReadReceipts);
    }
}

