#!/bin/sh

# Copyright (C) 2010 Valery Reznic
# This file is part of the Elf Statifier project
# 
# This project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License.
# See LICENSE file in the doc directory.

[ $# -ne 2 -o "x$1" = "x" -o "x$2" = "x" ] && {
	echo "Usage: $0 <Input> <Output>" 1>&2
	exit 1
}

Input=$1
Output=$2

awk -vName="$0" -vInput="$Input" -vAP='"' '
	BEGIN {
		print "/*"
		print " * Do not change this file. It was generated by " AP Name AP " from " AP Input AP
		print " */"
		count = 0
	}
	{
		if ($1 ~ "#") next;
		if (NF == 0)  next;
		
		R[count] = $1
		C[count] = ","
		count++
	}
	END {
		C[count] = ""
		for (i = 0; i < count; i++) {
			print "\t" AP R[i] AP C[i + 1]
		}
	}
' < $Input > $Output || exit
exit 0
