/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.SpellLikeAbility;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.FormulaResolvingFacet;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.cdom.facet.SpellsFacet;
import pcgen.cdom.facet.base.AbstractItemFacet;
import pcgen.cdom.facet.base.AbstractSourcedListFacet;
import pcgen.cdom.facet.event.DataFacetChangeEvent;
import pcgen.cdom.facet.event.DataFacetChangeListener;
import pcgen.cdom.facet.model.DeityFacet;
import pcgen.cdom.facet.model.RaceFacet;
import pcgen.cdom.facet.model.TemplateFacet;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellBook;
import pcgen.core.character.SpellInfo;

public class ActiveSpellsFacet
extends AbstractSourcedListFacet<CharID, CharacterSpell>
implements DataFacetChangeListener<CharID, CDOMObject> {
    private RaceFacet raceFacet;
    private DeityFacet deityFacet;
    private TemplateFacet templateFacet;
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private FormulaResolvingFacet formulaResolvingFacet;
    private SpellsFacet spellsFacet;

    @Override
    protected Map<CharacterSpell, Set<Object>> getComponentMap() {
        return new TreeMap<CharacterSpell, Set<Object>>();
    }

    @Override
    public void dataAdded(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.process(dfce.getCharID());
    }

    public void process(CharID id) {
        Race race = (Race)((AbstractItemFacet)this.raceFacet).get(id);
        this.removeAll(id, race);
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        for (SpellLikeAbility sla : this.spellsFacet.getQualifiedSet(id)) {
            Formula times = sla.getCastTimes();
            int resolvedTimes = this.formulaResolvingFacet.resolve(id, times, sla.getQualifiedKey()).intValue();
            String book = sla.getSpellBook();
            CharacterSpell cs = new CharacterSpell(race, sla.getSpell());
            cs.setFixedCasterLevel(sla.getFixedCasterLevel());
            SpellInfo si = cs.addInfo(0, resolvedTimes, book);
            si.setTimeUnit(sla.getCastTimeUnit());
            si.setFixedDC(sla.getDC());
            pc.addSpellBook(new SpellBook(book, 4));
            this.add(id, cs, race);
        }
    }

    @Override
    public void dataRemoved(DataFacetChangeEvent<CharID, CDOMObject> dfce) {
        this.process(dfce.getCharID());
    }

    public void setRaceFacet(RaceFacet raceFacet) {
        this.raceFacet = raceFacet;
    }

    public void setDeityFacet(DeityFacet deityFacet) {
        this.deityFacet = deityFacet;
    }

    public void setFormulaResolvingFacet(FormulaResolvingFacet formulaResolvingFacet) {
        this.formulaResolvingFacet = formulaResolvingFacet;
    }

    public void setSpellsFacet(SpellsFacet spellsFacet) {
        this.spellsFacet = spellsFacet;
    }

    public void setTemplateFacet(TemplateFacet templateFacet) {
        this.templateFacet = templateFacet;
    }

    public void init() {
        this.raceFacet.addDataFacetChangeListener(this);
        this.deityFacet.addDataFacetChangeListener(this);
        this.templateFacet.addDataFacetChangeListener(this);
    }
}

