/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.Ability;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.spell.Spell;
import pcgen.util.Delta;

public class EqModSpellInfo {
    private static final String s_CHARGES = "CHARGES";

    public static String getSpellInfoString(String listEntry, String desiredInfo) {
        int offs = listEntry.indexOf(desiredInfo + "[");
        int offs2 = listEntry.indexOf(93, offs + 1);
        if (offs >= 0 && offs2 > offs) {
            return listEntry.substring(offs + desiredInfo.length() + 1, offs2);
        }
        return "";
    }

    public static int getSpellInfo(String listEntry, String desiredInfo) {
        int modValue = 0;
        String info = EqModSpellInfo.getSpellInfoString(listEntry, desiredInfo);
        if (info.length() > 0) {
            try {
                modValue = Delta.parseInt(info);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return modValue;
    }

    public static void setRemainingCharges(Equipment parent, EquipmentModifier eqMod, int remainingCharges) {
        if (parent.hasAssociations(eqMod)) {
            List<String> assoc = parent.removeAllAssociations(eqMod);
            String listEntry = assoc.get(0);
            String chargeInfo = EqModSpellInfo.getSpellInfoString(listEntry, s_CHARGES);
            if (chargeInfo.length() != 0) {
                chargeInfo = "CHARGES[" + chargeInfo + ']';
                int idx = listEntry.indexOf(chargeInfo);
                listEntry = listEntry.substring(0, idx) + listEntry.substring(idx + chargeInfo.length());
                listEntry = listEntry + "CHARGES[" + Integer.toString(remainingCharges) + ']';
                assoc.set(0, listEntry);
            }
            for (String s : assoc) {
                parent.addAssociation(eqMod, s);
            }
        }
    }

    public static int getRemainingCharges(Equipment parent, EquipmentModifier eqMod) {
        if (parent.hasAssociations(eqMod)) {
            return EqModSpellInfo.getSpellInfo(parent.getFirstAssociation(eqMod), s_CHARGES);
        }
        return 0;
    }

    public static int getUsedCharges(Equipment parent, EquipmentModifier eqMod) {
        return eqMod.get(IntegerKey.MAX_CHARGES) - EqModSpellInfo.getRemainingCharges(parent, eqMod);
    }

    public static void setSpellInfo(Equipment parent, EquipmentModifier eqMod, CDOMObject spellCastingClass, Spell theSpell, String spellVariant, String spellType, int spellLevel, int spellCasterLevel, Object[] spellMetamagicFeats, int charges) {
        StringBuilder spellInfo = new StringBuilder(100);
        spellInfo.append("SPELLNAME[").append(theSpell.getKeyName()).append("] ");
        spellInfo.append("CASTER[").append(spellCastingClass.getKeyName()).append("] ");
        if (spellVariant.length() != 0) {
            spellInfo.append("VARIANT[").append(spellVariant).append("] ");
        }
        spellInfo.append("SPELLTYPE[").append(spellType).append("] ");
        spellInfo.append("SPELLLEVEL[").append(spellLevel).append("] ");
        spellInfo.append("CASTERLEVEL[").append(spellCasterLevel).append("] ");
        if (charges > 0) {
            spellInfo.append(s_CHARGES).append('[').append(charges).append("] ");
        }
        if (spellMetamagicFeats != null && spellMetamagicFeats.length > 0) {
            spellInfo.append("METAFEATS[");
            for (int i = 0; i < spellMetamagicFeats.length; ++i) {
                Ability aFeat = (Ability)spellMetamagicFeats[i];
                if (i != 0) {
                    spellInfo.append(", ");
                }
                spellInfo.append(aFeat.getKeyName());
            }
            spellInfo.append("] ");
        }
        parent.addAssociation(eqMod, spellInfo.toString());
    }
}

