/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.system;

import pcgen.core.utils.CoreUtility;

public class MigrationRule {
    private ObjectType objectType;
    private String oldKey;
    private String newKey;
    private String oldCategory;
    private String newCategory;
    private String maxVer;
    private String maxDevVer;
    private String minVer;
    private String minDevVer;

    public MigrationRule(ObjectType objectType, String oldCategory, String oldKey) {
        if (!objectType.isCategorized()) {
            throw new IllegalArgumentException((Object)((Object)objectType) + " must not have a category.");
        }
        this.objectType = objectType;
        this.oldCategory = oldCategory;
        this.oldKey = oldKey;
    }

    public MigrationRule(ObjectType objectType, String oldKey) {
        if (objectType.isCategorized()) {
            throw new IllegalArgumentException((Object)((Object)objectType) + " must have a category.");
        }
        this.objectType = objectType;
        this.oldKey = oldKey;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(ObjectType objectType) {
        this.objectType = objectType;
    }

    public String getOldKey() {
        return this.oldKey;
    }

    public void setOldKey(String oldKey) {
        this.oldKey = oldKey;
    }

    public String getNewKey() {
        return this.newKey;
    }

    public void setNewKey(String newKey) {
        this.newKey = newKey;
    }

    public String getOldCategory() {
        return this.oldCategory;
    }

    public void setOldCategory(String oldCategory) {
        this.oldCategory = oldCategory;
    }

    public String getNewCategory() {
        return this.newCategory;
    }

    public void setNewCategory(String newCategory) {
        this.newCategory = newCategory;
    }

    public String getMaxVer() {
        return this.maxVer;
    }

    public void setMaxVer(String maxVer) {
        this.maxVer = maxVer;
    }

    public String getMaxDevVer() {
        return this.maxDevVer;
    }

    public void setMaxDevVer(String maxDevVer) {
        this.maxDevVer = maxDevVer;
    }

    public String getMinVer() {
        return this.minVer;
    }

    public void setMinVer(String minVer) {
        this.minVer = minVer;
    }

    public String getMinDevVer() {
        return this.minDevVer;
    }

    public void setMinDevVer(String minDevVer) {
        this.minDevVer = minDevVer;
    }

    public boolean changeAppliesToVer(int[] pcgVer) {
        int[] maxVerInt = CoreUtility.convertVersionToNumber(this.maxVer);
        if (CoreUtility.compareVersions(pcgVer, maxVerInt) > 0) {
            if (this.maxDevVer == null) {
                return false;
            }
            int[] maxDevVerInt = CoreUtility.convertVersionToNumber(this.maxDevVer);
            if (CoreUtility.compareVersions(pcgVer, maxDevVerInt) > 0 || !CoreUtility.sameMajorMinorVer(pcgVer, maxDevVerInt)) {
                return false;
            }
        }
        if (this.minVer != null) {
            int[] minDevVerInt;
            int[] minVerInt = CoreUtility.convertVersionToNumber(this.minVer);
            if (CoreUtility.compareVersions(pcgVer, minVerInt) < 0) {
                return false;
            }
            if (this.minDevVer != null && CoreUtility.compareVersions(pcgVer, minDevVerInt = CoreUtility.convertVersionToNumber(this.minDevVer)) < 0 && CoreUtility.sameMajorMinorVer(pcgVer, minDevVerInt)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "MigrationRule [objectType=" + (Object)((Object)this.objectType) + ", oldKey=" + this.oldKey + ", maxVer=" + this.maxVer + "]";
    }

    public static enum ObjectType {
        ABILITY(true),
        EQUIPMENT(false),
        RACE(false),
        SOURCE(false),
        SPELL(false);

        private final boolean categorized;

        private ObjectType(boolean categorized) {
            this.categorized = categorized;
        }

        public boolean isCategorized() {
            return this.categorized;
        }
    }
}

