/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.term;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pcgen.core.Globals;
import pcgen.core.PCStat;
import pcgen.core.term.TermEvaluator;
import pcgen.core.term.TermEvaluatorBuilder;
import pcgen.core.term.TermEvaluatorBuilderEQVar;
import pcgen.core.term.TermEvaluatorBuilderPCStat;
import pcgen.core.term.TermEvaluatorBuilderPCVar;
import pcgen.core.term.TermEvaulatorException;
import pcgen.util.Logging;

public class EvaluatorFactory {
    Pattern internalVarPattern;
    Map<String, TermEvaluatorBuilder> BuilderStore;
    private Map<String, TermEvaluator> SrcNeutralEvaluatorStore = new HashMap<String, TermEvaluator>();
    private Map<String, Map<String, TermEvaluator>> SrcDependantEvaluatorStore = new HashMap<String, Map<String, TermEvaluator>>();
    public static final EvaluatorFactory PC = new EvaluatorFactory(true, TermEvaluatorBuilderPCVar.values());
    public static final EvaluatorFactory EQ = new EvaluatorFactory(false, TermEvaluatorBuilderEQVar.values());

    private EvaluatorFactory(boolean addStats, TermEvaluatorBuilder[] termEvaluatorBuilders) {
        TermEvaluatorBuilder[] evals = addStats ? EvaluatorFactory.addStatBuilder(termEvaluatorBuilders) : termEvaluatorBuilders;
        this.BuilderStore = new TreeMap<String, TermEvaluatorBuilder>();
        StringBuilder sb = new StringBuilder("^(");
        boolean add = false;
        for (TermEvaluatorBuilder e : evals) {
            String[] keys;
            if (add) {
                sb.append("|");
            } else {
                add = true;
            }
            sb.append(e.getTermConstructorPattern());
            for (String k : keys = e.getTermConstructorKeys()) {
                this.BuilderStore.put(k, e);
            }
        }
        sb.append(")");
        this.internalVarPattern = Pattern.compile(sb.toString());
    }

    private static TermEvaluatorBuilder[] addStatBuilder(TermEvaluatorBuilder[] builderArray) {
        int end = builderArray.length;
        TermEvaluatorBuilder[] tempArray = new TermEvaluatorBuilder[end + 1];
        System.arraycopy(builderArray, 0, tempArray, 0, end);
        tempArray[end] = EvaluatorFactory.makeStatBuilder();
        return tempArray;
    }

    private static TermEvaluatorBuilder makeStatBuilder() {
        Collection<PCStat> stats = Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCStat.class);
        LinkedList<String> s = new LinkedList<String>();
        StringBuilder pSt = new StringBuilder(stats.size() * 4 + 6);
        pSt.append("(?:");
        boolean add1 = false;
        for (PCStat stat : stats) {
            if (add1) {
                pSt.append("|");
            } else {
                add1 = true;
            }
            pSt.append(stat.getKeyName());
            s.add(stat.getKeyName());
        }
        pSt.append(")");
        return new TermEvaluatorBuilderPCStat(pSt.toString(), s.toArray(new String[s.size()]), false);
    }

    private TermEvaluator makeTermEvaluator(String term, String source) {
        block4: {
            Matcher mat = this.internalVarPattern.matcher(term);
            if (mat.find()) {
                String matchedPortion = mat.group(1);
                TermEvaluatorBuilder f = this.BuilderStore.get(matchedPortion);
                try {
                    if (f.isEntireTerm() && term.length() != matchedPortion.length()) {
                        return null;
                    }
                    return f.getTermEvaluator(term, source, matchedPortion);
                }
                catch (TermEvaulatorException e) {
                    if (!Logging.isDebugMode()) break block4;
                    Logging.log(Logging.DEBUG, e.toString());
                }
            }
        }
        return null;
    }

    public TermEvaluator getTermEvaluator(String term, String source) {
        TermEvaluator evaluator;
        Map<String, TermEvaluator> inner = this.SrcDependantEvaluatorStore.get(term);
        if (inner == null ? (evaluator = this.SrcNeutralEvaluatorStore.get(term)) != null : (evaluator = inner.get(source)) != null) {
            return evaluator;
        }
        evaluator = this.makeTermEvaluator(term, source);
        if (evaluator == null) {
            return null;
        }
        if (evaluator.isSourceDependant()) {
            HashMap<String, TermEvaluator> i = this.SrcDependantEvaluatorStore.get(term);
            HashMap<String, TermEvaluator> j = i == null ? new HashMap<String, TermEvaluator>() : i;
            j.put(source, evaluator);
            this.SrcDependantEvaluatorStore.put(term, j);
        } else {
            this.SrcNeutralEvaluatorStore.put(term, evaluator);
        }
        return evaluator;
    }
}

