/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util;

import java.util.Observable;
import java.util.Observer;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.MessageWrapper;
import pcgen.facade.core.UIDelegate;

public class ShowMessageGuiObserver
implements Observer {
    private final UIDelegate uiDelegate;

    public ShowMessageGuiObserver(UIDelegate uiDelegate) {
        this.uiDelegate = uiDelegate;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof MessageWrapper) {
            this.showMessageDialog((MessageWrapper)arg);
        }
    }

    public void showMessageDialog(MessageWrapper messageWrapper) {
        MessageType mt = messageWrapper.getMessageType();
        String title = messageWrapper.getTitle();
        if (title == null) {
            title = "PCGen";
        }
        String message = String.valueOf(messageWrapper.getMessage());
        if (mt.equals(MessageType.WARNING)) {
            this.uiDelegate.showWarningMessage(title, message);
        } else if (mt.equals(MessageType.ERROR)) {
            this.uiDelegate.showErrorMessage(title, message);
        } else {
            this.uiDelegate.showInfoMessage(title, message);
        }
    }
}

