/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import pcgen.core.PlayerCharacter;
import pcgen.core.VariableProcessor;
import pcgen.persistence.lst.LstUtils;
import pcgen.system.PluginLoader;
import pcgen.util.PCGenCommand;

public final class PJEP
extends JEP {
    private Object parent;
    private String variableSource;
    private static List<Class<PCGenCommand>> commandList = new ArrayList<Class<PCGenCommand>>();
    private List<PCGenCommand> localCommandList = new ArrayList<PCGenCommand>();

    public static void addCommand(Class<PCGenCommand> clazz) {
        commandList.add(clazz);
    }

    public static PluginLoader getJepPluginLoader() {
        return new PluginLoader(){

            public void loadPlugin(Class clazz) throws Exception {
                PJEP.addCommand(clazz);
            }

            public Class[] getPluginClasses() {
                return new Class[]{PCGenCommand.class};
            }
        };
    }

    public PJEP() {
        this.setAllowUndeclared(true);
        this.addStandardFunctions();
        for (Class<PCGenCommand> aClass : commandList) {
            try {
                PCGenCommand com = aClass.newInstance();
                this.localCommandList.add(com);
                this.addFunction(com.getFunctionName().toLowerCase(), (PostfixMathCommandI)com);
                this.addFunction(com.getFunctionName().toUpperCase(), (PostfixMathCommandI)com);
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.addFunction("cl", (PostfixMathCommandI)new ClassLevel());
        this.addVariable("TRUE", 1.0);
        this.addVariable("FALSE", 0.0);
    }

    public Node parseExpression(String expression_in) {
        if (this.updateVariables()) {
            this.initSymTab();
        }
        return super.parseExpression(expression_in);
    }

    public boolean isResultCachable() {
        return this.isResultCachable(this.getTopNode());
    }

    public boolean isResultCachable(Node node) {
        PCGenCommand cmd;
        ASTFunNode funcNode;
        if (node instanceof ASTFunNode && (funcNode = (ASTFunNode)node).getPFMC() instanceof PCGenCommand && !(cmd = (PCGenCommand)funcNode.getPFMC()).getCachable()) {
            return false;
        }
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (this.isResultCachable(node.jjtGetChild(i))) continue;
            return false;
        }
        return true;
    }

    private boolean updateVariables() {
        boolean updated = true;
        if (this.localCommandList != null) {
            for (PCGenCommand com : this.localCommandList) {
                updated = updated && !com.updateVariables(this);
            }
        }
        return updated;
    }

    @Deprecated
    protected String getVariableSource() {
        return this.variableSource;
    }

    protected void setVariableSource(String variableSource) {
        this.variableSource = variableSource;
        for (PCGenCommand com : this.localCommandList) {
            com.setVariableSource(variableSource);
        }
    }

    public void setParent(Object parent) {
        this.parent = parent;
        for (PCGenCommand com : this.localCommandList) {
            com.setParent(parent);
        }
    }

    @Deprecated
    private final class ClassLevel
    extends PostfixMathCommand {
        private ClassLevel() {
            this.numberOfParameters = -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(Stack inStack) throws ParseException {
            Object param1;
            String src;
            LstUtils.deprecationWarning("Jep function cl deprecated, use classlevel instead");
            this.checkStack(inStack);
            int paramCount = this.curNumberOfParameters;
            if (paramCount == 0 && (src = PJEP.this.getVariableSource()).startsWith("CLASS:")) {
                src = src.substring(6);
                inStack.push(src);
                ++paramCount;
            }
            Integer param2 = null;
            if (paramCount == 1) {
                param1 = inStack.pop();
            } else {
                if (paramCount != 2) throw new ParseException("Invalid parameter count");
                param2 = (Integer)inStack.pop();
                param1 = inStack.pop();
                if (!(param2 instanceof Integer)) {
                    if (!(param2 instanceof Double)) throw new ParseException("Invalid parameter type");
                    param2 = ((Double)((Object)param2)).intValue();
                }
            }
            if (!(param1 instanceof String)) throw new ParseException("Invalid parameter type");
            PlayerCharacter aPC = null;
            if (PJEP.this.parent instanceof VariableProcessor) {
                aPC = ((VariableProcessor)PJEP.this.parent).getPc();
            } else if (PJEP.this.parent instanceof PlayerCharacter) {
                aPC = (PlayerCharacter)PJEP.this.parent;
            }
            if (aPC == null) {
                throw new ParseException("Invalid parent (no PC): " + PJEP.this.parent.getClass().getName());
            }
            String cl = (String)param1;
            if (param2 != null) {
                cl = cl + ";BEFORELEVEL=" + ((Object)param2).toString();
            }
            inStack.push(new Double(aPC.getClassLevelString(cl, false)));
        }
    }
}

