/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.awt.Container;
import java.awt.GridLayout;

public class DiceBagGridLayout
extends GridLayout {
    public static final int MANAGE_BY_COLUMNS = 1;
    public static final int MANAGE_BY_ROWS = 0;
    private int m_manageBy = 1;
    private int m_maxSize = 0;
    private int m_minSize = 0;

    public DiceBagGridLayout() {
        this.m_manageBy = 0;
        this.m_minSize = 50;
        this.m_maxSize = 200;
    }

    public DiceBagGridLayout(int rows, int cols, int manageBy, int minSize, int maxSize) {
        super(rows, cols);
        this.m_manageBy = manageBy;
        this.m_minSize = minSize;
        this.m_maxSize = maxSize;
    }

    public DiceBagGridLayout(int rows, int cols, int hgap, int vgap, int manageBy, int minSize, int maxSize) {
        super(rows, cols, hgap, vgap);
        this.m_manageBy = manageBy;
        this.m_minSize = minSize;
        this.m_maxSize = maxSize;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.m_manageBy == 1) {
            int minWCols = (int)Math.floor((parent.getWidth() - this.getHgap() - parent.getInsets().left - parent.getInsets().right) / (this.m_minSize + this.getHgap()));
            int maxWCols = (int)Math.floor((parent.getWidth() - this.getHgap() - parent.getInsets().left - parent.getInsets().right) / (this.m_maxSize + this.getHgap()));
            if (minWCols < this.getColumns() && minWCols > 0) {
                this.setColumns(minWCols);
            } else if (maxWCols > this.getColumns() && maxWCols <= parent.getComponentCount()) {
                this.setColumns(maxWCols);
            }
        } else if (this.m_manageBy == 0) {
            int minWRows = (int)Math.floor((parent.getHeight() - this.getVgap() - parent.getInsets().top - parent.getInsets().bottom) / (this.m_minSize + this.getVgap()));
            int maxWRows = (int)Math.floor((parent.getHeight() - this.getVgap() - parent.getInsets().top - parent.getInsets().bottom) / (this.m_maxSize + this.getVgap()));
            if (minWRows < this.getRows() && minWRows > 0) {
                this.setRows(minWRows);
            } else if (maxWRows > this.getRows() && maxWRows <= parent.getComponentCount()) {
                this.setRows(maxWRows);
            }
        }
        super.layoutContainer(parent);
    }
}

