/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.BiographyField;
import pcgen.cdom.enumeration.FactKey;
import pcgen.cdom.enumeration.FactSetKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Deity;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialAbility;
import pcgen.core.WeaponProf;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.Token;
import pcgen.util.Logging;

public class DeityToken
extends Token {
    public static final String TOKENNAME = "DEITY";

    @Override
    public String getTokenName() {
        return TOKENNAME;
    }

    @Override
    public String getToken(String tokenSource, PlayerCharacter pc, ExportHandler eh) {
        String retString = "";
        CharacterDisplay display = pc.getDisplay();
        Deity deity = display.getDeity();
        if (deity != null) {
            StringTokenizer aTok = new StringTokenizer(tokenSource, ".", false);
            String subTag = "OUTPUTNAME";
            if (aTok.countTokens() > 1) {
                aTok.nextToken();
                subTag = aTok.nextToken();
            }
            if ("NAME".equals(subTag)) {
                if (!display.getSuppressBioField(BiographyField.DEITY)) {
                    retString = deity.getDisplayName();
                }
            } else if ("OUTPUTNAME".equals(subTag)) {
                if (!display.getSuppressBioField(BiographyField.DEITY)) {
                    retString = OutputNameFormatting.getOutputName(deity);
                }
            } else if ("DOMAINLIST".equals(subTag)) {
                retString = DeityToken.getDomainListToken(deity);
            } else if ("FOLLOWERALIGNMENT".equals(subTag)) {
                Logging.errorPrint("Output Sheet uses DEITY.FOLLOWERALIGN: Function has been removed from PCGen");
            } else if ("ALIGNMENT".equals(subTag)) {
                CDOMSingleRef<PCAlignment> al = deity.get(ObjectKey.ALIGNMENT);
                retString = al == null ? "" : al.resolvesTo().getKeyName();
            } else if ("APPEARANCE".equals(subTag)) {
                FactKey fk = FactKey.valueOf("Appearance");
                String str = (String)deity.getResolved(fk);
                retString = str == null ? "" : str;
            } else if ("DESCRIPTION".equals(subTag)) {
                retString = pc.getDescription(deity);
            } else if ("HOLYITEM".equals(subTag)) {
                FactKey fk = FactKey.valueOf("Symbol");
                String str = (String)deity.getResolved(fk);
                retString = str == null ? "" : str;
            } else if ("FAVOREDWEAPON".equals(subTag)) {
                List<CDOMReference<WeaponProf>> dwp = deity.getSafeListFor(ListKey.DEITYWEAPON);
                retString = ReferenceUtilities.joinLstFormat(dwp, "|", true);
            } else if ("PANTHEONLIST".equals(subTag)) {
                FactSetKey fk = FactSetKey.valueOf("Pantheon");
                TreeSet pset = new TreeSet();
                for (ObjectContainer oc : deity.getSafeSetFor(fk)) {
                    pset.addAll(oc.getContainedObjects());
                }
                retString = StringUtil.join(pset, (String)", ");
            } else if ("SOURCE".equals(subTag)) {
                retString = SourceFormat.getFormattedString(deity, Globals.getSourceDisplay(), true);
            } else if ("SA".equals(subTag)) {
                retString = DeityToken.getSAToken(deity, display);
            } else if ("TITLE".equals(subTag)) {
                FactKey fk = FactKey.valueOf("Title");
                String str = (String)deity.getResolved(fk);
                retString = str == null ? "" : str;
            } else if ("WORSHIPPERS".equals(subTag)) {
                FactKey fk = FactKey.valueOf("Worshippers");
                String str = (String)deity.getResolved(fk);
                retString = str == null ? "" : str;
            }
        }
        return retString;
    }

    public static String getDomainListToken(Deity deity) {
        return ReferenceUtilities.joinDisplayFormat(deity.getSafeListMods(Deity.DOMAINLIST), ", ");
    }

    public static String getSAToken(Deity deity, CharacterDisplay display) {
        ArrayList<SpecialAbility> saList = new ArrayList<SpecialAbility>();
        saList.addAll(display.getResolvedUserSpecialAbilities(deity));
        saList.addAll(display.getResolvedSpecialAbilities(deity));
        if (saList.isEmpty()) {
            return "";
        }
        StringBuilder returnString = new StringBuilder();
        boolean firstLine = true;
        for (SpecialAbility sa : saList) {
            if (!firstLine) {
                returnString.append(", ");
            }
            firstLine = false;
            returnString.append(sa.getDisplayName());
        }
        return returnString.toString();
    }
}

