/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.test;

import pcgen.cdom.base.CDOMObject;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.prereq.AbstractDisplayPrereqTest;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.util.Logging;

public class PreDomainTester
extends AbstractDisplayPrereqTest
implements PrerequisiteTest {
    private static final Class<Domain> DOMAIN_CLASS = Domain.class;

    @Override
    public int passes(Prerequisite prereq, CharacterDisplay display, CDOMObject source) {
        int runningTotal;
        int number = 0;
        try {
            number = Integer.parseInt(prereq.getOperand());
        }
        catch (NumberFormatException e) {
            Logging.errorPrintLocalised("PreDomain.error.bad_operand", prereq.toString());
        }
        if (prereq.getKey().equalsIgnoreCase("ANY")) {
            runningTotal = display.getDomainCount();
        } else {
            Domain domain = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(DOMAIN_CLASS, prereq.getKey());
            boolean hasDomain = domain != null && display.hasDomain(domain);
            runningTotal = hasDomain ? 1 : 0;
        }
        runningTotal = prereq.getOperator().compare(runningTotal, number);
        return this.countedTotal(prereq, runningTotal);
    }

    @Override
    public String kindHandled() {
        return "DOMAIN";
    }
}

