/*
 * Decompiled with CFR 0.152.
 */
package plugin.notes.gui;

import gmgen.gui.PreferencesPanel;
import gmgen.util.LogUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import pcgen.core.SettingsHandler;
import pcgen.system.LanguageBundle;

public class PreferencesNotesPanel
extends PreferencesPanel {
    private static final String OPTION_NAME_NOTES_DATA = "Notes.DataDir";
    private static final String OPTION_NAME_LOG = "Logging.On";
    private JPanel dirPanel;
    private JPanel loggingPanel;
    private JTextField dataDirField;
    private JCheckBox logging;
    private JButton browseButton;

    public PreferencesNotesPanel() {
        this.initComponents();
        this.initPreferences();
    }

    public void applyPreferences() {
        SettingsHandler.setGMGenOption((String)OPTION_NAME_NOTES_DATA, (String)this.getDataDir());
        SettingsHandler.setGMGenOption((String)OPTION_NAME_LOG, (boolean)this.isLogging());
        LogUtilities.inst().setLogging(this.isLogging());
    }

    public void initPreferences() {
        this.setDataDir(SettingsHandler.getGMGenOption((String)OPTION_NAME_NOTES_DATA, (String)(SettingsHandler.getGmgenPluginDir().toString() + File.separator + "Notes")));
        this.setLogging(SettingsHandler.getGMGenOption((String)OPTION_NAME_LOG, (boolean)false));
    }

    private void setDataDir(String dir) {
        this.dataDirField.setText(dir);
    }

    private String getDataDir() {
        return this.dataDirField.getText();
    }

    private boolean isLogging() {
        return this.logging.isSelected();
    }

    private void setLogging(boolean isLogging) {
        this.logging.setSelected(isLogging);
    }

    public String toString() {
        return LanguageBundle.getString((String)"in_plugin_notes_general");
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.dirPanel = new JPanel();
        this.loggingPanel = new JPanel();
        this.dataDirField = new JTextField();
        this.logging = new JCheckBox();
        this.browseButton = new JButton(LanguageBundle.getString((String)"..."));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesNotesPanel.this.browseButtonActionPerformed(e);
            }
        });
        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new GridBagLayout());
        this.dirPanel = new JPanel(new GridBagLayout());
        this.dirPanel.setBorder(new TitledBorder(LanguageBundle.getString((String)"in_plugin_notes_sourceDir")));
        JLabel locationLabel = new JLabel(LanguageBundle.getString((String)"in_plugin_notes_dataLocation"));
        GridBagConstraints c = new GridBagConstraints();
        this.dirPanel.add((Component)locationLabel, c);
        c.fill = 2;
        c.weightx = 1.0;
        this.dirPanel.add((Component)this.dataDirField, c);
        c.fill = 0;
        c.weightx = 0.0;
        this.dirPanel.add((Component)this.browseButton, c);
        this.loggingPanel = new JPanel();
        this.loggingPanel.setLayout(new BorderLayout());
        this.loggingPanel.setBorder(new TitledBorder(LanguageBundle.getString((String)"in_plugin_notes_client")));
        this.logging.setText(LanguageBundle.getString((String)"in_plugin_notes_logGameData"));
        this.loggingPanel.add((Component)this.logging, "Center");
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 0;
        borderPanel.add((Component)this.dirPanel, c);
        borderPanel.add((Component)this.loggingPanel, c);
        c.weighty = 1.0;
        c.fill = 3;
        borderPanel.add((Component)new JPanel(), c);
        JScrollPane jScrollPane1 = new JScrollPane();
        jScrollPane1.setViewportView(borderPanel);
        this.add(jScrollPane1, "Center");
    }

    protected void browseButtonActionPerformed(ActionEvent e) {
        JFileChooser dlg = new JFileChooser(this.getDataDir());
        dlg.setFileSelectionMode(1);
        if (dlg.showOpenDialog((Component)((Object)this)) == 0) {
            this.setDataDir(dlg.getSelectedFile().getAbsolutePath());
        }
    }
}

