/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class RepeatlevelToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "REPEATLEVEL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate template, String value) {
        int iLevel;
        int maxLevel;
        int consecutive;
        int lvlIncrement;
        ParseResult pr = this.checkForIllegalSeparator(':', value);
        if (!pr.passed()) {
            return pr;
        }
        int endRepeat = value.indexOf(":");
        if (endRepeat < 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (No Colon): " + value, context);
        }
        int endLevel = value.indexOf(":", endRepeat + 1);
        if (endLevel < 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Only One Colon): " + value, context);
        }
        int endAssignType = value.indexOf(":", endLevel + 1);
        if (endAssignType == -1) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Only Two Colons): " + value, context);
        }
        String repeatedInfo = value.substring(0, endRepeat);
        StringTokenizer repeatToken = new StringTokenizer(repeatedInfo, "|");
        if (repeatToken.countTokens() != 3) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (incorrect PIPE count in repeat): " + repeatedInfo, context);
        }
        String levelIncrement = repeatToken.nextToken();
        try {
            lvlIncrement = Integer.parseInt(levelIncrement);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Level Increment was not an Integer): " + levelIncrement, context);
        }
        if (lvlIncrement <= 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Level Increment was <= 0): " + lvlIncrement, context);
        }
        String consecutiveString = repeatToken.nextToken();
        try {
            consecutive = Integer.parseInt(consecutiveString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Consecutive Value was not an Integer): " + consecutiveString, context);
        }
        if (consecutive < 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Consecutive String was <= 0): " + consecutive, context);
        }
        String maxLevelString = repeatToken.nextToken();
        try {
            maxLevel = Integer.parseInt(maxLevelString);
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Max Level was not an Integer): " + maxLevelString, context);
        }
        if (maxLevel <= 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Max Level was <= 0): " + maxLevel, context);
        }
        String levelString = value.substring(endRepeat + 1, endLevel);
        try {
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Level was not a number): " + levelString, context);
        }
        if (iLevel <= 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Level was <= 0): " + iLevel, context);
        }
        if (iLevel > maxLevel) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Starting Level was > Maximum Level)", context);
        }
        if (iLevel + lvlIncrement > maxLevel) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (Does not repeat, Staring Level + Increment > Maximum Level)", context);
        }
        if (consecutive != 0 && (maxLevel - iLevel) / lvlIncrement < consecutive) {
            ComplexParseResult cpr = new ComplexParseResult();
            cpr.addErrorMessage("Malformed " + this.getTokenName() + " Token (Does not use Skip Interval value): " + consecutive);
            cpr.addErrorMessage("  You should set the interval to zero");
            return cpr;
        }
        String typeStr = value.substring(endLevel + 1, endAssignType);
        String contentStr = value.substring(endAssignType + 1);
        PCTemplate consolidator = new PCTemplate();
        consolidator.put(IntegerKey.CONSECUTIVE, Integer.valueOf(consecutive));
        consolidator.put(IntegerKey.MAX_LEVEL, Integer.valueOf(maxLevel));
        consolidator.put(IntegerKey.LEVEL_INCREMENT, Integer.valueOf(lvlIncrement));
        consolidator.put(IntegerKey.START_LEVEL, Integer.valueOf(iLevel));
        context.getObjectContext().addToList((CDOMObject)template, ListKey.REPEATLEVEL_TEMPLATES, (Object)consolidator);
        context.getReferenceContext().getManufacturer(PCTemplate.class).addDerivativeObject((Loadable)consolidator);
        int count = consecutive;
        for (iLevel = Integer.parseInt(levelString); iLevel <= maxLevel; iLevel += lvlIncrement) {
            if (consecutive == 0 || count != 0) {
                PCTemplate derivative = new PCTemplate();
                derivative.put(IntegerKey.LEVEL, Integer.valueOf(count));
                context.getReferenceContext().getManufacturer(PCTemplate.class).addDerivativeObject((Loadable)derivative);
                context.getObjectContext().addToList((CDOMObject)consolidator, ListKey.LEVEL_TEMPLATES, (Object)derivative);
                try {
                    if (!context.processToken((Loadable)derivative, typeStr, contentStr)) {
                        return ParseResult.INTERNAL_ERROR;
                    }
                }
                catch (PersistenceLayerException e) {
                    return new ParseResult.Fail(e.getMessage(), context);
                }
            }
            if (consecutive == 0) continue;
            if (count == 0) {
                count = consecutive;
                continue;
            }
            --count;
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.REPEATLEVEL_TEMPLATES);
        Collection added = changes.getAdded();
        if (added == null || added.isEmpty()) {
            return null;
        }
        TreeSet<String> list = new TreeSet<String>();
        for (PCTemplate agg : added) {
            StringBuilder sb = new StringBuilder();
            Integer consecutive = agg.get(IntegerKey.CONSECUTIVE);
            Integer maxLevel = agg.get(IntegerKey.MAX_LEVEL);
            Integer lvlIncrement = agg.get(IntegerKey.LEVEL_INCREMENT);
            Integer iLevel = agg.get(IntegerKey.START_LEVEL);
            sb.append(lvlIncrement).append("|");
            sb.append(consecutive).append("|");
            sb.append(maxLevel).append(":");
            sb.append(iLevel).append(":");
            Changes subchanges = context.getObjectContext().getListChanges((CDOMObject)agg, ListKey.LEVEL_TEMPLATES);
            Collection perAddCollection = subchanges.getAdded();
            if (perAddCollection == null || perAddCollection.isEmpty()) {
                context.addWriteMessage("Invalid Consolidator built in " + this.getTokenName() + ": had no subTemplates");
                return null;
            }
            PCTemplate next = (PCTemplate)perAddCollection.iterator().next();
            Collection unparse = context.unparse((Object)next);
            if (unparse == null) continue;
            int masterLength = sb.length();
            for (String str : unparse) {
                sb.setLength(masterLength);
                list.add(sb.append(str).toString());
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

