//**************************************************************************************************
//                                          FrmMain.hpp                                            *
//                                         -------------                                           *
// Description : The main frame used to contain the applications display objects.                  *
// Started     : 2003-08-18                                                                        *
// Last Update : 2020-10-27                                                                        *
// Copyright   : (C) 2003-2020 MSWaters                                                            *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef FRMMAIN_HPP
#define FRMMAIN_HPP

// Application Includes

#include "Version.hpp"
#include "TypeDefs.hpp"
#include "Config.hpp"
#include "SysScan.hpp"

#include "main/FileTasks.hpp"
#include "main/NbkTxtCtls.hpp"
#include "main/DlgPrefs.hpp"

#include "netlist/NetList.hpp"
#include "netlist/SimnNgSpice.hpp"
#include "netlist/SimnGnuCap.hpp"

#include "process/PrcSchem.hpp"
#include "process/PrcNgSpice.hpp"
#include "process/PrcGnuCap.hpp"
#include "process/PrcDataVwr.hpp"
#include "process/PrcCalc.hpp"
#include "process/PrcPdfVwr.hpp"

#include "gnucap/NbkGnuCap.hpp"
#include "ngspice/NbkNgSpice.hpp"

// wxWidgets Includes

#include <wx/config.h>
#include <wx/process.h>
#include <wx/cursor.h>
#include <wx/tooltip.h>
#include <wx/gbsizer.h>
#include <wx/progdlg.h>

//**************************************************************************************************

class FrmMain : public wxFrame
{
  private :

    // Define an enumerated type for the different status bar panes
    enum eTypePane
    {
      ePANE_MESAGE = 0,   // Message strings
      ePANE_SIMENG = 1,   // Simulation engine
      ePANE_EDATLS = 2,   // EDA tool suite
      ePANE_DATVWR = 3,   // Waveform data viewer

      ePANE_LAST = ePANE_DATVWR
    };

   // Define an enumerated type for the different dialogue message types
    enum eTypeDlgMsg
    {
      eDMSG_INFO  = 0,
      eDMSG_WARN  = 1,
      eDMSG_ERROR = 2
    };

    // Object attributes
    bool            m_bIsOpen;         // Flag indicating when the frame has closed
    uint            m_uiFrmLayout;     // Indicator of which main frame layout to use

    FileTasks       m_oFileTasks;      // Class to handler file operations

    NetList         m_oNetLst;         // The netlist object
    SimnNgSpice     m_oSimnNgSpice;    // NG-Spice simulation object
    SimnGnuCap      m_oSimnGnuCap;     // GNU-Cap  simulation object
    SimnBase      * m_poSimn;          // A pointer to the simulation object

    PrcSimEngBase * m_poPrcSimEng;     // Pointer to the simulator engine process
    PrcSchem        m_oPrcSchem;       // Process object to schematic capture application
    PrcDataVwr      m_oPrcDataVwr;     // Process object to data viewer application
    PrcCalc         m_oPrcCalculator;  // Process object to calculator application
    PrcPdfVwr       m_oPrcManUser;     // Process object to view gSpiceUI PDF documentation
    PrcPdfVwr       m_oPrcManNgSpice;  // Process object to view NG-SPICE PDF documentation
    PrcPdfVwr       m_oPrcManGnuCap;   // Process object to view GNU-CAP  PDF documentation

    // Display control objects
    NbkSimEngBase * m_poNbkSimEng;     // Pointer to the simulation engine notebook
    wxLabel         m_oLblNodes;       // Label above the test nodes list
    wxListBox       m_oLbxNodes;       // List of possible test nodes
    wxLabel         m_oLblCpnts;       // Label above the test components list
    wxListBox       m_oLbxCpnts;       // List of possible test components
    NbkTxtCtls      m_oNbkTxtCtls;     // Notebook containing the text controls

    // Object initialization functions
    void  Initialize     ( void );
    void  InitMenuBar    ( void );
    void  InitToolBar    ( void );
    void  InitLstBoxs    ( void );
    void  InitNbkTCtls   ( void );
    void  InitStatBar    ( void );
    void  InitToolTips   ( void );
    void  InitSimEng     ( void );
    void  InitLogFiles   ( void );
    void  InitPosnSize   ( void );
    void  InitCalculator ( void );
    void  InitPdfViewer  ( void );
    void  InitInstallPath( void );
    void  DoLayout       ( void );

	  // Read / write simulation information from / to file
    bool  bSimnLoad  ( void );
    bool  bSimnReload( void );
    bool  bSimnSave  ( void );

    void  LockGUI( bool bEnable );  // Lock GUI controls

  public :

    explicit  FrmMain( const wxApp * poApp=NULL );
             ~FrmMain( );

    bool  bIsOpen( void ) { return( m_bIsOpen ); }

    bool  bClear( void );  // Clear the object attributes

    // Display a dialogue containing an error message
    void  DlgMsg( eTypeDlgMsg eMsgType, const wxString & rosMsg,
                                                          const wxString & rosTitle=wxEmptyString );
  private :

    // Event handlers
    void  OnOpen      ( wxCommandEvent & roEvtCmd   );
    void  OnImport    ( wxCommandEvent & roEvtCmd   );
    void  OnReload    ( wxCommandEvent & roEvtCmd   );
    void  OnClose     ( wxCommandEvent & roEvtCmd   );
    void  OnQuit      ( wxCommandEvent & roEvtCmd   );
    void  OnSimCreate ( wxCommandEvent & roEvtCmd   );
    void  OnSimRun    ( wxCommandEvent & roEvtCmd   );
    void  OnSimStop   ( wxCommandEvent & roEvtCmd   );
    void  OnSchematic ( wxCommandEvent & roEvtCmd   );
    void  OnViewData  ( wxCommandEvent & roEvtCmd   );
    void  OnCalculator( wxCommandEvent & roEvtCmd   );
    void  OnSelSimEng ( wxCommandEvent & roEvtCmd   );
    void  OnSelEDA_TS ( wxCommandEvent & roEvtCmd   );
    void  OnSelDataVwr( wxCommandEvent & roEvtCmd   );
    void  OnPrefs     ( wxCommandEvent & roEvtCmd   );
    void  OnManUser   ( wxCommandEvent & roEvtCmd   );
    void  OnManNgSpice( wxCommandEvent & roEvtCmd   );
    void  OnManGnuCap ( wxCommandEvent & roEvtCmd   );
    void  OnAbout     ( wxCommandEvent & roEvtCmd   );
    void  OnToolEnter ( wxCommandEvent & roEvtCmd   );
    void  OnSysExit   ( wxCloseEvent   & roEvtClose );

    // Declare friend classes
    friend  class  App_gSpiceUI;
    friend  class  FileTasks;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eFrmItemID
    {
      ID_MNU_OPEN = 1,
      ID_MNU_IMPORT,
      ID_MNU_RELOAD,
      ID_MNU_CLOSE,
      ID_MNU_QUIT,
      ID_MNU_CREATE,
      ID_MNU_RUN,
      ID_MNU_STOP,
      ID_MNU_SCHEM,
      ID_MNU_VIEWDATA,
      ID_MNU_CALC,
      ID_MNU_NGSPICE,
      ID_MNU_GNUCAP,
      ID_MNU_LEPTON,
      ID_MNU_GEDAGAF,
      ID_MNU_GAW,
      ID_MNU_GWAVE,
      ID_MNU_KST,
      ID_MNU_PREFS,
      ID_MNU_MAN_USER,
      ID_MNU_MAN_NGSP,
      ID_MNU_MAN_GCAP,
      ID_MNU_ABOUT,

      ID_TBR_OPEN,
      ID_TBR_IMPORT,
      ID_TBR_RELOAD,
      ID_TBR_CLOSE,
      ID_TBR_CREATE,
      ID_TBR_RUN,
      ID_TBR_STOP,
      ID_TBR_SCHEM,
      ID_TBR_VIEWER,
      ID_TBR_CALC,
      ID_TBR_PREFS,
      ID_TBR_HELP,
      ID_TBR_FST = ID_TBR_OPEN,
      ID_TBR_LST = ID_TBR_HELP,

      ID_LBX_NODES,
      ID_LBX_CPNTS,

      ID_NBK_ANALYSIS,
      ID_NBK_TXTCTRLS,

      ID_UNUSED,      // Assigned to controls for which events are not used
    };

    // Leave this as the last line as private access is envoked by this macro
    wxDECLARE_EVENT_TABLE( );
};

//**************************************************************************************************

#endif // FRMMAIN_HPP
