/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2020 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Fractal formula created by Buddhi

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbulb3.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 Mandelbulb3Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	Q_UNUSED(fractal);

	aux->DE = aux->DE * 2.0f * aux->r;

	REAL temp, tempR;

	REAL sign = 1.0f;
	REAL sign2 = 1.0f;

	if (z.x < 0.0f) sign2 = -1.0f;
	tempR = native_sqrt(z.x * z.x + z.y * z.y); //+ 1e-030f
	z *= 1.0f / tempR;
	temp = z.x * z.x - z.y * z.y;
	z.y = 2.0f * z.x * z.y;
	z.x = temp;
	z *= tempR;

	if (z.x < 0.0f) sign = -1.0f;
	tempR = native_sqrt(z.x * z.x + z.z * z.z); //+ 1e-030f
	z *= 1.0f / tempR;
	temp = z.x * z.x - z.z * z.z;
	z.z = 2.0f * z.x * z.z * sign2;
	z.x = temp * sign;
	z *= tempR;

	z *= aux->r;
	return z;
}