/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * TransfDifsTorusTwistIteration  fragmentarium code, mdifs by knighty (jan 2012)
 * M3D difs code by darkbeam
 * and http://www.iquilezles.org/www/articles/distfunctions/distfunctions.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_menger_pyramid.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MengerPyramidIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL temp;
	REAL ang;
	// polyfold
	if (fractal->transformCommon.functionEnabledCFalse
			&& aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC1)
	{
		if (fractal->transformCommon.functionEnabledCxFalse)
		{
			z.y = fabs(z.y);
			ang = M_PI_F / fractal->transformCommon.int8X;
			ang = fabs(fmod(atan2(z.y, z.x) + ang, 2.0f * ang) - ang);
			temp = native_sqrt(z.x * z.x + z.y * z.y);
			z.x = native_cos(ang) * temp;
			z.y = native_sin(ang) * temp;
		}
		if (fractal->transformCommon.functionEnabledCyFalse)
		{
			z.z = fabs(z.z);
			ang = M_PI_F / fractal->transformCommon.int8Y;
			ang = fabs(fmod(atan2(z.z, z.y) + ang, 2.0f * ang) - ang);
			temp = native_sqrt(z.y * z.y + z.z * z.z);
			z.y = native_cos(ang) * temp;
			z.z = native_sin(ang) * temp;
		}
		if (fractal->transformCommon.functionEnabledCzFalse)
		{
			z.x = fabs(z.x);
			ang = M_PI_F / fractal->transformCommon.int8Z;
			ang = fabs(fmod(atan2(z.x, z.z) + ang, 2.0f * ang) - ang);
			temp = native_sqrt(z.z * z.z + z.x * z.x);
			z.z = native_cos(ang) * temp;
			z.x = native_sin(ang) * temp;
		}
		// addition constant
		z += fractal->transformCommon.additionConstant000;
	}

	if (aux->i >= fractal->transformCommon.startIterationsP
			&& aux->i < fractal->transformCommon.stopIterationsP1)
	{
		// pre abs
		if (fractal->transformCommon.functionEnabledx)
		{
			if (!fractal->transformCommon.functionEnabledBxFalse)
				z.x = fabs(z.x);
			else
				z.x = -fabs(z.x);
		}
		if (fractal->transformCommon.functionEnabledy)
		{
			if (!fractal->transformCommon.functionEnabledByFalse)
				z.y = fabs(z.y);
			else
				z.y = -fabs(z.y);
		}
		if (fractal->transformCommon.functionEnabledzFalse)
		{
			if (!fractal->transformCommon.functionEnabledBzFalse)
				z.z = fabs(z.z);
			else
				z.z = -fabs(z.z);
		}
		// addition constant
		z.x += fractal->transformCommon.offsetA05;
		z.y += fractal->transformCommon.offsetB05;
		z.z += fractal->transformCommon.offset0;

		z.x += z.z * fractal->transformCommon.scale05;
		z.y += z.z * fractal->transformCommon.offset05;

		if (fractal->transformCommon.functionEnabledAFalse)
		{
			aux->DE *= native_sqrt(z.x * z.x + z.y * z.y);
		}
	}

	if (fractal->transformCommon.functionEnabledDFalse
			&& aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD1)
	{
		if (!fractal->transformCommon.functionEnabledOFalse)
			ang = atan2(z.x, z.y);
		else
			ang = atan2(z.y, z.x);
		ang *= M_PI_2x_INV_F * fractal->transformCommon.scaleA1;

		if (fractal->transformCommon.functionEnabledM)
			z.y = native_sqrt(z.x * z.x + z.y * z.y) - fractal->transformCommon.radius1;

		if (fractal->transformCommon.functionEnabledBFalse)
		{
			z.y += z.z * fractal->transformCommon.scaleC0;
		}

		// stretch
		if (fractal->transformCommon.functionEnabledAyFalse)
		{
			if (!fractal->transformCommon.functionEnabledAy)
				z.x = fractal->transformCommon.offsetR1;
			else
			{
				temp = fractal->transformCommon.scaleA2 * ang + fractal->transformCommon.offsetR1;
				z.x = temp - 2.0f * floor(temp * 0.5f) - 1.0f;
			}
		}

		// vert
		if (fractal->transformCommon.functionEnabledAxFalse)
		{
			REAL Voff = fractal->transformCommon.offsetA2;
			temp = z.z - Voff * 0.5f;
			z.z = temp - Voff * floor(temp / Voff) - Voff * 0.5f;
		}

		// twist
		if (fractal->transformCommon.functionEnabledAzFalse)
		{
			if (fractal->transformCommon.functionEnabledAwFalse)
			{
				REAL Phi = z.z;
				REAL Rho = native_sqrt(z.x * z.x + z.y * z.y);

				ang = Rho * fractal->transformCommon.offsetA0 + Phi * fractal->transformCommon.offsetB0
							+ fractal->transformCommon.offsetC0;
			}
			REAL cosA = native_cos(ang);
			REAL sinB = native_sin(ang);
			if (!fractal->transformCommon.functionEnabledNFalse)
			{
				temp = z.x;
				z.x = z.y * cosA + z.x * sinB;
			}
			else
			{
				temp = z.z;
				z.z = z.y * cosA + z.z * sinB;
			}
			z.y = temp * cosA - z.y * sinB;
		}
	}

	// repeat
	if (fractal->transformCommon.functionEnabledMFalse
			&& aux->i >= fractal->transformCommon.startIterationsTM
			&& aux->i < fractal->transformCommon.stopIterationsTM1)
	{
		if ((z.z < (fractal->transformCommon.scaleB1 + 0.5f) * fractal->transformCommon.offset2)
				&& (z.z > (fractal->transformCommon.offsetT1 + 0.5f) * -fractal->transformCommon.offset2))
		{
			z.z -= round(z.z / fractal->transformCommon.offset2) * fractal->transformCommon.offset2;
			z.z = clamp(fabs(z.z), -fractal->transformCommon.offset1, fractal->transformCommon.offset1);
		}
	}

	// clip
	if (fractal->transformCommon.functionEnabledJFalse
			&& aux->i >= fractal->transformCommon.startIterationsT
			&& aux->i < fractal->transformCommon.stopIterationsT1)
	{
		if (fractal->transformCommon.functionEnabledEFalse)
			z.z = max(aux->const_c.z - fractal->transformCommon.offsetE0, z.z);

		if (fractal->transformCommon.functionEnabledFFalse)
			z.z = min(aux->const_c.z + fractal->transformCommon.offsetF0, -z.z);
	}

	int count = fractal->transformCommon.int1; // Menger Sponge
	int k;
	for (k = 0; k < count; k++)
	{
		// menger sponge
		z = fabs(z);
		// rotation
		if (k >= fractal->transformCommon.startIterationsR
				&& k < fractal->transformCommon.stopIterationsR1)
		{
			z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
		}

		REAL col = 0.0f;
		if (z.x < z.y)
		{
			temp = z.y;
			z.y = z.x;
			z.x = temp;
			col += fractal->foldColor.difs0000.x;
		}
		if (z.x < z.z)
		{
			temp = z.z;
			z.z = z.x;
			z.x = temp;
			col += fractal->foldColor.difs0000.y;
		}
		if (z.y < z.z)
		{
			temp = z.z;
			z.z = z.y;
			z.y = temp;
			col += fractal->foldColor.difs0000.z;
		}
		if (fractal->foldColor.auxColorEnabledFalse && k >= fractal->foldColor.startIterationsA
				&& k < fractal->foldColor.stopIterationsA)
		{
			aux->color += col;
		}

		// z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix2, z);

		z.z = fabs(z.z - FRAC_1_3_F * fractal->transformCommon.offset111.z)
					+ FRAC_1_3_F * fractal->transformCommon.offset111.z;
		z = z * fractal->transformCommon.scale3
				- fractal->transformCommon.offset111 * (fractal->transformCommon.scale3 - 1.0f);
		aux->DE = aux->DE * fractal->transformCommon.scale3;

		// Analytic DE tweak
		if (fractal->analyticDE.enabledFalse)
			aux->DE = aux->DE * fractal->analyticDE.scale1 + fractal->analyticDE.offset1;
	}

	if (fractal->transformCommon.functionEnabledPFalse)
	{
		REAL4 zc = z;
		REAL4 d = fabs(zc);
		d.x = max(d.x - fractal->transformCommon.offsetA1, 0.0f);
		d.y = max(d.y - fractal->transformCommon.offset01, 0.0f);
		d.z = max(d.z - fractal->transformCommon.offsetp1, 0.0f);

		REAL rDE;
		{
			if (!fractal->transformCommon.functionEnabledTFalse)
			{
				rDE = max(d.x, max(d.y, d.z));
			}
			else
			{
				rDE = length(d);
			}
		}
		aux->dist = min(aux->dist, rDE / aux->DE);
	}
	return z;
}