package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSecurityPolicyRelations invokes the alb.ListSecurityPolicyRelations API synchronously
func (client *Client) ListSecurityPolicyRelations(request *ListSecurityPolicyRelationsRequest) (response *ListSecurityPolicyRelationsResponse, err error) {
	response = CreateListSecurityPolicyRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListSecurityPolicyRelationsWithChan invokes the alb.ListSecurityPolicyRelations API asynchronously
func (client *Client) ListSecurityPolicyRelationsWithChan(request *ListSecurityPolicyRelationsRequest) (<-chan *ListSecurityPolicyRelationsResponse, <-chan error) {
	responseChan := make(chan *ListSecurityPolicyRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSecurityPolicyRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSecurityPolicyRelationsWithCallback invokes the alb.ListSecurityPolicyRelations API asynchronously
func (client *Client) ListSecurityPolicyRelationsWithCallback(request *ListSecurityPolicyRelationsRequest, callback func(response *ListSecurityPolicyRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSecurityPolicyRelationsResponse
		var err error
		defer close(result)
		response, err = client.ListSecurityPolicyRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSecurityPolicyRelationsRequest is the request struct for api ListSecurityPolicyRelations
type ListSecurityPolicyRelationsRequest struct {
	*requests.RpcRequest
	SecurityPolicyIds *[]string `position:"Query" name:"SecurityPolicyIds"  type:"Repeated"`
}

// ListSecurityPolicyRelationsResponse is the response struct for api ListSecurityPolicyRelations
type ListSecurityPolicyRelationsResponse struct {
	*responses.BaseResponse
	RequestId              string                  `json:"RequestId" xml:"RequestId"`
	SecrityPolicyRelations []SecrityPolicyRelation `json:"SecrityPolicyRelations" xml:"SecrityPolicyRelations"`
}

// CreateListSecurityPolicyRelationsRequest creates a request to invoke ListSecurityPolicyRelations API
func CreateListSecurityPolicyRelationsRequest() (request *ListSecurityPolicyRelationsRequest) {
	request = &ListSecurityPolicyRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListSecurityPolicyRelations", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSecurityPolicyRelationsResponse creates a response to parse from ListSecurityPolicyRelations response
func CreateListSecurityPolicyRelationsResponse() (response *ListSecurityPolicyRelationsResponse) {
	response = &ListSecurityPolicyRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
