/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.files;

import com.install4j.api.Util;
import com.install4j.api.actions.AbstractInstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.unix.UnixFileSystem;
import com.install4j.runtime.beans.actions.files.AbstractRecursiveFileAction;
import com.install4j.runtime.installer.frontend.ProgressAdapter;
import com.install4j.runtime.installer.helper.InstallerUtil;
import java.io.File;
import java.io.IOException;

public class SetOwnerAction
extends AbstractRecursiveFileAction {
    private String owner;
    private boolean recursive;

    public String getOwner() {
        return SetOwnerAction.replaceVariables(this.owner);
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (InstallerUtil.isWindows()) {
            return true;
        }
        String string = this.getOwner();
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return super.execute(context);
    }

    protected boolean executeForSingleRecursiveFile(Context context, File file, File file2, ProgressAdapter progressAdapter) throws UserCanceledException, IOException {
        UnixFileSystem.FileInformation fileInformation = UnixFileSystem.getFileInformation(file);
        if (fileInformation != null && fileInformation.getMode() > -1) {
            this.addRollbackAction(new PerformedAction(fileInformation.getOwnerInfo(), file));
        }
        Util.logInfo(this, "Setting owner for " + file.getAbsolutePath());
        return UnixFileSystem.setOwner(this.getOwner(), file);
    }

    private static class PerformedAction
    extends AbstractInstallAction {
        private String oldOwner;
        private File file;

        public PerformedAction(String string, File file) {
            this.oldOwner = string;
            this.file = file;
        }

        public boolean install(InstallerContext installerContext) throws UserCanceledException {
            throw new UnsupportedOperationException();
        }

        public void rollback(InstallerContext installerContext) {
            UnixFileSystem.setOwner(this.oldOwner, this.file);
        }
    }
}

