/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.misc;

import com.install4j.api.Util;
import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.Context;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.actions.SystemInstallOrUninstallAction;
import com.install4j.runtime.beans.actions.misc.ModifyStringType;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.platform.win32.EnvVars;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;

public class ModifyEnvironmentVariableAction
extends SystemInstallOrUninstallAction
implements AutoUninstallAction {
    private ModifyStringType type = ModifyStringType.SET;
    private String variableName;
    private String value;
    private boolean userSpecific = true;
    private boolean revertOnUninstallation = true;
    private boolean revertOnlyIfNotModified = false;
    private Properties persistentProperties = new Properties();
    private static final String PROP_VARIABLE_NAME = "variableName";
    private static final String PROP_VARIABLE_VALUE = "variableValue";
    private static final String PROP_USER_SPECIFIC = "userSpecific";
    private static final String PROP_TYPE = "type";
    private static final String PROP_ORIGINAL_VALUE = "originalValue";
    private static final String PROP_MODIFIED_VALUE = "modifiedValue";
    private static final String PROP_AUTO_UNINSTALL_TYPE = "autoUninstallType";
    private static final String AUTO_UNINSTALL_TYPE_NEVER = "never";
    private static final String AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED = "onlyIfNotModified";
    private static final String AUTO_UNINSTALL_TYPE_ALWAYS = "always";

    public ModifyStringType getType() {
        return this.type;
    }

    public void setType(ModifyStringType modifyStringType) {
        this.type = modifyStringType;
    }

    public String getVariableName() {
        return ModifyEnvironmentVariableAction.replaceVariables(this.variableName);
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getValue() {
        return ModifyEnvironmentVariableAction.replaceVariables(this.value);
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isUserSpecific() {
        return this.userSpecific;
    }

    public void setUserSpecific(boolean bl) {
        this.userSpecific = bl;
    }

    public boolean isRevertOnUninstallation() {
        return this.revertOnUninstallation;
    }

    public void setRevertOnUninstallation(boolean bl) {
        this.revertOnUninstallation = bl;
    }

    public boolean isRevertOnlyIfNotModified() {
        return this.revertOnlyIfNotModified;
    }

    public void setRevertOnlyIfNotModified(boolean bl) {
        this.revertOnlyIfNotModified = bl;
    }

    public boolean execute(Context context) throws UserCanceledException {
        if (!InstallerUtil.isWindows()) {
            return true;
        }
        try {
            String string;
            Object object;
            String string2 = AUTO_UNINSTALL_TYPE_NEVER;
            if (this.revertOnUninstallation && !Util.isWindows9X()) {
                object = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific());
                if (object != null) {
                    this.persistentProperties.setProperty(PROP_ORIGINAL_VALUE, (String)object);
                }
                string2 = this.revertOnlyIfNotModified ? AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED : AUTO_UNINSTALL_TYPE_ALWAYS;
            }
            object = EnvVars.set(this.getVariableName(), this.getValue(), this.isUserSpecific(), this.type == ModifyStringType.APPEND, this.type == ModifyStringType.PREPEND);
            this.addRollbackActions((Collection)object);
            if (object.size() == 0) {
                string2 = AUTO_UNINSTALL_TYPE_NEVER;
            }
            if (!string2.equals(AUTO_UNINSTALL_TYPE_NEVER) && (string = EnvVars.getWinNT(this.getVariableName(), this.isUserSpecific())) != null) {
                this.persistentProperties.setProperty(PROP_MODIFIED_VALUE, string);
            }
            this.persistentProperties.setProperty(PROP_VARIABLE_NAME, this.getVariableName());
            this.persistentProperties.setProperty(PROP_VARIABLE_VALUE, this.getValue());
            this.persistentProperties.setProperty(PROP_USER_SPECIFIC, String.valueOf(this.isUserSpecific()));
            this.persistentProperties.setProperty(PROP_TYPE, this.getType().toString());
            this.persistentProperties.setProperty(PROP_AUTO_UNINSTALL_TYPE, string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        if (this.persistentProperties.size() == 0) {
            return this.execute(uninstallerContext);
        }
        try {
            String string = this.persistentProperties.getProperty(PROP_AUTO_UNINSTALL_TYPE);
            if (!string.equals(AUTO_UNINSTALL_TYPE_NEVER)) {
                String string2 = this.persistentProperties.getProperty(PROP_VARIABLE_NAME);
                boolean bl = Boolean.valueOf(this.persistentProperties.getProperty(PROP_USER_SPECIFIC));
                String string3 = EnvVars.getWinNT(string2, bl);
                String string4 = this.persistentProperties.getProperty(PROP_ORIGINAL_VALUE);
                if (string.equals(AUTO_UNINSTALL_TYPE_ONLY_IF_NOT_MODIFIED)) {
                    if (string3 != null && string3.equals(this.persistentProperties.getProperty(PROP_MODIFIED_VALUE))) {
                        EnvVars.setWinNT(string2, string4, bl);
                    }
                } else {
                    ModifyStringType modifyStringType = ModifyStringType.getFromString(this.persistentProperties.getProperty(PROP_TYPE));
                    if (modifyStringType == ModifyStringType.SET || string3 != null && string3.equals(this.persistentProperties.getProperty(PROP_MODIFIED_VALUE))) {
                        EnvVars.setWinNT(string2, string4, bl);
                    } else {
                        int n;
                        String string5;
                        String string6 = string5 = this.persistentProperties.getProperty(PROP_VARIABLE_VALUE);
                        if (modifyStringType == ModifyStringType.APPEND) {
                            if (string4 != null && string4.length() > 0) {
                                string6 = ";" + string6;
                            }
                            if ((n = string3.endsWith(string6) ? string3.length() - string6.length() : string3.lastIndexOf(string6 + ";")) == -1) {
                                string6 = string5;
                                n = string3.endsWith(string6) ? string3.length() - string6.length() : string3.lastIndexOf(string6 + ";");
                            }
                        } else {
                            if (string4 != null && string4.length() > 0) {
                                string6 = string6 + ";";
                            }
                            if ((n = string3.startsWith(string6) ? 0 : string3.indexOf(";" + string6) - 1) < 0) {
                                string6 = string5;
                                n = string3.startsWith(string6) ? 0 : string3.indexOf(";" + string6) - 1;
                            }
                        }
                        if (n > -1) {
                            String string7 = string3.substring(0, n) + string3.substring(n + string6.length());
                            EnvVars.setWinNT(string2, string7, bl);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public Properties getPersistentProperties() {
        return this.persistentProperties;
    }

    public void setPersistentProperties(Properties properties) {
        this.persistentProperties = properties;
    }
}

