/* $Id: hash.c,v 1.1.1.1 2004/09/21 15:56:43 iscjonm Exp $
 *
 * Copyright (C) 2004 The Trustees of the University of Pennsylvania
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdlib.h>

#include "hash.h"

hash_table_t *hash_new(int num_items) {
  hash_table_t *t = NULL;
  int i;
  
  if ((t = malloc(sizeof(hash_table_t))) == NULL) goto err;
  if ((t->t = calloc(num_items, sizeof(struct list_elem *))) == NULL) goto err;
  t->sz = num_items;
  for(i=0; i<num_items; i++)
    t->t[i] = NULL;
  return t;

 err:
  if (t != NULL) {
    if (t->t != NULL) free(t->t);
    free(t);
  }
  return NULL;
}

int hash_put(hash_table_t *t, unsigned int key, void *item) {
  unsigned int idx = key % t->sz;
  struct list_elem *l = t->t[idx];
  int added = 0;
  
  /* see if it's already in there */
  while(l != NULL) {
    if (l->key == key) {
      /* found it, just update */
      l->item = item;
      added = 1;
      break;
    }
    l = l->next;
  }
  if (!added) {
    /* need to add a new entry */
    if ((l = malloc(sizeof(struct list_elem))) == NULL) return 0;
    l->next = t->t[idx];
    l->key = key;
    l->item = item;
    t->t[idx] = l;
  }
  return 1;
}

void *hash_lookup(hash_table_t *t, unsigned int key) {
  int idx = key % t->sz;
  struct list_elem *l = t->t[idx];

  while(l != NULL) {
    if (l->key == key) return l->item;
    l = l->next;
  }
  return NULL;
}
