module CommandLine (
  get_args )
where

import System.Console.CmdArgs (
  (&=),
  cmdArgs,
  def,
  details,
  help,
  program,
  summary )


-- Get the version from Cabal.
import Paths_list_remote_forwards ( version )
import Data.Version ( showVersion )

import OptionalConfiguration (
  OptionalConfiguration( OptionalConfiguration,
                         database,
                         domain_query,
                         exclude_mx,
                         forward_query,
                         host,
                         password,
                         port,
                         username )
  )

description :: String
description =
  "List all remote forwards for mail accounts stored in a SQL database."

program_name :: String
program_name = "list-remote-forwards"

my_summary :: String
my_summary = program_name ++ "-" ++ (showVersion version)

database_help :: String
database_help =
  "The name of the database (or file, if SQLite) to which we should connect"

domain_query_help :: String
domain_query_help =
  "SQL query used to produce the list of local domains"

exclude_mx_help :: String
exclude_mx_help =
  "MX for whom we don't report remote forwards"

forward_query_help :: String
forward_query_help =
  "SQL query used to produce the list of forwards, i.e. (to,from) pairs"

host_help :: String
host_help =
  "Hostname where the database is located (postgres-only)"

password_help :: String
password_help =
  "Password used to connect to the database (postgres-only)"

port_help :: String
port_help =
  "Port number used to connect to the database (postgres-only)"

username_help :: String
username_help =
  "Username used to connect to the database (postgres-only)"

arg_spec :: OptionalConfiguration
arg_spec =
  OptionalConfiguration {
    database = def &= help database_help,
    domain_query   = def &= help domain_query_help,
    exclude_mx = def &= help exclude_mx_help,
    forward_query   = def &= help forward_query_help,
    host     = def &= help host_help,
    password = def &= help password_help,
    port     = def &= help port_help,
    username = def &= help username_help }
    &= program program_name
    &= summary my_summary
    &= details [description]

get_args :: IO OptionalConfiguration
get_args = cmdArgs arg_spec
