// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/batch/v1alpha1/task.proto

package batch

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Task states.
type TaskStatus_State int32

const (
	// unknown state
	TaskStatus_STATE_UNSPECIFIED TaskStatus_State = 0
	// The Task is created and waiting for resources.
	TaskStatus_PENDING TaskStatus_State = 1
	// The Task is assigned to at least one VM.
	TaskStatus_ASSIGNED TaskStatus_State = 2
	// The Task is running.
	TaskStatus_RUNNING TaskStatus_State = 3
	// The Task has failed.
	TaskStatus_FAILED TaskStatus_State = 4
	// The Task has succeeded.
	TaskStatus_SUCCEEDED TaskStatus_State = 5
)

// Enum value maps for TaskStatus_State.
var (
	TaskStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ASSIGNED",
		3: "RUNNING",
		4: "FAILED",
		5: "SUCCEEDED",
	}
	TaskStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ASSIGNED":          2,
		"RUNNING":           3,
		"FAILED":            4,
		"SUCCEEDED":         5,
	}
)

func (x TaskStatus_State) Enum() *TaskStatus_State {
	p := new(TaskStatus_State)
	*p = x
	return p
}

func (x TaskStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_task_proto_enumTypes[0].Descriptor()
}

func (TaskStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_task_proto_enumTypes[0]
}

func (x TaskStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskStatus_State.Descriptor instead.
func (TaskStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{3, 0}
}

// Action on task failures based on different conditions.
type LifecyclePolicy_Action int32

const (
	// Action unspecified.
	LifecyclePolicy_ACTION_UNSPECIFIED LifecyclePolicy_Action = 0
	// Action that tasks in the group will be scheduled to re-execute.
	LifecyclePolicy_RETRY_TASK LifecyclePolicy_Action = 1
	// Action that tasks in the group will be stopped immediately.
	LifecyclePolicy_FAIL_TASK LifecyclePolicy_Action = 2
)

// Enum value maps for LifecyclePolicy_Action.
var (
	LifecyclePolicy_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "RETRY_TASK",
		2: "FAIL_TASK",
	}
	LifecyclePolicy_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"RETRY_TASK":         1,
		"FAIL_TASK":          2,
	}
)

func (x LifecyclePolicy_Action) Enum() *LifecyclePolicy_Action {
	p := new(LifecyclePolicy_Action)
	*p = x
	return p
}

func (x LifecyclePolicy_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LifecyclePolicy_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_batch_v1alpha1_task_proto_enumTypes[1].Descriptor()
}

func (LifecyclePolicy_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_batch_v1alpha1_task_proto_enumTypes[1]
}

func (x LifecyclePolicy_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LifecyclePolicy_Action.Descriptor instead.
func (LifecyclePolicy_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{6, 0}
}

// Compute resource requirements
type ComputeResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The milliCPU count.
	CpuMilli int64 `protobuf:"varint,1,opt,name=cpu_milli,json=cpuMilli,proto3" json:"cpu_milli,omitempty"`
	// Memory in MiB.
	MemoryMib int64 `protobuf:"varint,2,opt,name=memory_mib,json=memoryMib,proto3" json:"memory_mib,omitempty"`
	// The GPU count.
	GpuCount int64 `protobuf:"varint,3,opt,name=gpu_count,json=gpuCount,proto3" json:"gpu_count,omitempty"`
	// Boot disk size in MiB
	BootDiskMib int64 `protobuf:"varint,4,opt,name=boot_disk_mib,json=bootDiskMib,proto3" json:"boot_disk_mib,omitempty"`
}

func (x *ComputeResource) Reset() {
	*x = ComputeResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ComputeResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeResource) ProtoMessage() {}

func (x *ComputeResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeResource.ProtoReflect.Descriptor instead.
func (*ComputeResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{0}
}

func (x *ComputeResource) GetCpuMilli() int64 {
	if x != nil {
		return x.CpuMilli
	}
	return 0
}

func (x *ComputeResource) GetMemoryMib() int64 {
	if x != nil {
		return x.MemoryMib
	}
	return 0
}

func (x *ComputeResource) GetGpuCount() int64 {
	if x != nil {
		return x.GpuCount
	}
	return 0
}

func (x *ComputeResource) GetBootDiskMib() int64 {
	if x != nil {
		return x.BootDiskMib
	}
	return 0
}

// Status event
type StatusEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the event.
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// Description of the event.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// The time this event occurred.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Task Execution
	TaskExecution *TaskExecution `protobuf:"bytes,4,opt,name=task_execution,json=taskExecution,proto3" json:"task_execution,omitempty"`
}

func (x *StatusEvent) Reset() {
	*x = StatusEvent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StatusEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusEvent) ProtoMessage() {}

func (x *StatusEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusEvent.ProtoReflect.Descriptor instead.
func (*StatusEvent) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{1}
}

func (x *StatusEvent) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *StatusEvent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *StatusEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *StatusEvent) GetTaskExecution() *TaskExecution {
	if x != nil {
		return x.TaskExecution
	}
	return nil
}

// This Task Execution field includes detail information for
// task execution procedures, based on StatusEvent types.
type TaskExecution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// When task is completed as the status of FAILED or SUCCEEDED,
	// exit code is for one task execution result, default is 0 as success.
	ExitCode int32 `protobuf:"varint,1,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (x *TaskExecution) Reset() {
	*x = TaskExecution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskExecution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskExecution) ProtoMessage() {}

func (x *TaskExecution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskExecution.ProtoReflect.Descriptor instead.
func (*TaskExecution) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{2}
}

func (x *TaskExecution) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

// Status of a task
type TaskStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Task state
	State TaskStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.batch.v1alpha1.TaskStatus_State" json:"state,omitempty"`
	// Detailed info about why the state is reached.
	StatusEvents []*StatusEvent `protobuf:"bytes,2,rep,name=status_events,json=statusEvents,proto3" json:"status_events,omitempty"`
}

func (x *TaskStatus) Reset() {
	*x = TaskStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskStatus) ProtoMessage() {}

func (x *TaskStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskStatus.ProtoReflect.Descriptor instead.
func (*TaskStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{3}
}

func (x *TaskStatus) GetState() TaskStatus_State {
	if x != nil {
		return x.State
	}
	return TaskStatus_STATE_UNSPECIFIED
}

func (x *TaskStatus) GetStatusEvents() []*StatusEvent {
	if x != nil {
		return x.StatusEvents
	}
	return nil
}

// Runnable describes instructions for executing a specific script or container
// as part of a Task.
type Runnable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The script or container to run.
	//
	// Types that are assignable to Executable:
	//	*Runnable_Container_
	//	*Runnable_Script_
	//	*Runnable_Barrier_
	Executable isRunnable_Executable `protobuf_oneof:"executable"`
	// Normally, a non-zero exit status causes the Task to fail. This flag allows
	// execution of other Runnables to continue instead.
	IgnoreExitStatus bool `protobuf:"varint,3,opt,name=ignore_exit_status,json=ignoreExitStatus,proto3" json:"ignore_exit_status,omitempty"`
	// This flag allows a Runnable to continue running in the background while the
	// Task executes subsequent Runnables. This is useful to provide services to
	// other Runnables (or to provide debugging support tools like SSH servers).
	Background bool `protobuf:"varint,4,opt,name=background,proto3" json:"background,omitempty"`
	// By default, after a Runnable fails, no further Runnable are executed. This
	// flag indicates that this Runnable must be run even if the Task has already
	// failed. This is useful for Runnables that copy output files off of the VM
	// or for debugging.
	//
	// The always_run flag does not override the Task's overall max_run_duration.
	// If the max_run_duration has expired then no further Runnables will execute,
	// not even always_run Runnables.
	AlwaysRun bool `protobuf:"varint,5,opt,name=always_run,json=alwaysRun,proto3" json:"always_run,omitempty"`
}

func (x *Runnable) Reset() {
	*x = Runnable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Runnable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Runnable) ProtoMessage() {}

func (x *Runnable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Runnable.ProtoReflect.Descriptor instead.
func (*Runnable) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{4}
}

func (m *Runnable) GetExecutable() isRunnable_Executable {
	if m != nil {
		return m.Executable
	}
	return nil
}

func (x *Runnable) GetContainer() *Runnable_Container {
	if x, ok := x.GetExecutable().(*Runnable_Container_); ok {
		return x.Container
	}
	return nil
}

func (x *Runnable) GetScript() *Runnable_Script {
	if x, ok := x.GetExecutable().(*Runnable_Script_); ok {
		return x.Script
	}
	return nil
}

func (x *Runnable) GetBarrier() *Runnable_Barrier {
	if x, ok := x.GetExecutable().(*Runnable_Barrier_); ok {
		return x.Barrier
	}
	return nil
}

func (x *Runnable) GetIgnoreExitStatus() bool {
	if x != nil {
		return x.IgnoreExitStatus
	}
	return false
}

func (x *Runnable) GetBackground() bool {
	if x != nil {
		return x.Background
	}
	return false
}

func (x *Runnable) GetAlwaysRun() bool {
	if x != nil {
		return x.AlwaysRun
	}
	return false
}

type isRunnable_Executable interface {
	isRunnable_Executable()
}

type Runnable_Container_ struct {
	// Container runnable.
	Container *Runnable_Container `protobuf:"bytes,1,opt,name=container,proto3,oneof"`
}

type Runnable_Script_ struct {
	// Script runnable.
	Script *Runnable_Script `protobuf:"bytes,2,opt,name=script,proto3,oneof"`
}

type Runnable_Barrier_ struct {
	// Barrier runnable.
	Barrier *Runnable_Barrier `protobuf:"bytes,6,opt,name=barrier,proto3,oneof"`
}

func (*Runnable_Container_) isRunnable_Executable() {}

func (*Runnable_Script_) isRunnable_Executable() {}

func (*Runnable_Barrier_) isRunnable_Executable() {}

// Spec of a task
type TaskSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The sequence of scripts or containers to run for this Task. Each Task using
	// this TaskSpec executes its list of runnables in order. The Task succeeds if
	// all of its runnables either exit with a zero status or any that exit with a
	// non-zero status have the ignore_exit_status flag.
	//
	// Background runnables are killed automatically (if they have not already
	// exited) a short time after all foreground runnables have completed. Even
	// though this is likely to result in a non-zero exit status for the
	// background runnable, these automatic kills are not treated as Task
	// failures.
	Runnables []*Runnable `protobuf:"bytes,8,rep,name=runnables,proto3" json:"runnables,omitempty"`
	// ComputeResource requirements.
	ComputeResource *ComputeResource `protobuf:"bytes,3,opt,name=compute_resource,json=computeResource,proto3" json:"compute_resource,omitempty"`
	// Maximum duration the task should run.
	// The task will be killed and marked as FAILED if over this limit.
	MaxRunDuration *durationpb.Duration `protobuf:"bytes,4,opt,name=max_run_duration,json=maxRunDuration,proto3" json:"max_run_duration,omitempty"`
	// Maximum number of retries on failures.
	// The default, 0, which means never retry.
	// The valid value range is [0, 10].
	MaxRetryCount int32 `protobuf:"varint,5,opt,name=max_retry_count,json=maxRetryCount,proto3" json:"max_retry_count,omitempty"`
	// Lifecycle management schema when any task in a task group is failed.
	// The valid size of lifecycle policies are [0, 10].
	// For each lifecycle policy, when the condition is met,
	// the action in that policy will be executed.
	// If there are multiple policies that the task execution result matches,
	// we use the action from the first matched policy. If task execution result
	// does not meet with any of the defined lifecycle policy, we consider it as
	// the default policy. Default policy means if the exit code is 0, exit task.
	// If task ends with non-zero exit code, retry the task with max_retry_count.
	LifecyclePolicies []*LifecyclePolicy `protobuf:"bytes,9,rep,name=lifecycle_policies,json=lifecyclePolicies,proto3" json:"lifecycle_policies,omitempty"`
	// Environment variables to set before running the Task.
	// You can set up to 100 environments.
	Environments map[string]string `protobuf:"bytes,6,rep,name=environments,proto3" json:"environments,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Volumes to mount before running Tasks using this TaskSpec.
	Volumes []*Volume `protobuf:"bytes,7,rep,name=volumes,proto3" json:"volumes,omitempty"`
}

func (x *TaskSpec) Reset() {
	*x = TaskSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskSpec) ProtoMessage() {}

func (x *TaskSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskSpec.ProtoReflect.Descriptor instead.
func (*TaskSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{5}
}

func (x *TaskSpec) GetRunnables() []*Runnable {
	if x != nil {
		return x.Runnables
	}
	return nil
}

func (x *TaskSpec) GetComputeResource() *ComputeResource {
	if x != nil {
		return x.ComputeResource
	}
	return nil
}

func (x *TaskSpec) GetMaxRunDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxRunDuration
	}
	return nil
}

func (x *TaskSpec) GetMaxRetryCount() int32 {
	if x != nil {
		return x.MaxRetryCount
	}
	return 0
}

func (x *TaskSpec) GetLifecyclePolicies() []*LifecyclePolicy {
	if x != nil {
		return x.LifecyclePolicies
	}
	return nil
}

func (x *TaskSpec) GetEnvironments() map[string]string {
	if x != nil {
		return x.Environments
	}
	return nil
}

func (x *TaskSpec) GetVolumes() []*Volume {
	if x != nil {
		return x.Volumes
	}
	return nil
}

// LifecyclePolicy describes how to deal with task failures
// based on different conditions.
type LifecyclePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action to execute when ActionCondition is true.
	Action LifecyclePolicy_Action `protobuf:"varint,1,opt,name=action,proto3,enum=google.cloud.batch.v1alpha1.LifecyclePolicy_Action" json:"action,omitempty"`
	// Conditions that decide why a task failure is dealt with a specific action.
	ActionCondition *LifecyclePolicy_ActionCondition `protobuf:"bytes,2,opt,name=action_condition,json=actionCondition,proto3" json:"action_condition,omitempty"`
}

func (x *LifecyclePolicy) Reset() {
	*x = LifecyclePolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecyclePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecyclePolicy) ProtoMessage() {}

func (x *LifecyclePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecyclePolicy.ProtoReflect.Descriptor instead.
func (*LifecyclePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{6}
}

func (x *LifecyclePolicy) GetAction() LifecyclePolicy_Action {
	if x != nil {
		return x.Action
	}
	return LifecyclePolicy_ACTION_UNSPECIFIED
}

func (x *LifecyclePolicy) GetActionCondition() *LifecyclePolicy_ActionCondition {
	if x != nil {
		return x.ActionCondition
	}
	return nil
}

// A Cloud Batch task.
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Task name.
	// The name is generated from the parent TaskGroup name and 'id' field.
	// For example:
	// "projects/123456/locations/us-west1/jobs/job01/taskGroups/group01/tasks/task01".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Task Status.
	Status *TaskStatus `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{7}
}

func (x *Task) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Task) GetStatus() *TaskStatus {
	if x != nil {
		return x.Status
	}
	return nil
}

// Container runnable.
type Runnable_Container struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The URI to pull the container image from.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Overrides the `CMD` specified in the container. If there is an ENTRYPOINT
	// (either in the container image or with the entrypoint field below) then
	// commands are appended as arguments to the ENTRYPOINT.
	Commands []string `protobuf:"bytes,2,rep,name=commands,proto3" json:"commands,omitempty"`
	// Overrides the `ENTRYPOINT` specified in the container.
	Entrypoint string `protobuf:"bytes,3,opt,name=entrypoint,proto3" json:"entrypoint,omitempty"`
	// Volumes to mount (bind mount) from the host machine files or directories
	// into the container, formatted to match docker run's --volume option,
	// e.g. /foo:/bar, or /foo:/bar:ro
	Volumes []string `protobuf:"bytes,7,rep,name=volumes,proto3" json:"volumes,omitempty"`
	// Arbitrary additional options to include in the "docker run" command when
	// running this container, e.g. "--network host".
	Options string `protobuf:"bytes,8,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *Runnable_Container) Reset() {
	*x = Runnable_Container{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Runnable_Container) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Runnable_Container) ProtoMessage() {}

func (x *Runnable_Container) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Runnable_Container.ProtoReflect.Descriptor instead.
func (*Runnable_Container) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Runnable_Container) GetImageUri() string {
	if x != nil {
		return x.ImageUri
	}
	return ""
}

func (x *Runnable_Container) GetCommands() []string {
	if x != nil {
		return x.Commands
	}
	return nil
}

func (x *Runnable_Container) GetEntrypoint() string {
	if x != nil {
		return x.Entrypoint
	}
	return ""
}

func (x *Runnable_Container) GetVolumes() []string {
	if x != nil {
		return x.Volumes
	}
	return nil
}

func (x *Runnable_Container) GetOptions() string {
	if x != nil {
		return x.Options
	}
	return ""
}

// Script runnable.
type Runnable_Script struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Command:
	//	*Runnable_Script_Path
	//	*Runnable_Script_Text
	Command isRunnable_Script_Command `protobuf_oneof:"command"`
}

func (x *Runnable_Script) Reset() {
	*x = Runnable_Script{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Runnable_Script) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Runnable_Script) ProtoMessage() {}

func (x *Runnable_Script) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Runnable_Script.ProtoReflect.Descriptor instead.
func (*Runnable_Script) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{4, 1}
}

func (m *Runnable_Script) GetCommand() isRunnable_Script_Command {
	if m != nil {
		return m.Command
	}
	return nil
}

func (x *Runnable_Script) GetPath() string {
	if x, ok := x.GetCommand().(*Runnable_Script_Path); ok {
		return x.Path
	}
	return ""
}

func (x *Runnable_Script) GetText() string {
	if x, ok := x.GetCommand().(*Runnable_Script_Text); ok {
		return x.Text
	}
	return ""
}

type isRunnable_Script_Command interface {
	isRunnable_Script_Command()
}

type Runnable_Script_Path struct {
	// Script file path.
	Path string `protobuf:"bytes,1,opt,name=path,proto3,oneof"`
}

type Runnable_Script_Text struct {
	// Shell script text.
	Text string `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

func (*Runnable_Script_Path) isRunnable_Script_Command() {}

func (*Runnable_Script_Text) isRunnable_Script_Command() {}

// Barrier runnable blocks until all tasks in a taskgroup reach it.
type Runnable_Barrier struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Barriers are identified by their index in runnable list.
	// Names are not required, but if present should be an identifier.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Runnable_Barrier) Reset() {
	*x = Runnable_Barrier{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Runnable_Barrier) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Runnable_Barrier) ProtoMessage() {}

func (x *Runnable_Barrier) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Runnable_Barrier.ProtoReflect.Descriptor instead.
func (*Runnable_Barrier) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{4, 2}
}

func (x *Runnable_Barrier) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Conditions for actions to deal with task failures.
type LifecyclePolicy_ActionCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exit codes of a task execution.
	// If there are more than 1 exit codes,
	// when task executes with any of the exit code in the list,
	// the condition is met and the action will be executed.
	ExitCodes []int32 `protobuf:"varint,1,rep,packed,name=exit_codes,json=exitCodes,proto3" json:"exit_codes,omitempty"`
}

func (x *LifecyclePolicy_ActionCondition) Reset() {
	*x = LifecyclePolicy_ActionCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LifecyclePolicy_ActionCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LifecyclePolicy_ActionCondition) ProtoMessage() {}

func (x *LifecyclePolicy_ActionCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_batch_v1alpha1_task_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LifecyclePolicy_ActionCondition.ProtoReflect.Descriptor instead.
func (*LifecyclePolicy_ActionCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP(), []int{6, 0}
}

func (x *LifecyclePolicy_ActionCondition) GetExitCodes() []int32 {
	if x != nil {
		return x.ExitCodes
	}
	return nil
}

var File_google_cloud_batch_v1alpha1_task_proto protoreflect.FileDescriptor

var file_google_cloud_batch_v1alpha1_task_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x74, 0x61,
	0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2f, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8e, 0x01, 0x0a, 0x0f,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x08, 0x63, 0x70, 0x75, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x12, 0x1d, 0x0a, 0x0a,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x69, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x69, 0x62, 0x12, 0x1b, 0x0a, 0x09, 0x67,
	0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x08,
	0x67, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0d, 0x62, 0x6f, 0x6f, 0x74,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x62, 0x22, 0xd1, 0x01, 0x0a,
	0x0b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a,
	0x0e, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x2c, 0x0a, 0x0d, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x83,
	0x02, 0x0a, 0x0a, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x43, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x73, 0x22, 0x61, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0c,
	0x0a, 0x08, 0x41, 0x53, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x05, 0x22, 0xe4, 0x04, 0x0a, 0x08, 0x52, 0x75, 0x6e, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x12, 0x4f, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x65, 0x72, 0x48, 0x00, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x12, 0x46, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x48, 0x00, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x49, 0x0a, 0x07, 0x62, 0x61,
	0x72, 0x72, 0x69, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x42, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x48, 0x00, 0x52, 0x07, 0x62, 0x61,
	0x72, 0x72, 0x69, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x12, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f,
	0x65, 0x78, 0x69, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x45, 0x78, 0x69, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x5f, 0x72, 0x75,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73, 0x52,
	0x75, 0x6e, 0x1a, 0x98, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x1a, 0x0a,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3f, 0x0a,
	0x06, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x14, 0x0a,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x1a, 0x1d,
	0x0a, 0x07, 0x42, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0c, 0x0a,
	0x0a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xcf, 0x04, 0x0a, 0x08,
	0x54, 0x61, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x12, 0x43, 0x0a, 0x09, 0x72, 0x75, 0x6e, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x57, 0x0a,
	0x10, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x10, 0x6d, 0x61, 0x78, 0x5f, 0x72, 0x75,
	0x6e, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x6d, 0x61, 0x78,
	0x52, 0x75, 0x6e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x6d,
	0x61, 0x78, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x74, 0x72, 0x79, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x5b, 0x0a, 0x12, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69,
	0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x11, 0x6c,
	0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x12, 0x5b, 0x0a, 0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x45, 0x6e,
	0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0c, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3d, 0x0a,
	0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x56, 0x6f, 0x6c,
	0x75, 0x6d, 0x65, 0x52, 0x07, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x1a, 0x3f, 0x0a, 0x11,
	0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xba, 0x02,
	0x0a, 0x0f, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x4b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e,
	0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67,
	0x0a, 0x10, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x30, 0x0a, 0x0f, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78,
	0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x05, 0x52, 0x09,
	0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x73, 0x22, 0x3f, 0x0a, 0x06, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52,
	0x45, 0x54, 0x52, 0x59, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x46,
	0x41, 0x49, 0x4c, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x10, 0x02, 0x22, 0xd4, 0x01, 0x0a, 0x04, 0x54,
	0x61, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x3a, 0x77, 0xea, 0x41, 0x74, 0x0a, 0x19, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x6a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x2f, 0x74, 0x61, 0x73,
	0x6b, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x7d, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x73, 0x6b,
	0x7d, 0x42, 0x76, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x62, 0x61, 0x74, 0x63, 0x68, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x31, 0x42, 0x09, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x31, 0x3b, 0x62, 0x61,
	0x74, 0x63, 0x68, 0xa2, 0x02, 0x03, 0x47, 0x43, 0x42, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_batch_v1alpha1_task_proto_rawDescOnce sync.Once
	file_google_cloud_batch_v1alpha1_task_proto_rawDescData = file_google_cloud_batch_v1alpha1_task_proto_rawDesc
)

func file_google_cloud_batch_v1alpha1_task_proto_rawDescGZIP() []byte {
	file_google_cloud_batch_v1alpha1_task_proto_rawDescOnce.Do(func() {
		file_google_cloud_batch_v1alpha1_task_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_batch_v1alpha1_task_proto_rawDescData)
	})
	return file_google_cloud_batch_v1alpha1_task_proto_rawDescData
}

var file_google_cloud_batch_v1alpha1_task_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_batch_v1alpha1_task_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_batch_v1alpha1_task_proto_goTypes = []interface{}{
	(TaskStatus_State)(0),                   // 0: google.cloud.batch.v1alpha1.TaskStatus.State
	(LifecyclePolicy_Action)(0),             // 1: google.cloud.batch.v1alpha1.LifecyclePolicy.Action
	(*ComputeResource)(nil),                 // 2: google.cloud.batch.v1alpha1.ComputeResource
	(*StatusEvent)(nil),                     // 3: google.cloud.batch.v1alpha1.StatusEvent
	(*TaskExecution)(nil),                   // 4: google.cloud.batch.v1alpha1.TaskExecution
	(*TaskStatus)(nil),                      // 5: google.cloud.batch.v1alpha1.TaskStatus
	(*Runnable)(nil),                        // 6: google.cloud.batch.v1alpha1.Runnable
	(*TaskSpec)(nil),                        // 7: google.cloud.batch.v1alpha1.TaskSpec
	(*LifecyclePolicy)(nil),                 // 8: google.cloud.batch.v1alpha1.LifecyclePolicy
	(*Task)(nil),                            // 9: google.cloud.batch.v1alpha1.Task
	(*Runnable_Container)(nil),              // 10: google.cloud.batch.v1alpha1.Runnable.Container
	(*Runnable_Script)(nil),                 // 11: google.cloud.batch.v1alpha1.Runnable.Script
	(*Runnable_Barrier)(nil),                // 12: google.cloud.batch.v1alpha1.Runnable.Barrier
	nil,                                     // 13: google.cloud.batch.v1alpha1.TaskSpec.EnvironmentsEntry
	(*LifecyclePolicy_ActionCondition)(nil), // 14: google.cloud.batch.v1alpha1.LifecyclePolicy.ActionCondition
	(*timestamppb.Timestamp)(nil),           // 15: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),             // 16: google.protobuf.Duration
	(*Volume)(nil),                          // 17: google.cloud.batch.v1alpha1.Volume
}
var file_google_cloud_batch_v1alpha1_task_proto_depIdxs = []int32{
	15, // 0: google.cloud.batch.v1alpha1.StatusEvent.event_time:type_name -> google.protobuf.Timestamp
	4,  // 1: google.cloud.batch.v1alpha1.StatusEvent.task_execution:type_name -> google.cloud.batch.v1alpha1.TaskExecution
	0,  // 2: google.cloud.batch.v1alpha1.TaskStatus.state:type_name -> google.cloud.batch.v1alpha1.TaskStatus.State
	3,  // 3: google.cloud.batch.v1alpha1.TaskStatus.status_events:type_name -> google.cloud.batch.v1alpha1.StatusEvent
	10, // 4: google.cloud.batch.v1alpha1.Runnable.container:type_name -> google.cloud.batch.v1alpha1.Runnable.Container
	11, // 5: google.cloud.batch.v1alpha1.Runnable.script:type_name -> google.cloud.batch.v1alpha1.Runnable.Script
	12, // 6: google.cloud.batch.v1alpha1.Runnable.barrier:type_name -> google.cloud.batch.v1alpha1.Runnable.Barrier
	6,  // 7: google.cloud.batch.v1alpha1.TaskSpec.runnables:type_name -> google.cloud.batch.v1alpha1.Runnable
	2,  // 8: google.cloud.batch.v1alpha1.TaskSpec.compute_resource:type_name -> google.cloud.batch.v1alpha1.ComputeResource
	16, // 9: google.cloud.batch.v1alpha1.TaskSpec.max_run_duration:type_name -> google.protobuf.Duration
	8,  // 10: google.cloud.batch.v1alpha1.TaskSpec.lifecycle_policies:type_name -> google.cloud.batch.v1alpha1.LifecyclePolicy
	13, // 11: google.cloud.batch.v1alpha1.TaskSpec.environments:type_name -> google.cloud.batch.v1alpha1.TaskSpec.EnvironmentsEntry
	17, // 12: google.cloud.batch.v1alpha1.TaskSpec.volumes:type_name -> google.cloud.batch.v1alpha1.Volume
	1,  // 13: google.cloud.batch.v1alpha1.LifecyclePolicy.action:type_name -> google.cloud.batch.v1alpha1.LifecyclePolicy.Action
	14, // 14: google.cloud.batch.v1alpha1.LifecyclePolicy.action_condition:type_name -> google.cloud.batch.v1alpha1.LifecyclePolicy.ActionCondition
	5,  // 15: google.cloud.batch.v1alpha1.Task.status:type_name -> google.cloud.batch.v1alpha1.TaskStatus
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_batch_v1alpha1_task_proto_init() }
func file_google_cloud_batch_v1alpha1_task_proto_init() {
	if File_google_cloud_batch_v1alpha1_task_proto != nil {
		return
	}
	file_google_cloud_batch_v1alpha1_volume_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ComputeResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StatusEvent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskExecution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Runnable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LifecyclePolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Runnable_Container); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Runnable_Script); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Runnable_Barrier); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_batch_v1alpha1_task_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LifecyclePolicy_ActionCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_batch_v1alpha1_task_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Runnable_Container_)(nil),
		(*Runnable_Script_)(nil),
		(*Runnable_Barrier_)(nil),
	}
	file_google_cloud_batch_v1alpha1_task_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Runnable_Script_Path)(nil),
		(*Runnable_Script_Text)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_batch_v1alpha1_task_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_batch_v1alpha1_task_proto_goTypes,
		DependencyIndexes: file_google_cloud_batch_v1alpha1_task_proto_depIdxs,
		EnumInfos:         file_google_cloud_batch_v1alpha1_task_proto_enumTypes,
		MessageInfos:      file_google_cloud_batch_v1alpha1_task_proto_msgTypes,
	}.Build()
	File_google_cloud_batch_v1alpha1_task_proto = out.File
	file_google_cloud_batch_v1alpha1_task_proto_rawDesc = nil
	file_google_cloud_batch_v1alpha1_task_proto_goTypes = nil
	file_google_cloud_batch_v1alpha1_task_proto_depIdxs = nil
}
