/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.producerConsumer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfrog.build.api.producerConsumer.ProducerConsumerItem;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.producerConsumer.ConsumerRunnableBase;
import org.jfrog.build.extractor.producerConsumer.ProducerConsumerRunnableInt;
import org.jfrog.build.extractor.producerConsumer.ProducerRunnableBase;

public class ProducerConsumerExecutor {
    private BlockingQueue<ProducerConsumerItem> queue;
    private final Log log;
    private ProducerRunnableBase[] producerRunnables;
    private ConsumerRunnableBase[] consumerRunnables;
    public ProducerConsumerItem TERMINATE = new ProducerConsumerTerminateItem();
    private Thread[] producerThreads;
    private Thread[] consumerThreads;
    private int producersNumber;
    private int consumersNumber;
    private AtomicBoolean errorOccurred = new AtomicBoolean(false);
    private AtomicInteger producersFinished = new AtomicInteger(0);

    public ProducerConsumerExecutor(Log log, ProducerRunnableBase[] producerRunnables, ConsumerRunnableBase[] consumerRunnables, int queueSize) {
        this.log = log;
        this.producerRunnables = producerRunnables;
        this.consumerRunnables = consumerRunnables;
        this.queue = new ArrayBlockingQueue<ProducerConsumerItem>(queueSize);
        this.producersNumber = producerRunnables.length;
        this.consumersNumber = consumerRunnables.length;
        this.producerThreads = new Thread[this.producersNumber];
        this.consumerThreads = new Thread[this.consumersNumber];
    }

    public void start() throws Exception {
        int i;
        ProducerConsumerExceptionHandler exceptionHandler = new ProducerConsumerExceptionHandler();
        for (i = 0; i < this.producersNumber; ++i) {
            this.producerThreads[i] = new Thread(this.producerRunnables[i]);
            this.initializeThread(this.producerThreads[i], this.producerRunnables[i], "producer_" + i, exceptionHandler);
        }
        for (i = 0; i < this.consumersNumber; ++i) {
            this.consumerThreads[i] = new Thread(this.consumerRunnables[i]);
            this.initializeThread(this.consumerThreads[i], this.consumerRunnables[i], "consumer_" + i, exceptionHandler);
        }
        for (Thread consumer : this.consumerThreads) {
            consumer.start();
        }
        for (Thread producer : this.producerThreads) {
            producer.start();
        }
        try {
            for (Thread consumer : this.consumerThreads) {
                consumer.join();
            }
            for (Thread producer : this.producerThreads) {
                producer.join();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.stopWithException();
            throw e;
        }
        if (this.errorOccurred.get()) {
            throw new Exception("Error occurred during operation, please refer to logs for more information.");
        }
    }

    private void initializeThread(Thread thread, ProducerConsumerRunnableInt runnable, String name, Thread.UncaughtExceptionHandler exceptionHandler) {
        runnable.setExecutor(this);
        runnable.setLog(this.log);
        thread.setName(name);
        thread.setUncaughtExceptionHandler(exceptionHandler);
    }

    public void producerFinished() throws InterruptedException {
        if (this.producersFinished.addAndGet(1) == this.producersNumber) {
            this.queue.put(this.TERMINATE);
        }
    }

    private void stopWithException() {
        for (Thread thread : this.producerThreads) {
            thread.interrupt();
        }
        for (Thread thread : this.consumerThreads) {
            thread.interrupt();
        }
    }

    public void put(ProducerConsumerItem produced) throws InterruptedException {
        this.queue.put(produced);
    }

    public ProducerConsumerItem take() throws InterruptedException {
        return this.queue.take();
    }

    private class ProducerConsumerTerminateItem
    implements ProducerConsumerItem {
        private ProducerConsumerTerminateItem() {
        }
    }

    private class ProducerConsumerExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ProducerConsumerExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            ProducerConsumerExecutor.this.log.error(String.format("[%s] An exception occurred during execution:\n%s", t.getName(), sw.toString()));
            if (!ProducerConsumerExecutor.this.errorOccurred.getAndSet(true)) {
                ProducerConsumerExecutor.this.stopWithException();
            }
        }
    }
}

