/*
 * xfce4-hdaps, an XFCE4 panel plugin for the HDAPS system.
 *
 * Copyright (C) 2019 Michael Orlitzky
 *
 *   http://michael.orlitzky.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details:
 *
 *   https://www.gnu.org/licenses/agpl-3.0.html
 *
 */

#ifndef __HDAPS_H__
#define __HDAPS_H__

#include <stdio.h>

#define HDAPS_ERROR     -1
#define HDAPS_OFF        0
#define HDAPS_ON         1
#define UNLOAD_HEADS_FMT "/sys/block/%s/device/unload_heads"

/* The most devices we'll consider. Gotta stop somewhere. */
#define MAX_HDAPS_DEVICES 12

int parse_int_from_file(const char* filename);
int slurp_file(const char* filename, char* buf, int max_bytes);
int get_hdaps_device_list(char list[MAX_HDAPS_DEVICES][FILENAME_MAX]);

#endif
