#include "bool.h"
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include <signal.h>
#include <stdlib.h>
#include "connect.h"
#include "util.h"
#include "main.h"
#include "exec.h"

static bool dial_hack(void);
static void dial_sighandler(int sig);

static volatile sig_atomic_t childpid;

pid_t dial(void)
{
	pid_t pid;
	notice("connecting\n");
	pid = xfork();
	if (pid==-1) {
		notice_err("fork failed");
		return -1;
	} else if (pid==0) {
		if (cleanup_signals() || cleanup_fds_except(internal_write_fd)){
			notice("cleanup failed: not running commandon\n");
			_exit(EXIT_FAILURE);
		}
		/* don't unblock signals until dial_hack sets up handler */
		if (command_logfile())
			_exit(EXIT_FAILURE);
		if (dial_hack())
			_exit(EXIT_FAILURE);
		_exit(EXIT_SUCCESS);
	}
	return pid;
}

void dial_sighandler(int sig)
{
//	if (sig==SIGCHLD) {
//		while (waitpid_noint(-1, NULL, 0) > 0);
//	} else if (sig==SIGTERM) {
	if (sig==SIGTERM) {
		if (!set.commandoff) /* It's up to us. */
			kill(-childpid, SIGHUP);
	}
	return;
}

/* When this is called, all signals are blocked. */
bool dial_hack(void)
{
	bool ret;
	int waitpipe[2] = { -1, -1 };
//	int handled[] = { SIGTERM, SIGCHLD, 0 };
	int handled[] = { SIGTERM, 0 };
	struct sigaction cursig;
	struct sigaction ignore;
	int i;
	int c;

	if (set.waitpipe && -1==pipe(waitpipe)) {
		notice_err("creating pipes failed");
		return TRUE;
	}

	memset(&cursig, 0, sizeof cursig);
	cursig.sa_handler = dial_sighandler;

	/* If the system administrator naively does "killall -HUP dwun",
	 * we don't want to make dwun think commandon has died.
	 * (And exit immediately without disconnecting.) */
	memset(&ignore, 0, sizeof ignore);
	ignore.sa_handler = SIG_IGN;
	
	for (i=0; handled[i]; ++i) {
		if (-1==sigaction(handled[i], &cursig, NULL)) {
			notice_err("setting up signal handlers failed");
			return TRUE;
		}
	}
	if (-1==sigaction(SIGHUP, &ignore, NULL)) {
		notice_err("ignoring SIGHUP failed");
		return TRUE;
	}
	unblock_all_signals(NULL);
	
	childpid = xfork();
	if (childpid==-1) {
		notice_err("fork failed");
		return 0;
	} else if (childpid==0) {
		if (cleanup_signals()) {
			notice("cleanup failed: not running commandon\n");
			_exit(EXIT_FAILURE);
		}
		unblock_all_signals(NULL);
		
		close(waitpipe[0]);
		if (command_logfile())
			_exit(EXIT_FAILURE);
		setpgid(0, 0);
		/* XXX: Do not change the fd that waitpipe uses.
		 * e.g. in ip-up we might do exec 4>&-
		 */
		dup2(waitpipe[1], 4); close(waitpipe[1]);
		dup2(internal_write_fd, 3); close(internal_write_fd);
		runexec(set.commandon);
		_exit(EXIT_FAILURE);
	}
	(void)waitpid_noint(childpid, NULL, 0);
	if (set.waitpipe) {
		close(waitpipe[1]);
		do {
			ret = read(waitpipe[0], &c, 1);
		} while (ret==-1 && errno==EINTR);
		if (ret==-1)
			notice_errdebug("reading from waitpipe failed");
		else if (ret==1)
			notice_debug("process wrote to waitpipe\n");
	}
	notice_debug("commandon helper exiting\n");
	return FALSE;
}
