#ifndef MAKEAUTH_H
# define MAKEAUTH_H

#include "bool.h"

typedef struct {
	char *data;
	size_t len;
} mmap_area;

struct account {
	mmap_area user;
	char *lock; /* '!'==locked, ':'==unlocked */
	mmap_area crypass;
};

enum {
	USER_ADD,
	USER_REM,
	USER_INIT,
	USER_ERR,
	USER_END
};

enum {
	EXISTS_NO,
	EXISTS_YES,
	EXISTS_ERR
};

int args(int argc, char *argv[], char **filename, char **user);
bool auth_getaccount(const char *user, mmap_area authfile, struct account *ac);
mmap_area auth_getline(struct account *ac, mmap_area start);
bool changepass(struct account ac);
bool findchrline(const char *s, char *good, char *bad, size_t *len, size_t n);
void helpinfo(void);
bool invalid_authfile(mmap_area authfile);
bool invalid_username(mmap_area user);
int main(int argc, char *argv[]);
char *makepass(void);
void makesalt(char salt[3]);
bool map_authfile(int fd, mmap_area *authfile);
char *progname;;
bool unmap_authfile(mmap_area authfile);
bool user_add(const char *user, const char *filename);
int user_exists_changepass(const char *user, int fd);
bool user_rem(const char *user, const char *filename);
bool init_file(const char *filename);
void verinfo(void);
char *xstrdup(const char *s);

#endif
