package resources

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/resources/mgmt/2021-04-01/resources"

// Alias the alias type.
type Alias struct {
	// Name - The alias name.
	Name *string `json:"name,omitempty"`
	// Paths - The paths for an alias.
	Paths *[]AliasPath `json:"paths,omitempty"`
	// Type - The type of the alias. Possible values include: 'AliasTypeNotSpecified', 'AliasTypePlainText', 'AliasTypeMask'
	Type AliasType `json:"type,omitempty"`
	// DefaultPath - The default path for an alias.
	DefaultPath *string `json:"defaultPath,omitempty"`
	// DefaultPattern - The default pattern for an alias.
	DefaultPattern *AliasPattern `json:"defaultPattern,omitempty"`
	// DefaultMetadata - READ-ONLY; The default alias path metadata. Applies to the default path and to any alias path that doesn't have metadata
	DefaultMetadata *AliasPathMetadata `json:"defaultMetadata,omitempty"`
}

// MarshalJSON is the custom marshaler for Alias.
func (a Alias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.Paths != nil {
		objectMap["paths"] = a.Paths
	}
	if a.Type != "" {
		objectMap["type"] = a.Type
	}
	if a.DefaultPath != nil {
		objectMap["defaultPath"] = a.DefaultPath
	}
	if a.DefaultPattern != nil {
		objectMap["defaultPattern"] = a.DefaultPattern
	}
	return json.Marshal(objectMap)
}

// AliasPath the type of the paths for alias.
type AliasPath struct {
	// Path - The path of an alias.
	Path *string `json:"path,omitempty"`
	// APIVersions - The API versions.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// Pattern - The pattern for an alias path.
	Pattern *AliasPattern `json:"pattern,omitempty"`
	// Metadata - READ-ONLY; The metadata of the alias path. If missing, fall back to the default metadata of the alias.
	Metadata *AliasPathMetadata `json:"metadata,omitempty"`
}

// MarshalJSON is the custom marshaler for AliasPath.
func (ap AliasPath) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ap.Path != nil {
		objectMap["path"] = ap.Path
	}
	if ap.APIVersions != nil {
		objectMap["apiVersions"] = ap.APIVersions
	}
	if ap.Pattern != nil {
		objectMap["pattern"] = ap.Pattern
	}
	return json.Marshal(objectMap)
}

// AliasPathMetadata ...
type AliasPathMetadata struct {
	// Type - READ-ONLY; The type of the token that the alias path is referring to. Possible values include: 'NotSpecified', 'Any', 'String', 'Object', 'Array', 'Integer', 'Number', 'Boolean'
	Type AliasPathTokenType `json:"type,omitempty"`
	// Attributes - READ-ONLY; The attributes of the token that the alias path is referring to. Possible values include: 'None', 'Modifiable'
	Attributes AliasPathAttributes `json:"attributes,omitempty"`
}

// MarshalJSON is the custom marshaler for AliasPathMetadata.
func (apm AliasPathMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// AliasPattern the type of the pattern for an alias path.
type AliasPattern struct {
	// Phrase - The alias pattern phrase.
	Phrase *string `json:"phrase,omitempty"`
	// Variable - The alias pattern variable.
	Variable *string `json:"variable,omitempty"`
	// Type - The type of alias pattern. Possible values include: 'AliasPatternTypeNotSpecified', 'AliasPatternTypeExtract'
	Type AliasPatternType `json:"type,omitempty"`
}

// APIProfile ...
type APIProfile struct {
	// ProfileVersion - READ-ONLY; The profile version.
	ProfileVersion *string `json:"profileVersion,omitempty"`
	// APIVersion - READ-ONLY; The API version.
	APIVersion *string `json:"apiVersion,omitempty"`
}

// MarshalJSON is the custom marshaler for APIProfile.
func (ap APIProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// BasicDependency deployment dependency information.
type BasicDependency struct {
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// CloudError an error response for a resource management request.
type CloudError struct {
	Error *ErrorResponse `json:"error,omitempty"`
}

// CreateOrUpdateByIDFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (GenericResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrUpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrUpdateByIDFuture.Result.
func (future *CreateOrUpdateByIDFuture) result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.CreateOrUpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.CreateOrUpdateByIDResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateByIDFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// CreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type CreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (GenericResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *CreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for CreateOrUpdateFuture.Result.
func (future *CreateOrUpdateFuture) result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.CreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.CreateOrUpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.CreateOrUpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DebugSetting the debug setting.
type DebugSetting struct {
	// DetailLevel - Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information you are passing in during deployment. By logging information about the request or response, you could potentially expose sensitive data that is retrieved through the deployment operations.
	DetailLevel *string `json:"detailLevel,omitempty"`
}

// DeleteByIDFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteByIDFuture.Result.
func (future *DeleteByIDFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeleteByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeleteByIDFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type DeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeleteFuture.Result.
func (future *DeleteFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Dependency deployment dependency information.
type Dependency struct {
	// DependsOn - The list of dependencies.
	DependsOn *[]BasicDependency `json:"dependsOn,omitempty"`
	// ID - The ID of the dependency.
	ID *string `json:"id,omitempty"`
	// ResourceType - The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// ResourceName - The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`
}

// Deployment deployment operation parameters.
type Deployment struct {
	// Location - The location to store the deployment data.
	Location *string `json:"location,omitempty"`
	// Properties - The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`
	// Tags - Deployment tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if d.Location != nil {
		objectMap["location"] = d.Location
	}
	if d.Properties != nil {
		objectMap["properties"] = d.Properties
	}
	if d.Tags != nil {
		objectMap["tags"] = d.Tags
	}
	return json.Marshal(objectMap)
}

// DeploymentExportResult the deployment export result.
type DeploymentExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
}

// DeploymentExtended deployment information.
type DeploymentExtended struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the deployment.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the deployment.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the deployment.
	Type *string `json:"type,omitempty"`
	// Location - the location of the deployment.
	Location *string `json:"location,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
	// Tags - Deployment tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for DeploymentExtended.
func (de DeploymentExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if de.Location != nil {
		objectMap["location"] = de.Location
	}
	if de.Properties != nil {
		objectMap["properties"] = de.Properties
	}
	if de.Tags != nil {
		objectMap["tags"] = de.Tags
	}
	return json.Marshal(objectMap)
}

// DeploymentExtendedFilter deployment filter.
type DeploymentExtendedFilter struct {
	// ProvisioningState - The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult list of deployments.
type DeploymentListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of deployments.
	Value *[]DeploymentExtended `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentListResult.
func (dlr DeploymentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dlr.Value != nil {
		objectMap["value"] = dlr.Value
	}
	return json.Marshal(objectMap)
}

// DeploymentListResultIterator provides access to a complete listing of DeploymentExtended values.
type DeploymentListResultIterator struct {
	i    int
	page DeploymentListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentListResultIterator) Response() DeploymentListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentListResultIterator) Value() DeploymentExtended {
	if !iter.page.NotDone() {
		return DeploymentExtended{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentListResultIterator type.
func NewDeploymentListResultIterator(page DeploymentListResultPage) DeploymentListResultIterator {
	return DeploymentListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dlr DeploymentListResult) IsEmpty() bool {
	return dlr.Value == nil || len(*dlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dlr DeploymentListResult) hasNextLink() bool {
	return dlr.NextLink != nil && len(*dlr.NextLink) != 0
}

// deploymentListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dlr DeploymentListResult) deploymentListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dlr.NextLink)))
}

// DeploymentListResultPage contains a page of DeploymentExtended values.
type DeploymentListResultPage struct {
	fn  func(context.Context, DeploymentListResult) (DeploymentListResult, error)
	dlr DeploymentListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dlr)
		if err != nil {
			return err
		}
		page.dlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentListResultPage) NotDone() bool {
	return !page.dlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentListResultPage) Response() DeploymentListResult {
	return page.dlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentListResultPage) Values() []DeploymentExtended {
	if page.dlr.IsEmpty() {
		return nil
	}
	return *page.dlr.Value
}

// Creates a new instance of the DeploymentListResultPage type.
func NewDeploymentListResultPage(cur DeploymentListResult, getNextPage func(context.Context, DeploymentListResult) (DeploymentListResult, error)) DeploymentListResultPage {
	return DeploymentListResultPage{
		fn:  getNextPage,
		dlr: cur,
	}
}

// DeploymentOperation deployment operation information.
type DeploymentOperation struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; Full deployment operation ID.
	ID *string `json:"id,omitempty"`
	// OperationID - READ-ONLY; Deployment operation ID.
	OperationID *string `json:"operationId,omitempty"`
	// Properties - Deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentOperation.
func (do DeploymentOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if do.Properties != nil {
		objectMap["properties"] = do.Properties
	}
	return json.Marshal(objectMap)
}

// DeploymentOperationProperties deployment operation properties.
type DeploymentOperationProperties struct {
	// ProvisioningOperation - READ-ONLY; The name of the current provisioning operation. Possible values include: 'ProvisioningOperationNotSpecified', 'ProvisioningOperationCreate', 'ProvisioningOperationDelete', 'ProvisioningOperationWaiting', 'ProvisioningOperationAzureAsyncOperationWaiting', 'ProvisioningOperationResourceCacheWaiting', 'ProvisioningOperationAction', 'ProvisioningOperationRead', 'ProvisioningOperationEvaluateDeploymentOutput', 'ProvisioningOperationDeploymentCleanup'
	ProvisioningOperation ProvisioningOperation `json:"provisioningOperation,omitempty"`
	// ProvisioningState - READ-ONLY; The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Timestamp - READ-ONLY; The date and time of the operation.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Duration - READ-ONLY; The duration of the operation.
	Duration *string `json:"duration,omitempty"`
	// ServiceRequestID - READ-ONLY; Deployment operation service request id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty"`
	// StatusCode - READ-ONLY; Operation status code from the resource provider. This property may not be set if a response has not yet been received.
	StatusCode *string `json:"statusCode,omitempty"`
	// StatusMessage - READ-ONLY; Operation status message from the resource provider. This property is optional.  It will only be provided if an error was received from the resource provider.
	StatusMessage *StatusMessage `json:"statusMessage,omitempty"`
	// TargetResource - READ-ONLY; The target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty"`
	// Request - READ-ONLY; The HTTP request message.
	Request *HTTPMessage `json:"request,omitempty"`
	// Response - READ-ONLY; The HTTP response message.
	Response *HTTPMessage `json:"response,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentOperationProperties.
func (dop DeploymentOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeploymentOperationsListResult list of deployment operations.
type DeploymentOperationsListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of deployment operations.
	Value *[]DeploymentOperation `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentOperationsListResult.
func (dolr DeploymentOperationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dolr.Value != nil {
		objectMap["value"] = dolr.Value
	}
	return json.Marshal(objectMap)
}

// DeploymentOperationsListResultIterator provides access to a complete listing of DeploymentOperation
// values.
type DeploymentOperationsListResultIterator struct {
	i    int
	page DeploymentOperationsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *DeploymentOperationsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *DeploymentOperationsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter DeploymentOperationsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter DeploymentOperationsListResultIterator) Response() DeploymentOperationsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter DeploymentOperationsListResultIterator) Value() DeploymentOperation {
	if !iter.page.NotDone() {
		return DeploymentOperation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the DeploymentOperationsListResultIterator type.
func NewDeploymentOperationsListResultIterator(page DeploymentOperationsListResultPage) DeploymentOperationsListResultIterator {
	return DeploymentOperationsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (dolr DeploymentOperationsListResult) IsEmpty() bool {
	return dolr.Value == nil || len(*dolr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (dolr DeploymentOperationsListResult) hasNextLink() bool {
	return dolr.NextLink != nil && len(*dolr.NextLink) != 0
}

// deploymentOperationsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (dolr DeploymentOperationsListResult) deploymentOperationsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !dolr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(dolr.NextLink)))
}

// DeploymentOperationsListResultPage contains a page of DeploymentOperation values.
type DeploymentOperationsListResultPage struct {
	fn   func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)
	dolr DeploymentOperationsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *DeploymentOperationsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DeploymentOperationsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.dolr)
		if err != nil {
			return err
		}
		page.dolr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *DeploymentOperationsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page DeploymentOperationsListResultPage) NotDone() bool {
	return !page.dolr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page DeploymentOperationsListResultPage) Response() DeploymentOperationsListResult {
	return page.dolr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page DeploymentOperationsListResultPage) Values() []DeploymentOperation {
	if page.dolr.IsEmpty() {
		return nil
	}
	return *page.dolr.Value
}

// Creates a new instance of the DeploymentOperationsListResultPage type.
func NewDeploymentOperationsListResultPage(cur DeploymentOperationsListResult, getNextPage func(context.Context, DeploymentOperationsListResult) (DeploymentOperationsListResult, error)) DeploymentOperationsListResultPage {
	return DeploymentOperationsListResultPage{
		fn:   getNextPage,
		dolr: cur,
	}
}

// DeploymentProperties deployment properties.
type DeploymentProperties struct {
	// Template - The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
	// OnErrorDeployment - The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`
	// ExpressionEvaluationOptions - Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
	ExpressionEvaluationOptions *ExpressionEvaluationOptions `json:"expressionEvaluationOptions,omitempty"`
}

// DeploymentPropertiesExtended deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// ProvisioningState - READ-ONLY; Denotes the state of provisioning. Possible values include: 'ProvisioningStateNotSpecified', 'ProvisioningStateAccepted', 'ProvisioningStateRunning', 'ProvisioningStateReady', 'ProvisioningStateCreating', 'ProvisioningStateCreated', 'ProvisioningStateDeleting', 'ProvisioningStateDeleted', 'ProvisioningStateCanceled', 'ProvisioningStateFailed', 'ProvisioningStateSucceeded', 'ProvisioningStateUpdating'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// CorrelationID - READ-ONLY; The correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty"`
	// Timestamp - READ-ONLY; The timestamp of the template deployment.
	Timestamp *date.Time `json:"timestamp,omitempty"`
	// Duration - READ-ONLY; The duration of the template deployment.
	Duration *string `json:"duration,omitempty"`
	// Outputs - READ-ONLY; Key/value pairs that represent deployment output.
	Outputs interface{} `json:"outputs,omitempty"`
	// Providers - READ-ONLY; The list of resource providers needed for the deployment.
	Providers *[]Provider `json:"providers,omitempty"`
	// Dependencies - READ-ONLY; The list of deployment dependencies.
	Dependencies *[]Dependency `json:"dependencies,omitempty"`
	// TemplateLink - READ-ONLY; The URI referencing the template.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - READ-ONLY; Deployment parameters.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - READ-ONLY; The URI referencing the parameters.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - READ-ONLY; The deployment mode. Possible values are Incremental and Complete. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - READ-ONLY; The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
	// OnErrorDeployment - READ-ONLY; The deployment on error behavior.
	OnErrorDeployment *OnErrorDeploymentExtended `json:"onErrorDeployment,omitempty"`
	// TemplateHash - READ-ONLY; The hash produced for the template.
	TemplateHash *string `json:"templateHash,omitempty"`
	// OutputResources - READ-ONLY; Array of provisioned resources.
	OutputResources *[]Reference `json:"outputResources,omitempty"`
	// ValidatedResources - READ-ONLY; Array of validated resources.
	ValidatedResources *[]Reference `json:"validatedResources,omitempty"`
	// Error - READ-ONLY; The deployment error.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentPropertiesExtended.
func (dpe DeploymentPropertiesExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// DeploymentsCreateOrUpdateAtManagementGroupScopeFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DeploymentsCreateOrUpdateAtManagementGroupScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentExtended, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateAtManagementGroupScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateAtManagementGroupScopeFuture.Result.
func (future *DeploymentsCreateOrUpdateAtManagementGroupScopeFuture) result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtManagementGroupScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		de.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateAtManagementGroupScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateAtManagementGroupScopeResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtManagementGroupScopeFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsCreateOrUpdateAtScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateAtScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentExtended, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateAtScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateAtScopeFuture.Result.
func (future *DeploymentsCreateOrUpdateAtScopeFuture) result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		de.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateAtScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateAtScopeResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtScopeFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsCreateOrUpdateAtSubscriptionScopeFuture an abstraction for monitoring and retrieving the
// results of a long-running operation.
type DeploymentsCreateOrUpdateAtSubscriptionScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentExtended, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateAtSubscriptionScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateAtSubscriptionScopeFuture.Result.
func (future *DeploymentsCreateOrUpdateAtSubscriptionScopeFuture) result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtSubscriptionScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		de.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateAtSubscriptionScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateAtSubscriptionScopeResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtSubscriptionScopeFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsCreateOrUpdateAtTenantScopeFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DeploymentsCreateOrUpdateAtTenantScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentExtended, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateAtTenantScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateAtTenantScopeFuture.Result.
func (future *DeploymentsCreateOrUpdateAtTenantScopeFuture) result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtTenantScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		de.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateAtTenantScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateAtTenantScopeResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateAtTenantScopeFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsCreateOrUpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentExtended, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsCreateOrUpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsCreateOrUpdateFuture.Result.
func (future *DeploymentsCreateOrUpdateFuture) result(client DeploymentsClient) (de DeploymentExtended, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		de.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if de.Response.Response, err = future.GetResult(sender); err == nil && de.Response.Response.StatusCode != http.StatusNoContent {
		de, err = client.CreateOrUpdateResponder(de.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsCreateOrUpdateFuture", "Result", de.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsDeleteAtManagementGroupScopeFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DeploymentsDeleteAtManagementGroupScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteAtManagementGroupScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteAtManagementGroupScopeFuture.Result.
func (future *DeploymentsDeleteAtManagementGroupScopeFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteAtManagementGroupScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteAtManagementGroupScopeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsDeleteAtScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsDeleteAtScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteAtScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteAtScopeFuture.Result.
func (future *DeploymentsDeleteAtScopeFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteAtScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteAtScopeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsDeleteAtSubscriptionScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsDeleteAtSubscriptionScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteAtSubscriptionScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteAtSubscriptionScopeFuture.Result.
func (future *DeploymentsDeleteAtSubscriptionScopeFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteAtSubscriptionScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteAtSubscriptionScopeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsDeleteAtTenantScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsDeleteAtTenantScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteAtTenantScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteAtTenantScopeFuture.Result.
func (future *DeploymentsDeleteAtTenantScopeFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteAtTenantScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteAtTenantScopeFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsDeleteFuture.Result.
func (future *DeploymentsDeleteFuture) result(client DeploymentsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// DeploymentsValidateAtManagementGroupScopeFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DeploymentsValidateAtManagementGroupScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsValidateAtManagementGroupScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsValidateAtManagementGroupScopeFuture.Result.
func (future *DeploymentsValidateAtManagementGroupScopeFuture) result(client DeploymentsClient) (dvr DeploymentValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtManagementGroupScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsValidateAtManagementGroupScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvr.Response.Response, err = future.GetResult(sender); err == nil && dvr.Response.Response.StatusCode != http.StatusNoContent {
		dvr, err = client.ValidateAtManagementGroupScopeResponder(dvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtManagementGroupScopeFuture", "Result", dvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsValidateAtScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsValidateAtScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsValidateAtScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsValidateAtScopeFuture.Result.
func (future *DeploymentsValidateAtScopeFuture) result(client DeploymentsClient) (dvr DeploymentValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsValidateAtScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvr.Response.Response, err = future.GetResult(sender); err == nil && dvr.Response.Response.StatusCode != http.StatusNoContent {
		dvr, err = client.ValidateAtScopeResponder(dvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtScopeFuture", "Result", dvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsValidateAtSubscriptionScopeFuture an abstraction for monitoring and retrieving the results of
// a long-running operation.
type DeploymentsValidateAtSubscriptionScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsValidateAtSubscriptionScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsValidateAtSubscriptionScopeFuture.Result.
func (future *DeploymentsValidateAtSubscriptionScopeFuture) result(client DeploymentsClient) (dvr DeploymentValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtSubscriptionScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsValidateAtSubscriptionScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvr.Response.Response, err = future.GetResult(sender); err == nil && dvr.Response.Response.StatusCode != http.StatusNoContent {
		dvr, err = client.ValidateAtSubscriptionScopeResponder(dvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtSubscriptionScopeFuture", "Result", dvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsValidateAtTenantScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsValidateAtTenantScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsValidateAtTenantScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsValidateAtTenantScopeFuture.Result.
func (future *DeploymentsValidateAtTenantScopeFuture) result(client DeploymentsClient) (dvr DeploymentValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtTenantScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsValidateAtTenantScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvr.Response.Response, err = future.GetResult(sender); err == nil && dvr.Response.Response.StatusCode != http.StatusNoContent {
		dvr, err = client.ValidateAtTenantScopeResponder(dvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateAtTenantScopeFuture", "Result", dvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsValidateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsValidateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (DeploymentValidateResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsValidateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsValidateFuture.Result.
func (future *DeploymentsValidateFuture) result(client DeploymentsClient) (dvr DeploymentValidateResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		dvr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsValidateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if dvr.Response.Response, err = future.GetResult(sender); err == nil && dvr.Response.Response.StatusCode != http.StatusNoContent {
		dvr, err = client.ValidateResponder(dvr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsValidateFuture", "Result", dvr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsWhatIfAtManagementGroupScopeFuture an abstraction for monitoring and retrieving the results
// of a long-running operation.
type DeploymentsWhatIfAtManagementGroupScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (WhatIfOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsWhatIfAtManagementGroupScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsWhatIfAtManagementGroupScopeFuture.Result.
func (future *DeploymentsWhatIfAtManagementGroupScopeFuture) result(client DeploymentsClient) (wior WhatIfOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtManagementGroupScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wior.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsWhatIfAtManagementGroupScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wior.Response.Response, err = future.GetResult(sender); err == nil && wior.Response.Response.StatusCode != http.StatusNoContent {
		wior, err = client.WhatIfAtManagementGroupScopeResponder(wior.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtManagementGroupScopeFuture", "Result", wior.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsWhatIfAtSubscriptionScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsWhatIfAtSubscriptionScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (WhatIfOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsWhatIfAtSubscriptionScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsWhatIfAtSubscriptionScopeFuture.Result.
func (future *DeploymentsWhatIfAtSubscriptionScopeFuture) result(client DeploymentsClient) (wior WhatIfOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtSubscriptionScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wior.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsWhatIfAtSubscriptionScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wior.Response.Response, err = future.GetResult(sender); err == nil && wior.Response.Response.StatusCode != http.StatusNoContent {
		wior, err = client.WhatIfAtSubscriptionScopeResponder(wior.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtSubscriptionScopeFuture", "Result", wior.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsWhatIfAtTenantScopeFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type DeploymentsWhatIfAtTenantScopeFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (WhatIfOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsWhatIfAtTenantScopeFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsWhatIfAtTenantScopeFuture.Result.
func (future *DeploymentsWhatIfAtTenantScopeFuture) result(client DeploymentsClient) (wior WhatIfOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtTenantScopeFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wior.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsWhatIfAtTenantScopeFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wior.Response.Response, err = future.GetResult(sender); err == nil && wior.Response.Response.StatusCode != http.StatusNoContent {
		wior, err = client.WhatIfAtTenantScopeResponder(wior.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfAtTenantScopeFuture", "Result", wior.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentsWhatIfFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type DeploymentsWhatIfFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(DeploymentsClient) (WhatIfOperationResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *DeploymentsWhatIfFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for DeploymentsWhatIfFuture.Result.
func (future *DeploymentsWhatIfFuture) result(client DeploymentsClient) (wior WhatIfOperationResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		wior.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.DeploymentsWhatIfFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if wior.Response.Response, err = future.GetResult(sender); err == nil && wior.Response.Response.StatusCode != http.StatusNoContent {
		wior, err = client.WhatIfResponder(wior.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.DeploymentsWhatIfFuture", "Result", wior.Response.Response, "Failure responding to request")
		}
	}
	return
}

// DeploymentValidateResult information from validate template deployment response.
type DeploymentValidateResult struct {
	autorest.Response `json:"-"`
	// Error - READ-ONLY; The deployment validation error.
	Error *ErrorResponse `json:"error,omitempty"`
	// Properties - The template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for DeploymentValidateResult.
func (dvr DeploymentValidateResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dvr.Properties != nil {
		objectMap["properties"] = dvr.Properties
	}
	return json.Marshal(objectMap)
}

// DeploymentWhatIf deployment What-if operation parameters.
type DeploymentWhatIf struct {
	// Location - The location to store the deployment data.
	Location *string `json:"location,omitempty"`
	// Properties - The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`
}

// DeploymentWhatIfProperties deployment What-if properties.
type DeploymentWhatIfProperties struct {
	// WhatIfSettings - Optional What-If operation settings.
	WhatIfSettings *DeploymentWhatIfSettings `json:"whatIfSettings,omitempty"`
	// Template - The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
	Template interface{} `json:"template,omitempty"`
	// TemplateLink - The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
	// Parameters - Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide the parameter values directly in the request rather than link to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
	Parameters interface{} `json:"parameters,omitempty"`
	// ParametersLink - The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`
	// Mode - The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode, resources are deployed without deleting existing resources that are not included in the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included in the template are deleted. Be careful when using Complete mode as you may unintentionally delete resources. Possible values include: 'Incremental', 'Complete'
	Mode DeploymentMode `json:"mode,omitempty"`
	// DebugSetting - The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`
	// OnErrorDeployment - The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`
	// ExpressionEvaluationOptions - Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable to nested templates. If not specified, default value is outer.
	ExpressionEvaluationOptions *ExpressionEvaluationOptions `json:"expressionEvaluationOptions,omitempty"`
}

// DeploymentWhatIfSettings deployment What-If operation settings.
type DeploymentWhatIfSettings struct {
	// ResultFormat - The format of the What-If results. Possible values include: 'ResourceIDOnly', 'FullResourcePayloads'
	ResultFormat WhatIfResultFormat `json:"resultFormat,omitempty"`
}

// ErrorAdditionalInfo the resource management error additional info.
type ErrorAdditionalInfo struct {
	// Type - READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty"`
	// Info - READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorAdditionalInfo.
func (eai ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse common error response for all Azure Resource Manager APIs to return error details for
// failed operations. (This also follows the OData error response format.)
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The error target.
	Target *string `json:"target,omitempty"`
	// Details - READ-ONLY; The error details.
	Details *[]ErrorResponse `json:"details,omitempty"`
	// AdditionalInfo - READ-ONLY; The error additional info.
	AdditionalInfo *[]ErrorAdditionalInfo `json:"additionalInfo,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ExportTemplateRequest export resource group template request parameters.
type ExportTemplateRequest struct {
	// ResourcesProperty - The IDs of the resources to filter the export by. To export all resources, supply an array with single entry '*'.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// Options - The export template options. A CSV-formatted list containing zero or more of the following: 'IncludeParameterDefaultValue', 'IncludeComments', 'SkipResourceNameParameterization', 'SkipAllParameterization'
	Options *string `json:"options,omitempty"`
}

// ExpressionEvaluationOptions specifies whether template expressions are evaluated within the scope of the
// parent template or nested template.
type ExpressionEvaluationOptions struct {
	// Scope - The scope to be used for evaluation of parameters, variables and functions in a nested template. Possible values include: 'ExpressionEvaluationOptionsScopeTypeNotSpecified', 'ExpressionEvaluationOptionsScopeTypeOuter', 'ExpressionEvaluationOptionsScopeTypeInner'
	Scope ExpressionEvaluationOptionsScopeType `json:"scope,omitempty"`
}

// ExtendedLocation resource extended location.
type ExtendedLocation struct {
	// Type - The extended location type. Possible values include: 'EdgeZone'
	Type ExtendedLocationType `json:"type,omitempty"`
	// Name - The extended location name.
	Name *string `json:"name,omitempty"`
}

// GenericResource resource information.
type GenericResource struct {
	autorest.Response `json:"-"`
	// Plan - The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`
	// Properties - The resource properties.
	Properties interface{} `json:"properties,omitempty"`
	// Kind - The kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ExtendedLocation - Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResource.
func (gr GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gr.Plan != nil {
		objectMap["plan"] = gr.Plan
	}
	if gr.Properties != nil {
		objectMap["properties"] = gr.Properties
	}
	if gr.Kind != nil {
		objectMap["kind"] = gr.Kind
	}
	if gr.ManagedBy != nil {
		objectMap["managedBy"] = gr.ManagedBy
	}
	if gr.Sku != nil {
		objectMap["sku"] = gr.Sku
	}
	if gr.Identity != nil {
		objectMap["identity"] = gr.Identity
	}
	if gr.Location != nil {
		objectMap["location"] = gr.Location
	}
	if gr.ExtendedLocation != nil {
		objectMap["extendedLocation"] = gr.ExtendedLocation
	}
	if gr.Tags != nil {
		objectMap["tags"] = gr.Tags
	}
	return json.Marshal(objectMap)
}

// GenericResourceExpanded resource information.
type GenericResourceExpanded struct {
	// CreatedTime - READ-ONLY; The created time of the resource. This is only present if requested via the $expand query parameter.
	CreatedTime *date.Time `json:"createdTime,omitempty"`
	// ChangedTime - READ-ONLY; The changed time of the resource. This is only present if requested via the $expand query parameter.
	ChangedTime *date.Time `json:"changedTime,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. This is only present if requested via the $expand query parameter.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Plan - The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`
	// Properties - The resource properties.
	Properties interface{} `json:"properties,omitempty"`
	// Kind - The kind of the resource.
	Kind *string `json:"kind,omitempty"`
	// ManagedBy - ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Sku - The SKU of the resource.
	Sku *Sku `json:"sku,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ExtendedLocation - Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GenericResourceExpanded.
func (gre GenericResourceExpanded) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gre.Plan != nil {
		objectMap["plan"] = gre.Plan
	}
	if gre.Properties != nil {
		objectMap["properties"] = gre.Properties
	}
	if gre.Kind != nil {
		objectMap["kind"] = gre.Kind
	}
	if gre.ManagedBy != nil {
		objectMap["managedBy"] = gre.ManagedBy
	}
	if gre.Sku != nil {
		objectMap["sku"] = gre.Sku
	}
	if gre.Identity != nil {
		objectMap["identity"] = gre.Identity
	}
	if gre.Location != nil {
		objectMap["location"] = gre.Location
	}
	if gre.ExtendedLocation != nil {
		objectMap["extendedLocation"] = gre.ExtendedLocation
	}
	if gre.Tags != nil {
		objectMap["tags"] = gre.Tags
	}
	return json.Marshal(objectMap)
}

// GenericResourceFilter resource filter.
type GenericResourceFilter struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Tagname - The tag name.
	Tagname *string `json:"tagname,omitempty"`
	// Tagvalue - The tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// Group resource group information.
type Group struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the resource group.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the resource group.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the resource group.
	Type *string `json:"type,omitempty"`
	// Properties - The resource group properties.
	Properties *GroupProperties `json:"properties,omitempty"`
	// Location - The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
	Location *string `json:"location,omitempty"`
	// ManagedBy - The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Tags - The tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Group.
func (g Group) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if g.Properties != nil {
		objectMap["properties"] = g.Properties
	}
	if g.Location != nil {
		objectMap["location"] = g.Location
	}
	if g.ManagedBy != nil {
		objectMap["managedBy"] = g.ManagedBy
	}
	if g.Tags != nil {
		objectMap["tags"] = g.Tags
	}
	return json.Marshal(objectMap)
}

// GroupExportResult resource group export result.
type GroupExportResult struct {
	autorest.Response `json:"-"`
	// Template - The template content.
	Template interface{} `json:"template,omitempty"`
	// Error - The template export error.
	Error *ErrorResponse `json:"error,omitempty"`
}

// GroupFilter resource group filter.
type GroupFilter struct {
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// GroupListResult list of resource groups.
type GroupListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resource groups.
	Value *[]Group `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupListResult.
func (glr GroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if glr.Value != nil {
		objectMap["value"] = glr.Value
	}
	return json.Marshal(objectMap)
}

// GroupListResultIterator provides access to a complete listing of Group values.
type GroupListResultIterator struct {
	i    int
	page GroupListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *GroupListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *GroupListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter GroupListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter GroupListResultIterator) Response() GroupListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter GroupListResultIterator) Value() Group {
	if !iter.page.NotDone() {
		return Group{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the GroupListResultIterator type.
func NewGroupListResultIterator(page GroupListResultPage) GroupListResultIterator {
	return GroupListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (glr GroupListResult) IsEmpty() bool {
	return glr.Value == nil || len(*glr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (glr GroupListResult) hasNextLink() bool {
	return glr.NextLink != nil && len(*glr.NextLink) != 0
}

// groupListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (glr GroupListResult) groupListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !glr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(glr.NextLink)))
}

// GroupListResultPage contains a page of Group values.
type GroupListResultPage struct {
	fn  func(context.Context, GroupListResult) (GroupListResult, error)
	glr GroupListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *GroupListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/GroupListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.glr)
		if err != nil {
			return err
		}
		page.glr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *GroupListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page GroupListResultPage) NotDone() bool {
	return !page.glr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page GroupListResultPage) Response() GroupListResult {
	return page.glr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page GroupListResultPage) Values() []Group {
	if page.glr.IsEmpty() {
		return nil
	}
	return *page.glr.Value
}

// Creates a new instance of the GroupListResultPage type.
func NewGroupListResultPage(cur GroupListResult, getNextPage func(context.Context, GroupListResult) (GroupListResult, error)) GroupListResultPage {
	return GroupListResultPage{
		fn:  getNextPage,
		glr: cur,
	}
}

// GroupPatchable resource group information.
type GroupPatchable struct {
	// Name - The name of the resource group.
	Name *string `json:"name,omitempty"`
	// Properties - The resource group properties.
	Properties *GroupProperties `json:"properties,omitempty"`
	// ManagedBy - The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`
	// Tags - The tags attached to the resource group.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for GroupPatchable.
func (gp GroupPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if gp.Name != nil {
		objectMap["name"] = gp.Name
	}
	if gp.Properties != nil {
		objectMap["properties"] = gp.Properties
	}
	if gp.ManagedBy != nil {
		objectMap["managedBy"] = gp.ManagedBy
	}
	if gp.Tags != nil {
		objectMap["tags"] = gp.Tags
	}
	return json.Marshal(objectMap)
}

// GroupProperties the resource group properties.
type GroupProperties struct {
	// ProvisioningState - READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for GroupProperties.
func (gp GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// GroupsDeleteFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type GroupsDeleteFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GroupsDeleteFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GroupsDeleteFuture.Result.
func (future *GroupsDeleteFuture) result(client GroupsClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.GroupsDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.GroupsDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// GroupsExportTemplateFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type GroupsExportTemplateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(GroupsClient) (GroupExportResult, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *GroupsExportTemplateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for GroupsExportTemplateFuture.Result.
func (future *GroupsExportTemplateFuture) result(client GroupsClient) (ger GroupExportResult, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.GroupsExportTemplateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ger.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.GroupsExportTemplateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if ger.Response.Response, err = future.GetResult(sender); err == nil && ger.Response.Response.StatusCode != http.StatusNoContent {
		ger, err = client.ExportTemplateResponder(ger.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.GroupsExportTemplateFuture", "Result", ger.Response.Response, "Failure responding to request")
		}
	}
	return
}

// HTTPMessage HTTP message.
type HTTPMessage struct {
	// Content - HTTP message content.
	Content interface{} `json:"content,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'ResourceIdentityTypeSystemAssigned', 'ResourceIdentityTypeUserAssigned', 'ResourceIdentityTypeSystemAssignedUserAssigned', 'ResourceIdentityTypeNone'
	Type ResourceIdentityType `json:"type,omitempty"`
	// UserAssignedIdentities - The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*IdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities"`
}

// MarshalJSON is the custom marshaler for Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.Type != "" {
		objectMap["type"] = i.Type
	}
	if i.UserAssignedIdentities != nil {
		objectMap["userAssignedIdentities"] = i.UserAssignedIdentities
	}
	return json.Marshal(objectMap)
}

// IdentityUserAssignedIdentitiesValue ...
type IdentityUserAssignedIdentitiesValue struct {
	// PrincipalID - READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// ClientID - READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty"`
}

// MarshalJSON is the custom marshaler for IdentityUserAssignedIdentitiesValue.
func (iAiv IdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ListResult list of resource groups.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resources.
	Value *[]GenericResourceExpanded `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ListResult.
func (lr ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if lr.Value != nil {
		objectMap["value"] = lr.Value
	}
	return json.Marshal(objectMap)
}

// ListResultIterator provides access to a complete listing of GenericResourceExpanded values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() GenericResourceExpanded {
	if !iter.page.NotDone() {
		return GenericResourceExpanded{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of GenericResourceExpanded values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []GenericResourceExpanded {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// MoveInfo parameters of move resources.
type MoveInfo struct {
	// ResourcesProperty - The IDs of the resources.
	ResourcesProperty *[]string `json:"resources,omitempty"`
	// TargetResourceGroup - The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// MoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type MoveResourcesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *MoveResourcesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for MoveResourcesFuture.Result.
func (future *MoveResourcesFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.MoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.MoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// OnErrorDeployment deployment on error behavior.
type OnErrorDeployment struct {
	// Type - The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment. Possible values include: 'LastSuccessful', 'SpecificDeployment'
	Type OnErrorDeploymentType `json:"type,omitempty"`
	// DeploymentName - The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`
}

// OnErrorDeploymentExtended deployment on error behavior with additional details.
type OnErrorDeploymentExtended struct {
	// ProvisioningState - READ-ONLY; The state of the provisioning for the on error deployment.
	ProvisioningState *string `json:"provisioningState,omitempty"`
	// Type - The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment. Possible values include: 'LastSuccessful', 'SpecificDeployment'
	Type OnErrorDeploymentType `json:"type,omitempty"`
	// DeploymentName - The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`
}

// MarshalJSON is the custom marshaler for OnErrorDeploymentExtended.
func (oede OnErrorDeploymentExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if oede.Type != "" {
		objectMap["type"] = oede.Type
	}
	if oede.DeploymentName != nil {
		objectMap["deploymentName"] = oede.DeploymentName
	}
	return json.Marshal(objectMap)
}

// Operation microsoft.Resources operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - Service provider: Microsoft.Resources
	Provider *string `json:"provider,omitempty"`
	// Resource - Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
	// Description - Description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult result of the request to list Microsoft.Resources operations. It contains a list of
// operations and a URL link to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of Microsoft.Resources operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// ParametersLink entity representing the reference to the deployment parameters.
type ParametersLink struct {
	// URI - The URI of the parameters file.
	URI *string `json:"uri,omitempty"`
	// ContentVersion - If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Permission role definition permissions.
type Permission struct {
	// Actions - Allowed actions.
	Actions *[]string `json:"actions,omitempty"`
	// NotActions - Denied actions.
	NotActions *[]string `json:"notActions,omitempty"`
	// DataActions - Allowed Data actions.
	DataActions *[]string `json:"dataActions,omitempty"`
	// NotDataActions - Denied Data actions.
	NotDataActions *[]string `json:"notDataActions,omitempty"`
}

// Plan plan for the resource.
type Plan struct {
	// Name - The plan ID.
	Name *string `json:"name,omitempty"`
	// Publisher - The publisher ID.
	Publisher *string `json:"publisher,omitempty"`
	// Product - The offer ID.
	Product *string `json:"product,omitempty"`
	// PromotionCode - The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`
	// Version - The plan's version.
	Version *string `json:"version,omitempty"`
}

// Provider resource provider information.
type Provider struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The provider ID.
	ID *string `json:"id,omitempty"`
	// Namespace - The namespace of the resource provider.
	Namespace *string `json:"namespace,omitempty"`
	// RegistrationState - READ-ONLY; The registration state of the resource provider.
	RegistrationState *string `json:"registrationState,omitempty"`
	// RegistrationPolicy - READ-ONLY; The registration policy of the resource provider.
	RegistrationPolicy *string `json:"registrationPolicy,omitempty"`
	// ResourceTypes - READ-ONLY; The collection of provider resource types.
	ResourceTypes *[]ProviderResourceType `json:"resourceTypes,omitempty"`
	// ProviderAuthorizationConsentState - The provider authorization consent state. Possible values include: 'ProviderAuthorizationConsentStateNotSpecified', 'ProviderAuthorizationConsentStateRequired', 'ProviderAuthorizationConsentStateNotRequired', 'ProviderAuthorizationConsentStateConsented'
	ProviderAuthorizationConsentState ProviderAuthorizationConsentState `json:"providerAuthorizationConsentState,omitempty"`
}

// MarshalJSON is the custom marshaler for Provider.
func (p Provider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Namespace != nil {
		objectMap["namespace"] = p.Namespace
	}
	if p.ProviderAuthorizationConsentState != "" {
		objectMap["providerAuthorizationConsentState"] = p.ProviderAuthorizationConsentState
	}
	return json.Marshal(objectMap)
}

// ProviderConsentDefinition the provider consent.
type ProviderConsentDefinition struct {
	// ConsentToAuthorization - A value indicating whether authorization is consented or not.
	ConsentToAuthorization *bool `json:"consentToAuthorization,omitempty"`
}

// ProviderExtendedLocation the provider extended location.
type ProviderExtendedLocation struct {
	// Location - The azure location.
	Location *string `json:"location,omitempty"`
	// Type - The extended location type.
	Type *string `json:"type,omitempty"`
	// ExtendedLocations - The extended locations for the azure location.
	ExtendedLocations *[]string `json:"extendedLocations,omitempty"`
}

// ProviderListResult list of resource providers.
type ProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resource providers.
	Value *[]Provider `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderListResult.
func (plr ProviderListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if plr.Value != nil {
		objectMap["value"] = plr.Value
	}
	return json.Marshal(objectMap)
}

// ProviderListResultIterator provides access to a complete listing of Provider values.
type ProviderListResultIterator struct {
	i    int
	page ProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProviderListResultIterator) Response() ProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProviderListResultIterator) Value() Provider {
	if !iter.page.NotDone() {
		return Provider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProviderListResultIterator type.
func NewProviderListResultIterator(page ProviderListResultPage) ProviderListResultIterator {
	return ProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr ProviderListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr ProviderListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// providerListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr ProviderListResult) providerListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// ProviderListResultPage contains a page of Provider values.
type ProviderListResultPage struct {
	fn  func(context.Context, ProviderListResult) (ProviderListResult, error)
	plr ProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProviderListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProviderListResultPage) Response() ProviderListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProviderListResultPage) Values() []Provider {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the ProviderListResultPage type.
func NewProviderListResultPage(cur ProviderListResult, getNextPage func(context.Context, ProviderListResult) (ProviderListResult, error)) ProviderListResultPage {
	return ProviderListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// ProviderOperationDisplayProperties resource provider operation's display properties.
type ProviderOperationDisplayProperties struct {
	// Publisher - Operation description.
	Publisher *string `json:"publisher,omitempty"`
	// Provider - Operation provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - Operation resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - Resource provider operation.
	Operation *string `json:"operation,omitempty"`
	// Description - Operation description.
	Description *string `json:"description,omitempty"`
}

// ProviderPermission the provider permission
type ProviderPermission struct {
	// ApplicationID - The application id.
	ApplicationID *string `json:"applicationId,omitempty"`
	// RoleDefinition - Role definition properties.
	RoleDefinition *RoleDefinition `json:"roleDefinition,omitempty"`
	// ManagedByRoleDefinition - Role definition properties.
	ManagedByRoleDefinition *RoleDefinition `json:"managedByRoleDefinition,omitempty"`
	// ProviderAuthorizationConsentState - The provider authorization consent state. Possible values include: 'ProviderAuthorizationConsentStateNotSpecified', 'ProviderAuthorizationConsentStateRequired', 'ProviderAuthorizationConsentStateNotRequired', 'ProviderAuthorizationConsentStateConsented'
	ProviderAuthorizationConsentState ProviderAuthorizationConsentState `json:"providerAuthorizationConsentState,omitempty"`
}

// ProviderPermissionListResult list of provider permissions.
type ProviderPermissionListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of provider permissions.
	Value *[]ProviderPermission `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderPermissionListResult.
func (pplr ProviderPermissionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pplr.Value != nil {
		objectMap["value"] = pplr.Value
	}
	return json.Marshal(objectMap)
}

// ProviderRegistrationRequest the provider registration definition.
type ProviderRegistrationRequest struct {
	// ThirdPartyProviderConsent - The provider consent.
	ThirdPartyProviderConsent *ProviderConsentDefinition `json:"thirdPartyProviderConsent,omitempty"`
}

// ProviderResourceType resource type managed by the resource provider.
type ProviderResourceType struct {
	// ResourceType - The resource type.
	ResourceType *string `json:"resourceType,omitempty"`
	// Locations - The collection of locations where this resource type can be created.
	Locations *[]string `json:"locations,omitempty"`
	// LocationMappings - The location mappings that are supported by this resource type.
	LocationMappings *[]ProviderExtendedLocation `json:"locationMappings,omitempty"`
	// Aliases - The aliases that are supported by this resource type.
	Aliases *[]Alias `json:"aliases,omitempty"`
	// APIVersions - The API version.
	APIVersions *[]string `json:"apiVersions,omitempty"`
	// DefaultAPIVersion - READ-ONLY; The default API version.
	DefaultAPIVersion *string        `json:"defaultApiVersion,omitempty"`
	ZoneMappings      *[]ZoneMapping `json:"zoneMappings,omitempty"`
	// APIProfiles - READ-ONLY; The API profiles for the resource provider.
	APIProfiles *[]APIProfile `json:"apiProfiles,omitempty"`
	// Capabilities - The additional capabilities offered by this resource type.
	Capabilities *string `json:"capabilities,omitempty"`
	// Properties - The properties.
	Properties map[string]*string `json:"properties"`
}

// MarshalJSON is the custom marshaler for ProviderResourceType.
func (prt ProviderResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prt.ResourceType != nil {
		objectMap["resourceType"] = prt.ResourceType
	}
	if prt.Locations != nil {
		objectMap["locations"] = prt.Locations
	}
	if prt.LocationMappings != nil {
		objectMap["locationMappings"] = prt.LocationMappings
	}
	if prt.Aliases != nil {
		objectMap["aliases"] = prt.Aliases
	}
	if prt.APIVersions != nil {
		objectMap["apiVersions"] = prt.APIVersions
	}
	if prt.ZoneMappings != nil {
		objectMap["zoneMappings"] = prt.ZoneMappings
	}
	if prt.Capabilities != nil {
		objectMap["capabilities"] = prt.Capabilities
	}
	if prt.Properties != nil {
		objectMap["properties"] = prt.Properties
	}
	return json.Marshal(objectMap)
}

// ProviderResourceTypeListResult list of resource types of a resource provider.
type ProviderResourceTypeListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of resource types.
	Value *[]ProviderResourceType `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for ProviderResourceTypeListResult.
func (prtlr ProviderResourceTypeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if prtlr.Value != nil {
		objectMap["value"] = prtlr.Value
	}
	return json.Marshal(objectMap)
}

// Reference the resource Id model.
type Reference struct {
	// ID - READ-ONLY; The fully qualified resource Id.
	ID *string `json:"id,omitempty"`
}

// MarshalJSON is the custom marshaler for Reference.
func (r Reference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// Resource specified resource.
type Resource struct {
	// ID - READ-ONLY; Resource ID
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type
	Type *string `json:"type,omitempty"`
	// Location - Resource location
	Location *string `json:"location,omitempty"`
	// ExtendedLocation - Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`
	// Tags - Resource tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.ExtendedLocation != nil {
		objectMap["extendedLocation"] = r.ExtendedLocation
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// RoleDefinition role definition properties.
type RoleDefinition struct {
	// ID - The role definition ID.
	ID *string `json:"id,omitempty"`
	// Name - The role definition name.
	Name *string `json:"name,omitempty"`
	// IsServiceRole - If this is a service role.
	IsServiceRole *bool `json:"isServiceRole,omitempty"`
	// Permissions - Role definition permissions.
	Permissions *[]Permission `json:"permissions,omitempty"`
	// Scopes - Role definition assignable scopes.
	Scopes *[]string `json:"scopes,omitempty"`
}

// ScopedDeployment deployment operation parameters.
type ScopedDeployment struct {
	// Location - The location to store the deployment data.
	Location *string `json:"location,omitempty"`
	// Properties - The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`
	// Tags - Deployment tags
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ScopedDeployment.
func (sd ScopedDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sd.Location != nil {
		objectMap["location"] = sd.Location
	}
	if sd.Properties != nil {
		objectMap["properties"] = sd.Properties
	}
	if sd.Tags != nil {
		objectMap["tags"] = sd.Tags
	}
	return json.Marshal(objectMap)
}

// ScopedDeploymentWhatIf deployment What-if operation parameters.
type ScopedDeploymentWhatIf struct {
	// Location - The location to store the deployment data.
	Location *string `json:"location,omitempty"`
	// Properties - The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`
}

// Sku SKU for the resource.
type Sku struct {
	// Name - The SKU name.
	Name *string `json:"name,omitempty"`
	// Tier - The SKU tier.
	Tier *string `json:"tier,omitempty"`
	// Size - The SKU size.
	Size *string `json:"size,omitempty"`
	// Family - The SKU family.
	Family *string `json:"family,omitempty"`
	// Model - The SKU model.
	Model *string `json:"model,omitempty"`
	// Capacity - The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`
}

// StatusMessage operation status message object.
type StatusMessage struct {
	// Status - Status of the deployment operation.
	Status *string `json:"status,omitempty"`
	// Error - The error reported by the operation.
	Error *ErrorResponse `json:"error,omitempty"`
}

// SubResource sub-resource.
type SubResource struct {
	// ID - Resource ID
	ID *string `json:"id,omitempty"`
}

// TagCount tag count.
type TagCount struct {
	// Type - Type of count.
	Type *string `json:"type,omitempty"`
	// Value - Value of count.
	Value *int32 `json:"value,omitempty"`
}

// TagDetails tag details.
type TagDetails struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The tag name ID.
	ID *string `json:"id,omitempty"`
	// TagName - The tag name.
	TagName *string `json:"tagName,omitempty"`
	// Count - The total number of resources that use the resource tag. When a tag is initially created and has no associated resources, the value is 0.
	Count *TagCount `json:"count,omitempty"`
	// Values - The list of tag values.
	Values *[]TagValue `json:"values,omitempty"`
}

// MarshalJSON is the custom marshaler for TagDetails.
func (td TagDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if td.TagName != nil {
		objectMap["tagName"] = td.TagName
	}
	if td.Count != nil {
		objectMap["count"] = td.Count
	}
	if td.Values != nil {
		objectMap["values"] = td.Values
	}
	return json.Marshal(objectMap)
}

// Tags a dictionary of name and value pairs.
type Tags struct {
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if t.Tags != nil {
		objectMap["tags"] = t.Tags
	}
	return json.Marshal(objectMap)
}

// TagsListResult list of subscription tags.
type TagsListResult struct {
	autorest.Response `json:"-"`
	// Value - An array of tags.
	Value *[]TagDetails `json:"value,omitempty"`
	// NextLink - READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for TagsListResult.
func (tlr TagsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tlr.Value != nil {
		objectMap["value"] = tlr.Value
	}
	return json.Marshal(objectMap)
}

// TagsListResultIterator provides access to a complete listing of TagDetails values.
type TagsListResultIterator struct {
	i    int
	page TagsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *TagsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *TagsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter TagsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter TagsListResultIterator) Response() TagsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter TagsListResultIterator) Value() TagDetails {
	if !iter.page.NotDone() {
		return TagDetails{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the TagsListResultIterator type.
func NewTagsListResultIterator(page TagsListResultPage) TagsListResultIterator {
	return TagsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (tlr TagsListResult) IsEmpty() bool {
	return tlr.Value == nil || len(*tlr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (tlr TagsListResult) hasNextLink() bool {
	return tlr.NextLink != nil && len(*tlr.NextLink) != 0
}

// tagsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (tlr TagsListResult) tagsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !tlr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(tlr.NextLink)))
}

// TagsListResultPage contains a page of TagDetails values.
type TagsListResultPage struct {
	fn  func(context.Context, TagsListResult) (TagsListResult, error)
	tlr TagsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *TagsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/TagsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.tlr)
		if err != nil {
			return err
		}
		page.tlr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *TagsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page TagsListResultPage) NotDone() bool {
	return !page.tlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page TagsListResultPage) Response() TagsListResult {
	return page.tlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page TagsListResultPage) Values() []TagDetails {
	if page.tlr.IsEmpty() {
		return nil
	}
	return *page.tlr.Value
}

// Creates a new instance of the TagsListResultPage type.
func NewTagsListResultPage(cur TagsListResult, getNextPage func(context.Context, TagsListResult) (TagsListResult, error)) TagsListResultPage {
	return TagsListResultPage{
		fn:  getNextPage,
		tlr: cur,
	}
}

// TagsPatchResource wrapper resource for tags patch API request only.
type TagsPatchResource struct {
	// Operation - The operation type for the patch API. Possible values include: 'TagsPatchOperationReplace', 'TagsPatchOperationMerge', 'TagsPatchOperationDelete'
	Operation TagsPatchOperation `json:"operation,omitempty"`
	// Properties - The set of tags.
	Properties *Tags `json:"properties,omitempty"`
}

// TagsResource wrapper resource for tags API requests and responses.
type TagsResource struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The ID of the tags wrapper resource.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; The name of the tags wrapper resource.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; The type of the tags wrapper resource.
	Type *string `json:"type,omitempty"`
	// Properties - The set of tags.
	Properties *Tags `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for TagsResource.
func (tr TagsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tr.Properties != nil {
		objectMap["properties"] = tr.Properties
	}
	return json.Marshal(objectMap)
}

// TagValue tag information.
type TagValue struct {
	autorest.Response `json:"-"`
	// ID - READ-ONLY; The tag value ID.
	ID *string `json:"id,omitempty"`
	// TagValue - The tag value.
	TagValue *string `json:"tagValue,omitempty"`
	// Count - The tag value count.
	Count *TagCount `json:"count,omitempty"`
}

// MarshalJSON is the custom marshaler for TagValue.
func (tv TagValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if tv.TagValue != nil {
		objectMap["tagValue"] = tv.TagValue
	}
	if tv.Count != nil {
		objectMap["count"] = tv.Count
	}
	return json.Marshal(objectMap)
}

// TargetResource target resource.
type TargetResource struct {
	// ID - The ID of the resource.
	ID *string `json:"id,omitempty"`
	// ResourceName - The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`
	// ResourceType - The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateHashResult result of the request to calculate template hash. It contains a string of minified
// template and its hash.
type TemplateHashResult struct {
	autorest.Response `json:"-"`
	// MinifiedTemplate - The minified template string.
	MinifiedTemplate *string `json:"minifiedTemplate,omitempty"`
	// TemplateHash - The template hash.
	TemplateHash *string `json:"templateHash,omitempty"`
}

// TemplateLink entity representing the reference to the template.
type TemplateLink struct {
	// URI - The URI of the template to deploy. Use either the uri or id property, but not both.
	URI *string `json:"uri,omitempty"`
	// ID - The resource id of a Template Spec. Use either the id or uri property, but not both.
	ID *string `json:"id,omitempty"`
	// RelativePath - The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template was linked with a TemplateSpec, this will reference an artifact in the TemplateSpec.  If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath URIs
	RelativePath *string `json:"relativePath,omitempty"`
	// ContentVersion - If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
	// QueryString - The query string (for example, a SAS token) to be used with the templateLink URI.
	QueryString *string `json:"queryString,omitempty"`
}

// UpdateByIDFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateByIDFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (GenericResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateByIDFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateByIDFuture.Result.
func (future *UpdateByIDFuture) result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateByIDFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.UpdateByIDFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateByIDResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateByIDFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// UpdateFuture an abstraction for monitoring and retrieving the results of a long-running operation.
type UpdateFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (GenericResource, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *UpdateFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for UpdateFuture.Result.
func (future *UpdateFuture) result(client Client) (gr GenericResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		gr.Response.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.UpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if gr.Response.Response, err = future.GetResult(sender); err == nil && gr.Response.Response.StatusCode != http.StatusNoContent {
		gr, err = client.UpdateResponder(gr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "resources.UpdateFuture", "Result", gr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// ValidateMoveResourcesFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type ValidateMoveResourcesFuture struct {
	azure.FutureAPI
	// Result returns the result of the asynchronous operation.
	// If the operation has not completed it will return an error.
	Result func(Client) (autorest.Response, error)
}

// UnmarshalJSON is the custom unmarshaller for CreateFuture.
func (future *ValidateMoveResourcesFuture) UnmarshalJSON(body []byte) error {
	var azFuture azure.Future
	if err := json.Unmarshal(body, &azFuture); err != nil {
		return err
	}
	future.FutureAPI = &azFuture
	future.Result = future.result
	return nil
}

// result is the default implementation for ValidateMoveResourcesFuture.Result.
func (future *ValidateMoveResourcesFuture) result(client Client) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "resources.ValidateMoveResourcesFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		ar.Response = future.Response()
		err = azure.NewAsyncOpIncompleteError("resources.ValidateMoveResourcesFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WhatIfChange information about a single resource change predicted by What-If operation.
type WhatIfChange struct {
	// ResourceID - Resource ID
	ResourceID *string `json:"resourceId,omitempty"`
	// ChangeType - Type of change that will be made to the resource when the deployment is executed. Possible values include: 'Create', 'Delete', 'Ignore', 'Deploy', 'NoChange', 'Modify', 'Unsupported'
	ChangeType ChangeType `json:"changeType,omitempty"`
	// UnsupportedReason - The explanation about why the resource is unsupported by What-If.
	UnsupportedReason *string `json:"unsupportedReason,omitempty"`
	// Before - The snapshot of the resource before the deployment is executed.
	Before interface{} `json:"before,omitempty"`
	// After - The predicted snapshot of the resource after the deployment is executed.
	After interface{} `json:"after,omitempty"`
	// Delta - The predicted changes to resource properties.
	Delta *[]WhatIfPropertyChange `json:"delta,omitempty"`
}

// WhatIfOperationProperties deployment operation properties.
type WhatIfOperationProperties struct {
	// Changes - List of resource changes predicted by What-If operation.
	Changes *[]WhatIfChange `json:"changes,omitempty"`
}

// WhatIfOperationResult result of the What-If operation. Contains a list of predicted changes and a URL
// link to get to the next set of results.
type WhatIfOperationResult struct {
	autorest.Response `json:"-"`
	// Status - Status of the What-If operation.
	Status *string `json:"status,omitempty"`
	// WhatIfOperationProperties - What-If operation properties.
	*WhatIfOperationProperties `json:"properties,omitempty"`
	// Error - Error when What-If operation fails.
	Error *ErrorResponse `json:"error,omitempty"`
}

// MarshalJSON is the custom marshaler for WhatIfOperationResult.
func (wior WhatIfOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wior.Status != nil {
		objectMap["status"] = wior.Status
	}
	if wior.WhatIfOperationProperties != nil {
		objectMap["properties"] = wior.WhatIfOperationProperties
	}
	if wior.Error != nil {
		objectMap["error"] = wior.Error
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WhatIfOperationResult struct.
func (wior *WhatIfOperationResult) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "status":
			if v != nil {
				var status string
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				wior.Status = &status
			}
		case "properties":
			if v != nil {
				var whatIfOperationProperties WhatIfOperationProperties
				err = json.Unmarshal(*v, &whatIfOperationProperties)
				if err != nil {
					return err
				}
				wior.WhatIfOperationProperties = &whatIfOperationProperties
			}
		case "error":
			if v != nil {
				var errorVar ErrorResponse
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				wior.Error = &errorVar
			}
		}
	}

	return nil
}

// WhatIfPropertyChange the predicted change to the resource property.
type WhatIfPropertyChange struct {
	// Path - The path of the property.
	Path *string `json:"path,omitempty"`
	// PropertyChangeType - The type of property change. Possible values include: 'PropertyChangeTypeCreate', 'PropertyChangeTypeDelete', 'PropertyChangeTypeModify', 'PropertyChangeTypeArray', 'PropertyChangeTypeNoEffect'
	PropertyChangeType PropertyChangeType `json:"propertyChangeType,omitempty"`
	// Before - The value of the property before the deployment is executed.
	Before interface{} `json:"before,omitempty"`
	// After - The value of the property after the deployment is executed.
	After interface{} `json:"after,omitempty"`
	// Children - Nested property changes.
	Children *[]WhatIfPropertyChange `json:"children,omitempty"`
}

// ZoneMapping ...
type ZoneMapping struct {
	// Location - The location of the zone mapping.
	Location *string   `json:"location,omitempty"`
	Zones    *[]string `json:"zones,omitempty"`
}
