// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package chimesdkvoiceiface provides an interface to enable mocking the Amazon Chime SDK Voice service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package chimesdkvoiceiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/chimesdkvoice"
)

// ChimeSDKVoiceAPI provides an interface to enable mocking the
// chimesdkvoice.ChimeSDKVoice service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon Chime SDK Voice.
//	func myFunc(svc chimesdkvoiceiface.ChimeSDKVoiceAPI) bool {
//	    // Make svc.AssociatePhoneNumbersWithVoiceConnector request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := chimesdkvoice.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockChimeSDKVoiceClient struct {
//	    chimesdkvoiceiface.ChimeSDKVoiceAPI
//	}
//	func (m *mockChimeSDKVoiceClient) AssociatePhoneNumbersWithVoiceConnector(input *chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorInput) (*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockChimeSDKVoiceClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ChimeSDKVoiceAPI interface {
	AssociatePhoneNumbersWithVoiceConnector(*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorInput) (*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorOutput, error)
	AssociatePhoneNumbersWithVoiceConnectorWithContext(aws.Context, *chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorInput, ...request.Option) (*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorOutput, error)
	AssociatePhoneNumbersWithVoiceConnectorRequest(*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorInput) (*request.Request, *chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorOutput)

	AssociatePhoneNumbersWithVoiceConnectorGroup(*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupInput) (*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error)
	AssociatePhoneNumbersWithVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupOutput, error)
	AssociatePhoneNumbersWithVoiceConnectorGroupRequest(*chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.AssociatePhoneNumbersWithVoiceConnectorGroupOutput)

	BatchDeletePhoneNumber(*chimesdkvoice.BatchDeletePhoneNumberInput) (*chimesdkvoice.BatchDeletePhoneNumberOutput, error)
	BatchDeletePhoneNumberWithContext(aws.Context, *chimesdkvoice.BatchDeletePhoneNumberInput, ...request.Option) (*chimesdkvoice.BatchDeletePhoneNumberOutput, error)
	BatchDeletePhoneNumberRequest(*chimesdkvoice.BatchDeletePhoneNumberInput) (*request.Request, *chimesdkvoice.BatchDeletePhoneNumberOutput)

	BatchUpdatePhoneNumber(*chimesdkvoice.BatchUpdatePhoneNumberInput) (*chimesdkvoice.BatchUpdatePhoneNumberOutput, error)
	BatchUpdatePhoneNumberWithContext(aws.Context, *chimesdkvoice.BatchUpdatePhoneNumberInput, ...request.Option) (*chimesdkvoice.BatchUpdatePhoneNumberOutput, error)
	BatchUpdatePhoneNumberRequest(*chimesdkvoice.BatchUpdatePhoneNumberInput) (*request.Request, *chimesdkvoice.BatchUpdatePhoneNumberOutput)

	CreatePhoneNumberOrder(*chimesdkvoice.CreatePhoneNumberOrderInput) (*chimesdkvoice.CreatePhoneNumberOrderOutput, error)
	CreatePhoneNumberOrderWithContext(aws.Context, *chimesdkvoice.CreatePhoneNumberOrderInput, ...request.Option) (*chimesdkvoice.CreatePhoneNumberOrderOutput, error)
	CreatePhoneNumberOrderRequest(*chimesdkvoice.CreatePhoneNumberOrderInput) (*request.Request, *chimesdkvoice.CreatePhoneNumberOrderOutput)

	CreateProxySession(*chimesdkvoice.CreateProxySessionInput) (*chimesdkvoice.CreateProxySessionOutput, error)
	CreateProxySessionWithContext(aws.Context, *chimesdkvoice.CreateProxySessionInput, ...request.Option) (*chimesdkvoice.CreateProxySessionOutput, error)
	CreateProxySessionRequest(*chimesdkvoice.CreateProxySessionInput) (*request.Request, *chimesdkvoice.CreateProxySessionOutput)

	CreateSipMediaApplication(*chimesdkvoice.CreateSipMediaApplicationInput) (*chimesdkvoice.CreateSipMediaApplicationOutput, error)
	CreateSipMediaApplicationWithContext(aws.Context, *chimesdkvoice.CreateSipMediaApplicationInput, ...request.Option) (*chimesdkvoice.CreateSipMediaApplicationOutput, error)
	CreateSipMediaApplicationRequest(*chimesdkvoice.CreateSipMediaApplicationInput) (*request.Request, *chimesdkvoice.CreateSipMediaApplicationOutput)

	CreateSipMediaApplicationCall(*chimesdkvoice.CreateSipMediaApplicationCallInput) (*chimesdkvoice.CreateSipMediaApplicationCallOutput, error)
	CreateSipMediaApplicationCallWithContext(aws.Context, *chimesdkvoice.CreateSipMediaApplicationCallInput, ...request.Option) (*chimesdkvoice.CreateSipMediaApplicationCallOutput, error)
	CreateSipMediaApplicationCallRequest(*chimesdkvoice.CreateSipMediaApplicationCallInput) (*request.Request, *chimesdkvoice.CreateSipMediaApplicationCallOutput)

	CreateSipRule(*chimesdkvoice.CreateSipRuleInput) (*chimesdkvoice.CreateSipRuleOutput, error)
	CreateSipRuleWithContext(aws.Context, *chimesdkvoice.CreateSipRuleInput, ...request.Option) (*chimesdkvoice.CreateSipRuleOutput, error)
	CreateSipRuleRequest(*chimesdkvoice.CreateSipRuleInput) (*request.Request, *chimesdkvoice.CreateSipRuleOutput)

	CreateVoiceConnector(*chimesdkvoice.CreateVoiceConnectorInput) (*chimesdkvoice.CreateVoiceConnectorOutput, error)
	CreateVoiceConnectorWithContext(aws.Context, *chimesdkvoice.CreateVoiceConnectorInput, ...request.Option) (*chimesdkvoice.CreateVoiceConnectorOutput, error)
	CreateVoiceConnectorRequest(*chimesdkvoice.CreateVoiceConnectorInput) (*request.Request, *chimesdkvoice.CreateVoiceConnectorOutput)

	CreateVoiceConnectorGroup(*chimesdkvoice.CreateVoiceConnectorGroupInput) (*chimesdkvoice.CreateVoiceConnectorGroupOutput, error)
	CreateVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.CreateVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.CreateVoiceConnectorGroupOutput, error)
	CreateVoiceConnectorGroupRequest(*chimesdkvoice.CreateVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.CreateVoiceConnectorGroupOutput)

	CreateVoiceProfile(*chimesdkvoice.CreateVoiceProfileInput) (*chimesdkvoice.CreateVoiceProfileOutput, error)
	CreateVoiceProfileWithContext(aws.Context, *chimesdkvoice.CreateVoiceProfileInput, ...request.Option) (*chimesdkvoice.CreateVoiceProfileOutput, error)
	CreateVoiceProfileRequest(*chimesdkvoice.CreateVoiceProfileInput) (*request.Request, *chimesdkvoice.CreateVoiceProfileOutput)

	CreateVoiceProfileDomain(*chimesdkvoice.CreateVoiceProfileDomainInput) (*chimesdkvoice.CreateVoiceProfileDomainOutput, error)
	CreateVoiceProfileDomainWithContext(aws.Context, *chimesdkvoice.CreateVoiceProfileDomainInput, ...request.Option) (*chimesdkvoice.CreateVoiceProfileDomainOutput, error)
	CreateVoiceProfileDomainRequest(*chimesdkvoice.CreateVoiceProfileDomainInput) (*request.Request, *chimesdkvoice.CreateVoiceProfileDomainOutput)

	DeletePhoneNumber(*chimesdkvoice.DeletePhoneNumberInput) (*chimesdkvoice.DeletePhoneNumberOutput, error)
	DeletePhoneNumberWithContext(aws.Context, *chimesdkvoice.DeletePhoneNumberInput, ...request.Option) (*chimesdkvoice.DeletePhoneNumberOutput, error)
	DeletePhoneNumberRequest(*chimesdkvoice.DeletePhoneNumberInput) (*request.Request, *chimesdkvoice.DeletePhoneNumberOutput)

	DeleteProxySession(*chimesdkvoice.DeleteProxySessionInput) (*chimesdkvoice.DeleteProxySessionOutput, error)
	DeleteProxySessionWithContext(aws.Context, *chimesdkvoice.DeleteProxySessionInput, ...request.Option) (*chimesdkvoice.DeleteProxySessionOutput, error)
	DeleteProxySessionRequest(*chimesdkvoice.DeleteProxySessionInput) (*request.Request, *chimesdkvoice.DeleteProxySessionOutput)

	DeleteSipMediaApplication(*chimesdkvoice.DeleteSipMediaApplicationInput) (*chimesdkvoice.DeleteSipMediaApplicationOutput, error)
	DeleteSipMediaApplicationWithContext(aws.Context, *chimesdkvoice.DeleteSipMediaApplicationInput, ...request.Option) (*chimesdkvoice.DeleteSipMediaApplicationOutput, error)
	DeleteSipMediaApplicationRequest(*chimesdkvoice.DeleteSipMediaApplicationInput) (*request.Request, *chimesdkvoice.DeleteSipMediaApplicationOutput)

	DeleteSipRule(*chimesdkvoice.DeleteSipRuleInput) (*chimesdkvoice.DeleteSipRuleOutput, error)
	DeleteSipRuleWithContext(aws.Context, *chimesdkvoice.DeleteSipRuleInput, ...request.Option) (*chimesdkvoice.DeleteSipRuleOutput, error)
	DeleteSipRuleRequest(*chimesdkvoice.DeleteSipRuleInput) (*request.Request, *chimesdkvoice.DeleteSipRuleOutput)

	DeleteVoiceConnector(*chimesdkvoice.DeleteVoiceConnectorInput) (*chimesdkvoice.DeleteVoiceConnectorOutput, error)
	DeleteVoiceConnectorWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorOutput, error)
	DeleteVoiceConnectorRequest(*chimesdkvoice.DeleteVoiceConnectorInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorOutput)

	DeleteVoiceConnectorEmergencyCallingConfiguration(*chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationInput) (*chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error)
	DeleteVoiceConnectorEmergencyCallingConfigurationWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationOutput, error)
	DeleteVoiceConnectorEmergencyCallingConfigurationRequest(*chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorEmergencyCallingConfigurationOutput)

	DeleteVoiceConnectorGroup(*chimesdkvoice.DeleteVoiceConnectorGroupInput) (*chimesdkvoice.DeleteVoiceConnectorGroupOutput, error)
	DeleteVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorGroupOutput, error)
	DeleteVoiceConnectorGroupRequest(*chimesdkvoice.DeleteVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorGroupOutput)

	DeleteVoiceConnectorOrigination(*chimesdkvoice.DeleteVoiceConnectorOriginationInput) (*chimesdkvoice.DeleteVoiceConnectorOriginationOutput, error)
	DeleteVoiceConnectorOriginationWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorOriginationInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorOriginationOutput, error)
	DeleteVoiceConnectorOriginationRequest(*chimesdkvoice.DeleteVoiceConnectorOriginationInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorOriginationOutput)

	DeleteVoiceConnectorProxy(*chimesdkvoice.DeleteVoiceConnectorProxyInput) (*chimesdkvoice.DeleteVoiceConnectorProxyOutput, error)
	DeleteVoiceConnectorProxyWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorProxyInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorProxyOutput, error)
	DeleteVoiceConnectorProxyRequest(*chimesdkvoice.DeleteVoiceConnectorProxyInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorProxyOutput)

	DeleteVoiceConnectorStreamingConfiguration(*chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationInput) (*chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationOutput, error)
	DeleteVoiceConnectorStreamingConfigurationWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationOutput, error)
	DeleteVoiceConnectorStreamingConfigurationRequest(*chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorStreamingConfigurationOutput)

	DeleteVoiceConnectorTermination(*chimesdkvoice.DeleteVoiceConnectorTerminationInput) (*chimesdkvoice.DeleteVoiceConnectorTerminationOutput, error)
	DeleteVoiceConnectorTerminationWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorTerminationInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorTerminationOutput, error)
	DeleteVoiceConnectorTerminationRequest(*chimesdkvoice.DeleteVoiceConnectorTerminationInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorTerminationOutput)

	DeleteVoiceConnectorTerminationCredentials(*chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsInput) (*chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsOutput, error)
	DeleteVoiceConnectorTerminationCredentialsWithContext(aws.Context, *chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsInput, ...request.Option) (*chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsOutput, error)
	DeleteVoiceConnectorTerminationCredentialsRequest(*chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsInput) (*request.Request, *chimesdkvoice.DeleteVoiceConnectorTerminationCredentialsOutput)

	DeleteVoiceProfile(*chimesdkvoice.DeleteVoiceProfileInput) (*chimesdkvoice.DeleteVoiceProfileOutput, error)
	DeleteVoiceProfileWithContext(aws.Context, *chimesdkvoice.DeleteVoiceProfileInput, ...request.Option) (*chimesdkvoice.DeleteVoiceProfileOutput, error)
	DeleteVoiceProfileRequest(*chimesdkvoice.DeleteVoiceProfileInput) (*request.Request, *chimesdkvoice.DeleteVoiceProfileOutput)

	DeleteVoiceProfileDomain(*chimesdkvoice.DeleteVoiceProfileDomainInput) (*chimesdkvoice.DeleteVoiceProfileDomainOutput, error)
	DeleteVoiceProfileDomainWithContext(aws.Context, *chimesdkvoice.DeleteVoiceProfileDomainInput, ...request.Option) (*chimesdkvoice.DeleteVoiceProfileDomainOutput, error)
	DeleteVoiceProfileDomainRequest(*chimesdkvoice.DeleteVoiceProfileDomainInput) (*request.Request, *chimesdkvoice.DeleteVoiceProfileDomainOutput)

	DisassociatePhoneNumbersFromVoiceConnector(*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorInput) (*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorOutput, error)
	DisassociatePhoneNumbersFromVoiceConnectorWithContext(aws.Context, *chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorInput, ...request.Option) (*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorOutput, error)
	DisassociatePhoneNumbersFromVoiceConnectorRequest(*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorInput) (*request.Request, *chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorOutput)

	DisassociatePhoneNumbersFromVoiceConnectorGroup(*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error)
	DisassociatePhoneNumbersFromVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupOutput, error)
	DisassociatePhoneNumbersFromVoiceConnectorGroupRequest(*chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.DisassociatePhoneNumbersFromVoiceConnectorGroupOutput)

	GetGlobalSettings(*chimesdkvoice.GetGlobalSettingsInput) (*chimesdkvoice.GetGlobalSettingsOutput, error)
	GetGlobalSettingsWithContext(aws.Context, *chimesdkvoice.GetGlobalSettingsInput, ...request.Option) (*chimesdkvoice.GetGlobalSettingsOutput, error)
	GetGlobalSettingsRequest(*chimesdkvoice.GetGlobalSettingsInput) (*request.Request, *chimesdkvoice.GetGlobalSettingsOutput)

	GetPhoneNumber(*chimesdkvoice.GetPhoneNumberInput) (*chimesdkvoice.GetPhoneNumberOutput, error)
	GetPhoneNumberWithContext(aws.Context, *chimesdkvoice.GetPhoneNumberInput, ...request.Option) (*chimesdkvoice.GetPhoneNumberOutput, error)
	GetPhoneNumberRequest(*chimesdkvoice.GetPhoneNumberInput) (*request.Request, *chimesdkvoice.GetPhoneNumberOutput)

	GetPhoneNumberOrder(*chimesdkvoice.GetPhoneNumberOrderInput) (*chimesdkvoice.GetPhoneNumberOrderOutput, error)
	GetPhoneNumberOrderWithContext(aws.Context, *chimesdkvoice.GetPhoneNumberOrderInput, ...request.Option) (*chimesdkvoice.GetPhoneNumberOrderOutput, error)
	GetPhoneNumberOrderRequest(*chimesdkvoice.GetPhoneNumberOrderInput) (*request.Request, *chimesdkvoice.GetPhoneNumberOrderOutput)

	GetPhoneNumberSettings(*chimesdkvoice.GetPhoneNumberSettingsInput) (*chimesdkvoice.GetPhoneNumberSettingsOutput, error)
	GetPhoneNumberSettingsWithContext(aws.Context, *chimesdkvoice.GetPhoneNumberSettingsInput, ...request.Option) (*chimesdkvoice.GetPhoneNumberSettingsOutput, error)
	GetPhoneNumberSettingsRequest(*chimesdkvoice.GetPhoneNumberSettingsInput) (*request.Request, *chimesdkvoice.GetPhoneNumberSettingsOutput)

	GetProxySession(*chimesdkvoice.GetProxySessionInput) (*chimesdkvoice.GetProxySessionOutput, error)
	GetProxySessionWithContext(aws.Context, *chimesdkvoice.GetProxySessionInput, ...request.Option) (*chimesdkvoice.GetProxySessionOutput, error)
	GetProxySessionRequest(*chimesdkvoice.GetProxySessionInput) (*request.Request, *chimesdkvoice.GetProxySessionOutput)

	GetSipMediaApplication(*chimesdkvoice.GetSipMediaApplicationInput) (*chimesdkvoice.GetSipMediaApplicationOutput, error)
	GetSipMediaApplicationWithContext(aws.Context, *chimesdkvoice.GetSipMediaApplicationInput, ...request.Option) (*chimesdkvoice.GetSipMediaApplicationOutput, error)
	GetSipMediaApplicationRequest(*chimesdkvoice.GetSipMediaApplicationInput) (*request.Request, *chimesdkvoice.GetSipMediaApplicationOutput)

	GetSipMediaApplicationAlexaSkillConfiguration(*chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationInput) (*chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationOutput, error)
	GetSipMediaApplicationAlexaSkillConfigurationWithContext(aws.Context, *chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationInput, ...request.Option) (*chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationOutput, error)
	GetSipMediaApplicationAlexaSkillConfigurationRequest(*chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationInput) (*request.Request, *chimesdkvoice.GetSipMediaApplicationAlexaSkillConfigurationOutput)

	GetSipMediaApplicationLoggingConfiguration(*chimesdkvoice.GetSipMediaApplicationLoggingConfigurationInput) (*chimesdkvoice.GetSipMediaApplicationLoggingConfigurationOutput, error)
	GetSipMediaApplicationLoggingConfigurationWithContext(aws.Context, *chimesdkvoice.GetSipMediaApplicationLoggingConfigurationInput, ...request.Option) (*chimesdkvoice.GetSipMediaApplicationLoggingConfigurationOutput, error)
	GetSipMediaApplicationLoggingConfigurationRequest(*chimesdkvoice.GetSipMediaApplicationLoggingConfigurationInput) (*request.Request, *chimesdkvoice.GetSipMediaApplicationLoggingConfigurationOutput)

	GetSipRule(*chimesdkvoice.GetSipRuleInput) (*chimesdkvoice.GetSipRuleOutput, error)
	GetSipRuleWithContext(aws.Context, *chimesdkvoice.GetSipRuleInput, ...request.Option) (*chimesdkvoice.GetSipRuleOutput, error)
	GetSipRuleRequest(*chimesdkvoice.GetSipRuleInput) (*request.Request, *chimesdkvoice.GetSipRuleOutput)

	GetSpeakerSearchTask(*chimesdkvoice.GetSpeakerSearchTaskInput) (*chimesdkvoice.GetSpeakerSearchTaskOutput, error)
	GetSpeakerSearchTaskWithContext(aws.Context, *chimesdkvoice.GetSpeakerSearchTaskInput, ...request.Option) (*chimesdkvoice.GetSpeakerSearchTaskOutput, error)
	GetSpeakerSearchTaskRequest(*chimesdkvoice.GetSpeakerSearchTaskInput) (*request.Request, *chimesdkvoice.GetSpeakerSearchTaskOutput)

	GetVoiceConnector(*chimesdkvoice.GetVoiceConnectorInput) (*chimesdkvoice.GetVoiceConnectorOutput, error)
	GetVoiceConnectorWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorOutput, error)
	GetVoiceConnectorRequest(*chimesdkvoice.GetVoiceConnectorInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorOutput)

	GetVoiceConnectorEmergencyCallingConfiguration(*chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationInput) (*chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationOutput, error)
	GetVoiceConnectorEmergencyCallingConfigurationWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationOutput, error)
	GetVoiceConnectorEmergencyCallingConfigurationRequest(*chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorEmergencyCallingConfigurationOutput)

	GetVoiceConnectorGroup(*chimesdkvoice.GetVoiceConnectorGroupInput) (*chimesdkvoice.GetVoiceConnectorGroupOutput, error)
	GetVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorGroupOutput, error)
	GetVoiceConnectorGroupRequest(*chimesdkvoice.GetVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorGroupOutput)

	GetVoiceConnectorLoggingConfiguration(*chimesdkvoice.GetVoiceConnectorLoggingConfigurationInput) (*chimesdkvoice.GetVoiceConnectorLoggingConfigurationOutput, error)
	GetVoiceConnectorLoggingConfigurationWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorLoggingConfigurationInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorLoggingConfigurationOutput, error)
	GetVoiceConnectorLoggingConfigurationRequest(*chimesdkvoice.GetVoiceConnectorLoggingConfigurationInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorLoggingConfigurationOutput)

	GetVoiceConnectorOrigination(*chimesdkvoice.GetVoiceConnectorOriginationInput) (*chimesdkvoice.GetVoiceConnectorOriginationOutput, error)
	GetVoiceConnectorOriginationWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorOriginationInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorOriginationOutput, error)
	GetVoiceConnectorOriginationRequest(*chimesdkvoice.GetVoiceConnectorOriginationInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorOriginationOutput)

	GetVoiceConnectorProxy(*chimesdkvoice.GetVoiceConnectorProxyInput) (*chimesdkvoice.GetVoiceConnectorProxyOutput, error)
	GetVoiceConnectorProxyWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorProxyInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorProxyOutput, error)
	GetVoiceConnectorProxyRequest(*chimesdkvoice.GetVoiceConnectorProxyInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorProxyOutput)

	GetVoiceConnectorStreamingConfiguration(*chimesdkvoice.GetVoiceConnectorStreamingConfigurationInput) (*chimesdkvoice.GetVoiceConnectorStreamingConfigurationOutput, error)
	GetVoiceConnectorStreamingConfigurationWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorStreamingConfigurationInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorStreamingConfigurationOutput, error)
	GetVoiceConnectorStreamingConfigurationRequest(*chimesdkvoice.GetVoiceConnectorStreamingConfigurationInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorStreamingConfigurationOutput)

	GetVoiceConnectorTermination(*chimesdkvoice.GetVoiceConnectorTerminationInput) (*chimesdkvoice.GetVoiceConnectorTerminationOutput, error)
	GetVoiceConnectorTerminationWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorTerminationInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorTerminationOutput, error)
	GetVoiceConnectorTerminationRequest(*chimesdkvoice.GetVoiceConnectorTerminationInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorTerminationOutput)

	GetVoiceConnectorTerminationHealth(*chimesdkvoice.GetVoiceConnectorTerminationHealthInput) (*chimesdkvoice.GetVoiceConnectorTerminationHealthOutput, error)
	GetVoiceConnectorTerminationHealthWithContext(aws.Context, *chimesdkvoice.GetVoiceConnectorTerminationHealthInput, ...request.Option) (*chimesdkvoice.GetVoiceConnectorTerminationHealthOutput, error)
	GetVoiceConnectorTerminationHealthRequest(*chimesdkvoice.GetVoiceConnectorTerminationHealthInput) (*request.Request, *chimesdkvoice.GetVoiceConnectorTerminationHealthOutput)

	GetVoiceProfile(*chimesdkvoice.GetVoiceProfileInput) (*chimesdkvoice.GetVoiceProfileOutput, error)
	GetVoiceProfileWithContext(aws.Context, *chimesdkvoice.GetVoiceProfileInput, ...request.Option) (*chimesdkvoice.GetVoiceProfileOutput, error)
	GetVoiceProfileRequest(*chimesdkvoice.GetVoiceProfileInput) (*request.Request, *chimesdkvoice.GetVoiceProfileOutput)

	GetVoiceProfileDomain(*chimesdkvoice.GetVoiceProfileDomainInput) (*chimesdkvoice.GetVoiceProfileDomainOutput, error)
	GetVoiceProfileDomainWithContext(aws.Context, *chimesdkvoice.GetVoiceProfileDomainInput, ...request.Option) (*chimesdkvoice.GetVoiceProfileDomainOutput, error)
	GetVoiceProfileDomainRequest(*chimesdkvoice.GetVoiceProfileDomainInput) (*request.Request, *chimesdkvoice.GetVoiceProfileDomainOutput)

	GetVoiceToneAnalysisTask(*chimesdkvoice.GetVoiceToneAnalysisTaskInput) (*chimesdkvoice.GetVoiceToneAnalysisTaskOutput, error)
	GetVoiceToneAnalysisTaskWithContext(aws.Context, *chimesdkvoice.GetVoiceToneAnalysisTaskInput, ...request.Option) (*chimesdkvoice.GetVoiceToneAnalysisTaskOutput, error)
	GetVoiceToneAnalysisTaskRequest(*chimesdkvoice.GetVoiceToneAnalysisTaskInput) (*request.Request, *chimesdkvoice.GetVoiceToneAnalysisTaskOutput)

	ListAvailableVoiceConnectorRegions(*chimesdkvoice.ListAvailableVoiceConnectorRegionsInput) (*chimesdkvoice.ListAvailableVoiceConnectorRegionsOutput, error)
	ListAvailableVoiceConnectorRegionsWithContext(aws.Context, *chimesdkvoice.ListAvailableVoiceConnectorRegionsInput, ...request.Option) (*chimesdkvoice.ListAvailableVoiceConnectorRegionsOutput, error)
	ListAvailableVoiceConnectorRegionsRequest(*chimesdkvoice.ListAvailableVoiceConnectorRegionsInput) (*request.Request, *chimesdkvoice.ListAvailableVoiceConnectorRegionsOutput)

	ListPhoneNumberOrders(*chimesdkvoice.ListPhoneNumberOrdersInput) (*chimesdkvoice.ListPhoneNumberOrdersOutput, error)
	ListPhoneNumberOrdersWithContext(aws.Context, *chimesdkvoice.ListPhoneNumberOrdersInput, ...request.Option) (*chimesdkvoice.ListPhoneNumberOrdersOutput, error)
	ListPhoneNumberOrdersRequest(*chimesdkvoice.ListPhoneNumberOrdersInput) (*request.Request, *chimesdkvoice.ListPhoneNumberOrdersOutput)

	ListPhoneNumberOrdersPages(*chimesdkvoice.ListPhoneNumberOrdersInput, func(*chimesdkvoice.ListPhoneNumberOrdersOutput, bool) bool) error
	ListPhoneNumberOrdersPagesWithContext(aws.Context, *chimesdkvoice.ListPhoneNumberOrdersInput, func(*chimesdkvoice.ListPhoneNumberOrdersOutput, bool) bool, ...request.Option) error

	ListPhoneNumbers(*chimesdkvoice.ListPhoneNumbersInput) (*chimesdkvoice.ListPhoneNumbersOutput, error)
	ListPhoneNumbersWithContext(aws.Context, *chimesdkvoice.ListPhoneNumbersInput, ...request.Option) (*chimesdkvoice.ListPhoneNumbersOutput, error)
	ListPhoneNumbersRequest(*chimesdkvoice.ListPhoneNumbersInput) (*request.Request, *chimesdkvoice.ListPhoneNumbersOutput)

	ListPhoneNumbersPages(*chimesdkvoice.ListPhoneNumbersInput, func(*chimesdkvoice.ListPhoneNumbersOutput, bool) bool) error
	ListPhoneNumbersPagesWithContext(aws.Context, *chimesdkvoice.ListPhoneNumbersInput, func(*chimesdkvoice.ListPhoneNumbersOutput, bool) bool, ...request.Option) error

	ListProxySessions(*chimesdkvoice.ListProxySessionsInput) (*chimesdkvoice.ListProxySessionsOutput, error)
	ListProxySessionsWithContext(aws.Context, *chimesdkvoice.ListProxySessionsInput, ...request.Option) (*chimesdkvoice.ListProxySessionsOutput, error)
	ListProxySessionsRequest(*chimesdkvoice.ListProxySessionsInput) (*request.Request, *chimesdkvoice.ListProxySessionsOutput)

	ListProxySessionsPages(*chimesdkvoice.ListProxySessionsInput, func(*chimesdkvoice.ListProxySessionsOutput, bool) bool) error
	ListProxySessionsPagesWithContext(aws.Context, *chimesdkvoice.ListProxySessionsInput, func(*chimesdkvoice.ListProxySessionsOutput, bool) bool, ...request.Option) error

	ListSipMediaApplications(*chimesdkvoice.ListSipMediaApplicationsInput) (*chimesdkvoice.ListSipMediaApplicationsOutput, error)
	ListSipMediaApplicationsWithContext(aws.Context, *chimesdkvoice.ListSipMediaApplicationsInput, ...request.Option) (*chimesdkvoice.ListSipMediaApplicationsOutput, error)
	ListSipMediaApplicationsRequest(*chimesdkvoice.ListSipMediaApplicationsInput) (*request.Request, *chimesdkvoice.ListSipMediaApplicationsOutput)

	ListSipMediaApplicationsPages(*chimesdkvoice.ListSipMediaApplicationsInput, func(*chimesdkvoice.ListSipMediaApplicationsOutput, bool) bool) error
	ListSipMediaApplicationsPagesWithContext(aws.Context, *chimesdkvoice.ListSipMediaApplicationsInput, func(*chimesdkvoice.ListSipMediaApplicationsOutput, bool) bool, ...request.Option) error

	ListSipRules(*chimesdkvoice.ListSipRulesInput) (*chimesdkvoice.ListSipRulesOutput, error)
	ListSipRulesWithContext(aws.Context, *chimesdkvoice.ListSipRulesInput, ...request.Option) (*chimesdkvoice.ListSipRulesOutput, error)
	ListSipRulesRequest(*chimesdkvoice.ListSipRulesInput) (*request.Request, *chimesdkvoice.ListSipRulesOutput)

	ListSipRulesPages(*chimesdkvoice.ListSipRulesInput, func(*chimesdkvoice.ListSipRulesOutput, bool) bool) error
	ListSipRulesPagesWithContext(aws.Context, *chimesdkvoice.ListSipRulesInput, func(*chimesdkvoice.ListSipRulesOutput, bool) bool, ...request.Option) error

	ListSupportedPhoneNumberCountries(*chimesdkvoice.ListSupportedPhoneNumberCountriesInput) (*chimesdkvoice.ListSupportedPhoneNumberCountriesOutput, error)
	ListSupportedPhoneNumberCountriesWithContext(aws.Context, *chimesdkvoice.ListSupportedPhoneNumberCountriesInput, ...request.Option) (*chimesdkvoice.ListSupportedPhoneNumberCountriesOutput, error)
	ListSupportedPhoneNumberCountriesRequest(*chimesdkvoice.ListSupportedPhoneNumberCountriesInput) (*request.Request, *chimesdkvoice.ListSupportedPhoneNumberCountriesOutput)

	ListTagsForResource(*chimesdkvoice.ListTagsForResourceInput) (*chimesdkvoice.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *chimesdkvoice.ListTagsForResourceInput, ...request.Option) (*chimesdkvoice.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*chimesdkvoice.ListTagsForResourceInput) (*request.Request, *chimesdkvoice.ListTagsForResourceOutput)

	ListVoiceConnectorGroups(*chimesdkvoice.ListVoiceConnectorGroupsInput) (*chimesdkvoice.ListVoiceConnectorGroupsOutput, error)
	ListVoiceConnectorGroupsWithContext(aws.Context, *chimesdkvoice.ListVoiceConnectorGroupsInput, ...request.Option) (*chimesdkvoice.ListVoiceConnectorGroupsOutput, error)
	ListVoiceConnectorGroupsRequest(*chimesdkvoice.ListVoiceConnectorGroupsInput) (*request.Request, *chimesdkvoice.ListVoiceConnectorGroupsOutput)

	ListVoiceConnectorGroupsPages(*chimesdkvoice.ListVoiceConnectorGroupsInput, func(*chimesdkvoice.ListVoiceConnectorGroupsOutput, bool) bool) error
	ListVoiceConnectorGroupsPagesWithContext(aws.Context, *chimesdkvoice.ListVoiceConnectorGroupsInput, func(*chimesdkvoice.ListVoiceConnectorGroupsOutput, bool) bool, ...request.Option) error

	ListVoiceConnectorTerminationCredentials(*chimesdkvoice.ListVoiceConnectorTerminationCredentialsInput) (*chimesdkvoice.ListVoiceConnectorTerminationCredentialsOutput, error)
	ListVoiceConnectorTerminationCredentialsWithContext(aws.Context, *chimesdkvoice.ListVoiceConnectorTerminationCredentialsInput, ...request.Option) (*chimesdkvoice.ListVoiceConnectorTerminationCredentialsOutput, error)
	ListVoiceConnectorTerminationCredentialsRequest(*chimesdkvoice.ListVoiceConnectorTerminationCredentialsInput) (*request.Request, *chimesdkvoice.ListVoiceConnectorTerminationCredentialsOutput)

	ListVoiceConnectors(*chimesdkvoice.ListVoiceConnectorsInput) (*chimesdkvoice.ListVoiceConnectorsOutput, error)
	ListVoiceConnectorsWithContext(aws.Context, *chimesdkvoice.ListVoiceConnectorsInput, ...request.Option) (*chimesdkvoice.ListVoiceConnectorsOutput, error)
	ListVoiceConnectorsRequest(*chimesdkvoice.ListVoiceConnectorsInput) (*request.Request, *chimesdkvoice.ListVoiceConnectorsOutput)

	ListVoiceConnectorsPages(*chimesdkvoice.ListVoiceConnectorsInput, func(*chimesdkvoice.ListVoiceConnectorsOutput, bool) bool) error
	ListVoiceConnectorsPagesWithContext(aws.Context, *chimesdkvoice.ListVoiceConnectorsInput, func(*chimesdkvoice.ListVoiceConnectorsOutput, bool) bool, ...request.Option) error

	ListVoiceProfileDomains(*chimesdkvoice.ListVoiceProfileDomainsInput) (*chimesdkvoice.ListVoiceProfileDomainsOutput, error)
	ListVoiceProfileDomainsWithContext(aws.Context, *chimesdkvoice.ListVoiceProfileDomainsInput, ...request.Option) (*chimesdkvoice.ListVoiceProfileDomainsOutput, error)
	ListVoiceProfileDomainsRequest(*chimesdkvoice.ListVoiceProfileDomainsInput) (*request.Request, *chimesdkvoice.ListVoiceProfileDomainsOutput)

	ListVoiceProfileDomainsPages(*chimesdkvoice.ListVoiceProfileDomainsInput, func(*chimesdkvoice.ListVoiceProfileDomainsOutput, bool) bool) error
	ListVoiceProfileDomainsPagesWithContext(aws.Context, *chimesdkvoice.ListVoiceProfileDomainsInput, func(*chimesdkvoice.ListVoiceProfileDomainsOutput, bool) bool, ...request.Option) error

	ListVoiceProfiles(*chimesdkvoice.ListVoiceProfilesInput) (*chimesdkvoice.ListVoiceProfilesOutput, error)
	ListVoiceProfilesWithContext(aws.Context, *chimesdkvoice.ListVoiceProfilesInput, ...request.Option) (*chimesdkvoice.ListVoiceProfilesOutput, error)
	ListVoiceProfilesRequest(*chimesdkvoice.ListVoiceProfilesInput) (*request.Request, *chimesdkvoice.ListVoiceProfilesOutput)

	ListVoiceProfilesPages(*chimesdkvoice.ListVoiceProfilesInput, func(*chimesdkvoice.ListVoiceProfilesOutput, bool) bool) error
	ListVoiceProfilesPagesWithContext(aws.Context, *chimesdkvoice.ListVoiceProfilesInput, func(*chimesdkvoice.ListVoiceProfilesOutput, bool) bool, ...request.Option) error

	PutSipMediaApplicationAlexaSkillConfiguration(*chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationInput) (*chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationOutput, error)
	PutSipMediaApplicationAlexaSkillConfigurationWithContext(aws.Context, *chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationInput, ...request.Option) (*chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationOutput, error)
	PutSipMediaApplicationAlexaSkillConfigurationRequest(*chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationInput) (*request.Request, *chimesdkvoice.PutSipMediaApplicationAlexaSkillConfigurationOutput)

	PutSipMediaApplicationLoggingConfiguration(*chimesdkvoice.PutSipMediaApplicationLoggingConfigurationInput) (*chimesdkvoice.PutSipMediaApplicationLoggingConfigurationOutput, error)
	PutSipMediaApplicationLoggingConfigurationWithContext(aws.Context, *chimesdkvoice.PutSipMediaApplicationLoggingConfigurationInput, ...request.Option) (*chimesdkvoice.PutSipMediaApplicationLoggingConfigurationOutput, error)
	PutSipMediaApplicationLoggingConfigurationRequest(*chimesdkvoice.PutSipMediaApplicationLoggingConfigurationInput) (*request.Request, *chimesdkvoice.PutSipMediaApplicationLoggingConfigurationOutput)

	PutVoiceConnectorEmergencyCallingConfiguration(*chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationInput) (*chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationOutput, error)
	PutVoiceConnectorEmergencyCallingConfigurationWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationOutput, error)
	PutVoiceConnectorEmergencyCallingConfigurationRequest(*chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorEmergencyCallingConfigurationOutput)

	PutVoiceConnectorLoggingConfiguration(*chimesdkvoice.PutVoiceConnectorLoggingConfigurationInput) (*chimesdkvoice.PutVoiceConnectorLoggingConfigurationOutput, error)
	PutVoiceConnectorLoggingConfigurationWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorLoggingConfigurationInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorLoggingConfigurationOutput, error)
	PutVoiceConnectorLoggingConfigurationRequest(*chimesdkvoice.PutVoiceConnectorLoggingConfigurationInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorLoggingConfigurationOutput)

	PutVoiceConnectorOrigination(*chimesdkvoice.PutVoiceConnectorOriginationInput) (*chimesdkvoice.PutVoiceConnectorOriginationOutput, error)
	PutVoiceConnectorOriginationWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorOriginationInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorOriginationOutput, error)
	PutVoiceConnectorOriginationRequest(*chimesdkvoice.PutVoiceConnectorOriginationInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorOriginationOutput)

	PutVoiceConnectorProxy(*chimesdkvoice.PutVoiceConnectorProxyInput) (*chimesdkvoice.PutVoiceConnectorProxyOutput, error)
	PutVoiceConnectorProxyWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorProxyInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorProxyOutput, error)
	PutVoiceConnectorProxyRequest(*chimesdkvoice.PutVoiceConnectorProxyInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorProxyOutput)

	PutVoiceConnectorStreamingConfiguration(*chimesdkvoice.PutVoiceConnectorStreamingConfigurationInput) (*chimesdkvoice.PutVoiceConnectorStreamingConfigurationOutput, error)
	PutVoiceConnectorStreamingConfigurationWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorStreamingConfigurationInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorStreamingConfigurationOutput, error)
	PutVoiceConnectorStreamingConfigurationRequest(*chimesdkvoice.PutVoiceConnectorStreamingConfigurationInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorStreamingConfigurationOutput)

	PutVoiceConnectorTermination(*chimesdkvoice.PutVoiceConnectorTerminationInput) (*chimesdkvoice.PutVoiceConnectorTerminationOutput, error)
	PutVoiceConnectorTerminationWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorTerminationInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorTerminationOutput, error)
	PutVoiceConnectorTerminationRequest(*chimesdkvoice.PutVoiceConnectorTerminationInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorTerminationOutput)

	PutVoiceConnectorTerminationCredentials(*chimesdkvoice.PutVoiceConnectorTerminationCredentialsInput) (*chimesdkvoice.PutVoiceConnectorTerminationCredentialsOutput, error)
	PutVoiceConnectorTerminationCredentialsWithContext(aws.Context, *chimesdkvoice.PutVoiceConnectorTerminationCredentialsInput, ...request.Option) (*chimesdkvoice.PutVoiceConnectorTerminationCredentialsOutput, error)
	PutVoiceConnectorTerminationCredentialsRequest(*chimesdkvoice.PutVoiceConnectorTerminationCredentialsInput) (*request.Request, *chimesdkvoice.PutVoiceConnectorTerminationCredentialsOutput)

	RestorePhoneNumber(*chimesdkvoice.RestorePhoneNumberInput) (*chimesdkvoice.RestorePhoneNumberOutput, error)
	RestorePhoneNumberWithContext(aws.Context, *chimesdkvoice.RestorePhoneNumberInput, ...request.Option) (*chimesdkvoice.RestorePhoneNumberOutput, error)
	RestorePhoneNumberRequest(*chimesdkvoice.RestorePhoneNumberInput) (*request.Request, *chimesdkvoice.RestorePhoneNumberOutput)

	SearchAvailablePhoneNumbers(*chimesdkvoice.SearchAvailablePhoneNumbersInput) (*chimesdkvoice.SearchAvailablePhoneNumbersOutput, error)
	SearchAvailablePhoneNumbersWithContext(aws.Context, *chimesdkvoice.SearchAvailablePhoneNumbersInput, ...request.Option) (*chimesdkvoice.SearchAvailablePhoneNumbersOutput, error)
	SearchAvailablePhoneNumbersRequest(*chimesdkvoice.SearchAvailablePhoneNumbersInput) (*request.Request, *chimesdkvoice.SearchAvailablePhoneNumbersOutput)

	SearchAvailablePhoneNumbersPages(*chimesdkvoice.SearchAvailablePhoneNumbersInput, func(*chimesdkvoice.SearchAvailablePhoneNumbersOutput, bool) bool) error
	SearchAvailablePhoneNumbersPagesWithContext(aws.Context, *chimesdkvoice.SearchAvailablePhoneNumbersInput, func(*chimesdkvoice.SearchAvailablePhoneNumbersOutput, bool) bool, ...request.Option) error

	StartSpeakerSearchTask(*chimesdkvoice.StartSpeakerSearchTaskInput) (*chimesdkvoice.StartSpeakerSearchTaskOutput, error)
	StartSpeakerSearchTaskWithContext(aws.Context, *chimesdkvoice.StartSpeakerSearchTaskInput, ...request.Option) (*chimesdkvoice.StartSpeakerSearchTaskOutput, error)
	StartSpeakerSearchTaskRequest(*chimesdkvoice.StartSpeakerSearchTaskInput) (*request.Request, *chimesdkvoice.StartSpeakerSearchTaskOutput)

	StartVoiceToneAnalysisTask(*chimesdkvoice.StartVoiceToneAnalysisTaskInput) (*chimesdkvoice.StartVoiceToneAnalysisTaskOutput, error)
	StartVoiceToneAnalysisTaskWithContext(aws.Context, *chimesdkvoice.StartVoiceToneAnalysisTaskInput, ...request.Option) (*chimesdkvoice.StartVoiceToneAnalysisTaskOutput, error)
	StartVoiceToneAnalysisTaskRequest(*chimesdkvoice.StartVoiceToneAnalysisTaskInput) (*request.Request, *chimesdkvoice.StartVoiceToneAnalysisTaskOutput)

	StopSpeakerSearchTask(*chimesdkvoice.StopSpeakerSearchTaskInput) (*chimesdkvoice.StopSpeakerSearchTaskOutput, error)
	StopSpeakerSearchTaskWithContext(aws.Context, *chimesdkvoice.StopSpeakerSearchTaskInput, ...request.Option) (*chimesdkvoice.StopSpeakerSearchTaskOutput, error)
	StopSpeakerSearchTaskRequest(*chimesdkvoice.StopSpeakerSearchTaskInput) (*request.Request, *chimesdkvoice.StopSpeakerSearchTaskOutput)

	StopVoiceToneAnalysisTask(*chimesdkvoice.StopVoiceToneAnalysisTaskInput) (*chimesdkvoice.StopVoiceToneAnalysisTaskOutput, error)
	StopVoiceToneAnalysisTaskWithContext(aws.Context, *chimesdkvoice.StopVoiceToneAnalysisTaskInput, ...request.Option) (*chimesdkvoice.StopVoiceToneAnalysisTaskOutput, error)
	StopVoiceToneAnalysisTaskRequest(*chimesdkvoice.StopVoiceToneAnalysisTaskInput) (*request.Request, *chimesdkvoice.StopVoiceToneAnalysisTaskOutput)

	TagResource(*chimesdkvoice.TagResourceInput) (*chimesdkvoice.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *chimesdkvoice.TagResourceInput, ...request.Option) (*chimesdkvoice.TagResourceOutput, error)
	TagResourceRequest(*chimesdkvoice.TagResourceInput) (*request.Request, *chimesdkvoice.TagResourceOutput)

	UntagResource(*chimesdkvoice.UntagResourceInput) (*chimesdkvoice.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *chimesdkvoice.UntagResourceInput, ...request.Option) (*chimesdkvoice.UntagResourceOutput, error)
	UntagResourceRequest(*chimesdkvoice.UntagResourceInput) (*request.Request, *chimesdkvoice.UntagResourceOutput)

	UpdateGlobalSettings(*chimesdkvoice.UpdateGlobalSettingsInput) (*chimesdkvoice.UpdateGlobalSettingsOutput, error)
	UpdateGlobalSettingsWithContext(aws.Context, *chimesdkvoice.UpdateGlobalSettingsInput, ...request.Option) (*chimesdkvoice.UpdateGlobalSettingsOutput, error)
	UpdateGlobalSettingsRequest(*chimesdkvoice.UpdateGlobalSettingsInput) (*request.Request, *chimesdkvoice.UpdateGlobalSettingsOutput)

	UpdatePhoneNumber(*chimesdkvoice.UpdatePhoneNumberInput) (*chimesdkvoice.UpdatePhoneNumberOutput, error)
	UpdatePhoneNumberWithContext(aws.Context, *chimesdkvoice.UpdatePhoneNumberInput, ...request.Option) (*chimesdkvoice.UpdatePhoneNumberOutput, error)
	UpdatePhoneNumberRequest(*chimesdkvoice.UpdatePhoneNumberInput) (*request.Request, *chimesdkvoice.UpdatePhoneNumberOutput)

	UpdatePhoneNumberSettings(*chimesdkvoice.UpdatePhoneNumberSettingsInput) (*chimesdkvoice.UpdatePhoneNumberSettingsOutput, error)
	UpdatePhoneNumberSettingsWithContext(aws.Context, *chimesdkvoice.UpdatePhoneNumberSettingsInput, ...request.Option) (*chimesdkvoice.UpdatePhoneNumberSettingsOutput, error)
	UpdatePhoneNumberSettingsRequest(*chimesdkvoice.UpdatePhoneNumberSettingsInput) (*request.Request, *chimesdkvoice.UpdatePhoneNumberSettingsOutput)

	UpdateProxySession(*chimesdkvoice.UpdateProxySessionInput) (*chimesdkvoice.UpdateProxySessionOutput, error)
	UpdateProxySessionWithContext(aws.Context, *chimesdkvoice.UpdateProxySessionInput, ...request.Option) (*chimesdkvoice.UpdateProxySessionOutput, error)
	UpdateProxySessionRequest(*chimesdkvoice.UpdateProxySessionInput) (*request.Request, *chimesdkvoice.UpdateProxySessionOutput)

	UpdateSipMediaApplication(*chimesdkvoice.UpdateSipMediaApplicationInput) (*chimesdkvoice.UpdateSipMediaApplicationOutput, error)
	UpdateSipMediaApplicationWithContext(aws.Context, *chimesdkvoice.UpdateSipMediaApplicationInput, ...request.Option) (*chimesdkvoice.UpdateSipMediaApplicationOutput, error)
	UpdateSipMediaApplicationRequest(*chimesdkvoice.UpdateSipMediaApplicationInput) (*request.Request, *chimesdkvoice.UpdateSipMediaApplicationOutput)

	UpdateSipMediaApplicationCall(*chimesdkvoice.UpdateSipMediaApplicationCallInput) (*chimesdkvoice.UpdateSipMediaApplicationCallOutput, error)
	UpdateSipMediaApplicationCallWithContext(aws.Context, *chimesdkvoice.UpdateSipMediaApplicationCallInput, ...request.Option) (*chimesdkvoice.UpdateSipMediaApplicationCallOutput, error)
	UpdateSipMediaApplicationCallRequest(*chimesdkvoice.UpdateSipMediaApplicationCallInput) (*request.Request, *chimesdkvoice.UpdateSipMediaApplicationCallOutput)

	UpdateSipRule(*chimesdkvoice.UpdateSipRuleInput) (*chimesdkvoice.UpdateSipRuleOutput, error)
	UpdateSipRuleWithContext(aws.Context, *chimesdkvoice.UpdateSipRuleInput, ...request.Option) (*chimesdkvoice.UpdateSipRuleOutput, error)
	UpdateSipRuleRequest(*chimesdkvoice.UpdateSipRuleInput) (*request.Request, *chimesdkvoice.UpdateSipRuleOutput)

	UpdateVoiceConnector(*chimesdkvoice.UpdateVoiceConnectorInput) (*chimesdkvoice.UpdateVoiceConnectorOutput, error)
	UpdateVoiceConnectorWithContext(aws.Context, *chimesdkvoice.UpdateVoiceConnectorInput, ...request.Option) (*chimesdkvoice.UpdateVoiceConnectorOutput, error)
	UpdateVoiceConnectorRequest(*chimesdkvoice.UpdateVoiceConnectorInput) (*request.Request, *chimesdkvoice.UpdateVoiceConnectorOutput)

	UpdateVoiceConnectorGroup(*chimesdkvoice.UpdateVoiceConnectorGroupInput) (*chimesdkvoice.UpdateVoiceConnectorGroupOutput, error)
	UpdateVoiceConnectorGroupWithContext(aws.Context, *chimesdkvoice.UpdateVoiceConnectorGroupInput, ...request.Option) (*chimesdkvoice.UpdateVoiceConnectorGroupOutput, error)
	UpdateVoiceConnectorGroupRequest(*chimesdkvoice.UpdateVoiceConnectorGroupInput) (*request.Request, *chimesdkvoice.UpdateVoiceConnectorGroupOutput)

	UpdateVoiceProfile(*chimesdkvoice.UpdateVoiceProfileInput) (*chimesdkvoice.UpdateVoiceProfileOutput, error)
	UpdateVoiceProfileWithContext(aws.Context, *chimesdkvoice.UpdateVoiceProfileInput, ...request.Option) (*chimesdkvoice.UpdateVoiceProfileOutput, error)
	UpdateVoiceProfileRequest(*chimesdkvoice.UpdateVoiceProfileInput) (*request.Request, *chimesdkvoice.UpdateVoiceProfileOutput)

	UpdateVoiceProfileDomain(*chimesdkvoice.UpdateVoiceProfileDomainInput) (*chimesdkvoice.UpdateVoiceProfileDomainOutput, error)
	UpdateVoiceProfileDomainWithContext(aws.Context, *chimesdkvoice.UpdateVoiceProfileDomainInput, ...request.Option) (*chimesdkvoice.UpdateVoiceProfileDomainOutput, error)
	UpdateVoiceProfileDomainRequest(*chimesdkvoice.UpdateVoiceProfileDomainInput) (*request.Request, *chimesdkvoice.UpdateVoiceProfileDomainOutput)

	ValidateE911Address(*chimesdkvoice.ValidateE911AddressInput) (*chimesdkvoice.ValidateE911AddressOutput, error)
	ValidateE911AddressWithContext(aws.Context, *chimesdkvoice.ValidateE911AddressInput, ...request.Option) (*chimesdkvoice.ValidateE911AddressOutput, error)
	ValidateE911AddressRequest(*chimesdkvoice.ValidateE911AddressInput) (*request.Request, *chimesdkvoice.ValidateE911AddressOutput)
}

var _ ChimeSDKVoiceAPI = (*chimesdkvoice.ChimeSDKVoice)(nil)
