/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven;

import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.maven.Maven3BuildInfoLogger;

@Component(role=BuildInfoClientBuilder.class)
public class BuildInfoClientBuilder {
    @Requirement
    private Logger logger;

    public ArtifactoryBuildInfoClient resolveProperties(ArtifactoryClientConfiguration clientConf) {
        ArtifactoryBuildInfoClient client = this.resolveClientProps(clientConf);
        this.resolveTimeout(clientConf, client);
        this.resolveProxy(clientConf.proxy, client);
        this.resolveRetriesParams(clientConf, client);
        this.resolveInsecureTls(clientConf, client);
        return client;
    }

    private ArtifactoryBuildInfoClient resolveClientProps(ArtifactoryClientConfiguration clientConf) {
        String contextUrl = clientConf.publisher.getContextUrl();
        if (StringUtils.isBlank(contextUrl)) {
            throw new IllegalArgumentException("Unable to resolve Artifactory Build Info Client properties: no context URL was found.");
        }
        this.logResolvedProperty(clientConf.publisher.getPrefix() + "." + "contextUrl", contextUrl);
        String username = clientConf.publisher.getUsername();
        String password = clientConf.publisher.getPassword();
        if (StringUtils.isNotBlank(username)) {
            this.logResolvedProperty("username", username);
            return new ArtifactoryBuildInfoClient(contextUrl, username, password, new Maven3BuildInfoLogger(this.logger));
        }
        return new ArtifactoryBuildInfoClient(contextUrl, new Maven3BuildInfoLogger(this.logger));
    }

    private void resolveTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getTimeout() == null) {
            return;
        }
        int timeout = clientConf.getTimeout();
        this.logResolvedProperty("artifactory.timeout", String.valueOf(timeout));
        client.setConnectionTimeout(timeout);
    }

    private void resolveRetriesParams(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        if (clientConf.getConnectionRetries() == null) {
            return;
        }
        int configMaxRetries = clientConf.getConnectionRetries();
        this.logResolvedProperty("artifactory.connectionRetries", String.valueOf(configMaxRetries));
        client.setConnectionRetries(configMaxRetries);
    }

    private void resolveInsecureTls(ArtifactoryClientConfiguration clientConf, ArtifactoryBuildInfoClient client) {
        client.setInsecureTls(clientConf.getInsecureTls());
    }

    private void resolveProxy(ArtifactoryClientConfiguration.ProxyHandler proxyConf, ArtifactoryBuildInfoClient client) {
        String proxyHost = proxyConf.getHost();
        if (StringUtils.isNotBlank(proxyHost)) {
            this.logResolvedProperty("host", proxyHost);
            if (proxyConf.getPort() == null) {
                return;
            }
            String proxyUsername = proxyConf.getUsername();
            if (StringUtils.isNotBlank(proxyUsername)) {
                this.logResolvedProperty("username", proxyUsername);
                client.setProxyConfiguration(proxyHost, proxyConf.getPort(), proxyUsername, proxyConf.getPassword());
            } else {
                client.setProxyConfiguration(proxyHost, proxyConf.getPort());
            }
        }
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug("Artifactory Client Property Resolver: " + key + " = " + value);
    }
}

