# frozen_string_literal: true

require "cases/helper"
require "models/author"
require "models/book"

class OrderTest < ActiveRecord::TestCase
  fixtures :authors, :author_addresses

  def test_order_asc
    Book.destroy_all
    z = Book.create!(name: "Zulu", author: authors(:david))
    y = Book.create!(name: "Yankee", author: authors(:mary))
    x = Book.create!(name: "X-Ray", author: authors(:david))

    alphabetical = [x, y, z]

    assert_equal(alphabetical, Book.order(name: :asc))
    assert_equal(alphabetical, Book.order(name: :ASC))
    assert_equal(alphabetical, Book.order(name: "asc"))
    assert_equal(alphabetical, Book.order(:name))
    assert_equal(alphabetical, Book.order("name"))
    assert_equal(alphabetical, Book.order("books.name"))
    assert_equal(alphabetical, Book.order(Book.arel_table["name"]))
  end

  def test_order_desc
    Book.destroy_all
    z = Book.create!(name: "Zulu", author: authors(:david))
    y = Book.create!(name: "Yankee", author: authors(:mary))
    x = Book.create!(name: "X-Ray", author: authors(:david))

    reverse_alphabetical = [z, y, x]

    assert_equal(reverse_alphabetical, Book.order(name: :desc))
    assert_equal(reverse_alphabetical, Book.order(name: :DESC))
    assert_equal(reverse_alphabetical, Book.order(name: "desc"))
    assert_equal(reverse_alphabetical, Book.order(:name).reverse_order)
    assert_equal(reverse_alphabetical, Book.order("name desc"))
    assert_equal(reverse_alphabetical, Book.order("books.name desc"))
    assert_equal(reverse_alphabetical, Book.order(Book.arel_table["name"].desc))
  end

  def test_order_with_association
    Book.destroy_all
    z = Book.create!(name: "Zulu", author: authors(:david))
    y = Book.create!(name: "Yankee", author: authors(:mary))
    x = Book.create!(name: "X-Ray", author: authors(:david))

    author_then_book_name = [x, z, y]

    assert_equal(author_then_book_name, Book.includes(:author).order("authors.name", "books.name"))
    assert_equal(author_then_book_name, Book.includes(:author).order(Author.arel_table[:name], Book.arel_table[:name]))
  end
end
