________________________________________________________________________

This file is part of Logtalk <https://logtalk.org/>  
Copyright 1998-2021 Paulo Moura <pmoura@logtalk.org>  
SPDX-License-Identifier: Apache-2.0

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
________________________________________________________________________


AUTHORS
=======

* Paulo Moura (language designer, developer, and maintainer)


CONTRIBUTORS
============

* Abramo Bagnara (efficient expansion of once/1 goals and bug reports in corner cases when compiling disjunctions)
* Andreas Becker (PDT support for Logtalk, bug reports)
* Anne Ogborn (bug reports, usability suggestions)
* Artur Miguel Dias (testing, lambda expression examples)
* Artur Wang (Visual Studio Code support for Logtalk)
* Arun Majumdar (bug reports, usability suggestions)
* Barry Evans (dead code scanner tool, usability suggestions)
* Clara Dimene (GeSHi syntax highlighter)
* Damien Roch (Docker support)
* Daniel Gross (bug reports, documentation feedback and suggestions)
* Daniel L. Dudley (made the ISO 8601 library object available)
* Davide Ancona (coinduction examples)
* Douglas R. Miles (suggestions, bug reports, Logtalk on SWISH experiments)
* Ebrahim Azarisooreh (code metrics tool, Arch Linux package, made [lgtinit](https://github.com/eazar001/lgtinit) available)
* Eva Stöwe (PDT support for Logtalk)
* Feliks Kluzniak (coinduction examples and bug reports)
* François Fages (meta-predicate safety bug reports)
* Günter Kniesel (PDT support for Logtalk, feedback on Logtalk OOP features)
* Gopal Gupta (coinduction examples)
* Ivan Bratko (search methods in the state-space searching example)
* Jacinto Dávila (CSV library, bug reports)
* Jan Burse (unit tests patches and feedback)
* Jan Wielemaker (feedback on Prolog compliance testing and engine examples)
* Jeremy Vickery (bug reports)
* Joachim Schimpf (feedback on Prolog compliance testing)
* Joerg Schuster (bug reports)
* John Fletcher (made XML parser available)
* John Stewart (Java interface suggestions and solutions)
* Joost Geurts (bug reports)
* José Antonio Riaza Valverde (Tau Prolog integration)
* José Morales (Ciao Prolog support)
* Markus Triska (help in porting CLP(FD) examples)
* Mats Carlsson (bug reports)
* Michael Covington (DCGs tokenizer example)
* Michael Hendricks (EDCGs examples and tests)
* Michael Igler (testing, bug reports, examples documentation improvements)
* Michael Sheets (text editor support)
* Michael T. Richter (Textadept text editor support, pengines example)
* Neda Saeedloei (coinduction examples)
* Neng-Fa Zhou (bug reports)
* Nicolas Pelletier (bug reports, text editor support)
* Parker Jones (testing, unit tests, bug reports)
* Paul Brown (libraries, bug reports, suggestions, Wikipedia page maintenance)
* Paul Crocker (testing, multi-threading and meta-predicates examples, bug reports)
* Paul Fodor (library enhancements)
* Paul Tarau (feedback on threaded engines API and examples)
* Paula Marisa Sampaio (state-space searching examples)
* Paulo Nunes (multi-threading testing)
* Per Mildner (code for helping decompose file paths and feedback on Prolog compliance testing)
* Peter Van Roy (EDCGs implementation)
* rbt (bug reports)
* Rémy Haemmerlé (meta-predicate safety bug reports)
* Richard O'Keefe (heaps and ordered sets library code)
* Robert Sasak (PDDL 3.0 parser contribution)
* Robert Shiplett (bug reports)
* Rui Marques (bug reports)
* Sergio Castro (Docker support, IntelliJ IDEA support, testing, suggestions, and bug reports)
* Timon Van Overveldt (multi-threading optimization and bug reports)
* Theofrastos Mantadelis ("flags" contribution, ProbLog integration support, benchmark tests)
* Ulrich Neumerkel (lambda expression examples, bug reports, and feedback on Prolog compliance testing)
* Victor Lagerkvist (testing, library enhancements, made Verdi Neruda available)
* Victor Noel (bug reports)
* Vítor Santos Costa (red-black tree library)
* Xin Wang (bug reports)

A special thanks to all the Prolog implementers who fixed bugs and
implemented enhancements that greatly helped in improving Logtalk
portability and reliability.

This list may be incomplete. Logtalk contributions and feedback occur
in multiple forms, from private mail to public forums and paper reviews.
Your contributions are greatly appreciated. If your name is missing,
please accept our apologies and contact us so that we can fix the omission.
Contact us also if, for some reason, you don't want your name on this
list.


RESEARCH SUPPORT
================

* Center for Research in Advanced Computing Systems (CRACS), INESC TEC, Portugal


SPONSORS
========

* Kyndi, Inc. - 2015-2017
* VivoMind Research, LLC - 2012-2013


OPEN-SOURCE SOFTWARE USED IN LOGTALK DEVELOPMENT AND DISTRIBUTION
=================================================================

* Several open-source Prolog compilers (development)
* MacPorts (macOS installer)
* InnoSetup (Windows installer)
* RPM (Linux installer)
* dpkg (Debian installer)
* Git (source code version control)
* Sphinx (HTML, PDF, and ePub documentation)
* Read the Docs Sphinx Theme (HTML, PDF, and ePub documentation)
* Graphviz (diagrams)
* phpBB (discussion forums)
* WordPress (blog)
* TextMate (coding)


HOSTING AND TESTING SERVICES USED IN LOGTALK DEVELOPMENT AND DISTRIBUTION
=========================================================================

* GitHub
* Travis CI
* AppVeyor
* Docker
* Read the Docs
* Gitter
