/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.streaming.ProcessingTimeExecutor$;
import org.apache.spark.sql.execution.streaming.ProcessingTimeTrigger;
import org.apache.spark.sql.execution.streaming.TriggerExecutor;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005me\u0001B\u0010!\u00016B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005S\u0001\tE\t\u0015!\u0003M\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0011\u001dA\u0006A1A\u0005\neCa!\u0018\u0001!\u0002\u0013Q\u0006\"\u00020\u0001\t\u0003z\u0006\"B6\u0001\t\u0003a\u0007\"B8\u0001\t\u0003\u0001\bbB:\u0001\u0003\u0003%\t\u0001\u001e\u0005\bo\u0002\t\n\u0011\"\u0001y\u0011%\t9\u0001AI\u0001\n\u0003\tI\u0001C\u0005\u0002\u000e\u0001\t\t\u0011\"\u0011\u0002\u0010!I\u0011\u0011\u0005\u0001\u0002\u0002\u0013\u0005\u00111\u0005\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"!\u000f\u0001\u0003\u0003%\t%a\u000f\t\u0013\u0005%\u0003!!A\u0005\u0002\u0005-\u0003\"CA(\u0001\u0005\u0005I\u0011IA)\u0011%\t\u0019\u0006AA\u0001\n\u0003\n)\u0006C\u0005\u0002X\u0001\t\t\u0011\"\u0011\u0002Z\u001dI\u0011Q\f\u0011\u0002\u0002#\u0005\u0011q\f\u0004\t?\u0001\n\t\u0011#\u0001\u0002b!11k\u0006C\u0001\u0003_B\u0011\"a\u0015\u0018\u0003\u0003%)%!\u0016\t\u0013\u0005Et#!A\u0005\u0002\u0006M\u0004\"CA=/E\u0005I\u0011AA\u0005\u0011%\tYhFA\u0001\n\u0003\u000bi\bC\u0005\u0002\u0010^\t\n\u0011\"\u0001\u0002\n!I\u0011\u0011S\f\u0002\u0002\u0013%\u00111\u0013\u0002\u0017!J|7-Z:tS:<G+[7f\u000bb,7-\u001e;pe*\u0011\u0011EI\u0001\ngR\u0014X-Y7j]\u001eT!a\t\u0013\u0002\u0013\u0015DXmY;uS>t'BA\u0013'\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sO\u000e\u00011C\u0002\u0001/iar\u0014\t\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003kYj\u0011\u0001I\u0005\u0003o\u0001\u0012q\u0002\u0016:jO\u001e,'/\u0012=fGV$xN\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003{i\u0012q\u0001T8hO&tw\r\u0005\u00020\u007f%\u0011\u0001\t\r\u0002\b!J|G-^2u!\ty#)\u0003\u0002Da\ta1+\u001a:jC2L'0\u00192mK\u0006)\u0002O]8dKN\u001c\u0018N\\4US6,GK]5hO\u0016\u0014X#\u0001$\u0011\u0005U:\u0015B\u0001%!\u0005U\u0001&o\\2fgNLgn\u001a+j[\u0016$&/[4hKJ\fa\u0003\u001d:pG\u0016\u001c8/\u001b8h)&lW\r\u0016:jO\u001e,'\u000fI\u0001\u0006G2|7m[\u000b\u0002\u0019B\u0011Q\nU\u0007\u0002\u001d*\u0011qJJ\u0001\u0005kRLG.\u0003\u0002R\u001d\n)1\t\\8dW\u000611\r\\8dW\u0002\na\u0001P5oSRtDcA+W/B\u0011Q\u0007\u0001\u0005\u0006\t\u0016\u0001\rA\u0012\u0005\b\u0015\u0016\u0001\n\u00111\u0001M\u0003)Ig\u000e^3sm\u0006dWj]\u000b\u00025B\u0011qfW\u0005\u00039B\u0012A\u0001T8oO\u0006Y\u0011N\u001c;feZ\fG.T:!\u0003\u001d)\u00070Z2vi\u0016$\"\u0001Y2\u0011\u0005=\n\u0017B\u000121\u0005\u0011)f.\u001b;\t\u000b\u0011D\u0001\u0019A3\u0002\u001dQ\u0014\u0018nZ4fe\"\u000bg\u000e\u001a7feB\u0019qF\u001a5\n\u0005\u001d\u0004$!\u0003$v]\u000e$\u0018n\u001c81!\ty\u0013.\u0003\u0002ka\t9!i\\8mK\u0006t\u0017\u0001\u00078pi&4\u0017PQ1uG\"4\u0015\r\u001c7j]\u001e\u0014U\r[5oIR\u0011\u0001-\u001c\u0005\u0006]&\u0001\rAW\u0001\u0012e\u0016\fG.\u00127baN,G\rV5nK6\u001b\u0018!\u00048fqR\u0014\u0015\r^2i)&lW\r\u0006\u0002[c\")!O\u0003a\u00015\u0006\u0019an\\<\u0002\t\r|\u0007/\u001f\u000b\u0004+V4\bb\u0002#\f!\u0003\u0005\rA\u0012\u0005\b\u0015.\u0001\n\u00111\u0001M\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012!\u001f\u0016\u0003\rj\\\u0013a\u001f\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!C;oG\",7m[3e\u0015\r\t\t\u0001M\u0001\u000bC:tw\u000e^1uS>t\u0017bAA\u0003{\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0002\u0016\u0003\u0019j\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\t!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\tA\u0001\\1oO*\u0011\u00111D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002 \u0005U!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002&A\u0019q&a\n\n\u0007\u0005%\u0002GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u00020\u0005U\u0002cA\u0018\u00022%\u0019\u00111\u0007\u0019\u0003\u0007\u0005s\u0017\u0010C\u0005\u00028A\t\t\u00111\u0001\u0002&\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u0010\u0011\r\u0005}\u0012QIA\u0018\u001b\t\t\tEC\u0002\u0002DA\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004Q\u00065\u0003\"CA\u001c%\u0005\u0005\t\u0019AA\u0018\u0003!A\u0017m\u001d5D_\u0012,GCAA\u0013\u0003!!xn\u0015;sS:<GCAA\t\u0003\u0019)\u0017/^1mgR\u0019\u0001.a\u0017\t\u0013\u0005]R#!AA\u0002\u0005=\u0012A\u0006)s_\u000e,7o]5oORKW.Z#yK\u000e,Ho\u001c:\u0011\u0005U:2\u0003B\f\u0002d\u0005\u0003r!!\u001a\u0002l\u0019cU+\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u0019\u0002\u000fI,h\u000e^5nK&!\u0011QNA4\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003?\nQ!\u00199qYf$R!VA;\u0003oBQ\u0001\u0012\u000eA\u0002\u0019CqA\u0013\u000e\u0011\u0002\u0003\u0007A*A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$B!a \u0002\fB)q&!!\u0002\u0006&\u0019\u00111\u0011\u0019\u0003\r=\u0003H/[8o!\u0015y\u0013q\u0011$M\u0013\r\tI\t\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u00055E$!AA\u0002U\u000b1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\n\u0005\u0003\u0002\u0014\u0005]\u0015\u0002BAM\u0003+\u0011aa\u00142kK\u000e$\b")
public class ProcessingTimeExecutor
implements TriggerExecutor,
Logging,
Product,
scala.Serializable {
    private final ProcessingTimeTrigger processingTimeTrigger;
    private final Clock clock;
    private final long intervalMs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return ProcessingTimeExecutor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<ProcessingTimeTrigger, Clock>> unapply(ProcessingTimeExecutor processingTimeExecutor) {
        return ProcessingTimeExecutor$.MODULE$.unapply(processingTimeExecutor);
    }

    public static Clock apply$default$2() {
        return ProcessingTimeExecutor$.MODULE$.apply$default$2();
    }

    public static ProcessingTimeExecutor apply(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return ProcessingTimeExecutor$.MODULE$.apply(processingTimeTrigger, clock);
    }

    public static Function1<Tuple2<ProcessingTimeTrigger, Clock>, ProcessingTimeExecutor> tupled() {
        return ProcessingTimeExecutor$.MODULE$.tupled();
    }

    public static Function1<ProcessingTimeTrigger, Function1<Clock, ProcessingTimeExecutor>> curried() {
        return ProcessingTimeExecutor$.MODULE$.curried();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ProcessingTimeTrigger processingTimeTrigger() {
        return this.processingTimeTrigger;
    }

    public Clock clock() {
        return this.clock;
    }

    private long intervalMs() {
        return this.intervalMs;
    }

    @Override
    public void execute(Function0<Object> triggerHandler) {
        while (true) {
            Object object;
            boolean terminated;
            long triggerTimeMs = this.clock().getTimeMillis();
            long nextTriggerTimeMs = this.nextBatchTime(triggerTimeMs);
            boolean bl = terminated = !triggerHandler.apply$mcZ$sp();
            if (this.intervalMs() > 0L) {
                long batchElapsedTimeMs = this.clock().getTimeMillis() - triggerTimeMs;
                if (batchElapsedTimeMs > this.intervalMs()) {
                    this.notifyBatchFallingBehind(batchElapsedTimeMs);
                }
                if (terminated) {
                    return;
                }
                object = BoxesRunTime.boxToLong((long)this.clock().waitTillTime(nextTriggerTimeMs));
                continue;
            }
            if (terminated) {
                return;
            }
            object = BoxedUnit.UNIT;
        }
    }

    public void notifyBatchFallingBehind(long realElapsedTimeMs) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(95).append("Current batch is falling behind. The trigger interval is ").append(this.intervalMs()).append(" milliseconds, but spent ").append(realElapsedTimeMs).append(" milliseconds").toString());
    }

    public long nextBatchTime(long now) {
        return this.intervalMs() == 0L ? now : now / this.intervalMs() * this.intervalMs() + this.intervalMs();
    }

    public ProcessingTimeExecutor copy(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        return new ProcessingTimeExecutor(processingTimeTrigger, clock);
    }

    public ProcessingTimeTrigger copy$default$1() {
        return this.processingTimeTrigger();
    }

    public Clock copy$default$2() {
        return this.clock();
    }

    public String productPrefix() {
        return "ProcessingTimeExecutor";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        ProcessingTimeTrigger processingTimeTrigger;
        int n = x$1;
        switch (n) {
            case 0: {
                processingTimeTrigger = this.processingTimeTrigger();
                break;
            }
            case 1: {
                processingTimeTrigger = this.clock();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return processingTimeTrigger;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ProcessingTimeExecutor;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ProcessingTimeExecutor)) return false;
        boolean bl = true;
        if (!bl) return false;
        ProcessingTimeExecutor processingTimeExecutor = (ProcessingTimeExecutor)x$1;
        ProcessingTimeTrigger processingTimeTrigger = this.processingTimeTrigger();
        ProcessingTimeTrigger processingTimeTrigger2 = processingTimeExecutor.processingTimeTrigger();
        if (processingTimeTrigger == null) {
            if (processingTimeTrigger2 != null) {
                return false;
            }
        } else if (!((Object)processingTimeTrigger).equals(processingTimeTrigger2)) return false;
        Clock clock = this.clock();
        Clock clock2 = processingTimeExecutor.clock();
        if (clock == null) {
            if (clock2 != null) {
                return false;
            }
        } else if (!clock.equals(clock2)) return false;
        if (!processingTimeExecutor.canEqual(this)) return false;
        return true;
    }

    public ProcessingTimeExecutor(ProcessingTimeTrigger processingTimeTrigger, Clock clock) {
        this.processingTimeTrigger = processingTimeTrigger;
        this.clock = clock;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.intervalMs = processingTimeTrigger.intervalMs();
        Predef$.MODULE$.require(this.intervalMs() >= 0L);
    }
}

