/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.TextInputFormat;

public class SymbolicInputFormat
implements ReworkMapredInputFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rework(HiveConf job, MapredWork work) throws IOException {
        LinkedHashMap<Path, PartitionDesc> pathToParts = work.getMapWork().getPathToPartitionInfo();
        ArrayList<Path> toRemovePaths = new ArrayList<Path>();
        HashMap<Path, PartitionDesc> toAddPathToPart = new HashMap<Path, PartitionDesc>();
        LinkedHashMap<Path, ArrayList<String>> pathToAliases = work.getMapWork().getPathToAliases();
        for (Map.Entry pathPartEntry : pathToParts.entrySet()) {
            Path path = (Path)pathPartEntry.getKey();
            PartitionDesc partDesc = (PartitionDesc)pathPartEntry.getValue();
            if (!partDesc.getInputFileFormatClass().equals(SymlinkTextInputFormat.class)) continue;
            partDesc.setInputFileFormatClass(TextInputFormat.class);
            FileSystem fileSystem = path.getFileSystem((Configuration)job);
            FileStatus fStatus = fileSystem.getFileStatus(path);
            FileStatus[] symlinks = null;
            symlinks = !fStatus.isDir() ? new FileStatus[]{fStatus} : fileSystem.listStatus(path, FileUtils.HIDDEN_FILES_PATH_FILTER);
            toRemovePaths.add(path);
            ArrayList aliases = (ArrayList)pathToAliases.remove(path);
            for (FileStatus symlink : symlinks) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath())));
                    partDesc.setInputFileFormatClass(TextInputFormat.class);
                    while ((line = reader.readLine()) != null) {
                        FileStatus[] matches;
                        for (FileStatus fileStatus : matches = fileSystem.globStatus(new Path(line))) {
                            Path schemaLessPath = Path.getPathWithoutSchemeAndAuthority((Path)fileStatus.getPath());
                            StringInternUtils.internUriStringsInPath((Path)schemaLessPath);
                            toAddPathToPart.put(schemaLessPath, partDesc);
                            pathToAliases.put(schemaLessPath, aliases);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeStream(reader);
                    throw throwable;
                }
                IOUtils.closeStream((Closeable)reader);
            }
        }
        for (Map.Entry toAdd : toAddPathToPart.entrySet()) {
            work.getMapWork().addPathToPartitionInfo((Path)toAdd.getKey(), (PartitionDesc)toAdd.getValue());
        }
        for (Path toRemove : toRemovePaths) {
            work.getMapWork().removePathToPartitionInfo(toRemove);
        }
    }
}

