/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.client.StreamInterceptor;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.protocol.ChunkFetchRequest;
import org.apache.spark.network.protocol.Encodable;
import org.apache.spark.network.protocol.OneWayMessage;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.RpcFailure;
import org.apache.spark.network.protocol.RpcRequest;
import org.apache.spark.network.protocol.RpcResponse;
import org.apache.spark.network.protocol.StreamFailure;
import org.apache.spark.network.protocol.StreamRequest;
import org.apache.spark.network.protocol.StreamResponse;
import org.apache.spark.network.protocol.UploadStream;
import org.apache.spark.network.server.ChunkFetchRequestHandler;
import org.apache.spark.network.server.MessageHandler;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.StreamManager;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.base.Throwables;

public class TransportRequestHandler
extends MessageHandler<RequestMessage> {
    private static final Logger logger = LoggerFactory.getLogger(TransportRequestHandler.class);
    private final Channel channel;
    private final TransportClient reverseClient;
    private final RpcHandler rpcHandler;
    private final StreamManager streamManager;
    private final long maxChunksBeingTransferred;
    private final ChunkFetchRequestHandler chunkFetchRequestHandler;

    public TransportRequestHandler(Channel channel, TransportClient reverseClient, RpcHandler rpcHandler, Long maxChunksBeingTransferred, ChunkFetchRequestHandler chunkFetchRequestHandler) {
        this.channel = channel;
        this.reverseClient = reverseClient;
        this.rpcHandler = rpcHandler;
        this.streamManager = rpcHandler.getStreamManager();
        this.maxChunksBeingTransferred = maxChunksBeingTransferred;
        this.chunkFetchRequestHandler = chunkFetchRequestHandler;
    }

    @Override
    public void exceptionCaught(Throwable cause) {
        this.rpcHandler.exceptionCaught(cause, this.reverseClient);
    }

    @Override
    public void channelActive() {
        this.rpcHandler.channelActive(this.reverseClient);
    }

    @Override
    public void channelInactive() {
        if (this.streamManager != null) {
            try {
                this.streamManager.connectionTerminated(this.channel);
            }
            catch (RuntimeException e) {
                logger.error("StreamManager connectionTerminated() callback failed.", (Throwable)e);
            }
        }
        this.rpcHandler.channelInactive(this.reverseClient);
    }

    @Override
    public void handle(RequestMessage request) throws Exception {
        if (request instanceof ChunkFetchRequest) {
            this.chunkFetchRequestHandler.processFetchRequest(this.channel, (ChunkFetchRequest)request);
        } else if (request instanceof RpcRequest) {
            this.processRpcRequest((RpcRequest)request);
        } else if (request instanceof OneWayMessage) {
            this.processOneWayMessage((OneWayMessage)request);
        } else if (request instanceof StreamRequest) {
            this.processStreamRequest((StreamRequest)request);
        } else if (request instanceof UploadStream) {
            this.processStreamUpload((UploadStream)request);
        } else {
            throw new IllegalArgumentException("Unknown request type: " + request);
        }
    }

    private void processStreamRequest(StreamRequest req) {
        ManagedBuffer buf;
        long chunksBeingTransferred;
        if (logger.isTraceEnabled()) {
            logger.trace("Received req from {} to fetch stream {}", (Object)NettyUtils.getRemoteAddress(this.channel), (Object)req.streamId);
        }
        if (this.maxChunksBeingTransferred < Long.MAX_VALUE && (chunksBeingTransferred = this.streamManager.chunksBeingTransferred()) >= this.maxChunksBeingTransferred) {
            logger.warn("The number of chunks being transferred {} is above {}, close the connection.", (Object)chunksBeingTransferred, (Object)this.maxChunksBeingTransferred);
            this.channel.close();
            return;
        }
        try {
            buf = this.streamManager.openStream(req.streamId);
        }
        catch (Exception e) {
            logger.error(String.format("Error opening stream %s for request from %s", req.streamId, NettyUtils.getRemoteAddress(this.channel)), (Throwable)e);
            this.respond(new StreamFailure(req.streamId, Throwables.getStackTraceAsString(e)));
            return;
        }
        if (buf != null) {
            this.streamManager.streamBeingSent(req.streamId);
            this.respond(new StreamResponse(req.streamId, buf.size(), buf)).addListener(future -> this.streamManager.streamSent(req.streamId));
        } else {
            this.respond(new StreamFailure(req.streamId, String.format("Stream '%s' was not found.", req.streamId)));
        }
    }

    private void processRpcRequest(final RpcRequest req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer(), new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            });
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() on RPC id " + req.requestId, (Throwable)e);
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
        }
        finally {
            req.body().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStreamUpload(final UploadStream req) {
        assert (req.body() == null);
        try {
            final RpcResponseCallback callback = new RpcResponseCallback(){

                @Override
                public void onSuccess(ByteBuffer response) {
                    TransportRequestHandler.this.respond(new RpcResponse(req.requestId, new NioManagedBuffer(response)));
                }

                @Override
                public void onFailure(Throwable e) {
                    TransportRequestHandler.this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
                }
            };
            TransportFrameDecoder frameDecoder = (TransportFrameDecoder)this.channel.pipeline().get("frameDecoder");
            ByteBuffer meta = req.meta.nioByteBuffer();
            final StreamCallbackWithID streamHandler = this.rpcHandler.receiveStream(this.reverseClient, meta, callback);
            if (streamHandler == null) {
                throw new NullPointerException("rpcHandler returned a null streamHandler");
            }
            StreamCallbackWithID wrappedCallback = new StreamCallbackWithID(){

                @Override
                public void onData(String streamId, ByteBuffer buf) throws IOException {
                    streamHandler.onData(streamId, buf);
                }

                @Override
                public void onComplete(String streamId) throws IOException {
                    try {
                        streamHandler.onComplete(streamId);
                        callback.onSuccess(ByteBuffer.allocate(0));
                    }
                    catch (Exception ex) {
                        IOException ioExc = new IOException("Failure post-processing complete stream; failing this rpc and leaving channel active", ex);
                        callback.onFailure(ioExc);
                        streamHandler.onFailure(streamId, ioExc);
                    }
                }

                @Override
                public void onFailure(String streamId, Throwable cause) throws IOException {
                    callback.onFailure(new IOException("Destination failed while reading stream", cause));
                    streamHandler.onFailure(streamId, cause);
                }

                @Override
                public String getID() {
                    return streamHandler.getID();
                }
            };
            if (req.bodyByteCount > 0L) {
                StreamInterceptor<RequestMessage> interceptor = new StreamInterceptor<RequestMessage>(this, wrappedCallback.getID(), req.bodyByteCount, wrappedCallback);
                frameDecoder.setInterceptor(interceptor);
            } else {
                wrappedCallback.onComplete(wrappedCallback.getID());
            }
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() on RPC id " + req.requestId, (Throwable)e);
            this.respond(new RpcFailure(req.requestId, Throwables.getStackTraceAsString(e)));
            this.channel.pipeline().fireExceptionCaught((Throwable)e);
        }
        finally {
            req.meta.release();
        }
    }

    private void processOneWayMessage(OneWayMessage req) {
        try {
            this.rpcHandler.receive(this.reverseClient, req.body().nioByteBuffer());
        }
        catch (Exception e) {
            logger.error("Error while invoking RpcHandler#receive() for one-way message.", (Throwable)e);
        }
        finally {
            req.body().release();
        }
    }

    private ChannelFuture respond(Encodable result) {
        SocketAddress remoteAddress = this.channel.remoteAddress();
        return this.channel.writeAndFlush((Object)result).addListener(future -> {
            if (future.isSuccess()) {
                logger.trace("Sent result {} to client {}", (Object)result, (Object)remoteAddress);
            } else {
                logger.error(String.format("Error sending result %s to %s; closing connection", result, remoteAddress), future.cause());
                this.channel.close();
            }
        });
    }
}

