/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_GlobalConstants
#define GUARD_GlobalConstants

//I don't care if Microsoft thinks sprintf is deprecated
#pragma warning(disable:4996)

#define WFLAG_STATIC 1
#define WFLAG_TILED 2
#define WFLAG_CANTCLOSE 4
#define WFLAG_INVISIBLE 8

#define MFLAG_BOLD 1
#define MFLAG_CRECT 2
#define MFLAG_CRECTWIDTH 4
#define MFLAG_FADED 8

#include <SDL.h>
#include <string>

using std::string;

const string myVersionNumber = "1.74";
//(James when counting A=1, B=2 etc)
const int standardRandomSeed = 10113518;

typedef std::basic_string<unsigned char> ustring;

const int screenBPP = 16;

const int all_constant = 0x7F7F7F7F;
const int none_constant = 0x7F7F7F7E;
const int infinite_constant = 0x7F7F7F7F;

const int maxPlayers = 4;
const int startingRectDim = 3000;

const int lineGap = 18;
const int normalLetterWidth = 8;
const int boldLetterWidth = 9;
const int smallBorderSize = 2;
const int bigBorderSize = 7;

const int nFontChars = 91;
const int nWeapons = 16;
const int nGenPictures = 43;

const int maxWorldUpdateInterval = 400;
const int maxScrollInterval = 300;
const int maxNameLength = 20;
const int maxTextInputLength = 120;
const int standardInterval = 33;

const int LCSWidth = 328;
const int LCSHeight = 72;
const int LCSCap = 3;
const int LCSFrCap = 2;

const int MCSWidth = 512;
const int MCSHeight = 112;
const int MCSCap = 6;
const int MCSFrCap = 4;

const int HCSWidth = 768;
const int HCSHeight = 168;
const int HCSCap = 9;
const int HCSFrCap = 6;

const int FrWidth = 84;
const int FrHeight = 44;
const int FrSmNumber = 2;

const int SSWidth = 8;
const int SSHeight = 8;

const int csGroupSize = 1;
const int frGroupSize = 1;
const int ssGroupSize = 3;

const int sliderWinWidth = 250;
const int sliderWinHeight = 80;

const int framesPerAnimFrame = 3;
const int maxMessageVectorSize = 6;
const int launchTimePerGroup = 15;

const int SmShBackBackTime = launchTimePerGroup * HCSCap;

const int maxGroups = 60;

const int csExplodeFrames = 9;
const int frExplodeFrames = 7;
const int ssExplodeFrames = 6;
const int explosionExplodeFrames = 4;

const int screenMoveSpeed = 40;

const int maxIns = 100;
const int maxScriptDigits = 6;
const int maxAIInt = 999999;
const int nAIVars = 10;

const int smShGroupSpacing = 2;

const int moveLeeway = 30;
const int maxAiming = 15;
const int staggerFrames = 10;

const int menuItemWidth = 160;

#endif
