/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "OptWindow.h"
#include "Globals.h"
#include "Group.h"
#include "Stuff.h"

ChooseResolution::ChooseResolution():
Menu_Base(0, 0, none_constant, 0) {
	MenuItem tempItem;

	tempItem.desc = "800*600";
	tempItem.choice = Opt_800;
	AddItem(tempItem);

	tempItem.desc = "1024*768";
	tempItem.choice = Opt_1024;
	AddItem(tempItem);

	tempItem.desc = "1280*1024";
	tempItem.choice = Opt_1280;
	AddItem(tempItem);

	InitRects();

	CentreWindow();
}

bool ChooseResolution::SwitchOnChoice(Uint16 x, Uint16 y) {
	if (currentSelection.choiceType == MCT_LeftCursor) {
		switch (currentSelection.choice) {
		case Opt_800:
			globalSettings.screenWidth = 800;
			globalSettings.screenHeight = 600;
			ResetGraphics();
			gsTo = GST_Reload;
			closed = true;
			break;

		case Opt_1024:
			globalSettings.screenWidth = 1024;
			globalSettings.screenHeight = 768;
			ResetGraphics();
			gsTo = GST_Reload;
			closed = true;
			break;

		case Opt_1280:
			globalSettings.screenWidth = 1280;
			globalSettings.screenHeight = 1024;
			ResetGraphics();
			gsTo = GST_Reload;
			closed = true;
			break;
		}
	}

	return false;
}

WindowColorSlider::WindowColorSlider(int ix, int iy, int flags):
SliderWithUnits(ix, iy, &globalSettings.howGreenIsGreen, 0, 40, "Amount of green", "/ 255", none_constant, flags) {}

bool WindowColorSlider::MouseM(Uint8 state, Uint16 x, Uint16 y) {
	bool ret = Slider::MouseM(state, x, y);
	
	veryDarkGreen = JSDL.MapRGB(0, globalSettings.howGreenIsGreen, 0);
	
	return ret;
}

void WindowColorSlider::DrawSelf() {
	if (globalSettings.howGreenIsGreen == 12) {
		Slider::DrawSelf();
		int x = rect.x + smallBorderSize;
		int y = rect.y + smallBorderSize;
		char output[48];
		sprintf(output, "%s: %d - Default", varName.c_str(), *varPointer);
		normalFonts.BlitString(x, y, 0, output);
	} else
		SliderWithUnits::DrawSelf();
}

///

StandardOptions::StandardOptions(int ix, int iy, int iParentID, int flags):
PopupMenu(ix, iy, iParentID, flags) {
	Update();
}

void StandardOptions::Update() {
	ClearItems();

	PushBackSharedItems();
	InitRects();
}

void StandardOptions::PushBackSharedItems() {
	MenuItem tempItem;

	if (gsCurrent == GST_MainMenu) {
		tempItem.desc = "Screen resolution";
		tempItem.choice = Opt_SetResolution;
		AddItem(tempItem);

		if (globalSettings.fullScreen) {
			tempItem.desc = "Fullscreen: On";
			tempItem.choice = Opt_FullscreenToggle;
			AddItem(tempItem);
		} else {
			tempItem.desc = "Fullscreen: Off";
			tempItem.choice = Opt_FullscreenToggle;
			AddItem(tempItem);
		}
	}

	tempItem.desc = "Window colour";
	tempItem.choice = Opt_SetWindowColor;
	AddItem(tempItem);

	if (!globalSettings.disableSound) {
		if (globalSettings.bMusic) {
			tempItem.desc = "Music: On";
			tempItem.choice = Opt_MusicOff;
			AddItem(tempItem);
		} else {
			tempItem.desc = "Music: Off";
			tempItem.choice = Opt_MusicOn;
			AddItem(tempItem);
		}
	}
}

bool StandardOptions::SwitchOnChoice(Uint16 x, Uint16 y) {
	if (currentSelection.choiceType == MCT_LeftCursor) {
		switch (currentSelection.choice) {
		case RTS_SetGameSpeed:
			myWindows.push_back(GenWindow(rect.x, rect.y, RTS_SetGameSpeed, 0, 0, 0));
			closed = true;
			break;

		case RTS_SetScrollSpeed:
			myWindows.push_back(GenWindow(rect.x, rect.y, RTS_SetScrollSpeed, 0, 0, 0));
			closed = true;
			break;

		case RTS_GroupNums:
			for (int i = 0; i != sides.size(); ++i) {
				for (int j = 0; j != sides[i].groups.size(); ++j)
					sides[i].groups[j].ToggleDrawNumber();
			}
			break;

		case RTS_GroupRects:
			for (int i = 0; i != sides.size(); ++i) {
				for (int j = 0; j != sides[i].groups.size(); ++j)
					sides[i].groups[j].ToggleDrawBound();
			}
			break;

		case Opt_FullscreenToggle:
			globalSettings.fullScreen = !globalSettings.fullScreen;
			ResetGraphics();
			gsTo = GST_Reload;
			break;

		case Opt_SetResolution:
			myWindows.push_back(GenWindow(rect.x, rect.y, Opt_SetResolution, 0, 0, 0));
			break;

		case Opt_SetWindowColor:
			myWindows.push_back(GenWindow(rect.x, rect.y, Opt_SetWindowColor, 0, 0, 0));
			break;

		case Opt_MusicOn:
			globalSettings.bMusic = 1;
			JSDL.PlayMusic();
			break;

		case Opt_MusicOff:
			globalSettings.bMusic = 0;
			JSDL.StopMusic();
			break;

		case RTS_RestartQ:
			myWindows.push_back(GenWindow(0, 0, RTS_RestartQ, 0, 0, 0));
			closed = true;
			break;

		case WC_Quit:
			switch (gsCurrent) {
			case GST_MainMenu:
				gsTo = GST_Reload;
				break;

			default:
				gsTo = GST_MainMenu;
				break;
			}
			break;
		}
	}
	
	return false;
}


