// Code generated from hashicorp/nomad/tools/ec2info; DO NOT EDIT.

package fingerprint

// CPU contains virtual core count and processor baseline performance.
type CPU struct {
	// use small units to reduce size of the embedded table
	Cores uint32 // good for 4 billion cores
	MHz   uint32 // good for 4 billion MHz
}

// Ticks computes the total number of cycles available across the virtual
// cores of a CPU.
func (c CPU) Ticks() int {
	return int(c.MHz) * int(c.Cores)
}

// GHz returns the speed of CPU in ghz.
func (c CPU) GHz() float64 {
	return float64(c.MHz) / 1000.0
}

// newCPU create a CPUSpecs from the given virtual core count and core speed.
func newCPU(cores uint32, ghz float64) CPU {
	return CPU{
		Cores: cores,
		MHz:   uint32(ghz * 1000),
	}
}

// LookupEC2CPU returns the virtual core count and core speed information from a
// lookup table generated from the Amazon EC2 API.
//
// If the instance type does not exist, nil is returned.
func LookupEC2CPU(instanceType string) *CPU {
	specs, exists := instanceTypeCPU[instanceType]
	if !exists {
		return nil
	}
	return &specs
}

var instanceTypeCPU = map[string]CPU{

	"a1.2xlarge":        newCPU(8, 2.3),
	"a1.4xlarge":        newCPU(16, 2.3),
	"a1.large":          newCPU(2, 2.3),
	"a1.medium":         newCPU(1, 2.3),
	"a1.metal":          newCPU(16, 2.3),
	"a1.xlarge":         newCPU(4, 2.3),
	"c3.2xlarge":        newCPU(8, 2.8),
	"c3.4xlarge":        newCPU(16, 2.8),
	"c3.8xlarge":        newCPU(32, 2.8),
	"c3.large":          newCPU(2, 2.8),
	"c3.xlarge":         newCPU(4, 2.8),
	"c4.2xlarge":        newCPU(8, 2.9),
	"c4.4xlarge":        newCPU(16, 2.9),
	"c4.8xlarge":        newCPU(36, 2.9),
	"c4.large":          newCPU(2, 2.9),
	"c4.xlarge":         newCPU(4, 2.9),
	"c5.12xlarge":       newCPU(48, 3.6),
	"c5.18xlarge":       newCPU(72, 3.4),
	"c5.24xlarge":       newCPU(96, 3.6),
	"c5.2xlarge":        newCPU(8, 3.4),
	"c5.4xlarge":        newCPU(16, 3.4),
	"c5.9xlarge":        newCPU(36, 3.4),
	"c5.large":          newCPU(2, 3.4),
	"c5.metal":          newCPU(96, 3.6),
	"c5.xlarge":         newCPU(4, 3.4),
	"c5a.12xlarge":      newCPU(48, 3.3),
	"c5a.16xlarge":      newCPU(64, 3.3),
	"c5a.24xlarge":      newCPU(96, 3.3),
	"c5a.2xlarge":       newCPU(8, 3.3),
	"c5a.4xlarge":       newCPU(16, 3.3),
	"c5a.8xlarge":       newCPU(32, 3.3),
	"c5a.large":         newCPU(2, 3.3),
	"c5a.xlarge":        newCPU(4, 3.3),
	"c5ad.12xlarge":     newCPU(48, 3.3),
	"c5ad.16xlarge":     newCPU(64, 3.3),
	"c5ad.24xlarge":     newCPU(96, 3.3),
	"c5ad.2xlarge":      newCPU(8, 3.3),
	"c5ad.4xlarge":      newCPU(16, 3.3),
	"c5ad.8xlarge":      newCPU(32, 3.3),
	"c5ad.large":        newCPU(2, 3.3),
	"c5ad.xlarge":       newCPU(4, 3.3),
	"c5d.12xlarge":      newCPU(48, 3.6),
	"c5d.18xlarge":      newCPU(72, 3.4),
	"c5d.24xlarge":      newCPU(96, 3.6),
	"c5d.2xlarge":       newCPU(8, 3.4),
	"c5d.4xlarge":       newCPU(16, 3.4),
	"c5d.9xlarge":       newCPU(36, 3.4),
	"c5d.large":         newCPU(2, 3.4),
	"c5d.metal":         newCPU(96, 3.6),
	"c5d.xlarge":        newCPU(4, 3.4),
	"c5n.18xlarge":      newCPU(72, 3.4),
	"c5n.2xlarge":       newCPU(8, 3.4),
	"c5n.4xlarge":       newCPU(16, 3.4),
	"c5n.9xlarge":       newCPU(36, 3.4),
	"c5n.large":         newCPU(2, 3.4),
	"c5n.metal":         newCPU(72, 3.4),
	"c5n.xlarge":        newCPU(4, 3.4),
	"c6a.12xlarge":      newCPU(48, 3.6),
	"c6a.16xlarge":      newCPU(64, 3.6),
	"c6a.24xlarge":      newCPU(96, 3.6),
	"c6a.2xlarge":       newCPU(8, 3.6),
	"c6a.32xlarge":      newCPU(128, 3.6),
	"c6a.48xlarge":      newCPU(192, 3.6),
	"c6a.4xlarge":       newCPU(16, 3.6),
	"c6a.8xlarge":       newCPU(32, 3.6),
	"c6a.large":         newCPU(2, 3.6),
	"c6a.metal":         newCPU(192, 3.6),
	"c6a.xlarge":        newCPU(4, 3.6),
	"c6g.12xlarge":      newCPU(48, 2.5),
	"c6g.16xlarge":      newCPU(64, 2.5),
	"c6g.2xlarge":       newCPU(8, 2.5),
	"c6g.4xlarge":       newCPU(16, 2.5),
	"c6g.8xlarge":       newCPU(32, 2.5),
	"c6g.large":         newCPU(2, 2.5),
	"c6g.medium":        newCPU(1, 2.5),
	"c6g.metal":         newCPU(64, 2.5),
	"c6g.xlarge":        newCPU(4, 2.5),
	"c6gd.12xlarge":     newCPU(48, 2.5),
	"c6gd.16xlarge":     newCPU(64, 2.5),
	"c6gd.2xlarge":      newCPU(8, 2.5),
	"c6gd.4xlarge":      newCPU(16, 2.5),
	"c6gd.8xlarge":      newCPU(32, 2.5),
	"c6gd.large":        newCPU(2, 2.5),
	"c6gd.medium":       newCPU(1, 2.5),
	"c6gd.metal":        newCPU(64, 2.5),
	"c6gd.xlarge":       newCPU(4, 2.5),
	"c6gn.12xlarge":     newCPU(48, 2.5),
	"c6gn.16xlarge":     newCPU(64, 2.5),
	"c6gn.2xlarge":      newCPU(8, 2.5),
	"c6gn.4xlarge":      newCPU(16, 2.5),
	"c6gn.8xlarge":      newCPU(32, 2.5),
	"c6gn.large":        newCPU(2, 2.5),
	"c6gn.medium":       newCPU(1, 2.5),
	"c6gn.xlarge":       newCPU(4, 2.5),
	"c6i.12xlarge":      newCPU(48, 3.5),
	"c6i.16xlarge":      newCPU(64, 3.5),
	"c6i.24xlarge":      newCPU(96, 3.5),
	"c6i.2xlarge":       newCPU(8, 3.5),
	"c6i.32xlarge":      newCPU(128, 3.5),
	"c6i.4xlarge":       newCPU(16, 3.5),
	"c6i.8xlarge":       newCPU(32, 3.5),
	"c6i.large":         newCPU(2, 3.5),
	"c6i.metal":         newCPU(128, 3.5),
	"c6i.xlarge":        newCPU(4, 3.5),
	"c6id.12xlarge":     newCPU(48, 3.5),
	"c6id.16xlarge":     newCPU(64, 3.5),
	"c6id.24xlarge":     newCPU(96, 3.5),
	"c6id.2xlarge":      newCPU(8, 3.5),
	"c6id.32xlarge":     newCPU(128, 3.5),
	"c6id.4xlarge":      newCPU(16, 3.5),
	"c6id.8xlarge":      newCPU(32, 3.5),
	"c6id.large":        newCPU(2, 3.5),
	"c6id.metal":        newCPU(128, 3.5),
	"c6id.xlarge":       newCPU(4, 3.5),
	"c6in.12xlarge":     newCPU(48, 3.5),
	"c6in.16xlarge":     newCPU(64, 3.5),
	"c6in.24xlarge":     newCPU(96, 3.5),
	"c6in.2xlarge":      newCPU(8, 3.5),
	"c6in.32xlarge":     newCPU(128, 3.5),
	"c6in.4xlarge":      newCPU(16, 3.5),
	"c6in.8xlarge":      newCPU(32, 3.5),
	"c6in.large":        newCPU(2, 3.5),
	"c6in.metal":        newCPU(128, 3.5),
	"c6in.xlarge":       newCPU(4, 3.5),
	"c7g.12xlarge":      newCPU(48, 2.6),
	"c7g.16xlarge":      newCPU(64, 2.6),
	"c7g.2xlarge":       newCPU(8, 2.6),
	"c7g.4xlarge":       newCPU(16, 2.6),
	"c7g.8xlarge":       newCPU(32, 2.6),
	"c7g.large":         newCPU(2, 2.6),
	"c7g.medium":        newCPU(1, 2.6),
	"c7g.metal":         newCPU(64, 2.6),
	"c7g.xlarge":        newCPU(4, 2.6),
	"c7gn.12xlarge":     newCPU(48, 2.6),
	"c7gn.16xlarge":     newCPU(64, 2.6),
	"c7gn.2xlarge":      newCPU(8, 2.6),
	"c7gn.4xlarge":      newCPU(16, 2.6),
	"c7gn.8xlarge":      newCPU(32, 2.6),
	"c7gn.large":        newCPU(2, 2.6),
	"c7gn.medium":       newCPU(1, 2.6),
	"c7gn.xlarge":       newCPU(4, 2.6),
	"d2.2xlarge":        newCPU(8, 2.4),
	"d2.4xlarge":        newCPU(16, 2.4),
	"d2.8xlarge":        newCPU(36, 2.4),
	"d2.xlarge":         newCPU(4, 2.4),
	"d3.2xlarge":        newCPU(8, 3.1),
	"d3.4xlarge":        newCPU(16, 3.1),
	"d3.8xlarge":        newCPU(32, 3.1),
	"d3.xlarge":         newCPU(4, 3.1),
	"d3en.12xlarge":     newCPU(48, 3.1),
	"d3en.2xlarge":      newCPU(8, 3.1),
	"d3en.4xlarge":      newCPU(16, 3.1),
	"d3en.6xlarge":      newCPU(24, 3.1),
	"d3en.8xlarge":      newCPU(32, 3.1),
	"d3en.xlarge":       newCPU(4, 3.1),
	"dl1.24xlarge":      newCPU(96, 3),
	"f1.16xlarge":       newCPU(64, 2.3),
	"f1.2xlarge":        newCPU(8, 2.3),
	"f1.4xlarge":        newCPU(16, 2.3),
	"g2.2xlarge":        newCPU(8, 2.6),
	"g2.8xlarge":        newCPU(32, 2.6),
	"g3.16xlarge":       newCPU(64, 2.3),
	"g3.4xlarge":        newCPU(16, 2.7),
	"g3.8xlarge":        newCPU(32, 2.7),
	"g3s.xlarge":        newCPU(4, 2.7),
	"g4ad.16xlarge":     newCPU(64, 3),
	"g4ad.2xlarge":      newCPU(8, 3),
	"g4ad.4xlarge":      newCPU(16, 3),
	"g4ad.8xlarge":      newCPU(32, 3),
	"g4ad.xlarge":       newCPU(4, 3),
	"g4dn.12xlarge":     newCPU(48, 2.5),
	"g4dn.16xlarge":     newCPU(64, 2.5),
	"g4dn.2xlarge":      newCPU(8, 2.5),
	"g4dn.4xlarge":      newCPU(16, 2.5),
	"g4dn.8xlarge":      newCPU(32, 2.5),
	"g4dn.metal":        newCPU(96, 2.5),
	"g4dn.xlarge":       newCPU(4, 2.5),
	"g5.12xlarge":       newCPU(48, 3.3),
	"g5.16xlarge":       newCPU(64, 3.3),
	"g5.24xlarge":       newCPU(96, 3.3),
	"g5.2xlarge":        newCPU(8, 3.3),
	"g5.48xlarge":       newCPU(192, 3.3),
	"g5.4xlarge":        newCPU(16, 3.3),
	"g5.8xlarge":        newCPU(32, 3.3),
	"g5.xlarge":         newCPU(4, 3.3),
	"g5g.16xlarge":      newCPU(64, 2.5),
	"g5g.2xlarge":       newCPU(8, 2.5),
	"g5g.4xlarge":       newCPU(16, 2.5),
	"g5g.8xlarge":       newCPU(32, 2.5),
	"g5g.metal":         newCPU(64, 2.5),
	"g5g.xlarge":        newCPU(4, 2.5),
	"h1.16xlarge":       newCPU(64, 2.3),
	"h1.2xlarge":        newCPU(8, 2.3),
	"h1.4xlarge":        newCPU(16, 2.3),
	"h1.8xlarge":        newCPU(32, 2.3),
	"hpc6a.48xlarge":    newCPU(96, 3.6),
	"hpc6id.32xlarge":   newCPU(64, 3.5),
	"hpc7g.16xlarge":    newCPU(64, 2.6),
	"hpc7g.4xlarge":     newCPU(16, 2.6),
	"hpc7g.8xlarge":     newCPU(32, 2.6),
	"i2.2xlarge":        newCPU(8, 2.5),
	"i2.4xlarge":        newCPU(16, 2.5),
	"i2.8xlarge":        newCPU(32, 2.5),
	"i2.xlarge":         newCPU(4, 2.5),
	"i3.16xlarge":       newCPU(64, 2.3),
	"i3.2xlarge":        newCPU(8, 2.3),
	"i3.4xlarge":        newCPU(16, 2.3),
	"i3.8xlarge":        newCPU(32, 2.3),
	"i3.large":          newCPU(2, 2.3),
	"i3.metal":          newCPU(72, 2.3),
	"i3.xlarge":         newCPU(4, 2.3),
	"i3en.12xlarge":     newCPU(48, 3.1),
	"i3en.24xlarge":     newCPU(96, 3.1),
	"i3en.2xlarge":      newCPU(8, 3.1),
	"i3en.3xlarge":      newCPU(12, 3.1),
	"i3en.6xlarge":      newCPU(24, 3.1),
	"i3en.large":        newCPU(2, 3.1),
	"i3en.metal":        newCPU(96, 3.1),
	"i3en.xlarge":       newCPU(4, 3.1),
	"i4g.16xlarge":      newCPU(64, 2.5),
	"i4g.2xlarge":       newCPU(8, 2.5),
	"i4g.4xlarge":       newCPU(16, 2.5),
	"i4g.8xlarge":       newCPU(32, 2.5),
	"i4g.large":         newCPU(2, 2.5),
	"i4g.xlarge":        newCPU(4, 2.5),
	"i4i.16xlarge":      newCPU(64, 3.5),
	"i4i.2xlarge":       newCPU(8, 3.5),
	"i4i.32xlarge":      newCPU(128, 3.5),
	"i4i.4xlarge":       newCPU(16, 3.5),
	"i4i.8xlarge":       newCPU(32, 3.5),
	"i4i.large":         newCPU(2, 3.5),
	"i4i.metal":         newCPU(128, 3.5),
	"i4i.xlarge":        newCPU(4, 3.5),
	"im4gn.16xlarge":    newCPU(64, 2.5),
	"im4gn.2xlarge":     newCPU(8, 2.5),
	"im4gn.4xlarge":     newCPU(16, 2.5),
	"im4gn.8xlarge":     newCPU(32, 2.5),
	"im4gn.large":       newCPU(2, 2.5),
	"im4gn.xlarge":      newCPU(4, 2.5),
	"inf1.24xlarge":     newCPU(96, 2.5),
	"inf1.2xlarge":      newCPU(8, 2.5),
	"inf1.6xlarge":      newCPU(24, 2.5),
	"inf1.xlarge":       newCPU(4, 2.5),
	"inf2.24xlarge":     newCPU(96, 3.6),
	"inf2.48xlarge":     newCPU(192, 3.6),
	"inf2.8xlarge":      newCPU(32, 3.6),
	"inf2.xlarge":       newCPU(4, 3.6),
	"is4gen.2xlarge":    newCPU(8, 2.5),
	"is4gen.4xlarge":    newCPU(16, 2.5),
	"is4gen.8xlarge":    newCPU(32, 2.5),
	"is4gen.large":      newCPU(2, 2.5),
	"is4gen.medium":     newCPU(1, 2.5),
	"is4gen.xlarge":     newCPU(4, 2.5),
	"m3.2xlarge":        newCPU(8, 2.5),
	"m3.large":          newCPU(2, 2.5),
	"m3.medium":         newCPU(1, 2.5),
	"m3.xlarge":         newCPU(4, 2.5),
	"m4.10xlarge":       newCPU(40, 2.4),
	"m4.16xlarge":       newCPU(64, 2.3),
	"m4.2xlarge":        newCPU(8, 2.4),
	"m4.4xlarge":        newCPU(16, 2.4),
	"m4.large":          newCPU(2, 2.4),
	"m4.xlarge":         newCPU(4, 2.4),
	"m5.12xlarge":       newCPU(48, 3.1),
	"m5.16xlarge":       newCPU(64, 3.1),
	"m5.24xlarge":       newCPU(96, 3.1),
	"m5.2xlarge":        newCPU(8, 3.1),
	"m5.4xlarge":        newCPU(16, 3.1),
	"m5.8xlarge":        newCPU(32, 3.1),
	"m5.large":          newCPU(2, 3.1),
	"m5.metal":          newCPU(96, 3.1),
	"m5.xlarge":         newCPU(4, 3.1),
	"m5a.12xlarge":      newCPU(48, 2.5),
	"m5a.16xlarge":      newCPU(64, 2.5),
	"m5a.24xlarge":      newCPU(96, 2.5),
	"m5a.2xlarge":       newCPU(8, 2.5),
	"m5a.4xlarge":       newCPU(16, 2.5),
	"m5a.8xlarge":       newCPU(32, 2.5),
	"m5a.large":         newCPU(2, 2.5),
	"m5a.xlarge":        newCPU(4, 2.5),
	"m5ad.12xlarge":     newCPU(48, 2.2),
	"m5ad.16xlarge":     newCPU(64, 2.5),
	"m5ad.24xlarge":     newCPU(96, 2.2),
	"m5ad.2xlarge":      newCPU(8, 2.2),
	"m5ad.4xlarge":      newCPU(16, 2.2),
	"m5ad.8xlarge":      newCPU(32, 2.5),
	"m5ad.large":        newCPU(2, 2.2),
	"m5ad.xlarge":       newCPU(4, 2.2),
	"m5d.12xlarge":      newCPU(48, 3.1),
	"m5d.16xlarge":      newCPU(64, 3.1),
	"m5d.24xlarge":      newCPU(96, 3.1),
	"m5d.2xlarge":       newCPU(8, 3.1),
	"m5d.4xlarge":       newCPU(16, 3.1),
	"m5d.8xlarge":       newCPU(32, 3.1),
	"m5d.large":         newCPU(2, 3.1),
	"m5d.metal":         newCPU(96, 3.1),
	"m5d.xlarge":        newCPU(4, 3.1),
	"m5dn.12xlarge":     newCPU(48, 3.1),
	"m5dn.16xlarge":     newCPU(64, 3.1),
	"m5dn.24xlarge":     newCPU(96, 3.1),
	"m5dn.2xlarge":      newCPU(8, 3.1),
	"m5dn.4xlarge":      newCPU(16, 3.1),
	"m5dn.8xlarge":      newCPU(32, 3.1),
	"m5dn.large":        newCPU(2, 3.1),
	"m5dn.metal":        newCPU(96, 3.1),
	"m5dn.xlarge":       newCPU(4, 3.1),
	"m5n.12xlarge":      newCPU(48, 3.1),
	"m5n.16xlarge":      newCPU(64, 3.1),
	"m5n.24xlarge":      newCPU(96, 3.1),
	"m5n.2xlarge":       newCPU(8, 3.1),
	"m5n.4xlarge":       newCPU(16, 3.1),
	"m5n.8xlarge":       newCPU(32, 3.1),
	"m5n.large":         newCPU(2, 3.1),
	"m5n.metal":         newCPU(96, 3.1),
	"m5n.xlarge":        newCPU(4, 3.1),
	"m5zn.12xlarge":     newCPU(48, 4.5),
	"m5zn.2xlarge":      newCPU(8, 4.5),
	"m5zn.3xlarge":      newCPU(12, 4.5),
	"m5zn.6xlarge":      newCPU(24, 4.5),
	"m5zn.large":        newCPU(2, 4.5),
	"m5zn.metal":        newCPU(48, 4.5),
	"m5zn.xlarge":       newCPU(4, 4.5),
	"m6a.12xlarge":      newCPU(48, 3.6),
	"m6a.16xlarge":      newCPU(64, 3.6),
	"m6a.24xlarge":      newCPU(96, 3.6),
	"m6a.2xlarge":       newCPU(8, 3.6),
	"m6a.32xlarge":      newCPU(128, 3.6),
	"m6a.48xlarge":      newCPU(192, 3.6),
	"m6a.4xlarge":       newCPU(16, 3.6),
	"m6a.8xlarge":       newCPU(32, 3.6),
	"m6a.large":         newCPU(2, 3.6),
	"m6a.metal":         newCPU(192, 3.6),
	"m6a.xlarge":        newCPU(4, 3.6),
	"m6g.12xlarge":      newCPU(48, 2.5),
	"m6g.16xlarge":      newCPU(64, 2.5),
	"m6g.2xlarge":       newCPU(8, 2.5),
	"m6g.4xlarge":       newCPU(16, 2.5),
	"m6g.8xlarge":       newCPU(32, 2.5),
	"m6g.large":         newCPU(2, 2.5),
	"m6g.medium":        newCPU(1, 2.5),
	"m6g.metal":         newCPU(64, 2.5),
	"m6g.xlarge":        newCPU(4, 2.5),
	"m6gd.12xlarge":     newCPU(48, 2.5),
	"m6gd.16xlarge":     newCPU(64, 2.5),
	"m6gd.2xlarge":      newCPU(8, 2.5),
	"m6gd.4xlarge":      newCPU(16, 2.5),
	"m6gd.8xlarge":      newCPU(32, 2.5),
	"m6gd.large":        newCPU(2, 2.5),
	"m6gd.medium":       newCPU(1, 2.5),
	"m6gd.metal":        newCPU(64, 2.5),
	"m6gd.xlarge":       newCPU(4, 2.5),
	"m6i.12xlarge":      newCPU(48, 3.5),
	"m6i.16xlarge":      newCPU(64, 3.5),
	"m6i.24xlarge":      newCPU(96, 3.5),
	"m6i.2xlarge":       newCPU(8, 3.5),
	"m6i.32xlarge":      newCPU(128, 3.5),
	"m6i.4xlarge":       newCPU(16, 3.5),
	"m6i.8xlarge":       newCPU(32, 3.5),
	"m6i.large":         newCPU(2, 3.5),
	"m6i.metal":         newCPU(128, 3.5),
	"m6i.xlarge":        newCPU(4, 3.5),
	"m6id.12xlarge":     newCPU(48, 3.5),
	"m6id.16xlarge":     newCPU(64, 3.5),
	"m6id.24xlarge":     newCPU(96, 3.5),
	"m6id.2xlarge":      newCPU(8, 3.5),
	"m6id.32xlarge":     newCPU(128, 3.5),
	"m6id.4xlarge":      newCPU(16, 3.5),
	"m6id.8xlarge":      newCPU(32, 3.5),
	"m6id.large":        newCPU(2, 3.5),
	"m6id.metal":        newCPU(128, 3.5),
	"m6id.xlarge":       newCPU(4, 3.5),
	"m6idn.12xlarge":    newCPU(48, 3.5),
	"m6idn.16xlarge":    newCPU(64, 3.5),
	"m6idn.24xlarge":    newCPU(96, 3.5),
	"m6idn.2xlarge":     newCPU(8, 3.5),
	"m6idn.32xlarge":    newCPU(128, 3.5),
	"m6idn.4xlarge":     newCPU(16, 3.5),
	"m6idn.8xlarge":     newCPU(32, 3.5),
	"m6idn.large":       newCPU(2, 3.5),
	"m6idn.metal":       newCPU(128, 3.5),
	"m6idn.xlarge":      newCPU(4, 3.5),
	"m6in.12xlarge":     newCPU(48, 3.5),
	"m6in.16xlarge":     newCPU(64, 3.5),
	"m6in.24xlarge":     newCPU(96, 3.5),
	"m6in.2xlarge":      newCPU(8, 3.5),
	"m6in.32xlarge":     newCPU(128, 3.5),
	"m6in.4xlarge":      newCPU(16, 3.5),
	"m6in.8xlarge":      newCPU(32, 3.5),
	"m6in.large":        newCPU(2, 3.5),
	"m6in.metal":        newCPU(128, 3.5),
	"m6in.xlarge":       newCPU(4, 3.5),
	"m7g.12xlarge":      newCPU(48, 2.6),
	"m7g.16xlarge":      newCPU(64, 2.6),
	"m7g.2xlarge":       newCPU(8, 2.6),
	"m7g.4xlarge":       newCPU(16, 2.6),
	"m7g.8xlarge":       newCPU(32, 2.6),
	"m7g.large":         newCPU(2, 2.6),
	"m7g.medium":        newCPU(1, 2.6),
	"m7g.metal":         newCPU(64, 2.6),
	"m7g.xlarge":        newCPU(4, 2.6),
	"mac1.metal":        newCPU(12, 3.2),
	"mac2.metal":        newCPU(8, 3.2),
	"p2.16xlarge":       newCPU(64, 2.3),
	"p2.8xlarge":        newCPU(32, 2.7),
	"p2.xlarge":         newCPU(4, 2.7),
	"p3.16xlarge":       newCPU(64, 2.7),
	"p3.2xlarge":        newCPU(8, 2.7),
	"p3.8xlarge":        newCPU(32, 2.7),
	"p3dn.24xlarge":     newCPU(96, 2.5),
	"p4d.24xlarge":      newCPU(96, 3),
	"r3.2xlarge":        newCPU(8, 2.5),
	"r3.4xlarge":        newCPU(16, 2.5),
	"r3.8xlarge":        newCPU(32, 2.5),
	"r3.large":          newCPU(2, 2.5),
	"r3.xlarge":         newCPU(4, 2.5),
	"r4.16xlarge":       newCPU(64, 2.3),
	"r4.2xlarge":        newCPU(8, 2.3),
	"r4.4xlarge":        newCPU(16, 2.3),
	"r4.8xlarge":        newCPU(32, 2.3),
	"r4.large":          newCPU(2, 2.3),
	"r4.xlarge":         newCPU(4, 2.3),
	"r5.12xlarge":       newCPU(48, 3.1),
	"r5.16xlarge":       newCPU(64, 3.1),
	"r5.24xlarge":       newCPU(96, 3.1),
	"r5.2xlarge":        newCPU(8, 3.1),
	"r5.4xlarge":        newCPU(16, 3.1),
	"r5.8xlarge":        newCPU(32, 3.1),
	"r5.large":          newCPU(2, 3.1),
	"r5.metal":          newCPU(96, 3.1),
	"r5.xlarge":         newCPU(4, 3.1),
	"r5a.12xlarge":      newCPU(48, 2.5),
	"r5a.16xlarge":      newCPU(64, 2.5),
	"r5a.24xlarge":      newCPU(96, 2.5),
	"r5a.2xlarge":       newCPU(8, 2.5),
	"r5a.4xlarge":       newCPU(16, 2.5),
	"r5a.8xlarge":       newCPU(32, 2.5),
	"r5a.large":         newCPU(2, 2.5),
	"r5a.xlarge":        newCPU(4, 2.5),
	"r5ad.12xlarge":     newCPU(48, 2.2),
	"r5ad.16xlarge":     newCPU(64, 2.5),
	"r5ad.24xlarge":     newCPU(96, 2.2),
	"r5ad.2xlarge":      newCPU(8, 2.2),
	"r5ad.4xlarge":      newCPU(16, 2.2),
	"r5ad.8xlarge":      newCPU(32, 2.5),
	"r5ad.large":        newCPU(2, 2.2),
	"r5ad.xlarge":       newCPU(4, 2.2),
	"r5b.12xlarge":      newCPU(48, 3.1),
	"r5b.16xlarge":      newCPU(64, 3.1),
	"r5b.24xlarge":      newCPU(96, 3.1),
	"r5b.2xlarge":       newCPU(8, 3.1),
	"r5b.4xlarge":       newCPU(16, 3.1),
	"r5b.8xlarge":       newCPU(32, 3.1),
	"r5b.large":         newCPU(2, 3.1),
	"r5b.metal":         newCPU(96, 3.1),
	"r5b.xlarge":        newCPU(4, 3.1),
	"r5d.12xlarge":      newCPU(48, 3.1),
	"r5d.16xlarge":      newCPU(64, 3.1),
	"r5d.24xlarge":      newCPU(96, 3.1),
	"r5d.2xlarge":       newCPU(8, 3.1),
	"r5d.4xlarge":       newCPU(16, 3.1),
	"r5d.8xlarge":       newCPU(32, 3.1),
	"r5d.large":         newCPU(2, 3.1),
	"r5d.metal":         newCPU(96, 3.1),
	"r5d.xlarge":        newCPU(4, 3.1),
	"r5dn.12xlarge":     newCPU(48, 3.1),
	"r5dn.16xlarge":     newCPU(64, 3.1),
	"r5dn.24xlarge":     newCPU(96, 3.1),
	"r5dn.2xlarge":      newCPU(8, 3.1),
	"r5dn.4xlarge":      newCPU(16, 3.1),
	"r5dn.8xlarge":      newCPU(32, 3.1),
	"r5dn.large":        newCPU(2, 3.1),
	"r5dn.metal":        newCPU(96, 3.1),
	"r5dn.xlarge":       newCPU(4, 3.1),
	"r5n.12xlarge":      newCPU(48, 3.1),
	"r5n.16xlarge":      newCPU(64, 3.1),
	"r5n.24xlarge":      newCPU(96, 3.1),
	"r5n.2xlarge":       newCPU(8, 3.1),
	"r5n.4xlarge":       newCPU(16, 3.1),
	"r5n.8xlarge":       newCPU(32, 3.1),
	"r5n.large":         newCPU(2, 3.1),
	"r5n.metal":         newCPU(96, 3.1),
	"r5n.xlarge":        newCPU(4, 3.1),
	"r6a.12xlarge":      newCPU(48, 3.6),
	"r6a.16xlarge":      newCPU(64, 3.6),
	"r6a.24xlarge":      newCPU(96, 3.6),
	"r6a.2xlarge":       newCPU(8, 3.6),
	"r6a.32xlarge":      newCPU(128, 3.6),
	"r6a.48xlarge":      newCPU(192, 3.6),
	"r6a.4xlarge":       newCPU(16, 3.6),
	"r6a.8xlarge":       newCPU(32, 3.6),
	"r6a.large":         newCPU(2, 3.6),
	"r6a.metal":         newCPU(192, 3.6),
	"r6a.xlarge":        newCPU(4, 3.6),
	"r6g.12xlarge":      newCPU(48, 2.5),
	"r6g.16xlarge":      newCPU(64, 2.5),
	"r6g.2xlarge":       newCPU(8, 2.5),
	"r6g.4xlarge":       newCPU(16, 2.5),
	"r6g.8xlarge":       newCPU(32, 2.5),
	"r6g.large":         newCPU(2, 2.5),
	"r6g.medium":        newCPU(1, 2.5),
	"r6g.metal":         newCPU(64, 2.5),
	"r6g.xlarge":        newCPU(4, 2.5),
	"r6gd.12xlarge":     newCPU(48, 2.5),
	"r6gd.16xlarge":     newCPU(64, 2.5),
	"r6gd.2xlarge":      newCPU(8, 2.5),
	"r6gd.4xlarge":      newCPU(16, 2.5),
	"r6gd.8xlarge":      newCPU(32, 2.5),
	"r6gd.large":        newCPU(2, 2.5),
	"r6gd.medium":       newCPU(1, 2.5),
	"r6gd.metal":        newCPU(64, 2.5),
	"r6gd.xlarge":       newCPU(4, 2.5),
	"r6i.12xlarge":      newCPU(48, 3.5),
	"r6i.16xlarge":      newCPU(64, 3.5),
	"r6i.24xlarge":      newCPU(96, 3.5),
	"r6i.2xlarge":       newCPU(8, 3.5),
	"r6i.32xlarge":      newCPU(128, 3.5),
	"r6i.4xlarge":       newCPU(16, 3.5),
	"r6i.8xlarge":       newCPU(32, 3.5),
	"r6i.large":         newCPU(2, 3.5),
	"r6i.metal":         newCPU(128, 3.5),
	"r6i.xlarge":        newCPU(4, 3.5),
	"r6id.12xlarge":     newCPU(48, 3.5),
	"r6id.16xlarge":     newCPU(64, 3.5),
	"r6id.24xlarge":     newCPU(96, 3.5),
	"r6id.2xlarge":      newCPU(8, 3.5),
	"r6id.32xlarge":     newCPU(128, 3.5),
	"r6id.4xlarge":      newCPU(16, 3.5),
	"r6id.8xlarge":      newCPU(32, 3.5),
	"r6id.large":        newCPU(2, 3.5),
	"r6id.metal":        newCPU(128, 3.5),
	"r6id.xlarge":       newCPU(4, 3.5),
	"r6idn.12xlarge":    newCPU(48, 3.5),
	"r6idn.16xlarge":    newCPU(64, 3.5),
	"r6idn.24xlarge":    newCPU(96, 3.5),
	"r6idn.2xlarge":     newCPU(8, 3.5),
	"r6idn.32xlarge":    newCPU(128, 3.5),
	"r6idn.4xlarge":     newCPU(16, 3.5),
	"r6idn.8xlarge":     newCPU(32, 3.5),
	"r6idn.large":       newCPU(2, 3.5),
	"r6idn.metal":       newCPU(128, 3.5),
	"r6idn.xlarge":      newCPU(4, 3.5),
	"r6in.12xlarge":     newCPU(48, 3.5),
	"r6in.16xlarge":     newCPU(64, 3.5),
	"r6in.24xlarge":     newCPU(96, 3.5),
	"r6in.2xlarge":      newCPU(8, 3.5),
	"r6in.32xlarge":     newCPU(128, 3.5),
	"r6in.4xlarge":      newCPU(16, 3.5),
	"r6in.8xlarge":      newCPU(32, 3.5),
	"r6in.large":        newCPU(2, 3.5),
	"r6in.metal":        newCPU(128, 3.5),
	"r6in.xlarge":       newCPU(4, 3.5),
	"r7g.12xlarge":      newCPU(48, 2.6),
	"r7g.16xlarge":      newCPU(64, 2.6),
	"r7g.2xlarge":       newCPU(8, 2.6),
	"r7g.4xlarge":       newCPU(16, 2.6),
	"r7g.8xlarge":       newCPU(32, 2.6),
	"r7g.large":         newCPU(2, 2.6),
	"r7g.medium":        newCPU(1, 2.6),
	"r7g.metal":         newCPU(64, 2.6),
	"r7g.xlarge":        newCPU(4, 2.6),
	"t2.2xlarge":        newCPU(8, 2.3),
	"t2.large":          newCPU(2, 2.3),
	"t2.medium":         newCPU(2, 2.3),
	"t2.micro":          newCPU(1, 2.5),
	"t2.nano":           newCPU(1, 2.4),
	"t2.small":          newCPU(1, 2.5),
	"t2.xlarge":         newCPU(4, 2.3),
	"t3.2xlarge":        newCPU(8, 2.5),
	"t3.large":          newCPU(2, 2.5),
	"t3.medium":         newCPU(2, 2.5),
	"t3.micro":          newCPU(2, 2.5),
	"t3.nano":           newCPU(2, 2.5),
	"t3.small":          newCPU(2, 2.5),
	"t3.xlarge":         newCPU(4, 2.5),
	"t3a.2xlarge":       newCPU(8, 2.2),
	"t3a.large":         newCPU(2, 2.2),
	"t3a.medium":        newCPU(2, 2.2),
	"t3a.micro":         newCPU(2, 2.2),
	"t3a.nano":          newCPU(2, 2.2),
	"t3a.small":         newCPU(2, 2.2),
	"t3a.xlarge":        newCPU(4, 2.2),
	"t4g.2xlarge":       newCPU(8, 2.5),
	"t4g.large":         newCPU(2, 2.5),
	"t4g.medium":        newCPU(2, 2.5),
	"t4g.micro":         newCPU(2, 2.5),
	"t4g.nano":          newCPU(2, 2.5),
	"t4g.small":         newCPU(2, 2.5),
	"t4g.xlarge":        newCPU(4, 2.5),
	"trn1.2xlarge":      newCPU(8, 3.5),
	"trn1.32xlarge":     newCPU(128, 3.5),
	"trn1n.32xlarge":    newCPU(128, 3.5),
	"u-12tb1.112xlarge": newCPU(448, 2.1),
	"u-18tb1.112xlarge": newCPU(448, 2.7),
	"u-24tb1.112xlarge": newCPU(448, 2.7),
	"u-3tb1.56xlarge":   newCPU(224, 2.1),
	"u-6tb1.112xlarge":  newCPU(448, 2.1),
	"u-6tb1.56xlarge":   newCPU(224, 2.1),
	"u-9tb1.112xlarge":  newCPU(448, 2.1),
	"vt1.24xlarge":      newCPU(96, 2.5),
	"vt1.3xlarge":       newCPU(12, 2.5),
	"vt1.6xlarge":       newCPU(24, 2.5),
	"x1.16xlarge":       newCPU(64, 2.3),
	"x1.32xlarge":       newCPU(128, 2.3),
	"x1e.16xlarge":      newCPU(64, 2.3),
	"x1e.2xlarge":       newCPU(8, 2.3),
	"x1e.32xlarge":      newCPU(128, 2.3),
	"x1e.4xlarge":       newCPU(16, 2.3),
	"x1e.8xlarge":       newCPU(32, 2.3),
	"x1e.xlarge":        newCPU(4, 2.3),
	"x2gd.12xlarge":     newCPU(48, 2.5),
	"x2gd.16xlarge":     newCPU(64, 2.5),
	"x2gd.2xlarge":      newCPU(8, 2.5),
	"x2gd.4xlarge":      newCPU(16, 2.5),
	"x2gd.8xlarge":      newCPU(32, 2.5),
	"x2gd.large":        newCPU(2, 2.5),
	"x2gd.medium":       newCPU(1, 2.5),
	"x2gd.metal":        newCPU(64, 2.5),
	"x2gd.xlarge":       newCPU(4, 2.5),
	"x2idn.16xlarge":    newCPU(64, 3.5),
	"x2idn.24xlarge":    newCPU(96, 3.5),
	"x2idn.32xlarge":    newCPU(128, 3.5),
	"x2idn.metal":       newCPU(128, 3.5),
	"x2iedn.16xlarge":   newCPU(64, 3.5),
	"x2iedn.24xlarge":   newCPU(96, 3.5),
	"x2iedn.2xlarge":    newCPU(8, 3.5),
	"x2iedn.32xlarge":   newCPU(128, 3.5),
	"x2iedn.4xlarge":    newCPU(16, 3.5),
	"x2iedn.8xlarge":    newCPU(32, 3.5),
	"x2iedn.metal":      newCPU(128, 3.5),
	"x2iedn.xlarge":     newCPU(4, 3.5),
	"x2iezn.12xlarge":   newCPU(48, 4.5),
	"x2iezn.2xlarge":    newCPU(8, 4.5),
	"x2iezn.4xlarge":    newCPU(16, 4.5),
	"x2iezn.6xlarge":    newCPU(24, 4.5),
	"x2iezn.8xlarge":    newCPU(32, 4.5),
	"x2iezn.metal":      newCPU(48, 4.5),
	"z1d.12xlarge":      newCPU(48, 4),
	"z1d.2xlarge":       newCPU(8, 4),
	"z1d.3xlarge":       newCPU(12, 4),
	"z1d.6xlarge":       newCPU(24, 4),
	"z1d.large":         newCPU(2, 4),
	"z1d.metal":         newCPU(48, 4),
	"z1d.xlarge":        newCPU(4, 4),
}
