// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: roachpb/data.proto

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_storage_engine_enginepb1 "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ValueType defines a set of type constants placed in the "tag" field of Value
// messages. These are defined as a protocol buffer enumeration so that they
// can be used portably between our Go and C code. The tags are used by the
// RocksDB Merge Operator to perform specialized merges.
type ValueType int32

const (
	// This is a subset of the SQL column type values, representing the underlying
	// storage for various types. The DELIMITED_foo entries each represent a foo
	// variant that self-delimits length.
	ValueType_UNKNOWN           ValueType = 0
	ValueType_INT               ValueType = 1
	ValueType_FLOAT             ValueType = 2
	ValueType_BYTES             ValueType = 3
	ValueType_DELIMITED_BYTES   ValueType = 8
	ValueType_TIME              ValueType = 4
	ValueType_DECIMAL           ValueType = 5
	ValueType_DELIMITED_DECIMAL ValueType = 9
	ValueType_DURATION          ValueType = 6
	// TUPLE represents a DTuple, encoded as repeated pairs of varint field number
	// followed by a value encoded Datum.
	ValueType_TUPLE ValueType = 10
	// TIMESERIES is applied to values which contain InternalTimeSeriesData.
	ValueType_TIMESERIES ValueType = 100
)

var ValueType_name = map[int32]string{
	0:   "UNKNOWN",
	1:   "INT",
	2:   "FLOAT",
	3:   "BYTES",
	8:   "DELIMITED_BYTES",
	4:   "TIME",
	5:   "DECIMAL",
	9:   "DELIMITED_DECIMAL",
	6:   "DURATION",
	10:  "TUPLE",
	100: "TIMESERIES",
}
var ValueType_value = map[string]int32{
	"UNKNOWN":           0,
	"INT":               1,
	"FLOAT":             2,
	"BYTES":             3,
	"DELIMITED_BYTES":   8,
	"TIME":              4,
	"DECIMAL":           5,
	"DELIMITED_DECIMAL": 9,
	"DURATION":          6,
	"TUPLE":             10,
	"TIMESERIES":        100,
}

func (x ValueType) String() string {
	return proto.EnumName(ValueType_name, int32(x))
}
func (ValueType) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{0} }

// ReplicaChangeType is a parameter of ChangeReplicasTrigger.
type ReplicaChangeType int32

const (
	ADD_REPLICA    ReplicaChangeType = 0
	REMOVE_REPLICA ReplicaChangeType = 1
)

var ReplicaChangeType_name = map[int32]string{
	0: "ADD_REPLICA",
	1: "REMOVE_REPLICA",
}
var ReplicaChangeType_value = map[string]int32{
	"ADD_REPLICA":    0,
	"REMOVE_REPLICA": 1,
}

func (x ReplicaChangeType) String() string {
	return proto.EnumName(ReplicaChangeType_name, int32(x))
}
func (ReplicaChangeType) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{1} }

// TransactionStatus specifies possible states for a transaction.
type TransactionStatus int32

const (
	// PENDING is the default state for a new transaction. Transactions
	// move from PENDING to one of COMMITTED or ABORTED. Mutations made
	// as part of a PENDING transactions are recorded as "intents" in
	// the underlying MVCC model.
	PENDING TransactionStatus = 0
	// COMMITTED is the state for a transaction which has been
	// committed. Mutations made as part of a transaction which is moved
	// into COMMITTED state become durable and visible to other
	// transactions, moving from "intents" to permanent versioned
	// values.
	COMMITTED TransactionStatus = 1
	// ABORTED is the state for a transaction which has been aborted.
	// Mutations made as part of a transaction which is moved into
	// ABORTED state are deleted and are never made visible to other
	// transactions.
	ABORTED TransactionStatus = 2
)

var TransactionStatus_name = map[int32]string{
	0: "PENDING",
	1: "COMMITTED",
	2: "ABORTED",
}
var TransactionStatus_value = map[string]int32{
	"PENDING":   0,
	"COMMITTED": 1,
	"ABORTED":   2,
}

func (x TransactionStatus) String() string {
	return proto.EnumName(TransactionStatus_name, int32(x))
}
func (TransactionStatus) EnumDescriptor() ([]byte, []int) { return fileDescriptorData, []int{2} }

// Span is a key range with an inclusive start Key and an exclusive end Key.
type Span struct {
	// The start key of the key range.
	Key Key `protobuf:"bytes,3,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The end key of the key range. The value is empty if the key range
	// contains only a single key. Otherwise, it must order strictly after Key.
	// In such a case, the Span encompasses the key range from Key to EndKey,
	// including Key and excluding EndKey.
	EndKey Key `protobuf:"bytes,4,opt,name=end_key,json=endKey,proto3,casttype=Key" json:"end_key,omitempty"`
}

func (m *Span) Reset()                    { *m = Span{} }
func (*Span) ProtoMessage()               {}
func (*Span) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{0} }

// Value specifies the value at a key. Multiple values at the same key are
// supported based on timestamp. The data stored within a value is typed
// (ValueType) and custom encoded into the raw_bytes field. A custom encoding
// is used instead of separate proto fields to avoid proto overhead and to
// avoid unnecessary encoding and decoding as the value gets read from disk and
// passed through the network. The format is:
//
//   <4-byte-checksum><1-byte-tag><encoded-data>
//
// A CRC-32-IEEE checksum is computed from the associated key, tag and encoded
// data, in that order.
//
// TODO(peter): Is a 4-byte checksum overkill when most (all?) values
// will be less than 64KB?
type Value struct {
	// raw_bytes contains the encoded value and checksum.
	RawBytes []byte `protobuf:"bytes,1,opt,name=raw_bytes,json=rawBytes,proto3" json:"raw_bytes,omitempty"`
	// Timestamp of value.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *Value) Reset()                    { *m = Value{} }
func (m *Value) String() string            { return proto.CompactTextString(m) }
func (*Value) ProtoMessage()               {}
func (*Value) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{1} }

// KeyValue is a pair of Key and Value for returned Key/Value pairs
// from ScanRequest/ScanResponse. It embeds a Key and a Value.
type KeyValue struct {
	Key   Key   `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{2} }

// A StoreIdent uniquely identifies a store in the cluster. The
// StoreIdent is written to the underlying storage engine at a
// store-reserved system key (KeyLocalIdent).
type StoreIdent struct {
	ClusterID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
	NodeID    NodeID                                              `protobuf:"varint,2,opt,name=node_id,json=nodeId,proto3,casttype=NodeID" json:"node_id,omitempty"`
	StoreID   StoreID                                             `protobuf:"varint,3,opt,name=store_id,json=storeId,proto3,casttype=StoreID" json:"store_id,omitempty"`
}

func (m *StoreIdent) Reset()                    { *m = StoreIdent{} }
func (m *StoreIdent) String() string            { return proto.CompactTextString(m) }
func (*StoreIdent) ProtoMessage()               {}
func (*StoreIdent) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{3} }

// A SplitTrigger is run after a successful commit of an AdminSplit
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) and the new range descriptor covering
// the right hand side of the split (right_desc). This information
// allows the final bookkeeping for the split to be completed and the
// new range put into operation.
type SplitTrigger struct {
	LeftDesc  RangeDescriptor `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc" json:"left_desc"`
	RightDesc RangeDescriptor `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc" json:"right_desc"`
}

func (m *SplitTrigger) Reset()                    { *m = SplitTrigger{} }
func (m *SplitTrigger) String() string            { return proto.CompactTextString(m) }
func (*SplitTrigger) ProtoMessage()               {}
func (*SplitTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{4} }

// A MergeTrigger is run after a successful commit of an AdminMerge
// command. It provides the updated left hand side of the split's
// range descriptor (left_desc) that now encompasses what was
// originally both ranges and the soon-to-be-invalid range descriptor
// that used to cover the subsumed, right hand side of the merge
// (right_desc). This information allows the final bookkeeping for the
// merge to be completed and put into operation.
type MergeTrigger struct {
	LeftDesc       RangeDescriptor                              `protobuf:"bytes,1,opt,name=left_desc,json=leftDesc" json:"left_desc"`
	RightDesc      RangeDescriptor                              `protobuf:"bytes,2,opt,name=right_desc,json=rightDesc" json:"right_desc"`
	RightMVCCStats cockroach_storage_engine_enginepb1.MVCCStats `protobuf:"bytes,4,opt,name=right_mvcc_stats,json=rightMvccStats" json:"right_mvcc_stats"`
	// FreezeStart is a timestamp that is guaranteed to be greater than the
	// timestamps at which any requests were serviced by the responding replica
	// before it stopped responding to requests altogether (in anticipation of
	// being subsumed). It is suitable for use as the timestamp cache's low water
	// mark for the keys previously owned by the subsumed range.
	FreezeStart cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=freeze_start,json=freezeStart" json:"freeze_start"`
}

func (m *MergeTrigger) Reset()                    { *m = MergeTrigger{} }
func (m *MergeTrigger) String() string            { return proto.CompactTextString(m) }
func (*MergeTrigger) ProtoMessage()               {}
func (*MergeTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{5} }

type ChangeReplicasTrigger struct {
	ChangeType ReplicaChangeType `protobuf:"varint,1,opt,name=change_type,json=changeType,proto3,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type,omitempty"`
	// The replica being modified.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
	// The new replica list with this change applied.
	UpdatedReplicas []ReplicaDescriptor `protobuf:"bytes,3,rep,name=updated_replicas,json=updatedReplicas" json:"updated_replicas"`
	NextReplicaID   ReplicaID           `protobuf:"varint,4,opt,name=next_replica_id,json=nextReplicaId,proto3,casttype=ReplicaID" json:"next_replica_id,omitempty"`
}

func (m *ChangeReplicasTrigger) Reset()                    { *m = ChangeReplicasTrigger{} }
func (*ChangeReplicasTrigger) ProtoMessage()               {}
func (*ChangeReplicasTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{6} }

// ModifiedSpanTrigger indicates that a specific span has been modified.
// This can be used to trigger scan-and-gossip for the given span.
type ModifiedSpanTrigger struct {
	SystemConfigSpan bool `protobuf:"varint,1,opt,name=system_config_span,json=systemConfigSpan,proto3" json:"system_config_span,omitempty"`
	// node_liveness_span is set to indicate that node liveness records
	// need re-gossiping after modification or range lease updates. The
	// span is set to a single key when nodes update their liveness records
	// with heartbeats to extend the expiration timestamp. Changes to the
	// range lease for the range containing node liveness triggers re-gossip
	// of the entire node liveness key range.
	NodeLivenessSpan *Span `protobuf:"bytes,2,opt,name=node_liveness_span,json=nodeLivenessSpan" json:"node_liveness_span,omitempty"`
}

func (m *ModifiedSpanTrigger) Reset()                    { *m = ModifiedSpanTrigger{} }
func (m *ModifiedSpanTrigger) String() string            { return proto.CompactTextString(m) }
func (*ModifiedSpanTrigger) ProtoMessage()               {}
func (*ModifiedSpanTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{7} }

// InternalCommitTrigger encapsulates all of the internal-only commit triggers.
// Only one may be set.
type InternalCommitTrigger struct {
	SplitTrigger          *SplitTrigger          `protobuf:"bytes,1,opt,name=split_trigger,json=splitTrigger" json:"split_trigger,omitempty"`
	MergeTrigger          *MergeTrigger          `protobuf:"bytes,2,opt,name=merge_trigger,json=mergeTrigger" json:"merge_trigger,omitempty"`
	ChangeReplicasTrigger *ChangeReplicasTrigger `protobuf:"bytes,3,opt,name=change_replicas_trigger,json=changeReplicasTrigger" json:"change_replicas_trigger,omitempty"`
	ModifiedSpanTrigger   *ModifiedSpanTrigger   `protobuf:"bytes,4,opt,name=modified_span_trigger,json=modifiedSpanTrigger" json:"modified_span_trigger,omitempty"`
}

func (m *InternalCommitTrigger) Reset()                    { *m = InternalCommitTrigger{} }
func (m *InternalCommitTrigger) String() string            { return proto.CompactTextString(m) }
func (*InternalCommitTrigger) ProtoMessage()               {}
func (*InternalCommitTrigger) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{8} }

func (m *InternalCommitTrigger) GetSplitTrigger() *SplitTrigger {
	if m != nil {
		return m.SplitTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetMergeTrigger() *MergeTrigger {
	if m != nil {
		return m.MergeTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetChangeReplicasTrigger() *ChangeReplicasTrigger {
	if m != nil {
		return m.ChangeReplicasTrigger
	}
	return nil
}

func (m *InternalCommitTrigger) GetModifiedSpanTrigger() *ModifiedSpanTrigger {
	if m != nil {
		return m.ModifiedSpanTrigger
	}
	return nil
}

type ObservedTimestamp struct {
	NodeID    NodeID                       `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=NodeID" json:"node_id,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *ObservedTimestamp) Reset()                    { *m = ObservedTimestamp{} }
func (m *ObservedTimestamp) String() string            { return proto.CompactTextString(m) }
func (*ObservedTimestamp) ProtoMessage()               {}
func (*ObservedTimestamp) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{9} }

// A Transaction is a unit of work performed on the database.
// Cockroach transactions support two isolation levels: snapshot
// isolation and serializable snapshot isolation. Each Cockroach
// transaction is assigned a random priority. This priority will be
// used to decide whether a transaction will be aborted during
// contention.
//
// If you add fields to Transaction you'll need to update
// Transaction.Clone. Failure to do so will result in test failures.
type Transaction struct {
	// The transaction metadata. These are persisted with every intent.
	cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,1,opt,name=meta,embedded=meta" json:"meta"`
	// A free-text identifier for debug purposes.
	Name          string                       `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	Status        TransactionStatus            `protobuf:"varint,4,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
	LastHeartbeat cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=last_heartbeat,json=lastHeartbeat" json:"last_heartbeat"`
	// The original timestamp at which the transaction started. For serializable
	// transactions, if the timestamp drifts from the original timestamp, the
	// transaction will retry unless we manage to "refresh the reads" - see
	// refreshed_timestamp.
	//
	// This timestamp is the one at which all transactions will read, unless
	// refreshed_timestamp is set. It is also, surprisingly, the timestamp at
	// which transactions will provisionally _write_ (i.e. intents are written at
	// this orig_timestamp and, after commit, when the intents are resolved,
	// their timestamps are bumped to the to the commit timestamp), if
	// refreshed_timestamp isn't set.
	// This is ultimately because of correctness concerns around SNAPSHOT
	// transactions.
	//
	// Intuitively, one could think that the timestamp at which intents should be
	// written should be the provisional commit timestamp, and while this is
	// morally true, consider the following scenario, where txn1 is a SNAPSHOT
	// txn:
	//
	// - txn1 at orig_timestamp=5 reads key1: (value) 1.
	// - txn1 writes elsewhere, has its commit timestamp increased to 20.
	// - txn2 at orig_timestamp=10 reads key1: 1
	// - txn2 increases the value by 5: key1: 6 and commits
	// - txn1 increases the value by 1: key1: 2, attempts commit
	//
	// If txn1 uses its orig_timestamp for updating key1 (as it does), it
	// conflicts with txn2's committed value (which is at timestamp 10, in the
	// future of 5), and restarts.
	// Using instead its candidate commit timestamp, it wouldn't see a conflict
	// and commit, but this is not the expected outcome (the expected outcome is
	// {key1: 6} (since txn1 is not expected to commit)) and we would be
	// experiencing the Lost Update Anomaly.
	//
	// Note that in practice, before restarting, txn1 would still lay down an
	// intent (just above the committed value) not with the intent to commit it,
	// but to avoid being starved by short-lived transactions on that key which
	// would otherwise not have to go through conflict resolution with txn1.
	//
	// Again, keep in mind that, when the transaction commits, all the intents are
	// bumped to the commit timestamp (otherwise, pushing a transaction wouldn't
	// achieve anything).
	OrigTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,6,opt,name=orig_timestamp,json=origTimestamp" json:"orig_timestamp"`
	// Initial Timestamp + clock skew. Reads which encounter values with
	// timestamps between timestamp and max_timestamp trigger a txn
	// retry error, unless the node being read is listed in observed_timestamps
	// (in which case no more read uncertainty can occur).
	// The case max_timestamp < timestamp is possible for transactions which have
	// been pushed; in this case, max_timestamp should be ignored.
	MaxTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=max_timestamp,json=maxTimestamp" json:"max_timestamp"`
	// The refreshed timestamp is the timestamp at which the transaction
	// can commit without necessitating a serializable restart. This
	// value is forwarded to the transaction's current timestamp (meta.timestamp)
	// if the transaction coordinator is able to refresh all refreshable spans
	// encountered during the course of the txn. If set, this take precedence
	// over orig_timestamp and is the timestamp at which the transaction both
	// reads and writes going forward.
	RefreshedTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,15,opt,name=refreshed_timestamp,json=refreshedTimestamp" json:"refreshed_timestamp"`
	// A list of <NodeID, timestamp> pairs. The list maps NodeIDs to timestamps
	// as observed from their local clock during this transaction. The purpose of
	// this map is to avoid uncertainty related restarts which normally occur
	// when reading a value in the near future as per the max_timestamp field.
	//
	// Morally speaking, having an entry for a node in this map means that this
	// node has been visited before, and that no more uncertainty restarts are
	// expected for operations served from it. However, this is not entirely
	// accurate. For example, say a txn starts with orig_timestamp=1 (and some
	// large max_timestamp). It then reads key "a" from node A, registering an
	// entry `A -> 5` in the process (`5` happens to be a timestamp taken off
	// that node's clock at the end of the read).
	// Now assume that some other transaction writes and commits a value at key "b"
	// and timestamp 4 (again, served by node A), and our transaction attempts to
	// read that key. Since there is an entry in its observed_timestamps for A,
	// our uncertainty window is `[orig_timestamp, 5) = [1, 5)` but the value at
	// key "b" is in that window, and so we will restart. However, we will restart
	// with a timestamp that is at least high as our entry in the map for node A,
	// so no future operation on node A will be uncertain.
	//
	// Thus, expressed properly, you could say that when a node has been read from
	// successfully before, uncertainty on that node is restricted to values with
	// timestamps in the interval [orig_timestamp, first_visit_timestamp), and
	// that no node will trigger restarts more than once (and in fact, usually
	// the first restart also bumps the txn timestamp enough to clear all other
	// nodes).
	//
	// When this list holds a corresponding entry for the node the current
	// request is executing on, we can run the command with the map's timestamp
	// as the top boundary of our uncertainty interval, limiting (and often
	// avoiding) uncertainty restarts.
	//
	// When a transaction is first initialized on a node, it may use a timestamp
	// from the local hybrid logical clock to initialize the corresponding entry
	// in the map. In particular, if `orig_timestamp` is taken from that node's
	// clock, we may add that to the map, which eliminates read uncertainty for
	// reads on that node.
	//
	// The list of observed timestamps is kept sorted by NodeID. Use
	// Transaction.UpdateObservedTimestamp to maintain the sorted order.
	ObservedTimestamps []ObservedTimestamp `protobuf:"bytes,8,rep,name=observed_timestamps,json=observedTimestamps" json:"observed_timestamps"`
	// Writing is true if the transaction has previously sent a Begin transaction
	// (i.e. if it ever attempted to perform a write, so if it ever attempted to
	// leave intents (across retries)). The flag will be set even if the BeginTxn
	// batch failed.
	// When set, the AbortCache must be checked by reads so that they don't miss
	// to see the txn's previous writes.
	Writing bool `protobuf:"varint,9,opt,name=writing,proto3" json:"writing,omitempty"`
	// If this is true, the transaction must retry. Relevant only for
	// SNAPSHOT transactions: a SERIALIZABLE transaction would have to
	// retry anyway due to its commit timestamp having moved forward (whenever
	// write_too_old is set, meta.Timestamp has been pushed above orig_timestamp).
	// This bool is set instead of immediately returning a txn retry
	// error so that intents can continue to be laid down, minimizing
	// work required on txn restart.
	WriteTooOld bool `protobuf:"varint,12,opt,name=write_too_old,json=writeTooOld,proto3" json:"write_too_old,omitempty"`
	// If retry_on_push is true, the transaction must retry in the event
	// that the commit timestamp is pushed forward. This flag is set if
	// the transaction contains any calls to DeleteRange, in order to
	// prevent the LostDeleteRange anomaly. This flag is relevant only
	// for SNAPSHOT transactions.
	RetryOnPush bool   `protobuf:"varint,13,opt,name=retry_on_push,json=retryOnPush,proto3" json:"retry_on_push,omitempty"`
	Intents     []Span `protobuf:"bytes,11,rep,name=intents" json:"intents"`
	// Epoch zero timestamp is used to keep track of the earliest timestamp
	// that any epoch of the transaction used. This is set only if the
	// transaction is restarted and the epoch is bumped. It is used during
	// intent resolution to more efficiently scan for intents.
	EpochZeroTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,14,opt,name=epoch_zero_timestamp,json=epochZeroTimestamp" json:"epoch_zero_timestamp"`
	// This flag is set if the transaction's original timestamp was
	// "leaked" beyond the transaction (i.e. if returned via NOW() or
	// transaction_timestamp()). If true, this prevents optimizations
	// which commit at a higher timestamp without resorting to a
	// client-side retry.
	OrigTimestampWasObserved bool `protobuf:"varint,16,opt,name=orig_timestamp_was_observed,json=origTimestampWasObserved,proto3" json:"orig_timestamp_was_observed,omitempty"`
}

func (m *Transaction) Reset()                    { *m = Transaction{} }
func (*Transaction) ProtoMessage()               {}
func (*Transaction) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{10} }

// A Intent is a Span together with a Transaction metadata and its status.
type Intent struct {
	Span   `protobuf:"bytes,1,opt,name=span,embedded=span" json:"span"`
	Txn    cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn" json:"txn"`
	Status TransactionStatus                         `protobuf:"varint,3,opt,name=status,proto3,enum=cockroach.roachpb.TransactionStatus" json:"status,omitempty"`
}

func (m *Intent) Reset()                    { *m = Intent{} }
func (m *Intent) String() string            { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()               {}
func (*Intent) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{11} }

// A SequencedWrite is a point write to a key with a certain sequence number.
//
// TODO(nvanbenschoten/tschottdorf): This message type can be used as the
// PromisedWrites repeated field in EndTransaction in the parallel commits
// proposal (#24194).
type SequencedWrite struct {
	// The key that the write was made at.
	Key Key `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The sequence number of the request that created the write.
	Sequence int32 `protobuf:"varint,2,opt,name=sequence,proto3" json:"sequence,omitempty"`
}

func (m *SequencedWrite) Reset()                    { *m = SequencedWrite{} }
func (m *SequencedWrite) String() string            { return proto.CompactTextString(m) }
func (*SequencedWrite) ProtoMessage()               {}
func (*SequencedWrite) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{12} }

// Lease contains information about range leases including the
// expiration and lease holder.
type Lease struct {
	// The start is a timestamp at which the lease begins. This value
	// must be greater than the last lease expiration or the lease request
	// is considered invalid.
	Start cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=start" json:"start"`
	// The expiration is a timestamp at which the lease expires. This means that
	// a new lease can be granted for a later timestamp.
	Expiration *cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=expiration" json:"expiration,omitempty" cockroachdb:"randnullable"`
	// The address of the would-be lease holder.
	Replica ReplicaDescriptor `protobuf:"bytes,3,opt,name=replica" json:"replica"`
	// The start of the lease stasis period. This field is deprecated.
	DeprecatedStartStasis *cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=deprecated_start_stasis,json=deprecatedStartStasis" json:"deprecated_start_stasis,omitempty" cockroachdb:"randnullable"`
	// The current timestamp when this lease has been proposed. Used after a
	// transfer and after a node restart to enforce that a node only uses leases
	// proposed after the time of the said transfer or restart. This is nullable
	// to help with the rollout (such that a lease applied by some nodes before
	// the rollout and some nodes after the rollout is serialized the same).
	// TODO(andrei): Make this non-nullable after the rollout.
	ProposedTS *cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=proposed_ts,json=proposedTs" json:"proposed_ts,omitempty"`
	// The epoch of the lease holder's node liveness entry. If this value
	// is non-zero, the start and expiration values are ignored.
	Epoch int64 `protobuf:"varint,6,opt,name=epoch,proto3" json:"epoch,omitempty"`
	// A zero-indexed sequence number which is incremented during the acquisition
	// of each new range lease that is not equivalent to the previous range lease
	// (i.e. an acquisition that implies a leaseholder change). The sequence
	// number is used to detect lease changes between command proposal and
	// application without requiring that we send the entire lease through Raft.
	// Lease sequence numbers are a reflection of the "lease equivalency" property
	// (see Lease.Equivalent). Two adjacent leases that are equivalent will have
	// the same sequence number and two adjacent leases that are not equivalent
	// will have different sequence numbers.
	Sequence LeaseSequence `protobuf:"varint,7,opt,name=sequence,proto3,casttype=LeaseSequence" json:"sequence,omitempty"`
}

func (m *Lease) Reset()                    { *m = Lease{} }
func (*Lease) ProtoMessage()               {}
func (*Lease) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{13} }

// AbortSpanEntry contains information about a transaction which has
// been aborted. It's written to a range's AbortSpan if the range
// may have contained intents of the aborted txn. In the event that
// the same transaction attempts to read keys it may have written
// previously, this entry informs the transaction that it has aborted
// and must start fresh with an updated priority.
type AbortSpanEntry struct {
	// The key of the associated transaction.
	Key Key `protobuf:"bytes,1,opt,name=key,proto3,casttype=Key" json:"key,omitempty"`
	// The candidate commit timestamp the transaction record held at the time
	// it was aborted.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	// The priority of the transaction.
	Priority int32 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
}

func (m *AbortSpanEntry) Reset()                    { *m = AbortSpanEntry{} }
func (m *AbortSpanEntry) String() string            { return proto.CompactTextString(m) }
func (*AbortSpanEntry) ProtoMessage()               {}
func (*AbortSpanEntry) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{14} }

// TxnCoordMeta is metadata held by a transaction coordinator. This
// message is defined here because it is used in several layers of the
// system (internal/client, sql/distsqlrun, kv).
type TxnCoordMeta struct {
	// txn is a copy of the transaction record, updated with each request.
	Txn Transaction `protobuf:"bytes,1,opt,name=txn" json:"txn"`
	// intents stores key spans affected by this transaction through
	// this coordinator. These spans allow the coordinator to set the
	// list of intent spans in the EndTransactionRequest when the
	// transaction is finalized.
	Intents []Span `protobuf:"bytes,2,rep,name=intents" json:"intents"`
	// command_count indicates how many requests have been sent through
	// this transaction. Reset on retryable txn errors.
	CommandCount int32 `protobuf:"varint,3,opt,name=command_count,json=commandCount,proto3" json:"command_count,omitempty"`
	// refresh_reads and refresh_writes store key spans which were read
	// or, less frequently, written during a transaction. These fields
	// are utilized for SERIALIZABLE transactions in the event a
	// transaction experiences a retry error. In that case, the
	// coordinator uses the Refresh and RefreshRange RPCs to verify that
	// no write has occurred to the spans more recently than the txn's
	// original timestamp, and updates the affected timestamp caches to
	// the transaction's refreshed timestamp. On failure, the retry
	// error is propagated. On success, the transaction's original and
	// current timestamps are forwarded to the refresh timestamp, and
	// the transaction can continue.
	RefreshReads  []Span `protobuf:"bytes,4,rep,name=refresh_reads,json=refreshReads" json:"refresh_reads"`
	RefreshWrites []Span `protobuf:"bytes,5,rep,name=refresh_writes,json=refreshWrites" json:"refresh_writes"`
	// refresh_invalid indicates that spans were discarded or not collected
	// (i.e. because of a dist SQL processor running a version before refreshing
	// was introduced). This is false if all spans encountered during the
	// transaction which need refreshing have been collected to the refresh_reads
	// and refresh_writes span slices.
	RefreshInvalid bool `protobuf:"varint,7,opt,name=refresh_invalid,json=refreshInvalid,proto3" json:"refresh_invalid,omitempty"`
	// deprecated_refresh_valid is the inverse of refresh_invalid. It was
	// deprecated in favor of refresh_invalid in order to give the struct a useful
	// zero value.
	// TODO(nvanbenschoten): Can be removed in 2.2.
	DeprecatedRefreshValid bool `protobuf:"varint,6,opt,name=deprecated_refresh_valid,json=deprecatedRefreshValid,proto3" json:"deprecated_refresh_valid,omitempty"`
	// outstanding_writes stores all writes that are outstanding and have
	// not yet been resolved. Any client wishing to send a request that
	// overlaps with them must chain on to their success using a QueryIntent
	// request.
	OutstandingWrites []SequencedWrite `protobuf:"bytes,8,rep,name=outstanding_writes,json=outstandingWrites" json:"outstanding_writes"`
}

func (m *TxnCoordMeta) Reset()                    { *m = TxnCoordMeta{} }
func (m *TxnCoordMeta) String() string            { return proto.CompactTextString(m) }
func (*TxnCoordMeta) ProtoMessage()               {}
func (*TxnCoordMeta) Descriptor() ([]byte, []int) { return fileDescriptorData, []int{15} }

func init() {
	proto.RegisterType((*Span)(nil), "cockroach.roachpb.Span")
	proto.RegisterType((*Value)(nil), "cockroach.roachpb.Value")
	proto.RegisterType((*KeyValue)(nil), "cockroach.roachpb.KeyValue")
	proto.RegisterType((*StoreIdent)(nil), "cockroach.roachpb.StoreIdent")
	proto.RegisterType((*SplitTrigger)(nil), "cockroach.roachpb.SplitTrigger")
	proto.RegisterType((*MergeTrigger)(nil), "cockroach.roachpb.MergeTrigger")
	proto.RegisterType((*ChangeReplicasTrigger)(nil), "cockroach.roachpb.ChangeReplicasTrigger")
	proto.RegisterType((*ModifiedSpanTrigger)(nil), "cockroach.roachpb.ModifiedSpanTrigger")
	proto.RegisterType((*InternalCommitTrigger)(nil), "cockroach.roachpb.InternalCommitTrigger")
	proto.RegisterType((*ObservedTimestamp)(nil), "cockroach.roachpb.ObservedTimestamp")
	proto.RegisterType((*Transaction)(nil), "cockroach.roachpb.Transaction")
	proto.RegisterType((*Intent)(nil), "cockroach.roachpb.Intent")
	proto.RegisterType((*SequencedWrite)(nil), "cockroach.roachpb.SequencedWrite")
	proto.RegisterType((*Lease)(nil), "cockroach.roachpb.Lease")
	proto.RegisterType((*AbortSpanEntry)(nil), "cockroach.roachpb.AbortSpanEntry")
	proto.RegisterType((*TxnCoordMeta)(nil), "cockroach.roachpb.TxnCoordMeta")
	proto.RegisterEnum("cockroach.roachpb.ValueType", ValueType_name, ValueType_value)
	proto.RegisterEnum("cockroach.roachpb.ReplicaChangeType", ReplicaChangeType_name, ReplicaChangeType_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionStatus", TransactionStatus_name, TransactionStatus_value)
}
func (this *Span) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Span)
	if !ok {
		that2, ok := that.(Span)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	return true
}
func (this *Value) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Value)
	if !ok {
		that2, ok := that.(Value)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.RawBytes, that1.RawBytes) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *SplitTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SplitTrigger)
	if !ok {
		that2, ok := that.(SplitTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeftDesc.Equal(&that1.LeftDesc) {
		return false
	}
	if !this.RightDesc.Equal(&that1.RightDesc) {
		return false
	}
	return true
}
func (this *MergeTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*MergeTrigger)
	if !ok {
		that2, ok := that.(MergeTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.LeftDesc.Equal(&that1.LeftDesc) {
		return false
	}
	if !this.RightDesc.Equal(&that1.RightDesc) {
		return false
	}
	if !this.RightMVCCStats.Equal(&that1.RightMVCCStats) {
		return false
	}
	if !this.FreezeStart.Equal(&that1.FreezeStart) {
		return false
	}
	return true
}
func (this *ChangeReplicasTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ChangeReplicasTrigger)
	if !ok {
		that2, ok := that.(ChangeReplicasTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ChangeType != that1.ChangeType {
		return false
	}
	if !this.Replica.Equal(&that1.Replica) {
		return false
	}
	if len(this.UpdatedReplicas) != len(that1.UpdatedReplicas) {
		return false
	}
	for i := range this.UpdatedReplicas {
		if !this.UpdatedReplicas[i].Equal(&that1.UpdatedReplicas[i]) {
			return false
		}
	}
	if this.NextReplicaID != that1.NextReplicaID {
		return false
	}
	return true
}
func (this *ModifiedSpanTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ModifiedSpanTrigger)
	if !ok {
		that2, ok := that.(ModifiedSpanTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.SystemConfigSpan != that1.SystemConfigSpan {
		return false
	}
	if !this.NodeLivenessSpan.Equal(that1.NodeLivenessSpan) {
		return false
	}
	return true
}
func (this *InternalCommitTrigger) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*InternalCommitTrigger)
	if !ok {
		that2, ok := that.(InternalCommitTrigger)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SplitTrigger.Equal(that1.SplitTrigger) {
		return false
	}
	if !this.MergeTrigger.Equal(that1.MergeTrigger) {
		return false
	}
	if !this.ChangeReplicasTrigger.Equal(that1.ChangeReplicasTrigger) {
		return false
	}
	if !this.ModifiedSpanTrigger.Equal(that1.ModifiedSpanTrigger) {
		return false
	}
	return true
}
func (this *ObservedTimestamp) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ObservedTimestamp)
	if !ok {
		that2, ok := that.(ObservedTimestamp)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	return true
}
func (this *Transaction) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Transaction)
	if !ok {
		that2, ok := that.(Transaction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TxnMeta.Equal(&that1.TxnMeta) {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.LastHeartbeat.Equal(&that1.LastHeartbeat) {
		return false
	}
	if !this.OrigTimestamp.Equal(&that1.OrigTimestamp) {
		return false
	}
	if !this.MaxTimestamp.Equal(&that1.MaxTimestamp) {
		return false
	}
	if !this.RefreshedTimestamp.Equal(&that1.RefreshedTimestamp) {
		return false
	}
	if len(this.ObservedTimestamps) != len(that1.ObservedTimestamps) {
		return false
	}
	for i := range this.ObservedTimestamps {
		if !this.ObservedTimestamps[i].Equal(&that1.ObservedTimestamps[i]) {
			return false
		}
	}
	if this.Writing != that1.Writing {
		return false
	}
	if this.WriteTooOld != that1.WriteTooOld {
		return false
	}
	if this.RetryOnPush != that1.RetryOnPush {
		return false
	}
	if len(this.Intents) != len(that1.Intents) {
		return false
	}
	for i := range this.Intents {
		if !this.Intents[i].Equal(&that1.Intents[i]) {
			return false
		}
	}
	if !this.EpochZeroTimestamp.Equal(&that1.EpochZeroTimestamp) {
		return false
	}
	if this.OrigTimestampWasObserved != that1.OrigTimestampWasObserved {
		return false
	}
	return true
}
func (this *Intent) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Intent)
	if !ok {
		that2, ok := that.(Intent)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Span.Equal(&that1.Span) {
		return false
	}
	if !this.Txn.Equal(&that1.Txn) {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	return true
}
func (this *AbortSpanEntry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AbortSpanEntry)
	if !ok {
		that2, ok := that.(AbortSpanEntry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !this.Timestamp.Equal(&that1.Timestamp) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	return true
}
func (m *Span) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Span) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.EndKey) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	return i, nil
}

func (m *Value) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Value) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RawBytes) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n1, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *KeyValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Value.Size()))
	n2, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *StoreIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.ClusterID.Size()))
	n3, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.NodeID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.StoreID))
	}
	return i, nil
}

func (m *SplitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SplitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n4, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n5, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *MergeTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LeftDesc.Size()))
	n6, err := m.LeftDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightDesc.Size()))
	n7, err := m.RightDesc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x22
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RightMVCCStats.Size()))
	n8, err := m.RightMVCCStats.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.FreezeStart.Size()))
	n9, err := m.FreezeStart.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *ChangeReplicasTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ChangeReplicasTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ChangeType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ChangeType))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n10, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if len(m.UpdatedReplicas) > 0 {
		for _, msg := range m.UpdatedReplicas {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.NextReplicaID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NextReplicaID))
	}
	return i, nil
}

func (m *ModifiedSpanTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ModifiedSpanTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SystemConfigSpan {
		dAtA[i] = 0x8
		i++
		if m.SystemConfigSpan {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.NodeLivenessSpan != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeLivenessSpan.Size()))
		n11, err := m.NodeLivenessSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *InternalCommitTrigger) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InternalCommitTrigger) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SplitTrigger != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(m.SplitTrigger.Size()))
		n12, err := m.SplitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.MergeTrigger != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.MergeTrigger.Size()))
		n13, err := m.MergeTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.ChangeReplicasTrigger != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ChangeReplicasTrigger.Size()))
		n14, err := m.ChangeReplicasTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.ModifiedSpanTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ModifiedSpanTrigger.Size()))
		n15, err := m.ModifiedSpanTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *ObservedTimestamp) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ObservedTimestamp) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintData(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n16, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	return i, nil
}

func (m *Transaction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Transaction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.TxnMeta.Size()))
	n17, err := m.TxnMeta.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Status != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Status))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.LastHeartbeat.Size()))
	n18, err := m.LastHeartbeat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x32
	i++
	i = encodeVarintData(dAtA, i, uint64(m.OrigTimestamp.Size()))
	n19, err := m.OrigTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	dAtA[i] = 0x3a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.MaxTimestamp.Size()))
	n20, err := m.MaxTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	if len(m.ObservedTimestamps) > 0 {
		for _, msg := range m.ObservedTimestamps {
			dAtA[i] = 0x42
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Writing {
		dAtA[i] = 0x48
		i++
		if m.Writing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.WriteTooOld {
		dAtA[i] = 0x60
		i++
		if m.WriteTooOld {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RetryOnPush {
		dAtA[i] = 0x68
		i++
		if m.RetryOnPush {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	dAtA[i] = 0x72
	i++
	i = encodeVarintData(dAtA, i, uint64(m.EpochZeroTimestamp.Size()))
	n21, err := m.EpochZeroTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	dAtA[i] = 0x7a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.RefreshedTimestamp.Size()))
	n22, err := m.RefreshedTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	if m.OrigTimestampWasObserved {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		if m.OrigTimestampWasObserved {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *Intent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Intent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Span.Size()))
	n23, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Txn.Size()))
	n24, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	if m.Status != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Status))
	}
	return i, nil
}

func (m *SequencedWrite) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SequencedWrite) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *Lease) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Lease) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Start.Size()))
	n25, err := m.Start.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	if m.Expiration != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Expiration.Size()))
		n26, err := m.Expiration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Replica.Size()))
	n27, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if m.DeprecatedStartStasis != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintData(dAtA, i, uint64(m.DeprecatedStartStasis.Size()))
		n28, err := m.DeprecatedStartStasis.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.ProposedTS != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintData(dAtA, i, uint64(m.ProposedTS.Size()))
		n29, err := m.ProposedTS.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.Epoch != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Epoch))
	}
	if m.Sequence != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Sequence))
	}
	return i, nil
}

func (m *AbortSpanEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AbortSpanEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintData(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Timestamp.Size()))
	n30, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	if m.Priority != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.Priority))
	}
	return i, nil
}

func (m *TxnCoordMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnCoordMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintData(dAtA, i, uint64(m.Txn.Size()))
	n31, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0x12
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.CommandCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintData(dAtA, i, uint64(m.CommandCount))
	}
	if len(m.RefreshReads) > 0 {
		for _, msg := range m.RefreshReads {
			dAtA[i] = 0x22
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RefreshWrites) > 0 {
		for _, msg := range m.RefreshWrites {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DeprecatedRefreshValid {
		dAtA[i] = 0x30
		i++
		if m.DeprecatedRefreshValid {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RefreshInvalid {
		dAtA[i] = 0x38
		i++
		if m.RefreshInvalid {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.OutstandingWrites) > 0 {
		for _, msg := range m.OutstandingWrites {
			dAtA[i] = 0x42
			i++
			i = encodeVarintData(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintData(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedSpan(r randyData, easy bool) *Span {
	this := &Span{}
	v1 := r.Intn(100)
	this.Key = make(Key, v1)
	for i := 0; i < v1; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	v2 := r.Intn(100)
	this.EndKey = make(Key, v2)
	for i := 0; i < v2; i++ {
		this.EndKey[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedObservedTimestamp(r randyData, easy bool) *ObservedTimestamp {
	this := &ObservedTimestamp{}
	this.NodeID = NodeID(r.Int31())
	if r.Intn(2) == 0 {
		this.NodeID *= -1
	}
	v3 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedTransaction(r randyData, easy bool) *Transaction {
	this := &Transaction{}
	v4 := cockroach_storage_engine_enginepb.NewPopulatedTxnMeta(r, easy)
	this.TxnMeta = *v4
	this.Name = string(randStringData(r))
	this.Status = TransactionStatus([]int32{0, 1, 2}[r.Intn(3)])
	v5 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.LastHeartbeat = *v5
	v6 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.OrigTimestamp = *v6
	v7 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.MaxTimestamp = *v7
	if r.Intn(10) != 0 {
		v8 := r.Intn(5)
		this.ObservedTimestamps = make([]ObservedTimestamp, v8)
		for i := 0; i < v8; i++ {
			v9 := NewPopulatedObservedTimestamp(r, easy)
			this.ObservedTimestamps[i] = *v9
		}
	}
	this.Writing = bool(bool(r.Intn(2) == 0))
	if r.Intn(10) != 0 {
		v10 := r.Intn(5)
		this.Intents = make([]Span, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedSpan(r, easy)
			this.Intents[i] = *v11
		}
	}
	this.WriteTooOld = bool(bool(r.Intn(2) == 0))
	this.RetryOnPush = bool(bool(r.Intn(2) == 0))
	v12 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.EpochZeroTimestamp = *v12
	v13 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.RefreshedTimestamp = *v13
	this.OrigTimestampWasObserved = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLease(r randyData, easy bool) *Lease {
	this := &Lease{}
	v14 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Start = *v14
	if r.Intn(10) != 0 {
		this.Expiration = cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	}
	v15 := NewPopulatedReplicaDescriptor(r, easy)
	this.Replica = *v15
	if r.Intn(10) != 0 {
		this.DeprecatedStartStasis = cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ProposedTS = cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	}
	this.Epoch = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Epoch *= -1
	}
	this.Sequence = LeaseSequence(r.Int63())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedAbortSpanEntry(r randyData, easy bool) *AbortSpanEntry {
	this := &AbortSpanEntry{}
	v16 := r.Intn(100)
	this.Key = make(Key, v16)
	for i := 0; i < v16; i++ {
		this.Key[i] = byte(r.Intn(256))
	}
	v17 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v17
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyData interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneData(r randyData) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringData(r randyData) string {
	v18 := r.Intn(100)
	tmps := make([]rune, v18)
	for i := 0; i < v18; i++ {
		tmps[i] = randUTF8RuneData(r)
	}
	return string(tmps)
}
func randUnrecognizedData(r randyData, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldData(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldData(dAtA []byte, r randyData, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		v19 := r.Int63()
		if r.Intn(2) == 0 {
			v19 *= -1
		}
		dAtA = encodeVarintPopulateData(dAtA, uint64(v19))
	case 1:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateData(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateData(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateData(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Span) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = len(m.EndKey)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *Value) Size() (n int) {
	var l int
	_ = l
	l = len(m.RawBytes)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *KeyValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Value.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *StoreIdent) Size() (n int) {
	var l int
	_ = l
	l = m.ClusterID.Size()
	n += 1 + l + sovData(uint64(l))
	if m.NodeID != 0 {
		n += 1 + sovData(uint64(m.NodeID))
	}
	if m.StoreID != 0 {
		n += 1 + sovData(uint64(m.StoreID))
	}
	return n
}

func (m *SplitTrigger) Size() (n int) {
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *MergeTrigger) Size() (n int) {
	var l int
	_ = l
	l = m.LeftDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightDesc.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RightMVCCStats.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.FreezeStart.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *ChangeReplicasTrigger) Size() (n int) {
	var l int
	_ = l
	if m.ChangeType != 0 {
		n += 1 + sovData(uint64(m.ChangeType))
	}
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.UpdatedReplicas) > 0 {
		for _, e := range m.UpdatedReplicas {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.NextReplicaID != 0 {
		n += 1 + sovData(uint64(m.NextReplicaID))
	}
	return n
}

func (m *ModifiedSpanTrigger) Size() (n int) {
	var l int
	_ = l
	if m.SystemConfigSpan {
		n += 2
	}
	if m.NodeLivenessSpan != nil {
		l = m.NodeLivenessSpan.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *InternalCommitTrigger) Size() (n int) {
	var l int
	_ = l
	if m.SplitTrigger != nil {
		l = m.SplitTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.MergeTrigger != nil {
		l = m.MergeTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ChangeReplicasTrigger != nil {
		l = m.ChangeReplicasTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ModifiedSpanTrigger != nil {
		l = m.ModifiedSpanTrigger.Size()
		n += 1 + l + sovData(uint64(l))
	}
	return n
}

func (m *ObservedTimestamp) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovData(uint64(m.NodeID))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	return n
}

func (m *Transaction) Size() (n int) {
	var l int
	_ = l
	l = m.TxnMeta.Size()
	n += 1 + l + sovData(uint64(l))
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovData(uint64(m.Status))
	}
	l = m.LastHeartbeat.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.OrigTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.MaxTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.ObservedTimestamps) > 0 {
		for _, e := range m.ObservedTimestamps {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.Writing {
		n += 2
	}
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.WriteTooOld {
		n += 2
	}
	if m.RetryOnPush {
		n += 2
	}
	l = m.EpochZeroTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.RefreshedTimestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if m.OrigTimestampWasObserved {
		n += 3
	}
	return n
}

func (m *Intent) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovData(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Status != 0 {
		n += 1 + sovData(uint64(m.Status))
	}
	return n
}

func (m *SequencedWrite) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovData(uint64(m.Sequence))
	}
	return n
}

func (m *Lease) Size() (n int) {
	var l int
	_ = l
	l = m.Start.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Expiration != nil {
		l = m.Expiration.Size()
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Replica.Size()
	n += 1 + l + sovData(uint64(l))
	if m.DeprecatedStartStasis != nil {
		l = m.DeprecatedStartStasis.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.ProposedTS != nil {
		l = m.ProposedTS.Size()
		n += 1 + l + sovData(uint64(l))
	}
	if m.Epoch != 0 {
		n += 1 + sovData(uint64(m.Epoch))
	}
	if m.Sequence != 0 {
		n += 1 + sovData(uint64(m.Sequence))
	}
	return n
}

func (m *AbortSpanEntry) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovData(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovData(uint64(l))
	if m.Priority != 0 {
		n += 1 + sovData(uint64(m.Priority))
	}
	return n
}

func (m *TxnCoordMeta) Size() (n int) {
	var l int
	_ = l
	l = m.Txn.Size()
	n += 1 + l + sovData(uint64(l))
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.CommandCount != 0 {
		n += 1 + sovData(uint64(m.CommandCount))
	}
	if len(m.RefreshReads) > 0 {
		for _, e := range m.RefreshReads {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if len(m.RefreshWrites) > 0 {
		for _, e := range m.RefreshWrites {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	if m.DeprecatedRefreshValid {
		n += 2
	}
	if m.RefreshInvalid {
		n += 2
	}
	if len(m.OutstandingWrites) > 0 {
		for _, e := range m.OutstandingWrites {
			l = e.Size()
			n += 1 + l + sovData(uint64(l))
		}
	}
	return n
}

func sovData(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozData(x uint64) (n int) {
	return sovData(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Span) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Span: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Span: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Value) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Value: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Value: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SplitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SplitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SplitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightDesc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightDesc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightMVCCStats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightMVCCStats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FreezeStart", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FreezeStart.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ChangeReplicasTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ChangeReplicasTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UpdatedReplicas = append(m.UpdatedReplicas, ReplicaDescriptor{})
			if err := m.UpdatedReplicas[len(m.UpdatedReplicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextReplicaID", wireType)
			}
			m.NextReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ModifiedSpanTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ModifiedSpanTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SystemConfigSpan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SystemConfigSpan = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeLivenessSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeLivenessSpan == nil {
				m.NodeLivenessSpan = &Span{}
			}
			if err := m.NodeLivenessSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InternalCommitTrigger) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalCommitTrigger: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalCommitTrigger: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SplitTrigger == nil {
				m.SplitTrigger = &SplitTrigger{}
			}
			if err := m.SplitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTrigger == nil {
				m.MergeTrigger = &MergeTrigger{}
			}
			if err := m.MergeTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeReplicasTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ChangeReplicasTrigger == nil {
				m.ChangeReplicasTrigger = &ChangeReplicasTrigger{}
			}
			if err := m.ChangeReplicasTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModifiedSpanTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ModifiedSpanTrigger == nil {
				m.ModifiedSpanTrigger = &ModifiedSpanTrigger{}
			}
			if err := m.ModifiedSpanTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ObservedTimestamp) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ObservedTimestamp: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ObservedTimestamp: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Transaction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Transaction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Transaction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastHeartbeat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LastHeartbeat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OrigTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MaxTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObservedTimestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ObservedTimestamps = append(m.ObservedTimestamps, ObservedTimestamp{})
			if err := m.ObservedTimestamps[len(m.ObservedTimestamps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Writing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Writing = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteTooOld", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WriteTooOld = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryOnPush", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RetryOnPush = bool(v != 0)
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EpochZeroTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EpochZeroTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshedTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RefreshedTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigTimestampWasObserved", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OrigTimestampWasObserved = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Intent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Intent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Intent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SequencedWrite) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SequencedWrite: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SequencedWrite: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Lease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Lease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Lease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Start.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expiration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Expiration == nil {
				m.Expiration = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.Expiration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedStartStasis", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedStartStasis == nil {
				m.DeprecatedStartStasis = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.DeprecatedStartStasis.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProposedTS", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProposedTS == nil {
				m.ProposedTS = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.ProposedTS.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (LeaseSequence(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AbortSpanEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AbortSpanEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AbortSpanEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TxnCoordMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowData
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnCoordMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnCoordMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Span{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommandCount", wireType)
			}
			m.CommandCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CommandCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshReads", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RefreshReads = append(m.RefreshReads, Span{})
			if err := m.RefreshReads[len(m.RefreshReads)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshWrites", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RefreshWrites = append(m.RefreshWrites, Span{})
			if err := m.RefreshWrites[len(m.RefreshWrites)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedRefreshValid", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DeprecatedRefreshValid = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshInvalid", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RefreshInvalid = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutstandingWrites", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowData
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthData
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutstandingWrites = append(m.OutstandingWrites, SequencedWrite{})
			if err := m.OutstandingWrites[len(m.OutstandingWrites)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipData(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthData
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipData(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowData
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowData
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthData
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowData
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipData(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthData = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowData   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("roachpb/data.proto", fileDescriptorData) }

var fileDescriptorData = []byte{
	// 1891 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcd, 0x6f, 0xdb, 0xc8,
	0x15, 0x37, 0xf5, 0x61, 0x49, 0x4f, 0x1f, 0xa6, 0xc7, 0x71, 0xa2, 0x7a, 0x51, 0x29, 0xab, 0x2d,
	0xda, 0x20, 0xd8, 0x95, 0xd1, 0xa4, 0x9f, 0x46, 0x5b, 0xc0, 0xfa, 0x48, 0xc2, 0xc4, 0x92, 0x0d,
	0x8a, 0x76, 0xd0, 0x2c, 0x16, 0x2c, 0x4d, 0x8e, 0x25, 0x22, 0x12, 0xc9, 0xce, 0x8c, 0x1c, 0x6b,
	0xff, 0x82, 0xbd, 0x75, 0x0f, 0x3d, 0xf4, 0x18, 0xa0, 0xa7, 0xf6, 0x2f, 0xe8, 0x7f, 0xd0, 0x5c,
	0x0a, 0xec, 0xad, 0x45, 0x0f, 0x42, 0xab, 0x5e, 0x5a, 0xf4, 0xd6, 0x63, 0x80, 0x05, 0x8a, 0x99,
	0x21, 0x25, 0xba, 0x56, 0x0c, 0xb9, 0xdb, 0x43, 0x2f, 0xf6, 0xcc, 0x9b, 0xf7, 0x7e, 0xf3, 0xe6,
	0x7d, 0xfc, 0x66, 0x28, 0x40, 0xc4, 0xb7, 0xec, 0x41, 0x70, 0xba, 0xeb, 0x58, 0xcc, 0xaa, 0x07,
	0xc4, 0x67, 0x3e, 0xda, 0xb4, 0x7d, 0xfb, 0xa5, 0x90, 0xd7, 0xc3, 0xd5, 0x9d, 0xdb, 0x91, 0xda,
	0x08, 0x33, 0x6b, 0xa1, 0xba, 0x53, 0xa3, 0xcc, 0x27, 0x56, 0x1f, 0xef, 0x62, 0xaf, 0xef, 0x7a,
	0xd1, 0x3f, 0xae, 0x77, 0x6e, 0xdb, 0xa1, 0xce, 0x07, 0xd7, 0xe9, 0x3c, 0x0c, 0x95, 0xca, 0x63,
	0xe6, 0x0e, 0x77, 0x07, 0x43, 0x7b, 0x97, 0xb9, 0x23, 0x4c, 0x99, 0x35, 0x0a, 0xc2, 0x95, 0x5b,
	0x7d, 0xbf, 0xef, 0x8b, 0xe1, 0x2e, 0x1f, 0x49, 0x69, 0xed, 0x13, 0x48, 0xf5, 0x02, 0xcb, 0x43,
	0x5f, 0x83, 0xe4, 0x4b, 0x3c, 0x29, 0x27, 0xef, 0x2a, 0xf7, 0x0a, 0x8d, 0xcc, 0xdb, 0x69, 0x35,
	0xf9, 0x0c, 0x4f, 0x74, 0x2e, 0x43, 0x77, 0x21, 0x83, 0x3d, 0xc7, 0xe4, 0xcb, 0xa9, 0xcb, 0xcb,
	0xeb, 0xd8, 0x73, 0x9e, 0xe1, 0xc9, 0x5e, 0xe1, 0x57, 0xaf, 0xab, 0x6b, 0xbf, 0x7b, 0x5d, 0x55,
	0xfe, 0xfe, 0xba, 0xaa, 0x3c, 0x4d, 0x65, 0x15, 0x35, 0xf1, 0x34, 0x95, 0x4d, 0xa8, 0xc9, 0xda,
	0x08, 0xd2, 0x27, 0xd6, 0x70, 0x8c, 0xd1, 0x7b, 0x90, 0x23, 0xd6, 0x2b, 0xf3, 0x74, 0xc2, 0x30,
	0x2d, 0x2b, 0x1c, 0x46, 0xcf, 0x12, 0xeb, 0x55, 0x83, 0xcf, 0xd1, 0x3e, 0xe4, 0xe6, 0xde, 0x96,
	0x13, 0x77, 0x95, 0x7b, 0xf9, 0x07, 0x5f, 0xaf, 0x2f, 0x82, 0xc7, 0x8f, 0x54, 0x1f, 0x0c, 0xed,
	0xba, 0x11, 0x29, 0x35, 0x52, 0x6f, 0xa6, 0xd5, 0x35, 0x7d, 0x61, 0xb5, 0x97, 0xe2, 0x5b, 0xd7,
	0x3e, 0x86, 0xec, 0x33, 0x3c, 0x91, 0x3b, 0x86, 0x27, 0x52, 0x96, 0x9c, 0xe8, 0x3b, 0x90, 0x3e,
	0xe7, 0x3a, 0xe1, 0x5e, 0xe5, 0xfa, 0x95, 0x44, 0xd5, 0x05, 0x46, 0xb8, 0x8d, 0x54, 0xae, 0xfd,
	0x51, 0x01, 0xe8, 0x31, 0x9f, 0x60, 0xcd, 0xc1, 0x1e, 0x43, 0x7d, 0x00, 0x7b, 0x38, 0xa6, 0x0c,
	0x13, 0xd3, 0x75, 0xc2, 0x6d, 0x9e, 0x70, 0xfd, 0x3f, 0x4f, 0xab, 0x0f, 0xfb, 0x2e, 0x1b, 0x8c,
	0x4f, 0xeb, 0xb6, 0x3f, 0xda, 0x9d, 0x63, 0x3b, 0xa7, 0x8b, 0xf1, 0x6e, 0xf0, 0xb2, 0xbf, 0x2b,
	0x52, 0x35, 0x1e, 0xbb, 0x4e, 0xfd, 0xf8, 0x58, 0x6b, 0xcd, 0xa6, 0xd5, 0x5c, 0x53, 0x02, 0x6a,
	0x2d, 0x3d, 0x17, 0x62, 0x6b, 0x0e, 0xfa, 0x08, 0x32, 0x9e, 0xef, 0x60, 0xbe, 0x0b, 0xf7, 0x37,
	0xdd, 0xb8, 0x35, 0x9b, 0x56, 0xd7, 0xbb, 0xbe, 0x83, 0xb5, 0xd6, 0xdb, 0xf9, 0x48, 0x5f, 0xe7,
	0x4a, 0x9a, 0x83, 0xbe, 0x0d, 0x59, 0x5e, 0x28, 0x42, 0x3f, 0x29, 0xf4, 0x6f, 0xcf, 0xa6, 0xd5,
	0x8c, 0xf4, 0x9c, 0x1b, 0x44, 0x43, 0x3d, 0x43, 0xe5, 0x69, 0x6a, 0xbf, 0x55, 0xa0, 0xd0, 0x0b,
	0x86, 0x2e, 0x33, 0x88, 0xdb, 0xef, 0x63, 0x82, 0xda, 0x90, 0x1b, 0xe2, 0x33, 0x66, 0x3a, 0x98,
	0xda, 0xe2, 0x68, 0xf9, 0x07, 0xb5, 0x25, 0x41, 0xd2, 0x2d, 0xaf, 0x8f, 0x5b, 0x98, 0xda, 0xc4,
	0x0d, 0x98, 0x4f, 0xc2, 0x70, 0x65, 0xb9, 0x29, 0x97, 0xa2, 0xc7, 0x00, 0xc4, 0xed, 0x0f, 0x42,
	0x9c, 0xc4, 0x0d, 0x71, 0x72, 0xc2, 0x96, 0x8b, 0x65, 0x76, 0x9f, 0xa6, 0xb2, 0x49, 0x35, 0x55,
	0x9b, 0x25, 0xa0, 0xd0, 0xc1, 0xa4, 0x8f, 0xff, 0x4f, 0x9d, 0x45, 0x1e, 0xa8, 0x12, 0x88, 0xf7,
	0xa5, 0x49, 0x99, 0xc5, 0xa8, 0x68, 0x9c, 0xfc, 0x83, 0x0f, 0x63, 0x70, 0x61, 0x33, 0xd7, 0x65,
	0x17, 0xd7, 0xa3, 0x66, 0xae, 0x77, 0x4e, 0x9a, 0xcd, 0x1e, 0xb7, 0x69, 0xdc, 0xe6, 0xc0, 0xb3,
	0x69, 0xb5, 0xa4, 0x73, 0xb4, 0xb9, 0x5c, 0x2f, 0x09, 0xf4, 0xce, 0xb9, 0x6d, 0x8b, 0x39, 0x7a,
	0x04, 0x85, 0x33, 0x82, 0xf1, 0xa7, 0x98, 0xef, 0x45, 0x58, 0x39, 0xbd, 0x7a, 0x03, 0xe5, 0xa5,
	0x61, 0x8f, 0xdb, 0x5d, 0x0a, 0xf2, 0x1f, 0x12, 0xb0, 0xdd, 0x1c, 0xf0, 0x93, 0xea, 0x38, 0x18,
	0xba, 0xb6, 0x45, 0x17, 0xd1, 0xce, 0xdb, 0x62, 0xc1, 0x64, 0x93, 0x00, 0x8b, 0x78, 0x97, 0x1e,
	0x7c, 0x63, 0x59, 0x9c, 0xa4, 0xa1, 0x44, 0x31, 0x26, 0x01, 0xd6, 0xc1, 0x9e, 0x8f, 0x51, 0x0b,
	0x32, 0x44, 0x2a, 0x84, 0xa1, 0xbe, 0x06, 0xe2, 0x4a, 0xb0, 0x23, 0x53, 0x74, 0x0c, 0xea, 0x38,
	0x70, 0x2c, 0x86, 0x1d, 0x33, 0x14, 0xd1, 0x72, 0xf2, 0x6e, 0xf2, 0x86, 0x70, 0x1b, 0x21, 0x46,
	0x74, 0x54, 0xf4, 0x08, 0x36, 0x3c, 0x7c, 0xc1, 0x22, 0x4c, 0xde, 0x49, 0x29, 0xd1, 0x49, 0x95,
	0xd9, 0xb4, 0x5a, 0xec, 0xe2, 0x0b, 0x16, 0xaa, 0x8a, 0x7e, 0xca, 0xcd, 0x27, 0x7a, 0xd1, 0x8b,
	0xad, 0x39, 0x7b, 0x59, 0xce, 0x8b, 0x82, 0x98, 0x3e, 0x57, 0x60, 0xab, 0xe3, 0x3b, 0xee, 0x99,
	0x8b, 0x1d, 0xce, 0xb7, 0x51, 0x34, 0x3f, 0x04, 0x44, 0x27, 0x94, 0xe1, 0x91, 0x69, 0xfb, 0xde,
	0x99, 0xdb, 0x37, 0x69, 0x60, 0x79, 0x22, 0xa8, 0x59, 0x5d, 0x95, 0x2b, 0x4d, 0xb1, 0x20, 0x48,
	0xba, 0x0d, 0x48, 0x30, 0xc1, 0xd0, 0x3d, 0xc7, 0x1e, 0xa6, 0x54, 0x6a, 0xcb, 0xf8, 0xdd, 0x59,
	0x72, 0x60, 0x6e, 0xa4, 0xab, 0xdc, 0xe4, 0x20, 0xb4, 0xe0, 0x92, 0x90, 0x2b, 0xff, 0x99, 0x80,
	0x6d, 0xcd, 0x63, 0x98, 0x78, 0xd6, 0xb0, 0xe9, 0x8f, 0x46, 0x8b, 0xee, 0x6f, 0x41, 0x91, 0x72,
	0x36, 0x30, 0x99, 0x14, 0x84, 0x4d, 0x55, 0x5d, 0xba, 0xc3, 0x82, 0x35, 0xf4, 0x02, 0x8d, 0x73,
	0x48, 0x0b, 0x8a, 0x23, 0xde, 0xa6, 0x73, 0x94, 0xc4, 0x3b, 0x51, 0xe2, 0xed, 0xac, 0x17, 0x46,
	0xf1, 0xe6, 0xfe, 0x19, 0xdc, 0x09, 0xcb, 0x2d, 0x4a, 0xf0, 0x1c, 0x2f, 0x29, 0xf0, 0xee, 0x2d,
	0xc1, 0x5b, 0x5a, 0xb9, 0xfa, 0xb6, 0xbd, 0xb4, 0xa0, 0x5f, 0xc0, 0xf6, 0x28, 0xcc, 0x8c, 0x88,
	0xe7, 0x1c, 0x5f, 0xf6, 0xec, 0x37, 0x97, 0xf9, 0x7b, 0x35, 0x93, 0xfa, 0xd6, 0xe8, 0xaa, 0x70,
	0x2f, 0xfb, 0x59, 0x78, 0x29, 0xd6, 0x7e, 0xa1, 0xc0, 0xe6, 0xe1, 0x29, 0xc5, 0xe4, 0x1c, 0x3b,
	0xf3, 0x2e, 0x8c, 0x53, 0xbb, 0xb2, 0x02, 0xb5, 0xff, 0x0f, 0xee, 0xc9, 0x6c, 0x74, 0x4d, 0xd7,
	0xbe, 0x5c, 0x87, 0xbc, 0x41, 0x2c, 0x8f, 0x5a, 0x36, 0x73, 0x7d, 0x0f, 0x3d, 0x81, 0x14, 0x7f,
	0x94, 0x84, 0xc9, 0xbe, 0xbf, 0x02, 0x55, 0x19, 0x17, 0x5e, 0x07, 0x33, 0xab, 0x91, 0xe5, 0x9b,
	0x7c, 0x31, 0xad, 0x2a, 0xba, 0x40, 0x40, 0x08, 0x52, 0x9e, 0x35, 0x92, 0xb7, 0x6b, 0x4e, 0x17,
	0x63, 0xf4, 0x23, 0x58, 0xe7, 0x4c, 0x38, 0x96, 0x54, 0xb8, 0x9c, 0x31, 0x62, 0xde, 0xf4, 0x84,
	0xae, 0x1e, 0xda, 0xa0, 0xa7, 0x50, 0x1a, 0x5a, 0x94, 0x99, 0x03, 0x6c, 0x11, 0x76, 0x8a, 0xad,
	0x1b, 0x91, 0x5c, 0x91, 0x9b, 0x3e, 0x89, 0x2c, 0x39, 0x96, 0x4f, 0xdc, 0xbe, 0xb9, 0x88, 0xe4,
	0xfa, 0x0d, 0xb0, 0xb8, 0xe9, 0x22, 0x7f, 0x4f, 0xa0, 0x38, 0xb2, 0x2e, 0x62, 0x50, 0x99, 0xd5,
	0xa1, 0x0a, 0x23, 0xeb, 0x62, 0x81, 0xf4, 0x31, 0x6c, 0xf9, 0x61, 0x79, 0x2c, 0xe0, 0x68, 0x39,
	0xfb, 0x4e, 0x32, 0xbb, 0x52, 0x4c, 0x21, 0x2c, 0xf2, 0xff, 0x73, 0x81, 0xa2, 0x32, 0x64, 0x5e,
	0x11, 0x97, 0xb9, 0x5e, 0xbf, 0x9c, 0x13, 0xd4, 0x12, 0x4d, 0xd1, 0xf7, 0x21, 0xe3, 0x7a, 0x0c,
	0x7b, 0x8c, 0x96, 0xf3, 0x62, 0xab, 0x77, 0xd1, 0x48, 0xc4, 0xbc, 0xa1, 0x36, 0xaa, 0x41, 0x91,
	0x63, 0x60, 0x93, 0xf9, 0xbe, 0xe9, 0x0f, 0x9d, 0x72, 0x41, 0x00, 0xe7, 0x85, 0xd0, 0xf0, 0xfd,
	0xc3, 0xa1, 0xc3, 0x75, 0x08, 0x66, 0x64, 0x62, 0xfa, 0x9e, 0x19, 0x8c, 0xe9, 0xa0, 0x5c, 0x94,
	0x3a, 0x42, 0x78, 0xe8, 0x1d, 0x8d, 0xe9, 0x00, 0x1d, 0xc3, 0x2d, 0x1c, 0xf8, 0xf6, 0xc0, 0xfc,
	0x14, 0x13, 0x3f, 0x16, 0xc8, 0xd2, 0xea, 0x81, 0x44, 0x02, 0xe0, 0x05, 0x26, 0xfe, 0x22, 0x9c,
	0x06, 0x6c, 0x11, 0x7c, 0x46, 0x30, 0x1d, 0xc4, 0xe3, 0x59, 0xde, 0xb8, 0x01, 0xea, 0xdc, 0x7e,
	0x81, 0xfa, 0x63, 0x78, 0xef, 0x72, 0xe9, 0x98, 0xaf, 0x2c, 0x6a, 0x46, 0x01, 0x2f, 0xab, 0xe2,
	0x78, 0xe5, 0x4b, 0x25, 0xf2, 0xdc, 0xa2, 0x51, 0xa6, 0x2e, 0x3f, 0x93, 0x6b, 0xbf, 0x57, 0x60,
	0x5d, 0x13, 0xd1, 0x44, 0xdf, 0x85, 0xd4, 0x9c, 0xf7, 0xaf, 0x49, 0x41, 0xac, 0xcf, 0xb8, 0x3a,
	0x6a, 0x40, 0x92, 0x5d, 0x44, 0xfc, 0x7f, 0x93, 0x86, 0x95, 0x27, 0xe4, 0xc6, 0xb1, 0xbe, 0x4c,
	0xde, 0xbc, 0x2f, 0xc3, 0x9b, 0xe4, 0x31, 0x94, 0x7a, 0xf8, 0xe7, 0x63, 0xec, 0xd9, 0xd8, 0x79,
	0xce, 0xf3, 0x7f, 0xdd, 0xdb, 0x7b, 0x07, 0xb2, 0x34, 0x54, 0x96, 0xcf, 0x59, 0x7d, 0x3e, 0xaf,
	0x7d, 0x99, 0x84, 0xf4, 0x01, 0xb6, 0x28, 0x46, 0x3f, 0x84, 0xb4, 0x7c, 0xcc, 0x28, 0xab, 0x67,
	0x4c, 0x5a, 0xa0, 0x4f, 0x00, 0xf0, 0x45, 0xe0, 0x12, 0x8b, 0xfb, 0xbb, 0x1a, 0x4b, 0x56, 0xfe,
	0x35, 0xad, 0xee, 0xc4, 0xde, 0xe9, 0x7b, 0x35, 0x62, 0x79, 0x8e, 0x37, 0x1e, 0x0e, 0xad, 0xd3,
	0x21, 0xae, 0xe9, 0x31, 0xc0, 0xf8, 0xc3, 0x25, 0xf9, 0xdf, 0x3f, 0x5c, 0xc6, 0x70, 0xc7, 0xc1,
	0x01, 0xc1, 0xb6, 0x78, 0xbb, 0x08, 0xc7, 0xf9, 0x5f, 0xea, 0x46, 0x4f, 0xc5, 0xaf, 0xe8, 0xf1,
	0xf6, 0x02, 0x5d, 0x3c, 0xee, 0x7a, 0x02, 0x1b, 0x75, 0x21, 0x1f, 0x10, 0x3f, 0xf0, 0x29, 0xef,
	0x0a, 0xba, 0x1a, 0x89, 0x96, 0x66, 0xd3, 0x2a, 0x1c, 0x85, 0x56, 0x46, 0x4f, 0x87, 0x08, 0xc1,
	0xa0, 0xe8, 0x16, 0xa4, 0x45, 0xf3, 0x09, 0x0a, 0x4d, 0xea, 0x72, 0x82, 0x3e, 0x8a, 0xa5, 0x98,
	0x13, 0x62, 0xb2, 0xb1, 0xf9, 0x76, 0x5a, 0x2d, 0x8a, 0xcc, 0x46, 0x85, 0xb2, 0xc8, 0xba, 0x7c,
	0x25, 0xf1, 0xb6, 0xa8, 0xfd, 0x52, 0x81, 0xd2, 0xfe, 0xa9, 0x4f, 0x18, 0x2f, 0xf7, 0xb6, 0xc7,
	0xc8, 0xe4, 0xba, 0x4a, 0xfa, 0xea, 0xb7, 0x21, 0x2f, 0xc6, 0x80, 0xb8, 0x3e, 0x71, 0x99, 0xfc,
	0xf4, 0x4d, 0xeb, 0xf3, 0x79, 0xec, 0xa6, 0xfc, 0x47, 0x12, 0x0a, 0xc6, 0x85, 0xd7, 0xf4, 0x7d,
	0xe2, 0xf0, 0xfe, 0x41, 0xdf, 0x93, 0x8d, 0x27, 0x6b, 0xb3, 0x72, 0x7d, 0xc7, 0xc4, 0x9b, 0x2d,
	0xc6, 0xb6, 0x89, 0x1b, 0xb1, 0xed, 0x07, 0x50, 0xb4, 0xfd, 0xd1, 0xc8, 0xf2, 0x1c, 0xd3, 0xf6,
	0xc7, 0x1e, 0x0b, 0x9d, 0x2d, 0x84, 0xc2, 0x26, 0x97, 0xa1, 0x06, 0xa7, 0x5b, 0xc1, 0x59, 0x26,
	0xc1, 0x96, 0xc3, 0x2b, 0x69, 0x85, 0x3d, 0x0a, 0xa1, 0x8d, 0xce, 0x4d, 0x50, 0x0b, 0x4a, 0x11,
	0x86, 0x60, 0x72, 0x5e, 0x23, 0x2b, 0x80, 0x44, 0x1b, 0x8b, 0xee, 0xa7, 0xe8, 0x07, 0x50, 0x8e,
	0x55, 0x77, 0x04, 0x78, 0x6e, 0x0d, 0x5d, 0x47, 0x54, 0x4a, 0x56, 0xbf, 0xbd, 0x58, 0xd7, 0xe5,
	0xf2, 0x09, 0x5f, 0x45, 0xdf, 0x82, 0x8d, 0x48, 0xdd, 0xf5, 0xa4, 0x41, 0x46, 0x18, 0x44, 0x6e,
	0x69, 0x52, 0x8a, 0x4e, 0x00, 0xf9, 0x63, 0x46, 0x99, 0xe5, 0x39, 0xae, 0xd7, 0x8f, 0x9c, 0x95,
	0xd7, 0xe5, 0xfb, 0xcb, 0x9c, 0xbd, 0x44, 0x50, 0xa1, 0xdb, 0x9b, 0x31, 0x08, 0xe9, 0xfa, 0xfd,
	0xdf, 0x28, 0x90, 0x13, 0xdf, 0xfe, 0xe2, 0x2b, 0x25, 0x0f, 0x99, 0xe3, 0xee, 0xb3, 0xee, 0xe1,
	0xf3, 0xae, 0xba, 0x86, 0x32, 0x90, 0xd4, 0xba, 0x86, 0xaa, 0xa0, 0x1c, 0xa4, 0x1f, 0x1d, 0x1c,
	0xee, 0x1b, 0x6a, 0x82, 0x0f, 0x1b, 0x3f, 0x35, 0xda, 0x3d, 0x35, 0x89, 0xb6, 0x60, 0xa3, 0xd5,
	0x3e, 0xd0, 0x3a, 0x9a, 0xd1, 0x6e, 0x99, 0x52, 0x98, 0x45, 0x59, 0x48, 0x19, 0x5a, 0xa7, 0xad,
	0xa6, 0x38, 0x54, 0xab, 0xdd, 0xd4, 0x3a, 0xfb, 0x07, 0x6a, 0x1a, 0x6d, 0xc3, 0xe6, 0x42, 0x37,
	0x12, 0xe7, 0x50, 0x01, 0xb2, 0xad, 0x63, 0x7d, 0xdf, 0xd0, 0x0e, 0xbb, 0xea, 0x3a, 0xc7, 0x36,
	0x8e, 0x8f, 0x0e, 0xda, 0x2a, 0xa0, 0x12, 0x00, 0x87, 0xe9, 0xb5, 0x75, 0xad, 0xdd, 0x53, 0x9d,
	0x5a, 0x2a, 0x9b, 0x51, 0x33, 0xf7, 0x7f, 0x02, 0x9b, 0x57, 0x3e, 0xb2, 0xd0, 0x06, 0xe4, 0xf7,
	0x5b, 0x2d, 0x53, 0x6f, 0x1f, 0x1d, 0x68, 0xcd, 0x7d, 0x75, 0x0d, 0x21, 0x28, 0xe9, 0xed, 0xce,
	0xe1, 0x49, 0x7b, 0x2e, 0x53, 0x76, 0x52, 0x9f, 0xfd, 0xba, 0xb2, 0x76, 0xbf, 0x01, 0x9b, 0x57,
	0xa8, 0x9d, 0xfb, 0x79, 0xd4, 0xee, 0xb6, 0xb4, 0xee, 0x63, 0x75, 0x0d, 0x15, 0x21, 0xd7, 0x3c,
	0xec, 0x74, 0x34, 0xc3, 0x68, 0xb7, 0x54, 0x85, 0xaf, 0xed, 0x37, 0x0e, 0x75, 0x3e, 0x49, 0x48,
	0x8c, 0xc6, 0xfb, 0x6f, 0xfe, 0x5a, 0x59, 0x7b, 0x33, 0xab, 0x28, 0x5f, 0xcc, 0x2a, 0xca, 0x9f,
	0x66, 0x15, 0xe5, 0x2f, 0xb3, 0x8a, 0xf2, 0xf9, 0xdf, 0x2a, 0x6b, 0x2f, 0x32, 0x61, 0xe8, 0x4f,
	0xd7, 0xc5, 0x2f, 0x4d, 0x0f, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xa4, 0xe7, 0x23, 0xdb, 0x23,
	0x13, 0x00, 0x00,
}
