// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: storage/raft.proto

package storage

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb3 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_storage_storagebase "github.com/cockroachdb/cockroach/pkg/storage/storagebase"
import raftpb "go.etcd.io/etcd/raft/raftpb"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import context "context"
import grpc "google.golang.org/grpc"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type SnapshotRequest_Priority int32

const (
	SnapshotRequest_UNKNOWN SnapshotRequest_Priority = 0
	// RECOVERY is used for a Raft-initiated snapshots and for
	// up-replication snapshots (i.e. when a dead node has been
	// removed and the range needs to be up-replicated).
	SnapshotRequest_RECOVERY SnapshotRequest_Priority = 1
	// REBALANCE is used for snapshots involved in rebalancing.
	SnapshotRequest_REBALANCE SnapshotRequest_Priority = 2
)

var SnapshotRequest_Priority_name = map[int32]string{
	0: "UNKNOWN",
	1: "RECOVERY",
	2: "REBALANCE",
}
var SnapshotRequest_Priority_value = map[string]int32{
	"UNKNOWN":   0,
	"RECOVERY":  1,
	"REBALANCE": 2,
}

func (x SnapshotRequest_Priority) Enum() *SnapshotRequest_Priority {
	p := new(SnapshotRequest_Priority)
	*p = x
	return p
}
func (x SnapshotRequest_Priority) String() string {
	return proto.EnumName(SnapshotRequest_Priority_name, int32(x))
}
func (x *SnapshotRequest_Priority) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SnapshotRequest_Priority_value, data, "SnapshotRequest_Priority")
	if err != nil {
		return err
	}
	*x = SnapshotRequest_Priority(value)
	return nil
}
func (SnapshotRequest_Priority) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRaft, []int{5, 0}
}

type SnapshotRequest_Strategy int32

const (
	// KV_BATCH snapshots stream batches of KV pairs for all keys in a
	// range from the sender the the receiver. These KV pairs are then
	// combined into a large RocksDB WriteBatch that is atomically
	// applied.
	SnapshotRequest_KV_BATCH SnapshotRequest_Strategy = 0
)

var SnapshotRequest_Strategy_name = map[int32]string{
	0: "KV_BATCH",
}
var SnapshotRequest_Strategy_value = map[string]int32{
	"KV_BATCH": 0,
}

func (x SnapshotRequest_Strategy) Enum() *SnapshotRequest_Strategy {
	p := new(SnapshotRequest_Strategy)
	*p = x
	return p
}
func (x SnapshotRequest_Strategy) String() string {
	return proto.EnumName(SnapshotRequest_Strategy_name, int32(x))
}
func (x *SnapshotRequest_Strategy) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SnapshotRequest_Strategy_value, data, "SnapshotRequest_Strategy")
	if err != nil {
		return err
	}
	*x = SnapshotRequest_Strategy(value)
	return nil
}
func (SnapshotRequest_Strategy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRaft, []int{5, 1}
}

type SnapshotResponse_Status int32

const (
	SnapshotResponse_UNKNOWN  SnapshotResponse_Status = 0
	SnapshotResponse_ACCEPTED SnapshotResponse_Status = 1
	SnapshotResponse_APPLIED  SnapshotResponse_Status = 2
	SnapshotResponse_ERROR    SnapshotResponse_Status = 3
	SnapshotResponse_DECLINED SnapshotResponse_Status = 4
)

var SnapshotResponse_Status_name = map[int32]string{
	0: "UNKNOWN",
	1: "ACCEPTED",
	2: "APPLIED",
	3: "ERROR",
	4: "DECLINED",
}
var SnapshotResponse_Status_value = map[string]int32{
	"UNKNOWN":  0,
	"ACCEPTED": 1,
	"APPLIED":  2,
	"ERROR":    3,
	"DECLINED": 4,
}

func (x SnapshotResponse_Status) Enum() *SnapshotResponse_Status {
	p := new(SnapshotResponse_Status)
	*p = x
	return p
}
func (x SnapshotResponse_Status) String() string {
	return proto.EnumName(SnapshotResponse_Status_name, int32(x))
}
func (x *SnapshotResponse_Status) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SnapshotResponse_Status_value, data, "SnapshotResponse_Status")
	if err != nil {
		return err
	}
	*x = SnapshotResponse_Status(value)
	return nil
}
func (SnapshotResponse_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRaft, []int{6, 0}
}

// RaftHeartbeat is a request that contains the barebones information for a
// raftpb.MsgHeartbeat raftpb.Message. RaftHeartbeats are coalesced and sent
// in a RaftMessageRequest, and reconstructed by the receiver into individual
// raftpb.Message protos.
type RaftHeartbeat struct {
	RangeID       github_com_cockroachdb_cockroach_pkg_roachpb.RangeID   `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id"`
	FromReplicaID github_com_cockroachdb_cockroach_pkg_roachpb.ReplicaID `protobuf:"varint,2,opt,name=from_replica_id,json=fromReplicaId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.ReplicaID" json:"from_replica_id"`
	ToReplicaID   github_com_cockroachdb_cockroach_pkg_roachpb.ReplicaID `protobuf:"varint,3,opt,name=to_replica_id,json=toReplicaId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.ReplicaID" json:"to_replica_id"`
	Term          uint64                                                 `protobuf:"varint,4,opt,name=term" json:"term"`
	Commit        uint64                                                 `protobuf:"varint,5,opt,name=commit" json:"commit"`
	Quiesce       bool                                                   `protobuf:"varint,6,opt,name=quiesce" json:"quiesce"`
}

func (m *RaftHeartbeat) Reset()                    { *m = RaftHeartbeat{} }
func (m *RaftHeartbeat) String() string            { return proto.CompactTextString(m) }
func (*RaftHeartbeat) ProtoMessage()               {}
func (*RaftHeartbeat) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{0} }

// RaftMessageRequest is the request used to send raft messages using our
// protobuf-based RPC codec. If a RaftMessageRequest has a non-empty number of
// heartbeats or heartbeat_resps, the contents of the message field is treated
// as a dummy message and discarded. A coalesced heartbeat request's replica
// descriptor's range ID must be zero.
type RaftMessageRequest struct {
	RangeID     github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id"`
	FromReplica cockroach_roachpb.ReplicaDescriptor                  `protobuf:"bytes,2,opt,name=from_replica,json=fromReplica" json:"from_replica"`
	ToReplica   cockroach_roachpb.ReplicaDescriptor                  `protobuf:"bytes,3,opt,name=to_replica,json=toReplica" json:"to_replica"`
	Message     raftpb.Message                                       `protobuf:"bytes,4,opt,name=message" json:"message"`
	// Is this a quiesce request? A quiesce request is a MsgHeartbeat
	// which is requesting the recipient to stop ticking its local
	// replica as long as the current Raft state matches the heartbeat
	// Term/Commit. If the Term/Commit match, the recipient is marked as
	// quiescent. If they don't match, the message is passed along to
	// Raft which will generate a MsgHeartbeatResp that will unquiesce
	// the sender.
	Quiesce bool `protobuf:"varint,5,opt,name=quiesce" json:"quiesce"`
	// A coalesced heartbeat request is any RaftMessageRequest with a nonzero number of
	// heartbeats or heartbeat_resps.
	Heartbeats     []RaftHeartbeat `protobuf:"bytes,6,rep,name=heartbeats" json:"heartbeats"`
	HeartbeatResps []RaftHeartbeat `protobuf:"bytes,7,rep,name=heartbeat_resps,json=heartbeatResps" json:"heartbeat_resps"`
}

func (m *RaftMessageRequest) Reset()                    { *m = RaftMessageRequest{} }
func (m *RaftMessageRequest) String() string            { return proto.CompactTextString(m) }
func (*RaftMessageRequest) ProtoMessage()               {}
func (*RaftMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{1} }

type RaftMessageRequestBatch struct {
	Requests []RaftMessageRequest `protobuf:"bytes,1,rep,name=requests" json:"requests"`
}

func (m *RaftMessageRequestBatch) Reset()                    { *m = RaftMessageRequestBatch{} }
func (m *RaftMessageRequestBatch) String() string            { return proto.CompactTextString(m) }
func (*RaftMessageRequestBatch) ProtoMessage()               {}
func (*RaftMessageRequestBatch) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{2} }

type RaftMessageResponseUnion struct {
	Error *cockroach_roachpb3.Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *RaftMessageResponseUnion) Reset()                    { *m = RaftMessageResponseUnion{} }
func (m *RaftMessageResponseUnion) String() string            { return proto.CompactTextString(m) }
func (*RaftMessageResponseUnion) ProtoMessage()               {}
func (*RaftMessageResponseUnion) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{3} }

// RaftMessageResponse may be sent to the sender of a
// RaftMessageRequest. RaftMessage does not use the usual
// request/response pattern; it is primarily modeled as a one-way
// stream of requests. Normal 'responses' are usually sent as new
// requests on a separate stream in the other direction.
// RaftMessageResponse is not sent for every RaftMessageRequest, but
// may be used for certain error conditions.
type RaftMessageResponse struct {
	RangeID     github_com_cockroachdb_cockroach_pkg_roachpb.RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.RangeID" json:"range_id"`
	FromReplica cockroach_roachpb.ReplicaDescriptor                  `protobuf:"bytes,2,opt,name=from_replica,json=fromReplica" json:"from_replica"`
	ToReplica   cockroach_roachpb.ReplicaDescriptor                  `protobuf:"bytes,3,opt,name=to_replica,json=toReplica" json:"to_replica"`
	Union       RaftMessageResponseUnion                             `protobuf:"bytes,4,opt,name=union" json:"union"`
}

func (m *RaftMessageResponse) Reset()                    { *m = RaftMessageResponse{} }
func (m *RaftMessageResponse) String() string            { return proto.CompactTextString(m) }
func (*RaftMessageResponse) ProtoMessage()               {}
func (*RaftMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{4} }

// SnapshotRequest is the request used to send streaming snapshot requests.
type SnapshotRequest struct {
	Header *SnapshotRequest_Header `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	// A RocksDB BatchRepr. Multiple kv_batches may be sent across multiple request messages.
	KVBatch []byte `protobuf:"bytes,2,opt,name=kv_batch,json=kvBatch" json:"kv_batch,omitempty"`
	// These are really raftpb.Entry, but we model them as raw bytes to avoid
	// roundtripping through memory. They are separate from the kv_batch to
	// allow flexibility in log implementations.
	LogEntries [][]byte `protobuf:"bytes,3,rep,name=log_entries,json=logEntries" json:"log_entries,omitempty"`
	Final      bool     `protobuf:"varint,4,opt,name=final" json:"final"`
}

func (m *SnapshotRequest) Reset()                    { *m = SnapshotRequest{} }
func (m *SnapshotRequest) String() string            { return proto.CompactTextString(m) }
func (*SnapshotRequest) ProtoMessage()               {}
func (*SnapshotRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{5} }

type SnapshotRequest_Header struct {
	// The replica state at the time the snapshot was generated. Note
	// that ReplicaState.Desc differs from the above range_descriptor
	// field which holds the updated descriptor after the new replica
	// has been added while ReplicaState.Desc holds the descriptor
	// before the new replica has been added.
	State cockroach_storage_storagebase.ReplicaState `protobuf:"bytes,5,opt,name=state" json:"state"`
	// The inner raft message is of type MsgSnap, and its snapshot data contains a UUID.
	RaftMessageRequest RaftMessageRequest `protobuf:"bytes,2,opt,name=raft_message_request,json=raftMessageRequest" json:"raft_message_request"`
	// The estimated size of the range, to be used in reservation decisions.
	RangeSize int64 `protobuf:"varint,3,opt,name=range_size,json=rangeSize" json:"range_size"`
	// can_decline is set on preemptive snapshots, but not those generated
	// by raft because at that point it is better to queue up the stream
	// than to cancel it.
	CanDecline bool `protobuf:"varint,4,opt,name=can_decline,json=canDecline" json:"can_decline"`
	// The priority of the snapshot.
	Priority SnapshotRequest_Priority `protobuf:"varint,6,opt,name=priority,enum=cockroach.storage.SnapshotRequest_Priority" json:"priority"`
	// The strategy of the snapshot.
	Strategy SnapshotRequest_Strategy `protobuf:"varint,7,opt,name=strategy,enum=cockroach.storage.SnapshotRequest_Strategy" json:"strategy"`
}

func (m *SnapshotRequest_Header) Reset()                    { *m = SnapshotRequest_Header{} }
func (m *SnapshotRequest_Header) String() string            { return proto.CompactTextString(m) }
func (*SnapshotRequest_Header) ProtoMessage()               {}
func (*SnapshotRequest_Header) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{5, 0} }

type SnapshotResponse struct {
	Status  SnapshotResponse_Status `protobuf:"varint,1,opt,name=status,enum=cockroach.storage.SnapshotResponse_Status" json:"status"`
	Message string                  `protobuf:"bytes,2,opt,name=message" json:"message"`
}

func (m *SnapshotResponse) Reset()                    { *m = SnapshotResponse{} }
func (m *SnapshotResponse) String() string            { return proto.CompactTextString(m) }
func (*SnapshotResponse) ProtoMessage()               {}
func (*SnapshotResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{6} }

// ConfChangeContext is encoded in the raftpb.ConfChange.Context field.
type ConfChangeContext struct {
	CommandID string `protobuf:"bytes,1,opt,name=command_id,json=commandId" json:"command_id"`
	// Payload is the application-level command (i.e. an encoded
	// storagebase.RaftCommand).
	Payload []byte `protobuf:"bytes,2,opt,name=payload" json:"payload,omitempty"`
	// Replica contains full details about the replica being added or removed.
	Replica cockroach_roachpb.ReplicaDescriptor `protobuf:"bytes,3,opt,name=replica" json:"replica"`
}

func (m *ConfChangeContext) Reset()                    { *m = ConfChangeContext{} }
func (m *ConfChangeContext) String() string            { return proto.CompactTextString(m) }
func (*ConfChangeContext) ProtoMessage()               {}
func (*ConfChangeContext) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{7} }

func init() {
	proto.RegisterType((*RaftHeartbeat)(nil), "cockroach.storage.RaftHeartbeat")
	proto.RegisterType((*RaftMessageRequest)(nil), "cockroach.storage.RaftMessageRequest")
	proto.RegisterType((*RaftMessageRequestBatch)(nil), "cockroach.storage.RaftMessageRequestBatch")
	proto.RegisterType((*RaftMessageResponseUnion)(nil), "cockroach.storage.RaftMessageResponseUnion")
	proto.RegisterType((*RaftMessageResponse)(nil), "cockroach.storage.RaftMessageResponse")
	proto.RegisterType((*SnapshotRequest)(nil), "cockroach.storage.SnapshotRequest")
	proto.RegisterType((*SnapshotRequest_Header)(nil), "cockroach.storage.SnapshotRequest.Header")
	proto.RegisterType((*SnapshotResponse)(nil), "cockroach.storage.SnapshotResponse")
	proto.RegisterType((*ConfChangeContext)(nil), "cockroach.storage.ConfChangeContext")
	proto.RegisterEnum("cockroach.storage.SnapshotRequest_Priority", SnapshotRequest_Priority_name, SnapshotRequest_Priority_value)
	proto.RegisterEnum("cockroach.storage.SnapshotRequest_Strategy", SnapshotRequest_Strategy_name, SnapshotRequest_Strategy_value)
	proto.RegisterEnum("cockroach.storage.SnapshotResponse_Status", SnapshotResponse_Status_name, SnapshotResponse_Status_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for MultiRaft service

type MultiRaftClient interface {
	RaftMessageBatch(ctx context.Context, opts ...grpc.CallOption) (MultiRaft_RaftMessageBatchClient, error)
	RaftSnapshot(ctx context.Context, opts ...grpc.CallOption) (MultiRaft_RaftSnapshotClient, error)
}

type multiRaftClient struct {
	cc *grpc.ClientConn
}

func NewMultiRaftClient(cc *grpc.ClientConn) MultiRaftClient {
	return &multiRaftClient{cc}
}

func (c *multiRaftClient) RaftMessageBatch(ctx context.Context, opts ...grpc.CallOption) (MultiRaft_RaftMessageBatchClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_MultiRaft_serviceDesc.Streams[0], c.cc, "/cockroach.storage.MultiRaft/RaftMessageBatch", opts...)
	if err != nil {
		return nil, err
	}
	x := &multiRaftRaftMessageBatchClient{stream}
	return x, nil
}

type MultiRaft_RaftMessageBatchClient interface {
	Send(*RaftMessageRequestBatch) error
	Recv() (*RaftMessageResponse, error)
	grpc.ClientStream
}

type multiRaftRaftMessageBatchClient struct {
	grpc.ClientStream
}

func (x *multiRaftRaftMessageBatchClient) Send(m *RaftMessageRequestBatch) error {
	return x.ClientStream.SendMsg(m)
}

func (x *multiRaftRaftMessageBatchClient) Recv() (*RaftMessageResponse, error) {
	m := new(RaftMessageResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *multiRaftClient) RaftSnapshot(ctx context.Context, opts ...grpc.CallOption) (MultiRaft_RaftSnapshotClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_MultiRaft_serviceDesc.Streams[1], c.cc, "/cockroach.storage.MultiRaft/RaftSnapshot", opts...)
	if err != nil {
		return nil, err
	}
	x := &multiRaftRaftSnapshotClient{stream}
	return x, nil
}

type MultiRaft_RaftSnapshotClient interface {
	Send(*SnapshotRequest) error
	Recv() (*SnapshotResponse, error)
	grpc.ClientStream
}

type multiRaftRaftSnapshotClient struct {
	grpc.ClientStream
}

func (x *multiRaftRaftSnapshotClient) Send(m *SnapshotRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *multiRaftRaftSnapshotClient) Recv() (*SnapshotResponse, error) {
	m := new(SnapshotResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for MultiRaft service

type MultiRaftServer interface {
	RaftMessageBatch(MultiRaft_RaftMessageBatchServer) error
	RaftSnapshot(MultiRaft_RaftSnapshotServer) error
}

func RegisterMultiRaftServer(s *grpc.Server, srv MultiRaftServer) {
	s.RegisterService(&_MultiRaft_serviceDesc, srv)
}

func _MultiRaft_RaftMessageBatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MultiRaftServer).RaftMessageBatch(&multiRaftRaftMessageBatchServer{stream})
}

type MultiRaft_RaftMessageBatchServer interface {
	Send(*RaftMessageResponse) error
	Recv() (*RaftMessageRequestBatch, error)
	grpc.ServerStream
}

type multiRaftRaftMessageBatchServer struct {
	grpc.ServerStream
}

func (x *multiRaftRaftMessageBatchServer) Send(m *RaftMessageResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *multiRaftRaftMessageBatchServer) Recv() (*RaftMessageRequestBatch, error) {
	m := new(RaftMessageRequestBatch)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _MultiRaft_RaftSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(MultiRaftServer).RaftSnapshot(&multiRaftRaftSnapshotServer{stream})
}

type MultiRaft_RaftSnapshotServer interface {
	Send(*SnapshotResponse) error
	Recv() (*SnapshotRequest, error)
	grpc.ServerStream
}

type multiRaftRaftSnapshotServer struct {
	grpc.ServerStream
}

func (x *multiRaftRaftSnapshotServer) Send(m *SnapshotResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *multiRaftRaftSnapshotServer) Recv() (*SnapshotRequest, error) {
	m := new(SnapshotRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _MultiRaft_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.storage.MultiRaft",
	HandlerType: (*MultiRaftServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RaftMessageBatch",
			Handler:       _MultiRaft_RaftMessageBatch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "RaftSnapshot",
			Handler:       _MultiRaft_RaftSnapshot_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "storage/raft.proto",
}

func (m *RaftHeartbeat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftHeartbeat) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.FromReplicaID))
	dAtA[i] = 0x18
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.ToReplicaID))
	dAtA[i] = 0x20
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Term))
	dAtA[i] = 0x28
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Commit))
	dAtA[i] = 0x30
	i++
	if m.Quiesce {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *RaftMessageRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessageRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.FromReplica.Size()))
	n1, err := m.FromReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x1a
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.ToReplica.Size()))
	n2, err := m.ToReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x22
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Message.Size()))
	n3, err := m.Message.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x28
	i++
	if m.Quiesce {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.Heartbeats) > 0 {
		for _, msg := range m.Heartbeats {
			dAtA[i] = 0x32
			i++
			i = encodeVarintRaft(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HeartbeatResps) > 0 {
		for _, msg := range m.HeartbeatResps {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRaft(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RaftMessageRequestBatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessageRequestBatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Requests) > 0 {
		for _, msg := range m.Requests {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRaft(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RaftMessageResponseUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessageResponseUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Error.Size()))
		n4, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *RaftMessageResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftMessageResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.FromReplica.Size()))
	n5, err := m.FromReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x1a
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.ToReplica.Size()))
	n6, err := m.ToReplica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x22
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Union.Size()))
	n7, err := m.Union.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *SnapshotRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRaft(dAtA, i, uint64(m.Header.Size()))
		n8, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.KVBatch != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.KVBatch)))
		i += copy(dAtA[i:], m.KVBatch)
	}
	if len(m.LogEntries) > 0 {
		for _, b := range m.LogEntries {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRaft(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	dAtA[i] = 0x20
	i++
	if m.Final {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *SnapshotRequest_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotRequest_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.RaftMessageRequest.Size()))
	n9, err := m.RaftMessageRequest.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x18
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.RangeSize))
	dAtA[i] = 0x20
	i++
	if m.CanDecline {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x2a
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.State.Size()))
	n10, err := m.State.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	dAtA[i] = 0x30
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Priority))
	dAtA[i] = 0x38
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Strategy))
	return i, nil
}

func (m *SnapshotResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SnapshotResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Status))
	dAtA[i] = 0x12
	i++
	i = encodeVarintRaft(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	return i, nil
}

func (m *ConfChangeContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfChangeContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintRaft(dAtA, i, uint64(len(m.CommandID)))
	i += copy(dAtA[i:], m.CommandID)
	if m.Payload != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRaft(dAtA, i, uint64(len(m.Payload)))
		i += copy(dAtA[i:], m.Payload)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintRaft(dAtA, i, uint64(m.Replica.Size()))
	n11, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	return i, nil
}

func encodeVarintRaft(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RaftHeartbeat) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovRaft(uint64(m.RangeID))
	n += 1 + sovRaft(uint64(m.FromReplicaID))
	n += 1 + sovRaft(uint64(m.ToReplicaID))
	n += 1 + sovRaft(uint64(m.Term))
	n += 1 + sovRaft(uint64(m.Commit))
	n += 2
	return n
}

func (m *RaftMessageRequest) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovRaft(uint64(m.RangeID))
	l = m.FromReplica.Size()
	n += 1 + l + sovRaft(uint64(l))
	l = m.ToReplica.Size()
	n += 1 + l + sovRaft(uint64(l))
	l = m.Message.Size()
	n += 1 + l + sovRaft(uint64(l))
	n += 2
	if len(m.Heartbeats) > 0 {
		for _, e := range m.Heartbeats {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	if len(m.HeartbeatResps) > 0 {
		for _, e := range m.HeartbeatResps {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	return n
}

func (m *RaftMessageRequestBatch) Size() (n int) {
	var l int
	_ = l
	if len(m.Requests) > 0 {
		for _, e := range m.Requests {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	return n
}

func (m *RaftMessageResponseUnion) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *RaftMessageResponse) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovRaft(uint64(m.RangeID))
	l = m.FromReplica.Size()
	n += 1 + l + sovRaft(uint64(l))
	l = m.ToReplica.Size()
	n += 1 + l + sovRaft(uint64(l))
	l = m.Union.Size()
	n += 1 + l + sovRaft(uint64(l))
	return n
}

func (m *SnapshotRequest) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	if m.KVBatch != nil {
		l = len(m.KVBatch)
		n += 1 + l + sovRaft(uint64(l))
	}
	if len(m.LogEntries) > 0 {
		for _, b := range m.LogEntries {
			l = len(b)
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	n += 2
	return n
}

func (m *SnapshotRequest_Header) Size() (n int) {
	var l int
	_ = l
	l = m.RaftMessageRequest.Size()
	n += 1 + l + sovRaft(uint64(l))
	n += 1 + sovRaft(uint64(m.RangeSize))
	n += 2
	l = m.State.Size()
	n += 1 + l + sovRaft(uint64(l))
	n += 1 + sovRaft(uint64(m.Priority))
	n += 1 + sovRaft(uint64(m.Strategy))
	return n
}

func (m *SnapshotResponse) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovRaft(uint64(m.Status))
	l = len(m.Message)
	n += 1 + l + sovRaft(uint64(l))
	return n
}

func (m *ConfChangeContext) Size() (n int) {
	var l int
	_ = l
	l = len(m.CommandID)
	n += 1 + l + sovRaft(uint64(l))
	if m.Payload != nil {
		l = len(m.Payload)
		n += 1 + l + sovRaft(uint64(l))
	}
	l = m.Replica.Size()
	n += 1 + l + sovRaft(uint64(l))
	return n
}

func sovRaft(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRaft(x uint64) (n int) {
	return sovRaft(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RaftMessageResponseUnion) GetValue() interface{} {
	if this.Error != nil {
		return this.Error
	}
	return nil
}

func (this *RaftMessageResponseUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *cockroach_roachpb3.Error:
		this.Error = vt
	default:
		return false
	}
	return true
}
func (m *RaftHeartbeat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftHeartbeat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftHeartbeat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromReplicaID", wireType)
			}
			m.FromReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FromReplicaID |= (github_com_cockroachdb_cockroach_pkg_roachpb.ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToReplicaID", wireType)
			}
			m.ToReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ToReplicaID |= (github_com_cockroachdb_cockroach_pkg_roachpb.ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Term", wireType)
			}
			m.Term = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Term |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			m.Commit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Commit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quiesce", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Quiesce = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMessageRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FromReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ToReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Message.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quiesce", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Quiesce = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Heartbeats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Heartbeats = append(m.Heartbeats, RaftHeartbeat{})
			if err := m.Heartbeats[len(m.Heartbeats)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatResps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeartbeatResps = append(m.HeartbeatResps, RaftHeartbeat{})
			if err := m.HeartbeatResps[len(m.HeartbeatResps)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMessageRequestBatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessageRequestBatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessageRequestBatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requests = append(m.Requests, RaftMessageRequest{})
			if err := m.Requests[len(m.Requests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMessageResponseUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessageResponseUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessageResponseUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &cockroach_roachpb3.Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftMessageResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMessageResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMessageResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FromReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ToReplica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ToReplica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Union", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Union.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &SnapshotRequest_Header{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KVBatch", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KVBatch = append(m.KVBatch[:0], dAtA[iNdEx:postIndex]...)
			if m.KVBatch == nil {
				m.KVBatch = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogEntries", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogEntries = append(m.LogEntries, make([]byte, postIndex-iNdEx))
			copy(m.LogEntries[len(m.LogEntries)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Final", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Final = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotRequest_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftMessageRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RaftMessageRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeSize", wireType)
			}
			m.RangeSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CanDecline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CanDecline = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.State.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (SnapshotRequest_Priority(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Strategy", wireType)
			}
			m.Strategy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Strategy |= (SnapshotRequest_Strategy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SnapshotResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SnapshotResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SnapshotResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (SnapshotResponse_Status(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfChangeContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfChangeContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfChangeContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommandID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CommandID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Payload", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Payload = append(m.Payload[:0], dAtA[iNdEx:postIndex]...)
			if m.Payload == nil {
				m.Payload = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRaft(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRaft
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRaft
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRaft(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRaft = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRaft   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("storage/raft.proto", fileDescriptorRaft) }

var fileDescriptorRaft = []byte{
	// 1104 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x56, 0xcd, 0x6e, 0xdb, 0x46,
	0x17, 0x15, 0xad, 0xff, 0x2b, 0x29, 0x66, 0xe6, 0x33, 0xbe, 0x12, 0x6a, 0x21, 0xa9, 0x4c, 0x13,
	0xa8, 0x29, 0x40, 0x05, 0x42, 0xd0, 0x45, 0x77, 0xfa, 0x61, 0x6c, 0xc5, 0xbf, 0xa0, 0x1d, 0x17,
	0x2d, 0x10, 0x08, 0x23, 0x6a, 0x24, 0x11, 0x96, 0x38, 0x32, 0x39, 0x4a, 0xeb, 0x3c, 0x45, 0x1f,
	0x21, 0x9b, 0xee, 0xba, 0xef, 0x2b, 0x78, 0x53, 0xa0, 0xcb, 0x2c, 0x0a, 0xa3, 0x75, 0xdf, 0xa2,
	0xe8, 0xa2, 0x98, 0xe1, 0x8c, 0x4d, 0xdb, 0x6a, 0x63, 0x17, 0x45, 0x37, 0xdd, 0xd8, 0xe4, 0x9d,
	0x39, 0xe7, 0x70, 0xee, 0xb9, 0xf7, 0x8e, 0x00, 0x85, 0x8c, 0x06, 0x78, 0x4c, 0x1a, 0x01, 0x1e,
	0x31, 0x6b, 0x1e, 0x50, 0x46, 0xd1, 0x7d, 0x97, 0xba, 0x47, 0x01, 0xc5, 0xee, 0xc4, 0x92, 0xab,
	0xe5, 0x35, 0xf1, 0x3a, 0x1f, 0x34, 0x48, 0x10, 0xd0, 0x20, 0x8c, 0x36, 0x96, 0xff, 0xaf, 0xa2,
	0x33, 0xc2, 0xf0, 0x10, 0x33, 0x2c, 0xe3, 0x55, 0x45, 0x2a, 0xff, 0x0f, 0x70, 0xc8, 0x9f, 0x31,
	0x23, 0x72, 0xc3, 0xfb, 0x84, 0xb9, 0x43, 0x21, 0x29, 0xfe, 0xcc, 0x07, 0x31, 0xf9, 0xf2, 0xda,
	0x98, 0x8e, 0xa9, 0x78, 0x6c, 0xf0, 0xa7, 0x28, 0x6a, 0x7e, 0x9f, 0x84, 0x92, 0x83, 0x47, 0x6c,
	0x83, 0xe0, 0x80, 0x0d, 0x08, 0x66, 0x68, 0x00, 0xb9, 0x00, 0xfb, 0x63, 0xd2, 0xf7, 0x86, 0x86,
	0x56, 0xd3, 0xea, 0xa9, 0xf6, 0xfa, 0xe9, 0x59, 0x35, 0x71, 0x7e, 0x56, 0xcd, 0x3a, 0x3c, 0xde,
	0xeb, 0xfe, 0x76, 0x56, 0x7d, 0x3a, 0xf6, 0xd8, 0x64, 0x31, 0xb0, 0x5c, 0x3a, 0x6b, 0x5c, 0x1c,
	0x6b, 0x38, 0xb8, 0x7c, 0x6e, 0xcc, 0x8f, 0xc6, 0x0d, 0x79, 0x0e, 0x4b, 0xe2, 0x9c, 0xac, 0x20,
	0xee, 0x0d, 0xd1, 0x57, 0xb0, 0x3a, 0x0a, 0xe8, 0xac, 0x1f, 0x90, 0xf9, 0xd4, 0x73, 0x31, 0x97,
	0x5a, 0xa9, 0x69, 0xf5, 0x52, 0x7b, 0x57, 0x4a, 0x95, 0x9e, 0x05, 0x74, 0xe6, 0x44, 0xab, 0x42,
	0xf0, 0xd3, 0xbb, 0x09, 0x2a, 0xa4, 0x53, 0x1a, 0xc5, 0x88, 0x86, 0xe8, 0x18, 0x4a, 0x8c, 0xc6,
	0x65, 0x93, 0x42, 0x76, 0x5b, 0xca, 0x16, 0x0e, 0xe8, 0x3f, 0x21, 0x5a, 0x60, 0xf4, 0x52, 0xd2,
	0x80, 0x14, 0x23, 0xc1, 0xcc, 0x48, 0x89, 0x5c, 0xa6, 0xb8, 0x92, 0x23, 0x22, 0xe8, 0x03, 0xc8,
	0xb8, 0x74, 0x36, 0xf3, 0x98, 0x91, 0x8e, 0xad, 0xc9, 0x18, 0xaa, 0x40, 0xf6, 0x78, 0xe1, 0x91,
	0xd0, 0x25, 0x46, 0xa6, 0xa6, 0xd5, 0x73, 0x72, 0x59, 0x05, 0xcd, 0xdf, 0x93, 0x80, 0xb8, 0x73,
	0xdb, 0x24, 0x0c, 0xf1, 0x98, 0x38, 0xe4, 0x78, 0x41, 0xc2, 0x7f, 0xc7, 0xbe, 0x6d, 0x28, 0xc6,
	0xed, 0x13, 0xde, 0x15, 0x9a, 0x1f, 0x59, 0x97, 0x05, 0x7e, 0x2d, 0x27, 0x5d, 0x12, 0xba, 0x81,
	0x37, 0x67, 0x34, 0x90, 0xa7, 0x28, 0xc4, 0x6c, 0x41, 0x3d, 0x80, 0x4b, 0x53, 0x84, 0x23, 0x77,
	0x23, 0xcb, 0x5f, 0xa4, 0x1b, 0x35, 0x20, 0x3b, 0x8b, 0xf2, 0x21, 0xf2, 0x5d, 0x68, 0xae, 0x5a,
	0x51, 0x27, 0x58, 0x32, 0x4d, 0x2a, 0x8b, 0x72, 0x57, 0x3c, 0xcb, 0xe9, 0x25, 0x59, 0x46, 0xcf,
	0x00, 0x26, 0xaa, 0x35, 0x42, 0x23, 0x53, 0x4b, 0xd6, 0x0b, 0xcd, 0x9a, 0x75, 0xa3, 0x93, 0xad,
	0x2b, 0x3d, 0x24, 0x49, 0x62, 0x48, 0xb4, 0x0b, 0xab, 0x17, 0x6f, 0xfd, 0x80, 0x84, 0xf3, 0xd0,
	0xc8, 0xde, 0x89, 0xec, 0xde, 0x05, 0xdc, 0xe1, 0x68, 0x73, 0x00, 0xef, 0xdd, 0x74, 0xbf, 0x8d,
	0x99, 0x3b, 0x41, 0xeb, 0x90, 0x0b, 0xa2, 0xf7, 0xd0, 0xd0, 0x84, 0xc8, 0xc3, 0x3f, 0x11, 0xb9,
	0x86, 0x8e, 0x94, 0x2e, 0xc0, 0xe6, 0x1e, 0x18, 0x57, 0x76, 0x85, 0x73, 0xea, 0x87, 0xe4, 0x85,
	0xef, 0x51, 0x1f, 0x59, 0x90, 0x16, 0x43, 0x4b, 0x14, 0x59, 0xa1, 0x69, 0x2c, 0xf1, 0xcb, 0xe6,
	0xeb, 0x4e, 0xb4, 0xed, 0xb3, 0xd4, 0xe9, 0x9b, 0xaa, 0x66, 0xfe, 0xb4, 0x02, 0xff, 0x5b, 0x42,
	0xf9, 0x1f, 0xaf, 0xda, 0x75, 0x48, 0x2f, 0x78, 0x52, 0x65, 0xcd, 0x7e, 0xf2, 0x2e, 0xb7, 0x62,
	0x3e, 0x48, 0xb2, 0x08, 0x6f, 0x7e, 0x97, 0x86, 0xd5, 0x7d, 0x1f, 0xcf, 0xc3, 0x09, 0x65, 0x6a,
	0x20, 0xb4, 0x20, 0x33, 0x21, 0x78, 0x48, 0x94, 0x53, 0x1f, 0x2f, 0x61, 0xbf, 0x86, 0xb1, 0x36,
	0x04, 0xc0, 0x91, 0x40, 0xf4, 0x08, 0x72, 0x47, 0xaf, 0xfa, 0x03, 0x5e, 0x5c, 0x22, 0x6b, 0xc5,
	0x76, 0x81, 0x3b, 0xb3, 0x79, 0x28, 0xea, 0xcd, 0xc9, 0x1e, 0xbd, 0x8a, 0x0a, 0xaf, 0x0a, 0x85,
	0x29, 0x1d, 0xf7, 0x89, 0xcf, 0x02, 0x8f, 0x84, 0x46, 0xb2, 0x96, 0xac, 0x17, 0x1d, 0x98, 0xd2,
	0xb1, 0x1d, 0x45, 0x50, 0x19, 0xd2, 0x23, 0xcf, 0xc7, 0x53, 0x71, 0x50, 0xd5, 0x6b, 0x51, 0xa8,
	0xfc, 0x26, 0x09, 0x99, 0x48, 0x17, 0xbd, 0x84, 0x35, 0xde, 0xb5, 0x7d, 0xd9, 0xa4, 0x7d, 0x59,
	0x90, 0xd2, 0xb1, 0x3b, 0x15, 0x33, 0x0a, 0x6e, 0x8e, 0xc8, 0x07, 0x00, 0x51, 0xb1, 0x85, 0xde,
	0x6b, 0x22, 0x9c, 0x4b, 0x2a, 0x4f, 0x44, 0x7c, 0xdf, 0x7b, 0x4d, 0xd0, 0x43, 0x28, 0xb8, 0xd8,
	0xef, 0x0f, 0x89, 0x3b, 0xf5, 0x7c, 0x72, 0xe5, 0x83, 0xc1, 0xc5, 0x7e, 0x37, 0x8a, 0x73, 0xeb,
	0xc4, 0x0d, 0x2c, 0xa6, 0xc7, 0x72, 0xeb, 0x62, 0xb7, 0xb5, 0x2a, 0x86, 0x7d, 0x0e, 0x51, 0xc7,
	0x17, 0x78, 0xb4, 0x0d, 0xb9, 0x79, 0xe0, 0xd1, 0xc0, 0x63, 0x27, 0x62, 0xde, 0xdf, 0x5b, 0xca,
	0x75, 0xdd, 0xa8, 0x3d, 0x09, 0x51, 0xad, 0xab, 0x28, 0x38, 0x5d, 0xc8, 0x02, 0xcc, 0xc8, 0xf8,
	0xc4, 0xc8, 0xde, 0x9a, 0x6e, 0x5f, 0x42, 0x14, 0x9d, 0xa2, 0x78, 0x9e, 0xca, 0x69, 0xfa, 0x8a,
	0xf9, 0x14, 0x72, 0x4a, 0x10, 0x15, 0x20, 0xfb, 0x62, 0x67, 0x73, 0x67, 0xf7, 0xf3, 0x1d, 0x3d,
	0x81, 0x8a, 0x90, 0x73, 0xec, 0xce, 0xee, 0xa1, 0xed, 0x7c, 0xa1, 0x6b, 0xa8, 0x04, 0x79, 0xc7,
	0x6e, 0xb7, 0xb6, 0x5a, 0x3b, 0x1d, 0x5b, 0x5f, 0x31, 0x0d, 0xc8, 0x29, 0x5e, 0xbe, 0x71, 0xf3,
	0xb0, 0xdf, 0x6e, 0x1d, 0x74, 0x36, 0xf4, 0x84, 0xf9, 0x83, 0x06, 0xfa, 0xe5, 0x27, 0xc8, 0x51,
	0xb0, 0x01, 0x19, 0x9e, 0x91, 0x45, 0x28, 0xea, 0xf5, 0x5e, 0xf3, 0xf1, 0x5f, 0x7e, 0x77, 0x04,
	0xb2, 0xf6, 0x05, 0x42, 0xdd, 0xa0, 0x11, 0x9e, 0xcf, 0x76, 0x75, 0x19, 0xf0, 0xca, 0xc9, 0x5f,
	0x9b, 0xfd, 0x66, 0x0f, 0x32, 0x11, 0xee, 0xc6, 0x61, 0x5a, 0x9d, 0x8e, 0xbd, 0x77, 0x60, 0x77,
	0x75, 0x8d, 0x2f, 0xb5, 0xf6, 0xf6, 0xb6, 0x7a, 0x76, 0x57, 0x5f, 0x41, 0x79, 0x48, 0xdb, 0x8e,
	0xb3, 0xeb, 0xe8, 0x49, 0xbe, 0xab, 0x6b, 0x77, 0xb6, 0x7a, 0x3b, 0x76, 0x57, 0x4f, 0x3d, 0x4f,
	0xe5, 0x92, 0x7a, 0xca, 0xfc, 0x56, 0x83, 0xfb, 0x1d, 0xea, 0x8f, 0x3a, 0x13, 0x5e, 0x46, 0x1d,
	0xea, 0x33, 0xf2, 0x35, 0x43, 0x4f, 0x00, 0xf8, 0x95, 0x8e, 0xfd, 0xa1, 0x9a, 0x6e, 0xf9, 0xf6,
	0x7d, 0x39, 0xdd, 0xf2, 0x9d, 0x68, 0xa5, 0xd7, 0x75, 0xf2, 0x72, 0x93, 0xf8, 0xc9, 0x90, 0x9d,
	0xe3, 0x93, 0x29, 0xc5, 0xd1, 0xcf, 0xa2, 0xa2, 0xa3, 0x5e, 0x51, 0x17, 0xb2, 0x7f, 0x7f, 0xe2,
	0x28, 0x68, 0xf3, 0xad, 0x06, 0xf9, 0xed, 0xc5, 0x94, 0x79, 0xbc, 0x6d, 0xd0, 0x14, 0xf4, 0x58,
	0xfb, 0x44, 0x9d, 0xfc, 0xf8, 0x76, 0x3d, 0xc6, 0xf7, 0x96, 0x1f, 0xdd, 0x6e, 0x5c, 0x99, 0x89,
	0xba, 0xf6, 0x44, 0x43, 0x2f, 0xa1, 0xc8, 0x17, 0x95, 0x83, 0xc8, 0x7c, 0x77, 0x59, 0x96, 0x1f,
	0xdc, 0xa2, 0x04, 0x22, 0xfa, 0xf6, 0x87, 0xa7, 0xbf, 0x54, 0x12, 0xa7, 0xe7, 0x15, 0xed, 0xc7,
	0xf3, 0x8a, 0xf6, 0xf6, 0xbc, 0xa2, 0xfd, 0x7c, 0x5e, 0xd1, 0xbe, 0xf9, 0xb5, 0x92, 0xf8, 0x32,
	0x2b, 0x91, 0x7f, 0x04, 0x00, 0x00, 0xff, 0xff, 0xa4, 0xd6, 0xb6, 0x01, 0x9c, 0x0b, 0x00, 0x00,
}
