// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: util/tracing/recorded_span.proto

/*
	Package tracing is a generated protocol buffer package.

	It is generated from these files:
		util/tracing/recorded_span.proto

	It has these top-level messages:
		RecordedSpan
*/
package tracing

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf1 "github.com/gogo/protobuf/types"

import time "time"

import sortkeys "github.com/gogo/protobuf/sortkeys"
import types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// RecordedSpan is a span that is part of a recording. It can be transferred
// over the wire for snowball tracing.
type RecordedSpan struct {
	// ID of the trace; spans that are part of the same hierarchy share
	// the same trace ID.
	TraceID uint64 `protobuf:"varint,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// ID of the span.
	SpanID uint64 `protobuf:"varint,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Span ID of the parent span.
	ParentSpanID uint64 `protobuf:"varint,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Operation name.
	Operation string `protobuf:"bytes,4,opt,name=operation,proto3" json:"operation,omitempty"`
	// Baggage items get passed from parent to child spans (even through gRPC).
	// Notably, snowball tracing uses a special `sb` baggage item.
	Baggage map[string]string `protobuf:"bytes,5,rep,name=baggage" json:"baggage,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags associated with the span.
	Tags map[string]string `protobuf:"bytes,6,rep,name=tags" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Time when the span was started.
	StartTime time.Time `protobuf:"bytes,7,opt,name=start_time,json=startTime,stdtime" json:"start_time"`
	// Duration in nanoseconds; 0 if the span is not finished.
	Duration time.Duration `protobuf:"bytes,8,opt,name=duration,stdduration" json:"duration"`
	// Events logged in the span.
	Logs []RecordedSpan_LogRecord `protobuf:"bytes,9,rep,name=logs" json:"logs"`
	// Stats collected in this span.
	Stats *google_protobuf1.Any `protobuf:"bytes,10,opt,name=stats" json:"stats,omitempty"`
}

func (m *RecordedSpan) Reset()                    { *m = RecordedSpan{} }
func (m *RecordedSpan) String() string            { return proto.CompactTextString(m) }
func (*RecordedSpan) ProtoMessage()               {}
func (*RecordedSpan) Descriptor() ([]byte, []int) { return fileDescriptorRecordedSpan, []int{0} }

type RecordedSpan_LogRecord struct {
	// Time of the log record.
	Time time.Time `protobuf:"bytes,1,opt,name=time,stdtime" json:"time"`
	// Fields with values converted to strings.
	Fields []RecordedSpan_LogRecord_Field `protobuf:"bytes,2,rep,name=fields" json:"fields"`
}

func (m *RecordedSpan_LogRecord) Reset()         { *m = RecordedSpan_LogRecord{} }
func (m *RecordedSpan_LogRecord) String() string { return proto.CompactTextString(m) }
func (*RecordedSpan_LogRecord) ProtoMessage()    {}
func (*RecordedSpan_LogRecord) Descriptor() ([]byte, []int) {
	return fileDescriptorRecordedSpan, []int{0, 2}
}

type RecordedSpan_LogRecord_Field struct {
	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *RecordedSpan_LogRecord_Field) Reset()         { *m = RecordedSpan_LogRecord_Field{} }
func (m *RecordedSpan_LogRecord_Field) String() string { return proto.CompactTextString(m) }
func (*RecordedSpan_LogRecord_Field) ProtoMessage()    {}
func (*RecordedSpan_LogRecord_Field) Descriptor() ([]byte, []int) {
	return fileDescriptorRecordedSpan, []int{0, 2, 0}
}

func init() {
	proto.RegisterType((*RecordedSpan)(nil), "cockroach.util.tracing.RecordedSpan")
	proto.RegisterType((*RecordedSpan_LogRecord)(nil), "cockroach.util.tracing.RecordedSpan.LogRecord")
	proto.RegisterType((*RecordedSpan_LogRecord_Field)(nil), "cockroach.util.tracing.RecordedSpan.LogRecord.Field")
}
func (m *RecordedSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordedSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TraceID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(m.TraceID))
	}
	if m.SpanID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(m.SpanID))
	}
	if m.ParentSpanID != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(m.ParentSpanID))
	}
	if len(m.Operation) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(len(m.Operation)))
		i += copy(dAtA[i:], m.Operation)
	}
	if len(m.Baggage) > 0 {
		keysForBaggage := make([]string, 0, len(m.Baggage))
		for k := range m.Baggage {
			keysForBaggage = append(keysForBaggage, string(k))
		}
		sortkeys.Strings(keysForBaggage)
		for _, k := range keysForBaggage {
			dAtA[i] = 0x2a
			i++
			v := m.Baggage[string(k)]
			mapSize := 1 + len(k) + sovRecordedSpan(uint64(len(k))) + 1 + len(v) + sovRecordedSpan(uint64(len(v)))
			i = encodeVarintRecordedSpan(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Tags) > 0 {
		keysForTags := make([]string, 0, len(m.Tags))
		for k := range m.Tags {
			keysForTags = append(keysForTags, string(k))
		}
		sortkeys.Strings(keysForTags)
		for _, k := range keysForTags {
			dAtA[i] = 0x32
			i++
			v := m.Tags[string(k)]
			mapSize := 1 + len(k) + sovRecordedSpan(uint64(len(k))) + 1 + len(v) + sovRecordedSpan(uint64(len(v)))
			i = encodeVarintRecordedSpan(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintRecordedSpan(dAtA, i, uint64(types.SizeOfStdTime(m.StartTime)))
	n1, err := types.StdTimeMarshalTo(m.StartTime, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x42
	i++
	i = encodeVarintRecordedSpan(dAtA, i, uint64(types.SizeOfStdDuration(m.Duration)))
	n2, err := types.StdDurationMarshalTo(m.Duration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.Logs) > 0 {
		for _, msg := range m.Logs {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Stats != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(m.Stats.Size()))
		n3, err := m.Stats.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *RecordedSpan_LogRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordedSpan_LogRecord) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintRecordedSpan(dAtA, i, uint64(types.SizeOfStdTime(m.Time)))
	n4, err := types.StdTimeMarshalTo(m.Time, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if len(m.Fields) > 0 {
		for _, msg := range m.Fields {
			dAtA[i] = 0x12
			i++
			i = encodeVarintRecordedSpan(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RecordedSpan_LogRecord_Field) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RecordedSpan_LogRecord_Field) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRecordedSpan(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func encodeVarintRecordedSpan(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RecordedSpan) Size() (n int) {
	var l int
	_ = l
	if m.TraceID != 0 {
		n += 1 + sovRecordedSpan(uint64(m.TraceID))
	}
	if m.SpanID != 0 {
		n += 1 + sovRecordedSpan(uint64(m.SpanID))
	}
	if m.ParentSpanID != 0 {
		n += 1 + sovRecordedSpan(uint64(m.ParentSpanID))
	}
	l = len(m.Operation)
	if l > 0 {
		n += 1 + l + sovRecordedSpan(uint64(l))
	}
	if len(m.Baggage) > 0 {
		for k, v := range m.Baggage {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRecordedSpan(uint64(len(k))) + 1 + len(v) + sovRecordedSpan(uint64(len(v)))
			n += mapEntrySize + 1 + sovRecordedSpan(uint64(mapEntrySize))
		}
	}
	if len(m.Tags) > 0 {
		for k, v := range m.Tags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovRecordedSpan(uint64(len(k))) + 1 + len(v) + sovRecordedSpan(uint64(len(v)))
			n += mapEntrySize + 1 + sovRecordedSpan(uint64(mapEntrySize))
		}
	}
	l = types.SizeOfStdTime(m.StartTime)
	n += 1 + l + sovRecordedSpan(uint64(l))
	l = types.SizeOfStdDuration(m.Duration)
	n += 1 + l + sovRecordedSpan(uint64(l))
	if len(m.Logs) > 0 {
		for _, e := range m.Logs {
			l = e.Size()
			n += 1 + l + sovRecordedSpan(uint64(l))
		}
	}
	if m.Stats != nil {
		l = m.Stats.Size()
		n += 1 + l + sovRecordedSpan(uint64(l))
	}
	return n
}

func (m *RecordedSpan_LogRecord) Size() (n int) {
	var l int
	_ = l
	l = types.SizeOfStdTime(m.Time)
	n += 1 + l + sovRecordedSpan(uint64(l))
	if len(m.Fields) > 0 {
		for _, e := range m.Fields {
			l = e.Size()
			n += 1 + l + sovRecordedSpan(uint64(l))
		}
	}
	return n
}

func (m *RecordedSpan_LogRecord_Field) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovRecordedSpan(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRecordedSpan(uint64(l))
	}
	return n
}

func sovRecordedSpan(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRecordedSpan(x uint64) (n int) {
	return sovRecordedSpan(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *RecordedSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRecordedSpan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RecordedSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RecordedSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceID", wireType)
			}
			m.TraceID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TraceID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanID", wireType)
			}
			m.SpanID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SpanID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanID", wireType)
			}
			m.ParentSpanID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentSpanID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Baggage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Baggage == nil {
				m.Baggage = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRecordedSpan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRecordedSpan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRecordedSpan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRecordedSpan(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Baggage[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tags == nil {
				m.Tags = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRecordedSpan
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRecordedSpan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRecordedSpan
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRecordedSpan(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRecordedSpan
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Tags[mapkey] = mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.StartTime, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.Duration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Logs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Logs = append(m.Logs, RecordedSpan_LogRecord{})
			if err := m.Logs[len(m.Logs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stats", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stats == nil {
				m.Stats = &google_protobuf1.Any{}
			}
			if err := m.Stats.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRecordedSpan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordedSpan_LogRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRecordedSpan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LogRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LogRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdTimeUnmarshal(&m.Time, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Fields", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Fields = append(m.Fields, RecordedSpan_LogRecord_Field{})
			if err := m.Fields[len(m.Fields)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRecordedSpan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RecordedSpan_LogRecord_Field) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRecordedSpan
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Field: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Field: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRecordedSpan(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRecordedSpan
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRecordedSpan(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRecordedSpan
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRecordedSpan
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRecordedSpan
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRecordedSpan
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRecordedSpan(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRecordedSpan = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRecordedSpan   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("util/tracing/recorded_span.proto", fileDescriptorRecordedSpan) }

var fileDescriptorRecordedSpan = []byte{
	// 536 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x52, 0x4f, 0x6f, 0xd3, 0x3e,
	0x18, 0x9e, 0xd7, 0xb4, 0x69, 0xde, 0x56, 0x3f, 0x4d, 0x56, 0xf5, 0x53, 0x16, 0xa1, 0xa4, 0x80,
	0x84, 0x2a, 0x0e, 0x8e, 0x18, 0x08, 0xa6, 0x5d, 0x10, 0xa1, 0x20, 0x2a, 0x38, 0x20, 0xd3, 0x13,
	0x97, 0xca, 0x6d, 0x3c, 0x13, 0xad, 0x8b, 0xa3, 0xc4, 0x45, 0xea, 0x8d, 0x8f, 0xb0, 0x23, 0x1f,
	0xa9, 0xe2, 0xc4, 0x91, 0x53, 0x81, 0xf0, 0x45, 0x90, 0x9d, 0xb4, 0x9b, 0x36, 0x0e, 0xeb, 0x2d,
	0xaf, 0x9f, 0x3f, 0x79, 0xde, 0xc7, 0x86, 0xfe, 0x42, 0x25, 0xf3, 0x50, 0xe5, 0x6c, 0x96, 0xa4,
	0x22, 0xcc, 0xf9, 0x4c, 0xe6, 0x31, 0x8f, 0x27, 0x45, 0xc6, 0x52, 0x92, 0xe5, 0x52, 0x49, 0xfc,
	0xff, 0x4c, 0xce, 0xce, 0x72, 0xc9, 0x66, 0x9f, 0x88, 0xe6, 0x92, 0x9a, 0xeb, 0xf5, 0x84, 0x14,
	0xd2, 0x50, 0x42, 0xfd, 0x55, 0xb1, 0xbd, 0x43, 0x21, 0xa5, 0x98, 0xf3, 0xd0, 0x4c, 0xd3, 0xc5,
	0x69, 0xc8, 0xd2, 0x65, 0x0d, 0x05, 0xd7, 0x21, 0x95, 0x9c, 0xf3, 0x42, 0xb1, 0xf3, 0xac, 0x26,
	0xf8, 0xd7, 0x09, 0xf1, 0x22, 0x67, 0x2a, 0x91, 0x75, 0x92, 0x7b, 0x5f, 0x6c, 0xe8, 0xd2, 0x3a,
	0xe1, 0x87, 0x8c, 0xa5, 0xf8, 0x01, 0xb4, 0x75, 0x1a, 0x3e, 0x49, 0x62, 0x17, 0xf5, 0xd1, 0xc0,
	0x8a, 0x3a, 0xe5, 0x3a, 0xb0, 0xc7, 0xfa, 0x6c, 0x34, 0xa4, 0xb6, 0x01, 0x47, 0x31, 0xbe, 0x0f,
	0xb6, 0x5e, 0x48, 0xd3, 0xf6, 0x0d, 0x0d, 0xca, 0x75, 0xd0, 0xd2, 0x16, 0xa3, 0x21, 0x6d, 0x69,
	0x68, 0x14, 0xe3, 0xa7, 0xf0, 0x5f, 0xc6, 0x72, 0x9e, 0xaa, 0xc9, 0x86, 0xdb, 0x30, 0xdc, 0x83,
	0x72, 0x1d, 0x74, 0xdf, 0x1b, 0xa4, 0x56, 0x74, 0xb3, 0xcb, 0x29, 0xc6, 0x77, 0xc0, 0x91, 0x19,
	0xaf, 0x82, 0xba, 0x56, 0x1f, 0x0d, 0x1c, 0x7a, 0x79, 0x80, 0xdf, 0x82, 0x3d, 0x65, 0x42, 0x30,
	0xc1, 0xdd, 0x66, 0xbf, 0x31, 0xe8, 0x1c, 0x3d, 0x22, 0xff, 0xee, 0x93, 0x5c, 0xdd, 0x8c, 0x44,
	0x95, 0xe6, 0x55, 0xaa, 0xf2, 0x25, 0xdd, 0x38, 0xe0, 0x08, 0x2c, 0xc5, 0x44, 0xe1, 0xb6, 0x8c,
	0x13, 0xb9, 0x95, 0xd3, 0x98, 0x89, 0xa2, 0xb2, 0x31, 0x5a, 0xfc, 0x12, 0xa0, 0x50, 0x2c, 0x57,
	0x13, 0xdd, 0xbe, 0x6b, 0xf7, 0xd1, 0xa0, 0x73, 0xe4, 0x91, 0xaa, 0x79, 0xb2, 0x69, 0x9e, 0x8c,
	0x37, 0x57, 0x13, 0xb5, 0x57, 0xeb, 0x60, 0xef, 0xe2, 0x67, 0x80, 0xa8, 0x63, 0x74, 0x1a, 0xc1,
	0xcf, 0xa1, 0xbd, 0xb9, 0x1b, 0xb7, 0x6d, 0x2c, 0x0e, 0x6f, 0x58, 0x0c, 0x6b, 0x42, 0xe5, 0xf0,
	0x55, 0x3b, 0x6c, 0x45, 0xf8, 0x0d, 0x58, 0x73, 0x29, 0x0a, 0xd7, 0xd9, 0x61, 0x93, 0x77, 0x52,
	0x54, 0x73, 0x64, 0x69, 0x47, 0x6a, 0x1c, 0xf0, 0x43, 0x68, 0x16, 0x8a, 0xa9, 0xc2, 0x05, 0x93,
	0xa3, 0x77, 0x23, 0xc7, 0x8b, 0x74, 0x49, 0x2b, 0x8a, 0x77, 0x02, 0xdd, 0xab, 0xc5, 0xe2, 0x03,
	0x68, 0x9c, 0xf1, 0xa5, 0x79, 0x3a, 0x0e, 0xd5, 0x9f, 0xb8, 0x07, 0xcd, 0xcf, 0x6c, 0xbe, 0xe0,
	0xe6, 0x9d, 0x38, 0xb4, 0x1a, 0x4e, 0xf6, 0x8f, 0x91, 0xf7, 0x0c, 0x9c, 0x6d, 0x95, 0x3b, 0x09,
	0xbf, 0x21, 0x70, 0xb6, 0xd1, 0xf1, 0x31, 0x58, 0xa6, 0x78, 0xb4, 0x43, 0xf1, 0x46, 0x81, 0x29,
	0xb4, 0x4e, 0x13, 0x3e, 0x8f, 0x0b, 0x77, 0xdf, 0x94, 0xf6, 0x64, 0xb7, 0xd2, 0xc8, 0x6b, 0x2d,
	0xae, 0xab, 0xab, 0x9d, 0xbc, 0x10, 0x9a, 0xe6, 0xf8, 0xb6, 0x0b, 0x45, 0x77, 0x57, 0xbf, 0xfd,
	0xbd, 0x55, 0xe9, 0xa3, 0xef, 0xa5, 0x8f, 0x7e, 0x94, 0x3e, 0xfa, 0x55, 0xfa, 0xe8, 0xe2, 0x8f,
	0xbf, 0xf7, 0xd1, 0xae, 0x7f, 0x3f, 0x6d, 0x99, 0x5d, 0x1e, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff,
	0xae, 0x03, 0xc9, 0x38, 0x5a, 0x04, 0x00, 0x00,
}
