/* pattern-selector.c generated by valac 0.46.3, the Vala compiler
 * generated from pattern-selector.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define PASANG_TYPE_PATTERN_SELECTOR (pasang_pattern_selector_get_type ())
#define PASANG_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelector))
#define PASANG_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))
#define PASANG_IS_PATTERN_SELECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_IS_PATTERN_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN_SELECTOR))
#define PASANG_PATTERN_SELECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelectorClass))

typedef struct _PasangPatternSelector PasangPatternSelector;
typedef struct _PasangPatternSelectorClass PasangPatternSelectorClass;
typedef struct _PasangPatternSelectorPrivate PasangPatternSelectorPrivate;

#define PASANG_TYPE_PATTERN (pasang_pattern_get_type ())
#define PASANG_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_PATTERN, PasangPattern))
#define PASANG_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_PATTERN, PasangPatternClass))
#define PASANG_IS_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_PATTERN))
#define PASANG_IS_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_PATTERN))
#define PASANG_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_PATTERN, PasangPatternClass))

typedef struct _PasangPattern PasangPattern;
typedef struct _PasangPatternClass PasangPatternClass;

#define PASANG_TYPE_RANDOM_PATTERN (pasang_random_pattern_get_type ())
#define PASANG_RANDOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPattern))
#define PASANG_RANDOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPatternClass))
#define PASANG_IS_RANDOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_RANDOM_PATTERN))
#define PASANG_IS_RANDOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_RANDOM_PATTERN))
#define PASANG_RANDOM_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_RANDOM_PATTERN, PasangRandomPatternClass))

typedef struct _PasangRandomPattern PasangRandomPattern;
typedef struct _PasangRandomPatternClass PasangRandomPatternClass;
enum  {
	PASANG_PATTERN_SELECTOR_0_PROPERTY,
	PASANG_PATTERN_SELECTOR_NUM_PROPERTIES
};
static GParamSpec* pasang_pattern_selector_properties[PASANG_PATTERN_SELECTOR_NUM_PROPERTIES];
#define _pasang_pattern_unref0(var) ((var == NULL) ? NULL : (var = (pasang_pattern_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define PASANG_TYPE_CUSTOM_PATTERN (pasang_custom_pattern_get_type ())
#define PASANG_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPattern))
#define PASANG_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))
#define PASANG_IS_CUSTOM_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_IS_CUSTOM_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_CUSTOM_PATTERN))
#define PASANG_CUSTOM_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_CUSTOM_PATTERN, PasangCustomPatternClass))

typedef struct _PasangCustomPattern PasangCustomPattern;
typedef struct _PasangCustomPatternClass PasangCustomPatternClass;

#define PASANG_TYPE_BLANK_PATTERN (pasang_blank_pattern_get_type ())
#define PASANG_BLANK_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_BLANK_PATTERN, PasangBlankPattern))
#define PASANG_BLANK_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_BLANK_PATTERN, PasangBlankPatternClass))
#define PASANG_IS_BLANK_PATTERN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_BLANK_PATTERN))
#define PASANG_IS_BLANK_PATTERN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_BLANK_PATTERN))
#define PASANG_BLANK_PATTERN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_BLANK_PATTERN, PasangBlankPatternClass))

typedef struct _PasangBlankPattern PasangBlankPattern;
typedef struct _PasangBlankPatternClass PasangBlankPatternClass;
typedef struct _Block7Data Block7Data;
typedef struct _PasangPatternPrivate PasangPatternPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PasangPatternSelectorCoolDownData PasangPatternSelectorCoolDownData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL,
	PASANG_PATTERN_SELECTOR_NUM_SIGNALS
};
static guint pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangPatternSelector {
	GtkScrolledWindow parent_instance;
	PasangPatternSelectorPrivate * priv;
};

struct _PasangPatternSelectorClass {
	GtkScrolledWindowClass parent_class;
};

struct _PasangPatternSelectorPrivate {
	PasangPattern** core_patterns;
	gint core_patterns_length1;
	gint _core_patterns_size_;
	PasangPattern** patterns;
	gint patterns_length1;
	gint _patterns_size_;
	PasangRandomPattern* recent_pattern;
	gint cooling_ticket;
	gboolean responsive;
	gboolean ignore_signal;
	GtkRadioButton* invisible_button;
	GtkFlowBox* pattern_box;
	gint prev_dot_width;
};

struct _Block7Data {
	int _ref_count_;
	PasangPatternSelector* self;
	gint index;
};

struct _PasangPattern {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PasangPatternPrivate * priv;
	gchar* name;
	gchar* dots;
	guint8* pixbuf_data;
	gint pixbuf_data_length1;
	gint _pixbuf_data_size_;
	GdkPixbuf* pixbuf;
	gint dot_width;
	GtkRadioButton* button;
};

struct _PasangPatternClass {
	GTypeClass parent_class;
	void (*finalize) (PasangPattern *self);
	void (*background) (PasangPattern* self, gint n, gint x, gint y);
	void (*create_pixbuf) (PasangPattern* self);
};

struct _PasangPatternSelectorCoolDownData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PasangPatternSelector* self;
	PasangRandomPattern* pattern;
	GTimer* timer;
	GTimer* _tmp0_;
	gint my_cooling_ticket;
	gdouble temperature;
	GTimer* _tmp1_;
	PasangRandomPattern* _tmp2_;
	gboolean _tmp3_;
	PasangRandomPattern* _tmp4_;
	const gchar* _tmp5_;
};

static gint PasangPatternSelector_private_offset;
static gpointer pasang_pattern_selector_parent_class = NULL;

GType pasang_pattern_selector_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPatternSelector, g_object_unref)
gpointer pasang_pattern_ref (gpointer instance);
void pasang_pattern_unref (gpointer instance);
GParamSpec* pasang_param_spec_pattern (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void pasang_value_set_pattern (GValue* value,
                               gpointer v_object);
void pasang_value_take_pattern (GValue* value,
                                gpointer v_object);
gpointer pasang_value_get_pattern (const GValue* value);
GType pasang_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangPattern, pasang_pattern_unref)
GType pasang_random_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangRandomPattern, pasang_pattern_unref)
PasangPattern* pasang_pattern_new (const gchar* name,
                                   const gchar* dots);
PasangPattern* pasang_pattern_construct (GType object_type,
                                         const gchar* name,
                                         const gchar* dots);
PasangRandomPattern* pasang_random_pattern_new (const gchar* name,
                                                const gchar* spec);
PasangRandomPattern* pasang_random_pattern_construct (GType object_type,
                                                      const gchar* name,
                                                      const gchar* spec);
PasangPatternSelector* pasang_pattern_selector_new (void);
PasangPatternSelector* pasang_pattern_selector_construct (GType object_type);
static void pasang_pattern_selector_add_pattern (PasangPatternSelector* self,
                                          PasangPattern* pattern);
static void pasang_pattern_selector_real_size_allocate (GtkWidget* base,
                                                 GtkAllocation* allocation);
#define PASANG_BOARD_WIDTH 13
void pasang_pattern_set_dot_width (PasangPattern* self,
                                   gint width);
void pasang_pattern_selector_add_patterns (PasangPatternSelector* self,
                                           PasangPattern** additional_patterns,
                                           gint additional_patterns_length1);
PasangBlankPattern* pasang_blank_pattern_new (void);
PasangBlankPattern* pasang_blank_pattern_construct (GType object_type);
GType pasang_custom_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangCustomPattern, pasang_pattern_unref)
GType pasang_blank_pattern_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangBlankPattern, pasang_pattern_unref)
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda23_ (Block7Data* _data7_,
                  GtkButton* s);
static void pasang_pattern_selector_on_selection (PasangPatternSelector* self,
                                           gint pattern_num);
static void ___lambda23__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _vala_array_add19 (PasangPattern** * array,
                        int* length,
                        int* size,
                        PasangPattern* value);
void pasang_pattern_selector_random (PasangPatternSelector* self);
void pasang_pattern_selector_unselect (PasangPatternSelector* self);
static void pasang_pattern_selector_scroll_to_view (PasangPatternSelector* self,
                                             GtkWidget* widget);
void pasang_random_pattern_next_random (PasangRandomPattern* self);
static void pasang_pattern_selector_cool_down (PasangPatternSelector* self,
                                        PasangRandomPattern* pattern,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void pasang_pattern_selector_cool_down_finish (PasangPatternSelector* self,
                                               GAsyncResult* _res_);
static void pasang_pattern_selector_cool_down_data_free (gpointer _data);
static gboolean pasang_pattern_selector_cool_down_co (PasangPatternSelectorCoolDownData* _data_);
void pasang_random_pattern_set_temperature (PasangRandomPattern* self,
                                            gdouble value);
void pasang_util_wait_async (gint millisecs,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
void pasang_util_wait_finish (GAsyncResult* _res_);
static void pasang_pattern_selector_cool_down_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
void pasang_pattern_selector_set_sensitive (PasangPatternSelector* self,
                                            gboolean b);
void pasang_pattern_selector_highlight_selected (PasangPatternSelector* self);
void pasang_pattern_selector_find_and_click (PasangPatternSelector* self,
                                             const gchar* dots);
static void pasang_pattern_selector_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
pasang_pattern_selector_get_instance_private (PasangPatternSelector* self)
{
	return G_STRUCT_MEMBER_P (self, PasangPatternSelector_private_offset);
}

static gpointer
_pasang_pattern_ref0 (gpointer self)
{
#line 313 "pattern-selector.vala"
	return self ? pasang_pattern_ref (self) : NULL;
#line 287 "pattern-selector.c"
}

PasangPatternSelector*
pasang_pattern_selector_construct (GType object_type)
{
	PasangPatternSelector * self = NULL;
	PasangPattern** _tmp0_;
	GtkFlowBox* _tmp1_;
	GtkFlowBox* _tmp2_;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkFlowBox* _tmp5_;
	GtkFlowBox* _tmp6_;
	GtkFlowBox* _tmp7_;
	GtkFlowBox* _tmp8_;
	GtkRadioButton* _tmp9_;
	PasangPattern** _tmp10_;
	gint _tmp10__length1;
#line 304 "pattern-selector.vala"
	self = (PasangPatternSelector*) g_object_new (object_type, NULL);
#line 305 "pattern-selector.vala"
	_tmp0_ = g_new0 (PasangPattern*, 0 + 1);
#line 305 "pattern-selector.vala"
	self->priv->patterns = (_vala_array_free (self->priv->patterns, self->priv->patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 305 "pattern-selector.vala"
	self->priv->patterns = _tmp0_;
#line 305 "pattern-selector.vala"
	self->priv->patterns_length1 = 0;
#line 305 "pattern-selector.vala"
	self->priv->_patterns_size_ = self->priv->patterns_length1;
#line 306 "pattern-selector.vala"
	_tmp1_ = (GtkFlowBox*) gtk_flow_box_new ();
#line 306 "pattern-selector.vala"
	g_object_ref_sink (_tmp1_);
#line 306 "pattern-selector.vala"
	_g_object_unref0 (self->priv->pattern_box);
#line 306 "pattern-selector.vala"
	self->priv->pattern_box = _tmp1_;
#line 307 "pattern-selector.vala"
	_tmp2_ = self->priv->pattern_box;
#line 307 "pattern-selector.vala"
	_tmp3_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
#line 307 "pattern-selector.vala"
	_tmp4_ = _tmp3_;
#line 307 "pattern-selector.vala"
	gtk_flow_box_set_vadjustment (_tmp2_, _tmp4_);
#line 308 "pattern-selector.vala"
	_tmp5_ = self->priv->pattern_box;
#line 308 "pattern-selector.vala"
	gtk_flow_box_set_selection_mode (_tmp5_, GTK_SELECTION_NONE);
#line 309 "pattern-selector.vala"
	_tmp6_ = self->priv->pattern_box;
#line 309 "pattern-selector.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
#line 310 "pattern-selector.vala"
	_tmp7_ = self->priv->pattern_box;
#line 310 "pattern-selector.vala"
	gtk_flow_box_set_max_children_per_line (_tmp7_, (guint) 10);
#line 311 "pattern-selector.vala"
	_tmp8_ = self->priv->pattern_box;
#line 311 "pattern-selector.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp8_);
#line 312 "pattern-selector.vala"
	_tmp9_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
#line 312 "pattern-selector.vala"
	g_object_ref_sink (_tmp9_);
#line 312 "pattern-selector.vala"
	_g_object_unref0 (self->priv->invisible_button);
#line 312 "pattern-selector.vala"
	self->priv->invisible_button = _tmp9_;
#line 313 "pattern-selector.vala"
	_tmp10_ = self->priv->core_patterns;
#line 313 "pattern-selector.vala"
	_tmp10__length1 = self->priv->core_patterns_length1;
#line 362 "pattern-selector.c"
	{
		PasangPattern** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 313 "pattern-selector.vala"
		pattern_collection = _tmp10_;
#line 313 "pattern-selector.vala"
		pattern_collection_length1 = _tmp10__length1;
#line 313 "pattern-selector.vala"
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 374 "pattern-selector.c"
			PasangPattern* _tmp11_;
			PasangPattern* pattern = NULL;
#line 313 "pattern-selector.vala"
			_tmp11_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 313 "pattern-selector.vala"
			pattern = _tmp11_;
#line 381 "pattern-selector.c"
			{
				PasangPattern* _tmp12_;
#line 314 "pattern-selector.vala"
				_tmp12_ = pattern;
#line 314 "pattern-selector.vala"
				pasang_pattern_selector_add_pattern (self, _tmp12_);
#line 313 "pattern-selector.vala"
				_pasang_pattern_unref0 (pattern);
#line 390 "pattern-selector.c"
			}
		}
	}
#line 316 "pattern-selector.vala"
	gtk_scrolled_window_set_policy ((GtkScrolledWindow*) self, GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
#line 304 "pattern-selector.vala"
	return self;
#line 398 "pattern-selector.c"
}

PasangPatternSelector*
pasang_pattern_selector_new (void)
{
#line 304 "pattern-selector.vala"
	return pasang_pattern_selector_construct (PASANG_TYPE_PATTERN_SELECTOR);
#line 406 "pattern-selector.c"
}

static void
pasang_pattern_selector_real_size_allocate (GtkWidget* base,
                                            GtkAllocation* allocation)
{
	PasangPatternSelector * self;
	gint width = 0;
	GtkAllocation _tmp0_;
	gint dot_width = 0;
	GtkAllocation _tmp4_;
#line 326 "pattern-selector.vala"
	self = (PasangPatternSelector*) base;
#line 326 "pattern-selector.vala"
	g_return_if_fail (allocation != NULL);
#line 327 "pattern-selector.vala"
	_tmp0_ = *allocation;
#line 327 "pattern-selector.vala"
	width = _tmp0_.width;
#line 329 "pattern-selector.vala"
	dot_width = CLAMP ((width / 5) / (PASANG_BOARD_WIDTH + 4), 2, 12);
#line 330 "pattern-selector.vala"
	if (dot_width != self->priv->prev_dot_width) {
#line 430 "pattern-selector.c"
		PasangPattern** _tmp1_;
		gint _tmp1__length1;
#line 331 "pattern-selector.vala"
		self->priv->prev_dot_width = dot_width;
#line 332 "pattern-selector.vala"
		_tmp1_ = self->priv->patterns;
#line 332 "pattern-selector.vala"
		_tmp1__length1 = self->priv->patterns_length1;
#line 439 "pattern-selector.c"
		{
			PasangPattern** pattern_collection = NULL;
			gint pattern_collection_length1 = 0;
			gint _pattern_collection_size_ = 0;
			gint pattern_it = 0;
#line 332 "pattern-selector.vala"
			pattern_collection = _tmp1_;
#line 332 "pattern-selector.vala"
			pattern_collection_length1 = _tmp1__length1;
#line 332 "pattern-selector.vala"
			for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 451 "pattern-selector.c"
				PasangPattern* _tmp2_;
				PasangPattern* pattern = NULL;
#line 332 "pattern-selector.vala"
				_tmp2_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 332 "pattern-selector.vala"
				pattern = _tmp2_;
#line 458 "pattern-selector.c"
				{
					PasangPattern* _tmp3_;
#line 333 "pattern-selector.vala"
					_tmp3_ = pattern;
#line 333 "pattern-selector.vala"
					pasang_pattern_set_dot_width (_tmp3_, dot_width);
#line 332 "pattern-selector.vala"
					_pasang_pattern_unref0 (pattern);
#line 467 "pattern-selector.c"
				}
			}
		}
	}
#line 336 "pattern-selector.vala"
	_tmp4_ = *allocation;
#line 336 "pattern-selector.vala"
	GTK_WIDGET_CLASS (pasang_pattern_selector_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_scrolled_window_get_type (), GtkScrolledWindow), &_tmp4_);
#line 476 "pattern-selector.c"
}

/**
     * Add custom patterns, replacing any previous ones.
     */
void
pasang_pattern_selector_add_patterns (PasangPatternSelector* self,
                                      PasangPattern** additional_patterns,
                                      gint additional_patterns_length1)
{
	PasangPattern** _tmp9_;
	gint _tmp9__length1;
	PasangBlankPattern* _tmp12_;
	PasangBlankPattern* _tmp13_;
	GtkFlowBox* _tmp14_;
#line 342 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 494 "pattern-selector.c"
	{
		gint i = 0;
		PasangPattern** _tmp0_;
		gint _tmp0__length1;
#line 344 "pattern-selector.vala"
		_tmp0_ = self->priv->core_patterns;
#line 344 "pattern-selector.vala"
		_tmp0__length1 = self->priv->core_patterns_length1;
#line 344 "pattern-selector.vala"
		i = _tmp0__length1;
#line 505 "pattern-selector.c"
		{
			gboolean _tmp1_ = FALSE;
#line 344 "pattern-selector.vala"
			_tmp1_ = TRUE;
#line 344 "pattern-selector.vala"
			while (TRUE) {
#line 512 "pattern-selector.c"
				PasangPattern** _tmp3_;
				gint _tmp3__length1;
				GtkFlowBox* _tmp4_;
				GtkFlowBox* _tmp5_;
				PasangPattern** _tmp6_;
				gint _tmp6__length1;
				GtkFlowBoxChild* _tmp7_;
				PasangPattern** _tmp8_;
				gint _tmp8__length1;
#line 344 "pattern-selector.vala"
				if (!_tmp1_) {
#line 524 "pattern-selector.c"
					gint _tmp2_;
#line 344 "pattern-selector.vala"
					_tmp2_ = i;
#line 344 "pattern-selector.vala"
					i = _tmp2_ + 1;
#line 530 "pattern-selector.c"
				}
#line 344 "pattern-selector.vala"
				_tmp1_ = FALSE;
#line 344 "pattern-selector.vala"
				_tmp3_ = self->priv->patterns;
#line 344 "pattern-selector.vala"
				_tmp3__length1 = self->priv->patterns_length1;
#line 344 "pattern-selector.vala"
				if (!(i < _tmp3__length1)) {
#line 344 "pattern-selector.vala"
					break;
#line 542 "pattern-selector.c"
				}
#line 346 "pattern-selector.vala"
				_tmp4_ = self->priv->pattern_box;
#line 346 "pattern-selector.vala"
				_tmp5_ = self->priv->pattern_box;
#line 346 "pattern-selector.vala"
				_tmp6_ = self->priv->core_patterns;
#line 346 "pattern-selector.vala"
				_tmp6__length1 = self->priv->core_patterns_length1;
#line 346 "pattern-selector.vala"
				_tmp7_ = gtk_flow_box_get_child_at_index (_tmp5_, _tmp6__length1);
#line 346 "pattern-selector.vala"
				gtk_container_remove ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp7_);
#line 347 "pattern-selector.vala"
				_tmp8_ = self->priv->patterns;
#line 347 "pattern-selector.vala"
				_tmp8__length1 = self->priv->patterns_length1;
#line 347 "pattern-selector.vala"
				_pasang_pattern_unref0 (_tmp8_[i]);
#line 347 "pattern-selector.vala"
				_tmp8_[i] = NULL;
#line 564 "pattern-selector.c"
			}
		}
	}
#line 349 "pattern-selector.vala"
	_tmp9_ = self->priv->core_patterns;
#line 349 "pattern-selector.vala"
	_tmp9__length1 = self->priv->core_patterns_length1;
#line 349 "pattern-selector.vala"
	self->priv->patterns_length1 = _tmp9__length1;
#line 574 "pattern-selector.c"
	{
		PasangPattern** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 352 "pattern-selector.vala"
		pattern_collection = additional_patterns;
#line 352 "pattern-selector.vala"
		pattern_collection_length1 = additional_patterns_length1;
#line 352 "pattern-selector.vala"
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 586 "pattern-selector.c"
			PasangPattern* _tmp10_;
			PasangPattern* pattern = NULL;
#line 352 "pattern-selector.vala"
			_tmp10_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 352 "pattern-selector.vala"
			pattern = _tmp10_;
#line 593 "pattern-selector.c"
			{
				PasangPattern* _tmp11_;
#line 353 "pattern-selector.vala"
				_tmp11_ = pattern;
#line 353 "pattern-selector.vala"
				pasang_pattern_selector_add_pattern (self, _tmp11_);
#line 352 "pattern-selector.vala"
				_pasang_pattern_unref0 (pattern);
#line 602 "pattern-selector.c"
			}
		}
	}
#line 357 "pattern-selector.vala"
	_tmp12_ = pasang_blank_pattern_new ();
#line 357 "pattern-selector.vala"
	_tmp13_ = _tmp12_;
#line 357 "pattern-selector.vala"
	pasang_pattern_selector_add_pattern (self, (PasangPattern*) _tmp13_);
#line 357 "pattern-selector.vala"
	_pasang_pattern_unref0 (_tmp13_);
#line 359 "pattern-selector.vala"
	_tmp14_ = self->priv->pattern_box;
#line 359 "pattern-selector.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp14_);
#line 618 "pattern-selector.c"
}

/**
     * Add pattern to patterns
     * Initialise and add pattern.button to pattern_box
     */
static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 366 "pattern-selector.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 366 "pattern-selector.vala"
	return _data7_;
#line 632 "pattern-selector.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 366 "pattern-selector.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 642 "pattern-selector.c"
		PasangPatternSelector* self;
#line 366 "pattern-selector.vala"
		self = _data7_->self;
#line 366 "pattern-selector.vala"
		_g_object_unref0 (self);
#line 366 "pattern-selector.vala"
		g_slice_free (Block7Data, _data7_);
#line 650 "pattern-selector.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 367 "pattern-selector.vala"
	return self ? g_object_ref (self) : NULL;
#line 659 "pattern-selector.c"
}

static void
__lambda23_ (Block7Data* _data7_,
             GtkButton* s)
{
	PasangPatternSelector* self;
#line 379 "pattern-selector.vala"
	self = _data7_->self;
#line 379 "pattern-selector.vala"
	g_return_if_fail (s != NULL);
#line 379 "pattern-selector.vala"
	pasang_pattern_selector_on_selection (self, _data7_->index);
#line 673 "pattern-selector.c"
}

static void
___lambda23__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 379 "pattern-selector.vala"
	__lambda23_ (self, _sender);
#line 682 "pattern-selector.c"
}

static void
_vala_array_add19 (PasangPattern** * array,
                   int* length,
                   int* size,
                   PasangPattern* value)
{
#line 384 "pattern-selector.vala"
	if ((*length) == (*size)) {
#line 384 "pattern-selector.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 384 "pattern-selector.vala"
		*array = g_renew (PasangPattern*, *array, (*size) + 1);
#line 697 "pattern-selector.c"
	}
#line 384 "pattern-selector.vala"
	(*array)[(*length)++] = value;
#line 384 "pattern-selector.vala"
	(*array)[*length] = NULL;
#line 703 "pattern-selector.c"
}

static void
pasang_pattern_selector_add_pattern (PasangPatternSelector* self,
                                     PasangPattern* pattern)
{
	Block7Data* _data7_;
	GtkRadioButton* button = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	PasangPattern** _tmp2_;
	gint _tmp2__length1;
	GtkRadioButton* _tmp5_;
	GtkRadioButton* _tmp6_;
	GSList* _tmp7_;
	GtkRadioButton* _tmp8_;
	GtkRadioButton* _tmp9_;
	GtkRadioButton* _tmp10_;
	GtkRadioButton* _tmp11_;
	GtkRadioButton* _tmp12_;
	GtkRadioButton* _tmp13_;
	PasangPattern** _tmp14_;
	gint _tmp14__length1;
	GtkRadioButton* _tmp15_;
	gchar* _tmp16_ = NULL;
	GtkRadioButton* _tmp24_;
	PasangPattern** _tmp25_;
	gint _tmp25__length1;
	PasangPattern* _tmp26_;
	GtkFlowBox* _tmp27_;
	GtkRadioButton* _tmp28_;
#line 366 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 366 "pattern-selector.vala"
	g_return_if_fail (pattern != NULL);
#line 366 "pattern-selector.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 366 "pattern-selector.vala"
	_data7_->_ref_count_ = 1;
#line 366 "pattern-selector.vala"
	_data7_->self = g_object_ref (self);
#line 367 "pattern-selector.vala"
	_tmp0_ = pattern->button;
#line 367 "pattern-selector.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 367 "pattern-selector.vala"
	button = _tmp1_;
#line 368 "pattern-selector.vala"
	_tmp2_ = self->priv->patterns;
#line 368 "pattern-selector.vala"
	_tmp2__length1 = self->priv->patterns_length1;
#line 368 "pattern-selector.vala"
	if (_tmp2__length1 > 0) {
#line 757 "pattern-selector.c"
		PasangPattern** _tmp3_;
		gint _tmp3__length1;
		PasangPattern* _tmp4_;
#line 368 "pattern-selector.vala"
		_tmp3_ = self->priv->patterns;
#line 368 "pattern-selector.vala"
		_tmp3__length1 = self->priv->patterns_length1;
#line 368 "pattern-selector.vala"
		_tmp4_ = _tmp3_[0];
#line 368 "pattern-selector.vala"
		pasang_pattern_set_dot_width (pattern, _tmp4_->dot_width);
#line 769 "pattern-selector.c"
	}
#line 369 "pattern-selector.vala"
	_tmp5_ = button;
#line 369 "pattern-selector.vala"
	_tmp6_ = self->priv->invisible_button;
#line 369 "pattern-selector.vala"
	_tmp7_ = gtk_radio_button_get_group (_tmp6_);
#line 369 "pattern-selector.vala"
	gtk_radio_button_set_group (_tmp5_, _tmp7_);
#line 370 "pattern-selector.vala"
	_tmp8_ = button;
#line 370 "pattern-selector.vala"
	gtk_toggle_button_set_mode ((GtkToggleButton*) _tmp8_, FALSE);
#line 371 "pattern-selector.vala"
	_tmp9_ = button;
#line 371 "pattern-selector.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp9_, (guint) 0);
#line 372 "pattern-selector.vala"
	_tmp10_ = button;
#line 372 "pattern-selector.vala"
	gtk_button_set_relief ((GtkButton*) _tmp10_, GTK_RELIEF_NONE);
#line 373 "pattern-selector.vala"
	_tmp11_ = button;
#line 373 "pattern-selector.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
#line 374 "pattern-selector.vala"
	_tmp12_ = button;
#line 374 "pattern-selector.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
#line 375 "pattern-selector.vala"
	_tmp13_ = button;
#line 375 "pattern-selector.vala"
	g_object_set ((GtkWidget*) _tmp13_, "expand", FALSE, NULL);
#line 378 "pattern-selector.vala"
	_tmp14_ = self->priv->patterns;
#line 378 "pattern-selector.vala"
	_tmp14__length1 = self->priv->patterns_length1;
#line 378 "pattern-selector.vala"
	_data7_->index = _tmp14__length1;
#line 379 "pattern-selector.vala"
	_tmp15_ = button;
#line 379 "pattern-selector.vala"
	g_signal_connect_data ((GtkButton*) _tmp15_, "clicked", (GCallback) ___lambda23__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 381 "pattern-selector.vala"
	if (PASANG_IS_RANDOM_PATTERN (pattern)) {
#line 815 "pattern-selector.c"
		const gchar* _tmp17_;
		gchar* _tmp18_;
#line 381 "pattern-selector.vala"
		_tmp17_ = pattern->name;
#line 381 "pattern-selector.vala"
		_tmp18_ = g_strdup_printf (_ ("Random Pattern: %s"), _ (_tmp17_));
#line 381 "pattern-selector.vala"
		_g_free0 (_tmp16_);
#line 381 "pattern-selector.vala"
		_tmp16_ = _tmp18_;
#line 826 "pattern-selector.c"
	} else {
		gchar* _tmp19_ = NULL;
		gchar* _tmp23_;
#line 382 "pattern-selector.vala"
		if (PASANG_IS_CUSTOM_PATTERN (pattern)) {
#line 832 "pattern-selector.c"
			gchar* _tmp20_;
#line 382 "pattern-selector.vala"
			_tmp20_ = g_strdup (_ ("Custom Pattern"));
#line 382 "pattern-selector.vala"
			_g_free0 (_tmp19_);
#line 382 "pattern-selector.vala"
			_tmp19_ = _tmp20_;
#line 840 "pattern-selector.c"
		} else {
			const gchar* _tmp21_;
			gchar* _tmp22_;
#line 383 "pattern-selector.vala"
			_tmp21_ = pattern->name;
#line 383 "pattern-selector.vala"
			_tmp22_ = g_strdup_printf (_ ("Pattern: \"%s\""), _ (_tmp21_));
#line 383 "pattern-selector.vala"
			_g_free0 (_tmp19_);
#line 383 "pattern-selector.vala"
			_tmp19_ = _tmp22_;
#line 852 "pattern-selector.c"
		}
#line 382 "pattern-selector.vala"
		_tmp23_ = g_strdup (_tmp19_);
#line 382 "pattern-selector.vala"
		_g_free0 (_tmp16_);
#line 382 "pattern-selector.vala"
		_tmp16_ = _tmp23_;
#line 381 "pattern-selector.vala"
		_g_free0 (_tmp19_);
#line 862 "pattern-selector.c"
	}
#line 380 "pattern-selector.vala"
	_tmp24_ = button;
#line 380 "pattern-selector.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp24_, _tmp16_);
#line 384 "pattern-selector.vala"
	_tmp25_ = self->priv->patterns;
#line 384 "pattern-selector.vala"
	_tmp25__length1 = self->priv->patterns_length1;
#line 384 "pattern-selector.vala"
	_tmp26_ = _pasang_pattern_ref0 (pattern);
#line 384 "pattern-selector.vala"
	_vala_array_add19 (&self->priv->patterns, &self->priv->patterns_length1, &self->priv->_patterns_size_, _tmp26_);
#line 385 "pattern-selector.vala"
	_tmp27_ = self->priv->pattern_box;
#line 385 "pattern-selector.vala"
	_tmp28_ = button;
#line 385 "pattern-selector.vala"
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
#line 366 "pattern-selector.vala"
	_g_free0 (_tmp16_);
#line 366 "pattern-selector.vala"
	_g_object_unref0 (button);
#line 366 "pattern-selector.vala"
	block7_data_unref (_data7_);
#line 366 "pattern-selector.vala"
	_data7_ = NULL;
#line 890 "pattern-selector.c"
}

/**
     * Select a random pattern. This can be a traditional pattern, or a pattern
     * generated by a randomizer, or a custom pattern.
     */
void
pasang_pattern_selector_random (PasangPatternSelector* self)
{
	gint rnd = 0;
	PasangPattern** _tmp0_;
	gint _tmp0__length1;
	PasangPattern* pattern = NULL;
	PasangPattern** _tmp1_;
	gint _tmp1__length1;
	PasangPattern* _tmp2_;
	PasangPattern* _tmp3_;
	PasangPattern* _tmp4_;
	GtkRadioButton* _tmp5_;
	PasangPattern* _tmp6_;
	GtkRadioButton* _tmp7_;
	PasangPattern* _tmp8_;
	PasangPattern* _tmp10_;
	const gchar* _tmp11_;
#line 392 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 394 "pattern-selector.vala"
	_tmp0_ = self->priv->patterns;
#line 394 "pattern-selector.vala"
	_tmp0__length1 = self->priv->patterns_length1;
#line 394 "pattern-selector.vala"
	rnd = (gint) g_random_int_range ((gint32) 0, (gint32) (_tmp0__length1 - 1));
#line 395 "pattern-selector.vala"
	_tmp1_ = self->priv->patterns;
#line 395 "pattern-selector.vala"
	_tmp1__length1 = self->priv->patterns_length1;
#line 395 "pattern-selector.vala"
	_tmp2_ = _tmp1_[rnd];
#line 395 "pattern-selector.vala"
	_tmp3_ = _pasang_pattern_ref0 (_tmp2_);
#line 395 "pattern-selector.vala"
	pattern = _tmp3_;
#line 396 "pattern-selector.vala"
	pasang_pattern_selector_unselect (self);
#line 398 "pattern-selector.vala"
	self->priv->ignore_signal = TRUE;
#line 399 "pattern-selector.vala"
	_tmp4_ = pattern;
#line 399 "pattern-selector.vala"
	_tmp5_ = _tmp4_->button;
#line 399 "pattern-selector.vala"
	gtk_button_clicked ((GtkButton*) _tmp5_);
#line 400 "pattern-selector.vala"
	_tmp6_ = pattern;
#line 400 "pattern-selector.vala"
	_tmp7_ = _tmp6_->button;
#line 400 "pattern-selector.vala"
	pasang_pattern_selector_scroll_to_view (self, (GtkWidget*) _tmp7_);
#line 401 "pattern-selector.vala"
	self->priv->ignore_signal = FALSE;
#line 403 "pattern-selector.vala"
	_tmp8_ = pattern;
#line 403 "pattern-selector.vala"
	if (PASANG_IS_RANDOM_PATTERN (_tmp8_)) {
#line 955 "pattern-selector.c"
		PasangPattern* _tmp9_;
#line 403 "pattern-selector.vala"
		_tmp9_ = pattern;
#line 403 "pattern-selector.vala"
		pasang_random_pattern_next_random (PASANG_IS_RANDOM_PATTERN (_tmp9_) ? ((PasangRandomPattern*) _tmp9_) : NULL);
#line 961 "pattern-selector.c"
	}
#line 404 "pattern-selector.vala"
	_tmp10_ = pattern;
#line 404 "pattern-selector.vala"
	_tmp11_ = _tmp10_->dots;
#line 404 "pattern-selector.vala"
	g_signal_emit (self, pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL], 0, _tmp11_);
#line 392 "pattern-selector.vala"
	_pasang_pattern_unref0 (pattern);
#line 971 "pattern-selector.c"
}

/**
     * Handler for button click.
     */
static void
pasang_pattern_selector_on_selection (PasangPatternSelector* self,
                                      gint pattern_num)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PasangPattern* pattern = NULL;
	PasangPattern** _tmp3_;
	gint _tmp3__length1;
	PasangPattern* _tmp4_;
	PasangPattern* _tmp5_;
	gboolean hot = FALSE;
	PasangPattern* _tmp6_;
	PasangRandomPattern* _tmp7_;
	PasangPattern* _tmp8_;
	PasangRandomPattern* _tmp9_;
	PasangPattern* _tmp10_;
	GtkRadioButton* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	PasangPattern* _tmp14_;
#line 410 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 411 "pattern-selector.vala"
	if (pattern_num >= 0) {
#line 1002 "pattern-selector.c"
		PasangPattern** _tmp1_;
		gint _tmp1__length1;
#line 411 "pattern-selector.vala"
		_tmp1_ = self->priv->patterns;
#line 411 "pattern-selector.vala"
		_tmp1__length1 = self->priv->patterns_length1;
#line 411 "pattern-selector.vala"
		_tmp0_ = pattern_num < _tmp1__length1;
#line 1011 "pattern-selector.c"
	} else {
#line 411 "pattern-selector.vala"
		_tmp0_ = FALSE;
#line 1015 "pattern-selector.c"
	}
#line 411 "pattern-selector.vala"
	_vala_assert (_tmp0_, "pattern_num >= 0 && pattern_num < patterns.length");
#line 412 "pattern-selector.vala"
	if (self->priv->ignore_signal) {
#line 412 "pattern-selector.vala"
		_tmp2_ = TRUE;
#line 1023 "pattern-selector.c"
	} else {
#line 412 "pattern-selector.vala"
		_tmp2_ = !self->priv->responsive;
#line 1027 "pattern-selector.c"
	}
#line 412 "pattern-selector.vala"
	if (_tmp2_) {
#line 412 "pattern-selector.vala"
		return;
#line 1033 "pattern-selector.c"
	}
#line 413 "pattern-selector.vala"
	_tmp3_ = self->priv->patterns;
#line 413 "pattern-selector.vala"
	_tmp3__length1 = self->priv->patterns_length1;
#line 413 "pattern-selector.vala"
	_tmp4_ = _tmp3_[pattern_num];
#line 413 "pattern-selector.vala"
	_tmp5_ = _pasang_pattern_ref0 (_tmp4_);
#line 413 "pattern-selector.vala"
	pattern = _tmp5_;
#line 414 "pattern-selector.vala"
	_tmp6_ = pattern;
#line 414 "pattern-selector.vala"
	_tmp7_ = self->priv->recent_pattern;
#line 414 "pattern-selector.vala"
	hot = _tmp6_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, PASANG_TYPE_PATTERN, PasangPattern);
#line 415 "pattern-selector.vala"
	_tmp8_ = pattern;
#line 415 "pattern-selector.vala"
	_tmp9_ = _pasang_pattern_ref0 (PASANG_IS_RANDOM_PATTERN (_tmp8_) ? ((PasangRandomPattern*) _tmp8_) : NULL);
#line 415 "pattern-selector.vala"
	_pasang_pattern_unref0 (self->priv->recent_pattern);
#line 415 "pattern-selector.vala"
	self->priv->recent_pattern = _tmp9_;
#line 418 "pattern-selector.vala"
	_tmp10_ = pattern;
#line 418 "pattern-selector.vala"
	_tmp11_ = _tmp10_->button;
#line 418 "pattern-selector.vala"
	_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 418 "pattern-selector.vala"
	_tmp13_ = _tmp12_;
#line 418 "pattern-selector.vala"
	if (_tmp13_ == FALSE) {
#line 418 "pattern-selector.vala"
		_pasang_pattern_unref0 (pattern);
#line 418 "pattern-selector.vala"
		return;
#line 1073 "pattern-selector.c"
	}
#line 421 "pattern-selector.vala"
	_tmp14_ = pattern;
#line 421 "pattern-selector.vala"
	if (PASANG_IS_RANDOM_PATTERN (_tmp14_)) {
#line 1079 "pattern-selector.c"
		PasangPattern* _tmp16_;
#line 422 "pattern-selector.vala"
		if (hot) {
#line 1083 "pattern-selector.c"
			PasangPattern* _tmp15_;
#line 422 "pattern-selector.vala"
			_tmp15_ = pattern;
#line 422 "pattern-selector.vala"
			pasang_random_pattern_next_random (PASANG_IS_RANDOM_PATTERN (_tmp15_) ? ((PasangRandomPattern*) _tmp15_) : NULL);
#line 1089 "pattern-selector.c"
		}
#line 423 "pattern-selector.vala"
		_tmp16_ = pattern;
#line 423 "pattern-selector.vala"
		pasang_pattern_selector_cool_down (self, PASANG_IS_RANDOM_PATTERN (_tmp16_) ? ((PasangRandomPattern*) _tmp16_) : NULL, NULL, NULL);
#line 1095 "pattern-selector.c"
	} else {
		PasangPattern* _tmp17_;
#line 426 "pattern-selector.vala"
		_tmp17_ = pattern;
#line 426 "pattern-selector.vala"
		if (PASANG_IS_BLANK_PATTERN (_tmp17_)) {
#line 427 "pattern-selector.vala"
			g_signal_emit (self, pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL], 0, NULL);
#line 1104 "pattern-selector.c"
		} else {
			PasangPattern* _tmp18_;
			const gchar* _tmp19_;
#line 430 "pattern-selector.vala"
			_tmp18_ = pattern;
#line 430 "pattern-selector.vala"
			_tmp19_ = _tmp18_->dots;
#line 430 "pattern-selector.vala"
			g_signal_emit (self, pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL], 0, _tmp19_);
#line 1114 "pattern-selector.c"
		}
	}
#line 410 "pattern-selector.vala"
	_pasang_pattern_unref0 (pattern);
#line 1119 "pattern-selector.c"
}

static void
pasang_pattern_selector_cool_down_data_free (gpointer _data)
{
	PasangPatternSelectorCoolDownData* _data_;
	_data_ = _data;
#line 21 "pattern-selector.vala"
	_pasang_pattern_unref0 (_data_->pattern);
#line 21 "pattern-selector.vala"
	_g_object_unref0 (_data_->self);
#line 21 "pattern-selector.vala"
	g_slice_free (PasangPatternSelectorCoolDownData, _data_);
#line 1133 "pattern-selector.c"
}

static void
pasang_pattern_selector_cool_down (PasangPatternSelector* self,
                                   PasangRandomPattern* pattern,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	PasangPatternSelectorCoolDownData* _data_;
	PasangPatternSelector* _tmp0_;
	PasangRandomPattern* _tmp1_;
#line 21 "pattern-selector.vala"
	_data_ = g_slice_new0 (PasangPatternSelectorCoolDownData);
#line 21 "pattern-selector.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 21 "pattern-selector.vala"
	g_task_set_task_data (_data_->_async_result, _data_, pasang_pattern_selector_cool_down_data_free);
#line 21 "pattern-selector.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 21 "pattern-selector.vala"
	_data_->self = _tmp0_;
#line 21 "pattern-selector.vala"
	_tmp1_ = _pasang_pattern_ref0 (pattern);
#line 21 "pattern-selector.vala"
	_pasang_pattern_unref0 (_data_->pattern);
#line 21 "pattern-selector.vala"
	_data_->pattern = _tmp1_;
#line 21 "pattern-selector.vala"
	pasang_pattern_selector_cool_down_co (_data_);
#line 1163 "pattern-selector.c"
}

static void
pasang_pattern_selector_cool_down_finish (PasangPatternSelector* self,
                                          GAsyncResult* _res_)
{
	PasangPatternSelectorCoolDownData* _data_;
#line 21 "pattern-selector.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 1173 "pattern-selector.c"
}

static void
pasang_pattern_selector_cool_down_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	PasangPatternSelectorCoolDownData* _data_;
#line 450 "pattern-selector.vala"
	_data_ = _user_data_;
#line 450 "pattern-selector.vala"
	_data_->_source_object_ = source_object;
#line 450 "pattern-selector.vala"
	_data_->_res_ = _res_;
#line 450 "pattern-selector.vala"
	pasang_pattern_selector_cool_down_co (_data_);
#line 1190 "pattern-selector.c"
}

static gboolean
pasang_pattern_selector_cool_down_co (PasangPatternSelectorCoolDownData* _data_)
{
#line 434 "pattern-selector.vala"
	switch (_data_->_state_) {
#line 434 "pattern-selector.vala"
		case 0:
#line 1200 "pattern-selector.c"
		goto _state_0;
#line 434 "pattern-selector.vala"
		case 1:
#line 1204 "pattern-selector.c"
		goto _state_1;
		default:
#line 434 "pattern-selector.vala"
		g_assert_not_reached ();
#line 1209 "pattern-selector.c"
	}
	_state_0:
#line 435 "pattern-selector.vala"
	_data_->_tmp0_ = g_timer_new ();
#line 435 "pattern-selector.vala"
	_data_->timer = _data_->_tmp0_;
#line 436 "pattern-selector.vala"
	_data_->self->priv->cooling_ticket = _data_->self->priv->cooling_ticket + 1;
#line 436 "pattern-selector.vala"
	_data_->my_cooling_ticket = _data_->self->priv->cooling_ticket;
#line 437 "pattern-selector.vala"
	while (TRUE) {
#line 438 "pattern-selector.vala"
		_data_->_tmp1_ = _data_->timer;
#line 438 "pattern-selector.vala"
		_data_->temperature = 3.0 - MIN (MAX (g_timer_elapsed (_data_->_tmp1_, NULL), 2.0), 3.0);
#line 439 "pattern-selector.vala"
		_data_->_tmp2_ = _data_->self->priv->recent_pattern;
#line 439 "pattern-selector.vala"
		if (_data_->pattern != _data_->_tmp2_) {
#line 439 "pattern-selector.vala"
			_data_->temperature = (gdouble) 0;
#line 1232 "pattern-selector.c"
		}
#line 440 "pattern-selector.vala"
		pasang_random_pattern_set_temperature (_data_->pattern, _data_->temperature);
#line 442 "pattern-selector.vala"
		if (_data_->temperature == ((gdouble) 0)) {
#line 443 "pattern-selector.vala"
			if (_data_->my_cooling_ticket == _data_->self->priv->cooling_ticket) {
#line 443 "pattern-selector.vala"
				_data_->_tmp4_ = _data_->self->priv->recent_pattern;
#line 443 "pattern-selector.vala"
				_data_->_tmp3_ = _data_->pattern == _data_->_tmp4_;
#line 1244 "pattern-selector.c"
			} else {
#line 443 "pattern-selector.vala"
				_data_->_tmp3_ = FALSE;
#line 1248 "pattern-selector.c"
			}
#line 443 "pattern-selector.vala"
			if (_data_->_tmp3_) {
#line 444 "pattern-selector.vala"
				_pasang_pattern_unref0 (_data_->self->priv->recent_pattern);
#line 444 "pattern-selector.vala"
				_data_->self->priv->recent_pattern = NULL;
#line 445 "pattern-selector.vala"
				_data_->_tmp5_ = ((PasangPattern*) _data_->pattern)->dots;
#line 445 "pattern-selector.vala"
				g_signal_emit (_data_->self, pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL], 0, _data_->_tmp5_);
#line 1260 "pattern-selector.c"
			}
#line 447 "pattern-selector.vala"
			_g_timer_destroy0 (_data_->timer);
#line 447 "pattern-selector.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 447 "pattern-selector.vala"
			if (_data_->_state_ != 0) {
#line 447 "pattern-selector.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 447 "pattern-selector.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1272 "pattern-selector.c"
				}
			}
#line 447 "pattern-selector.vala"
			g_object_unref (_data_->_async_result);
#line 447 "pattern-selector.vala"
			return FALSE;
#line 1279 "pattern-selector.c"
		}
#line 449 "pattern-selector.vala"
		if (_data_->my_cooling_ticket != _data_->self->priv->cooling_ticket) {
#line 449 "pattern-selector.vala"
			_g_timer_destroy0 (_data_->timer);
#line 449 "pattern-selector.vala"
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 449 "pattern-selector.vala"
			if (_data_->_state_ != 0) {
#line 449 "pattern-selector.vala"
				while (!g_task_get_completed (_data_->_async_result)) {
#line 449 "pattern-selector.vala"
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1293 "pattern-selector.c"
				}
			}
#line 449 "pattern-selector.vala"
			g_object_unref (_data_->_async_result);
#line 449 "pattern-selector.vala"
			return FALSE;
#line 1300 "pattern-selector.c"
		}
#line 450 "pattern-selector.vala"
		_data_->_state_ = 1;
#line 450 "pattern-selector.vala"
		pasang_util_wait_async (200, pasang_pattern_selector_cool_down_ready, _data_);
#line 450 "pattern-selector.vala"
		return FALSE;
#line 1308 "pattern-selector.c"
		_state_1:
#line 450 "pattern-selector.vala"
		pasang_util_wait_finish (_data_->_res_);
#line 1312 "pattern-selector.c"
	}
#line 434 "pattern-selector.vala"
	_g_timer_destroy0 (_data_->timer);
#line 434 "pattern-selector.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 434 "pattern-selector.vala"
	if (_data_->_state_ != 0) {
#line 434 "pattern-selector.vala"
		while (!g_task_get_completed (_data_->_async_result)) {
#line 434 "pattern-selector.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1324 "pattern-selector.c"
		}
	}
#line 434 "pattern-selector.vala"
	g_object_unref (_data_->_async_result);
#line 434 "pattern-selector.vala"
	return FALSE;
#line 1331 "pattern-selector.c"
}

/**
     * Unselect all buttons by selecting the invisible one.
     */
void
pasang_pattern_selector_unselect (PasangPatternSelector* self)
{
	GtkRadioButton* _tmp0_;
#line 457 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 458 "pattern-selector.vala"
	self->priv->ignore_signal = TRUE;
#line 459 "pattern-selector.vala"
	_tmp0_ = self->priv->invisible_button;
#line 459 "pattern-selector.vala"
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, TRUE);
#line 460 "pattern-selector.vala"
	self->priv->ignore_signal = FALSE;
#line 1351 "pattern-selector.c"
}

/**
     * Ignore click signals from the user, but not self-clicks.
     */
void
pasang_pattern_selector_set_sensitive (PasangPatternSelector* self,
                                       gboolean b)
{
	PasangPattern** _tmp0_;
	gint _tmp0__length1;
#line 466 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 467 "pattern-selector.vala"
	_pasang_pattern_unref0 (self->priv->recent_pattern);
#line 467 "pattern-selector.vala"
	self->priv->recent_pattern = NULL;
#line 468 "pattern-selector.vala"
	self->priv->responsive = b;
#line 469 "pattern-selector.vala"
	_tmp0_ = self->priv->patterns;
#line 469 "pattern-selector.vala"
	_tmp0__length1 = self->priv->patterns_length1;
#line 1375 "pattern-selector.c"
	{
		PasangPattern** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 469 "pattern-selector.vala"
		pattern_collection = _tmp0_;
#line 469 "pattern-selector.vala"
		pattern_collection_length1 = _tmp0__length1;
#line 469 "pattern-selector.vala"
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 1387 "pattern-selector.c"
			PasangPattern* _tmp1_;
			PasangPattern* pattern = NULL;
#line 469 "pattern-selector.vala"
			_tmp1_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 469 "pattern-selector.vala"
			pattern = _tmp1_;
#line 1394 "pattern-selector.c"
			{
				PasangPattern* _tmp2_;
				GtkRadioButton* _tmp3_;
#line 469 "pattern-selector.vala"
				_tmp2_ = pattern;
#line 469 "pattern-selector.vala"
				_tmp3_ = _tmp2_->button;
#line 469 "pattern-selector.vala"
				gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
#line 469 "pattern-selector.vala"
				_pasang_pattern_unref0 (pattern);
#line 1406 "pattern-selector.c"
			}
		}
	}
}

/**
     * Apply set_sensitive to all child, except the currently selected pattern.
     * This has the effect of highlighting the current selection more prominently
     * then the typical pressed look.
     */
void
pasang_pattern_selector_highlight_selected (PasangPatternSelector* self)
{
	PasangPattern** _tmp0_;
	gint _tmp0__length1;
#line 477 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 478 "pattern-selector.vala"
	_tmp0_ = self->priv->patterns;
#line 478 "pattern-selector.vala"
	_tmp0__length1 = self->priv->patterns_length1;
#line 1428 "pattern-selector.c"
	{
		PasangPattern** pattern_collection = NULL;
		gint pattern_collection_length1 = 0;
		gint _pattern_collection_size_ = 0;
		gint pattern_it = 0;
#line 478 "pattern-selector.vala"
		pattern_collection = _tmp0_;
#line 478 "pattern-selector.vala"
		pattern_collection_length1 = _tmp0__length1;
#line 478 "pattern-selector.vala"
		for (pattern_it = 0; pattern_it < pattern_collection_length1; pattern_it = pattern_it + 1) {
#line 1440 "pattern-selector.c"
			PasangPattern* _tmp1_;
			PasangPattern* pattern = NULL;
#line 478 "pattern-selector.vala"
			_tmp1_ = _pasang_pattern_ref0 (pattern_collection[pattern_it]);
#line 478 "pattern-selector.vala"
			pattern = _tmp1_;
#line 1447 "pattern-selector.c"
			{
				PasangPattern* _tmp2_;
				GtkRadioButton* _tmp3_;
				PasangPattern* _tmp4_;
				GtkRadioButton* _tmp5_;
#line 479 "pattern-selector.vala"
				_tmp2_ = pattern;
#line 479 "pattern-selector.vala"
				_tmp3_ = _tmp2_->button;
#line 479 "pattern-selector.vala"
				_tmp4_ = pattern;
#line 479 "pattern-selector.vala"
				_tmp5_ = _tmp4_->button;
#line 479 "pattern-selector.vala"
				gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_));
#line 478 "pattern-selector.vala"
				_pasang_pattern_unref0 (pattern);
#line 1465 "pattern-selector.c"
			}
		}
	}
}

/**
     * Find a pattern. Set the selection to this pattern.
     * Trigger pattern_changed_signal, even if the pattern is not found.
     */
static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1494 "pattern-selector.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1498 "pattern-selector.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1504 "pattern-selector.c"
	} else {
#line 1481 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1508 "pattern-selector.c"
	}
#line 1481 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1512 "pattern-selector.c"
		gchar* _tmp2_;
#line 1482 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1482 "glib-2.0.vapi"
		result = _tmp2_;
#line 1482 "glib-2.0.vapi"
		return result;
#line 1520 "pattern-selector.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1485 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1485 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1485 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1485 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1485 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1485 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1485 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1485 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1548 "pattern-selector.c"
				goto __catch11_g_regex_error;
			}
#line 1485 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1485 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1485 "glib-2.0.vapi"
			return NULL;
#line 1557 "pattern-selector.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1486 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1486 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1486 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1486 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1571 "pattern-selector.c"
				goto __catch11_g_regex_error;
			}
#line 1486 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1486 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1486 "glib-2.0.vapi"
			return NULL;
#line 1580 "pattern-selector.c"
		}
#line 1486 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1486 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1486 "glib-2.0.vapi"
		result = _tmp10_;
#line 1486 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1486 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1486 "glib-2.0.vapi"
		return result;
#line 1594 "pattern-selector.c"
	}
	goto __finally11;
	__catch11_g_regex_error:
	{
		GError* e = NULL;
#line 1484 "glib-2.0.vapi"
		e = _inner_error0_;
#line 1484 "glib-2.0.vapi"
		_inner_error0_ = NULL;
#line 1488 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1484 "glib-2.0.vapi"
		_g_error_free0 (e);
#line 1608 "pattern-selector.c"
	}
	__finally11:
#line 1484 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1484 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1484 "glib-2.0.vapi"
	return NULL;
#line 1617 "pattern-selector.c"
}

void
pasang_pattern_selector_find_and_click (PasangPatternSelector* self,
                                        const gchar* dots)
{
	gchar* compressed_dots = NULL;
	gchar* _tmp0_;
#line 487 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 487 "pattern-selector.vala"
	g_return_if_fail (dots != NULL);
#line 488 "pattern-selector.vala"
	_tmp0_ = string_replace (dots, " ", "");
#line 488 "pattern-selector.vala"
	compressed_dots = _tmp0_;
#line 1634 "pattern-selector.c"
	{
		gint i = 0;
#line 489 "pattern-selector.vala"
		i = 0;
#line 1639 "pattern-selector.c"
		{
			gboolean _tmp1_ = FALSE;
#line 489 "pattern-selector.vala"
			_tmp1_ = TRUE;
#line 489 "pattern-selector.vala"
			while (TRUE) {
#line 1646 "pattern-selector.c"
				PasangPattern** _tmp3_;
				gint _tmp3__length1;
				gboolean _tmp4_ = FALSE;
				PasangPattern** _tmp5_;
				gint _tmp5__length1;
				PasangPattern* _tmp6_;
#line 489 "pattern-selector.vala"
				if (!_tmp1_) {
#line 1655 "pattern-selector.c"
					gint _tmp2_;
#line 489 "pattern-selector.vala"
					_tmp2_ = i;
#line 489 "pattern-selector.vala"
					i = _tmp2_ + 1;
#line 1661 "pattern-selector.c"
				}
#line 489 "pattern-selector.vala"
				_tmp1_ = FALSE;
#line 489 "pattern-selector.vala"
				_tmp3_ = self->priv->patterns;
#line 489 "pattern-selector.vala"
				_tmp3__length1 = self->priv->patterns_length1;
#line 489 "pattern-selector.vala"
				if (!(i < _tmp3__length1)) {
#line 489 "pattern-selector.vala"
					break;
#line 1673 "pattern-selector.c"
				}
#line 490 "pattern-selector.vala"
				_tmp5_ = self->priv->patterns;
#line 490 "pattern-selector.vala"
				_tmp5__length1 = self->priv->patterns_length1;
#line 490 "pattern-selector.vala"
				_tmp6_ = _tmp5_[i];
#line 490 "pattern-selector.vala"
				if (!PASANG_IS_RANDOM_PATTERN (_tmp6_)) {
#line 1683 "pattern-selector.c"
					PasangPattern** _tmp7_;
					gint _tmp7__length1;
					PasangPattern* _tmp8_;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
#line 490 "pattern-selector.vala"
					_tmp7_ = self->priv->patterns;
#line 490 "pattern-selector.vala"
					_tmp7__length1 = self->priv->patterns_length1;
#line 490 "pattern-selector.vala"
					_tmp8_ = _tmp7_[i];
#line 490 "pattern-selector.vala"
					_tmp9_ = _tmp8_->dots;
#line 490 "pattern-selector.vala"
					_tmp10_ = string_replace (_tmp9_, " ", "");
#line 490 "pattern-selector.vala"
					_tmp11_ = _tmp10_;
#line 490 "pattern-selector.vala"
					_tmp12_ = compressed_dots;
#line 490 "pattern-selector.vala"
					_tmp4_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
#line 490 "pattern-selector.vala"
					_g_free0 (_tmp11_);
#line 1709 "pattern-selector.c"
				} else {
#line 490 "pattern-selector.vala"
					_tmp4_ = FALSE;
#line 1713 "pattern-selector.c"
				}
#line 490 "pattern-selector.vala"
				if (_tmp4_) {
#line 1717 "pattern-selector.c"
					PasangPattern** _tmp13_;
					gint _tmp13__length1;
					PasangPattern* _tmp14_;
					GtkRadioButton* _tmp15_;
					PasangPattern** _tmp16_;
					gint _tmp16__length1;
					PasangPattern* _tmp17_;
					GtkRadioButton* _tmp18_;
#line 492 "pattern-selector.vala"
					self->priv->ignore_signal = TRUE;
#line 493 "pattern-selector.vala"
					_tmp13_ = self->priv->patterns;
#line 493 "pattern-selector.vala"
					_tmp13__length1 = self->priv->patterns_length1;
#line 493 "pattern-selector.vala"
					_tmp14_ = _tmp13_[i];
#line 493 "pattern-selector.vala"
					_tmp15_ = _tmp14_->button;
#line 493 "pattern-selector.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp15_, TRUE);
#line 494 "pattern-selector.vala"
					self->priv->ignore_signal = FALSE;
#line 495 "pattern-selector.vala"
					_tmp16_ = self->priv->patterns;
#line 495 "pattern-selector.vala"
					_tmp16__length1 = self->priv->patterns_length1;
#line 495 "pattern-selector.vala"
					_tmp17_ = _tmp16_[i];
#line 495 "pattern-selector.vala"
					_tmp18_ = _tmp17_->button;
#line 495 "pattern-selector.vala"
					pasang_pattern_selector_scroll_to_view (self, (GtkWidget*) _tmp18_);
#line 496 "pattern-selector.vala"
					break;
#line 1752 "pattern-selector.c"
				}
			}
		}
	}
#line 499 "pattern-selector.vala"
	g_signal_emit (self, pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL], 0, dots);
#line 487 "pattern-selector.vala"
	_g_free0 (compressed_dots);
#line 1761 "pattern-selector.c"
}

/**
     * Scroll the given widget to view. If possible show it at the centre.
     */
static void
pasang_pattern_selector_scroll_to_view (PasangPatternSelector* self,
                                        GtkWidget* widget)
{
	gint middle = 0;
	gint x = 0;
	gint y = 0;
	GtkFlowBox* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkAdjustment* _tmp3_;
	GtkAdjustment* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	GtkAdjustment* _tmp9_;
	GtkAdjustment* _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
#line 505 "pattern-selector.vala"
	g_return_if_fail (self != NULL);
#line 505 "pattern-selector.vala"
	g_return_if_fail (widget != NULL);
#line 506 "pattern-selector.vala"
	middle = gtk_widget_get_allocated_height (widget) / 2;
#line 508 "pattern-selector.vala"
	_tmp0_ = self->priv->pattern_box;
#line 508 "pattern-selector.vala"
	gtk_widget_translate_coordinates (widget, (GtkWidget*) _tmp0_, 0, middle, &_tmp1_, &_tmp2_);
#line 508 "pattern-selector.vala"
	x = _tmp1_;
#line 508 "pattern-selector.vala"
	y = _tmp2_;
#line 509 "pattern-selector.vala"
	_tmp3_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
#line 509 "pattern-selector.vala"
	_tmp4_ = _tmp3_;
#line 509 "pattern-selector.vala"
	_tmp5_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
#line 509 "pattern-selector.vala"
	_tmp6_ = _tmp5_;
#line 509 "pattern-selector.vala"
	_tmp7_ = gtk_adjustment_get_page_size (_tmp6_);
#line 509 "pattern-selector.vala"
	_tmp8_ = _tmp7_;
#line 509 "pattern-selector.vala"
	_tmp9_ = gtk_scrolled_window_get_vadjustment ((GtkScrolledWindow*) self);
#line 509 "pattern-selector.vala"
	_tmp10_ = _tmp9_;
#line 509 "pattern-selector.vala"
	_tmp11_ = gtk_adjustment_get_page_size (_tmp10_);
#line 509 "pattern-selector.vala"
	_tmp12_ = _tmp11_;
#line 509 "pattern-selector.vala"
	gtk_adjustment_clamp_page (_tmp4_, y - (_tmp8_ / 2), y + (_tmp12_ / 2));
#line 1823 "pattern-selector.c"
}

static void
pasang_pattern_selector_class_init (PasangPatternSelectorClass * klass,
                                    gpointer klass_data)
{
#line 21 "pattern-selector.vala"
	pasang_pattern_selector_parent_class = g_type_class_peek_parent (klass);
#line 21 "pattern-selector.vala"
	g_type_class_adjust_private_offset (klass, &PasangPatternSelector_private_offset);
#line 21 "pattern-selector.vala"
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) pasang_pattern_selector_real_size_allocate;
#line 21 "pattern-selector.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_pattern_selector_finalize;
#line 1838 "pattern-selector.c"
	/**
	     * Emitted whenever a pattern is selected.
	     */
#line 21 "pattern-selector.vala"
	pasang_pattern_selector_signals[PASANG_PATTERN_SELECTOR_PATTERN_CHANGED_SIGNAL_SIGNAL] = g_signal_new ("pattern-changed-signal", PASANG_TYPE_PATTERN_SELECTOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 1844 "pattern-selector.c"
}

static void
pasang_pattern_selector_instance_init (PasangPatternSelector * self,
                                       gpointer klass)
{
	PasangPattern* _tmp0_;
	PasangPattern* _tmp1_;
	PasangPattern* _tmp2_;
	PasangPattern* _tmp3_;
	PasangPattern* _tmp4_;
	PasangPattern* _tmp5_;
	PasangPattern* _tmp6_;
	PasangPattern* _tmp7_;
	PasangPattern* _tmp8_;
	PasangPattern* _tmp9_;
	PasangPattern* _tmp10_;
	PasangPattern* _tmp11_;
	PasangPattern* _tmp12_;
	PasangPattern* _tmp13_;
	PasangPattern* _tmp14_;
	PasangPattern* _tmp15_;
	PasangPattern* _tmp16_;
	PasangPattern* _tmp17_;
	PasangPattern* _tmp18_;
	PasangPattern* _tmp19_;
	PasangPattern* _tmp20_;
	PasangPattern* _tmp21_;
	PasangPattern* _tmp22_;
	PasangPattern* _tmp23_;
	PasangPattern* _tmp24_;
	PasangPattern* _tmp25_;
	PasangPattern* _tmp26_;
	PasangPattern* _tmp27_;
	PasangPattern* _tmp28_;
	PasangPattern* _tmp29_;
	PasangPattern* _tmp30_;
	PasangPattern* _tmp31_;
	PasangPattern* _tmp32_;
	PasangPattern* _tmp33_;
	PasangPattern* _tmp34_;
	PasangPattern* _tmp35_;
	PasangPattern* _tmp36_;
	PasangPattern* _tmp37_;
	PasangPattern* _tmp38_;
	PasangPattern* _tmp39_;
	PasangPattern* _tmp40_;
	PasangPattern* _tmp41_;
	PasangPattern* _tmp42_;
	PasangRandomPattern* _tmp43_;
	PasangRandomPattern* _tmp44_;
	PasangRandomPattern* _tmp45_;
	PasangRandomPattern* _tmp46_;
	PasangRandomPattern* _tmp47_;
	PasangRandomPattern* _tmp48_;
	PasangPattern** _tmp49_;
#line 21 "pattern-selector.vala"
	self->priv = pasang_pattern_selector_get_instance_private (self);
#line 31 "pattern-selector.vala"
	_tmp0_ = pasang_pattern_new (N_ ("Ajong Dengan Sauhnya"), "HPHHPPPHHPH PPHPPHPPHPP HHPHHPHHPHH HPHPHPHPHPH PPHHPHPHHPP PHPPH");
#line 31 "pattern-selector.vala"
	_tmp1_ = pasang_pattern_new (N_ ("Awan Berturus"), "PHPPHHHPPHP HPHPPPPPHPH PHPHHPHHPHP PPHPHHHPHPP HPHHPHPHHPH HPPHH");
#line 31 "pattern-selector.vala"
	_tmp2_ = pasang_pattern_new (N_ ("Awan Mengandung Hujan"), "PPHPHPPHHHP HPPHPHPPHPP HHHPHPHHHPH HPHHHPPHPHP PPHPPHPHHPH PHPPH");
#line 31 "pattern-selector.vala"
	_tmp3_ = pasang_pattern_new (N_ ("Awan Tunjung"), "PHHPPHPPHPP PPHHPHPHPPH HPPHHPHHPHH PHHHHPPHHHP PPHPPHPHHPP HHPPH");
#line 31 "pattern-selector.vala"
	_tmp4_ = pasang_pattern_new (N_ ("Bangkawat / Awan Menurus"), "PHHPPHHPPHP HHPPHHPPHHH HPPHHPPHPHP PPHHPPHHHPP PHHPPHPHPPH HHPPH");
#line 31 "pattern-selector.vala"
	_tmp5_ = pasang_pattern_new (N_ ("Bangkawat Kudung"), "PPHHPPHHHHP HPPHHPPHHPP HHPPHHPHPPH HHHPPHHPPHH HPPHPPPPHHP PPHHP");
#line 31 "pattern-selector.vala"
	_tmp6_ = pasang_pattern_new (N_ ("Bintang Terhambur"), "HPHPHPHPHPH PHPHPHPHPHP HPHPHPHPHPH PHPHPHPHPHP HPHPHPHPHPH PHPHP");
#line 31 "pattern-selector.vala"
	_tmp7_ = pasang_pattern_new (N_ ("Bunga Bercucuk"), "PPHHHHHHHPP PPPHHPHHPPP HPPPHPHPPPH HHPPPHPPPHH HHHPPHPPHHH HPPHH");
#line 31 "pattern-selector.vala"
	_tmp8_ = pasang_pattern_new (N_ ("Bunga Kambang Kiapu"), "HPHHPPPHHPH PPHPHPHPHPP HHPHPHPHPHH HPHPHPHPHPH PHPHPHPHPHP PPHPH");
#line 31 "pattern-selector.vala"
	_tmp9_ = pasang_pattern_new (N_ ("Bunga Kembang Berhujan"), "PPHPPHPPHHP HPHHPHHPHPP HHPPHHPHPHH PPHHPPHHPHP PHPHHPHPHPP HHHPP");
#line 31 "pattern-selector.vala"
	_tmp10_ = pasang_pattern_new (N_ ("Bunga Sepapan"), "PPHPPHPPHPP PHHHPHPHHHP HHPPHHHPPHH PHPHHPPHPHP PPHPPHPHHPP HHHPH");
#line 31 "pattern-selector.vala"
	_tmp11_ = pasang_pattern_new (N_ ("Galap Madam"), "PPPPPHHHHHP HHHHHPPPPHP HPPPPHHHPHP HPHHHPPHPHP HPHPPHPHPHP HPHPH");
#line 31 "pattern-selector.vala"
	_tmp12_ = pasang_pattern_new (N_ ("Ikan Bernang"), "PHHHPPPHHHP HPPHHPHHPPH HPPPHPHPPPH HHPPHPHPPHH PHHHPHPHHHP PPPPH");
#line 31 "pattern-selector.vala"
	_tmp13_ = pasang_pattern_new (N_ ("Kalabutan"), "HPPHHPHHPPH PPHPHHHPHPP PHPHPHPHPHP HPHPPHPPHPH HHPPHPHPPHH PHHHP");
#line 31 "pattern-selector.vala"
	_tmp14_ = pasang_pattern_new (N_ ("Kalabutan Berdarah Hitam"), "HHPPHPHPPHH HPHHPHPHHPH PHPPHPHPPHP PHPPHPHPPHP HPHHPHPHHPH PHPPH");
#line 31 "pattern-selector.vala"
	_tmp15_ = pasang_pattern_new (N_ ("Kalajangking 1"), "HPHPHPHPHPH PPHPPHPPHPP HHPHHPHHPHH PPHPPHPPHPP HPHPHHHPHPH PHPHH");
#line 31 "pattern-selector.vala"
	_tmp16_ = pasang_pattern_new (N_ ("Kalajangking 2"), "HPHHPHPHHPH PPHPPHPPHPP HHPHHPHHPHH HPHPPHPPHPH PPHPHPHPHPP HHPHP");
#line 31 "pattern-selector.vala"
	_tmp17_ = pasang_pattern_new (N_ ("Kedudukan Dian"), "PHPPHPHPPHP HPHPHPHPHPH PHPHPHPHPHP PPHPHHHPHPP HHPHPHPHPHH PPHHH");
#line 31 "pattern-selector.vala"
	_tmp18_ = pasang_pattern_new (N_ ("Kina Putar"), "HPPHHPPHPHH HHPPHHPPHHP PHHPPHHPHPP HPPHPPHHPPH PPHHHPHPPHH PHHPP");
#line 31 "pattern-selector.vala"
	_tmp19_ = pasang_pattern_new (N_ ("Lasung-Lasung"), "HPPPPHHHHPH PHHHHPPPHHP HHPPPHHPPHP HPPHHPHHPHP HPHHPPPHPHP HPHPP");
#line 31 "pattern-selector.vala"
	_tmp20_ = pasang_pattern_new (N_ ("Lungun Sipugut"), "PPHPHPHPHPP PPHHPHPHHPP HHPHHPHHPHH PHHPPHPPHHP HPHPHPHPHPH PHPHP");
#line 31 "pattern-selector.vala"
	_tmp21_ = pasang_pattern_new (N_ ("Mahligai Bergantung Bertali"), "PHPPHPHPPHP HHHPPHPPHHH PHPHPHPHPHP PPHHHPHHHPP HPPHPHPHPPH PHHPH");
#line 31 "pattern-selector.vala"
	_tmp22_ = pasang_pattern_new (N_ ("Mayang Piasau"), "PHHPPHHHPPP PHPHPPPHPHH PPHHPHPHHPH HHHPHPHPHHP HPPHPHPHPPP HPHPH");
#line 31 "pattern-selector.vala"
	_tmp23_ = pasang_pattern_new (N_ ("Pagar Batu"), "PHHPPHPPHHP HPPHHPHHPPH HPPHPHPHPPH PHHPHPHPHHP PHPHPHPHPHP HPHPH");
#line 31 "pattern-selector.vala"
	_tmp24_ = pasang_pattern_new (N_ ("Paha Ayam"), "PPPPPHHHHHP HPPPPHHHHPP HHPPPHHHPPP HHHPPHHPPPP HHHHPHPPPPP HHHHH");
#line 31 "pattern-selector.vala"
	_tmp25_ = pasang_pattern_new (N_ ("Paita"), "HPPHPHPHPPH PPHHHPHHHPP PHHPPHPPHHP HHPPPHPPPHH PHPPHHHPPHP HPHHH");
#line 31 "pattern-selector.vala"
	_tmp26_ = pasang_pattern_new (N_ ("Patah-Patah"), "HPHPPHPPHPH PPHPHHHPHPP HHHPHPHPHHH PPPHPHPHPPP PHHPPHPPHHP HHPHH");
#line 31 "pattern-selector.vala"
	_tmp27_ = pasang_pattern_new (N_ ("Peria Bulat"), "PPHHHPHHHPP PPPHHPHHPPP HPPPHHHPPPH HHPPPHPPPHH HHHPPHPPHHH PPHHH");
#line 31 "pattern-selector.vala"
	_tmp28_ = pasang_pattern_new (N_ ("Peria Buruk Hatinya"), "HPPHPHPHPPH PHPHHPHHPHP PPHPPHPPHPP HHPHPHPHPHH PHPPHHHPPHP HPHHH");
#line 31 "pattern-selector.vala"
	_tmp29_ = pasang_pattern_new (N_ ("Peria Buruk Sepanggal"), "HPPHPPPHHPH PPPHHHHHPPP HPHHHPPHHPP HHHPHPPPHHH PHPPPHPHHHP PHPPH");
#line 31 "pattern-selector.vala"
	_tmp30_ = pasang_pattern_new (N_ ("Peria Sejambangan"), "HPPHPHPHPPH PPHHHPHHHPP PHPPHPHPPHP HHPHPHPHPHH PHHPPHPPHHP HPPHH");
#line 31 "pattern-selector.vala"
	_tmp31_ = pasang_pattern_new (N_ ("Pucuk Rebung"), "HHPHPPPHPHH HPPHHPHHPPH PPPPHPHPPPP HHPPHHHPPHH PHHHPHPHHHP PPPHH");
#line 31 "pattern-selector.vala"
	_tmp32_ = pasang_pattern_new (N_ ("Puncak Mahligai"), "PHPHHPHHPHP HPHPPPPPHPH PHHHPPPHHHP HPHHHPHHHPH HPPHHPHHPPH PPPPP");
#line 31 "pattern-selector.vala"
	_tmp33_ = pasang_pattern_new (N_ ("Saputangan Jatuh Ke Laut"), "HPPHHPHHPPH PPHHPHPHHPP PHPPHPHPPHP HHPHHPPHPHH HPHPPHPHHPH PHPPH");
#line 31 "pattern-selector.vala"
	_tmp34_ = pasang_pattern_new (N_ ("Sarimbangun"), "HPPHPHPHPPH PPHPPHPPHPP PHPHHHHHPHP HPHPPHPPHPH PPHPHHHPHPP HHHHH");
#line 31 "pattern-selector.vala"
	_tmp35_ = pasang_pattern_new (N_ ("Selidan Putar"), "PHHPHPPHHPP PPHHPPHHPPH HPPHPHHPPHH HHPPHHPPHHP PHHPPHPHPPH PPHHH");
#line 31 "pattern-selector.vala"
	_tmp36_ = pasang_pattern_new (N_ ("Si Pugut Menunggu Beringin Buruk Hatinya"), "HPHPPHPPHPH PHPHHPHHPHP HPHPHPHPHPH PHPHPHPHPHP PHHPPHPPHHP HPPHH");
#line 31 "pattern-selector.vala"
	_tmp37_ = pasang_pattern_new (N_ ("Sisir Sepapan"), "HPPHHPPHPPH PPHHPPHHHPP PHPHPHHPPHP HHPPHHPPHHH PHHPPHPHPPH PPHHH");
#line 31 "pattern-selector.vala"
	_tmp38_ = pasang_pattern_new (N_ ("Talapok Berantai"), "HPHHHPHHHPH PPPHPHPHPPP HPHPHPHPHPH HHPHPPPHPHH HPHPHPHPHPH PHPPP");
#line 31 "pattern-selector.vala"
	_tmp39_ = pasang_pattern_new (N_ ("Talapok Sepapan"), "HPHHHPHHHPH PPPHPPPHPPP HPHPHPHPHPH HHPPPHPPPHH HPHPHHHPHPH PPPHH");
#line 31 "pattern-selector.vala"
	_tmp40_ = pasang_pattern_new (N_ ("Tekuyong Naik Pasang"), "PHPHPHPHPHP HPHPHPHPHPH PHPHPHPHPHP HPHPPHPPHPH PHPPHHHPPHP HPHHH");
#line 31 "pattern-selector.vala"
	_tmp41_ = pasang_pattern_new (N_ ("Tikus Naik Ke Durong"), "HPHHPPPHHPH PPPHPHPHPPP HPPHHPHHPPH HHHPHPHPHHH PPHHPHPHHPP PHPPH");
#line 31 "pattern-selector.vala"
	_tmp42_ = pasang_pattern_new (N_ ("Tudung Dulang"), "PHPHPHPHPHP HPPHPHPHPPH PPHHPHPHHPP HHHPPHPPHHH PPPPHHHPPPP HHHHH");
#line 31 "pattern-selector.vala"
	_tmp43_ = pasang_random_pattern_new (N_ ("Gardens"), " J J J O X OfJf");
#line 31 "pattern-selector.vala"
	_tmp44_ = pasang_random_pattern_new (N_ ("Day and Night"), " d");
#line 31 "pattern-selector.vala"
	_tmp45_ = pasang_random_pattern_new (N_ ("Fans"), " R R R * *fRf Rf*f");
#line 31 "pattern-selector.vala"
	_tmp46_ = pasang_random_pattern_new (N_ ("Folds"), " Rt Rt Rt *t RtJf JfRt");
#line 31 "pattern-selector.vala"
	_tmp47_ = pasang_random_pattern_new (N_ ("Oblique Folds"), " JL JL Xs JLJf JfJL");
#line 31 "pattern-selector.vala"
	_tmp48_ = pasang_random_pattern_new (N_ ("Whatever"), " RR RR RR *? ** *?*? d");
#line 31 "pattern-selector.vala"
	_tmp49_ = g_new0 (PasangPattern*, 49 + 1);
#line 31 "pattern-selector.vala"
	_tmp49_[0] = _tmp0_;
#line 31 "pattern-selector.vala"
	_tmp49_[1] = _tmp1_;
#line 31 "pattern-selector.vala"
	_tmp49_[2] = _tmp2_;
#line 31 "pattern-selector.vala"
	_tmp49_[3] = _tmp3_;
#line 31 "pattern-selector.vala"
	_tmp49_[4] = _tmp4_;
#line 31 "pattern-selector.vala"
	_tmp49_[5] = _tmp5_;
#line 31 "pattern-selector.vala"
	_tmp49_[6] = _tmp6_;
#line 31 "pattern-selector.vala"
	_tmp49_[7] = _tmp7_;
#line 31 "pattern-selector.vala"
	_tmp49_[8] = _tmp8_;
#line 31 "pattern-selector.vala"
	_tmp49_[9] = _tmp9_;
#line 31 "pattern-selector.vala"
	_tmp49_[10] = _tmp10_;
#line 31 "pattern-selector.vala"
	_tmp49_[11] = _tmp11_;
#line 31 "pattern-selector.vala"
	_tmp49_[12] = _tmp12_;
#line 31 "pattern-selector.vala"
	_tmp49_[13] = _tmp13_;
#line 31 "pattern-selector.vala"
	_tmp49_[14] = _tmp14_;
#line 31 "pattern-selector.vala"
	_tmp49_[15] = _tmp15_;
#line 31 "pattern-selector.vala"
	_tmp49_[16] = _tmp16_;
#line 31 "pattern-selector.vala"
	_tmp49_[17] = _tmp17_;
#line 31 "pattern-selector.vala"
	_tmp49_[18] = _tmp18_;
#line 31 "pattern-selector.vala"
	_tmp49_[19] = _tmp19_;
#line 31 "pattern-selector.vala"
	_tmp49_[20] = _tmp20_;
#line 31 "pattern-selector.vala"
	_tmp49_[21] = _tmp21_;
#line 31 "pattern-selector.vala"
	_tmp49_[22] = _tmp22_;
#line 31 "pattern-selector.vala"
	_tmp49_[23] = _tmp23_;
#line 31 "pattern-selector.vala"
	_tmp49_[24] = _tmp24_;
#line 31 "pattern-selector.vala"
	_tmp49_[25] = _tmp25_;
#line 31 "pattern-selector.vala"
	_tmp49_[26] = _tmp26_;
#line 31 "pattern-selector.vala"
	_tmp49_[27] = _tmp27_;
#line 31 "pattern-selector.vala"
	_tmp49_[28] = _tmp28_;
#line 31 "pattern-selector.vala"
	_tmp49_[29] = _tmp29_;
#line 31 "pattern-selector.vala"
	_tmp49_[30] = _tmp30_;
#line 31 "pattern-selector.vala"
	_tmp49_[31] = _tmp31_;
#line 31 "pattern-selector.vala"
	_tmp49_[32] = _tmp32_;
#line 31 "pattern-selector.vala"
	_tmp49_[33] = _tmp33_;
#line 31 "pattern-selector.vala"
	_tmp49_[34] = _tmp34_;
#line 31 "pattern-selector.vala"
	_tmp49_[35] = _tmp35_;
#line 31 "pattern-selector.vala"
	_tmp49_[36] = _tmp36_;
#line 31 "pattern-selector.vala"
	_tmp49_[37] = _tmp37_;
#line 31 "pattern-selector.vala"
	_tmp49_[38] = _tmp38_;
#line 31 "pattern-selector.vala"
	_tmp49_[39] = _tmp39_;
#line 31 "pattern-selector.vala"
	_tmp49_[40] = _tmp40_;
#line 31 "pattern-selector.vala"
	_tmp49_[41] = _tmp41_;
#line 31 "pattern-selector.vala"
	_tmp49_[42] = _tmp42_;
#line 31 "pattern-selector.vala"
	_tmp49_[43] = (PasangPattern*) _tmp43_;
#line 31 "pattern-selector.vala"
	_tmp49_[44] = (PasangPattern*) _tmp44_;
#line 31 "pattern-selector.vala"
	_tmp49_[45] = (PasangPattern*) _tmp45_;
#line 31 "pattern-selector.vala"
	_tmp49_[46] = (PasangPattern*) _tmp46_;
#line 31 "pattern-selector.vala"
	_tmp49_[47] = (PasangPattern*) _tmp47_;
#line 31 "pattern-selector.vala"
	_tmp49_[48] = (PasangPattern*) _tmp48_;
#line 31 "pattern-selector.vala"
	self->priv->core_patterns = _tmp49_;
#line 31 "pattern-selector.vala"
	self->priv->core_patterns_length1 = 49;
#line 31 "pattern-selector.vala"
	self->priv->_core_patterns_size_ = self->priv->core_patterns_length1;
#line 282 "pattern-selector.vala"
	self->priv->cooling_ticket = 0;
#line 287 "pattern-selector.vala"
	self->priv->responsive = TRUE;
#line 292 "pattern-selector.vala"
	self->priv->ignore_signal = FALSE;
#line 2113 "pattern-selector.c"
}

static void
pasang_pattern_selector_finalize (GObject * obj)
{
	PasangPatternSelector * self;
#line 21 "pattern-selector.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_PATTERN_SELECTOR, PasangPatternSelector);
#line 31 "pattern-selector.vala"
	self->priv->core_patterns = (_vala_array_free (self->priv->core_patterns, self->priv->core_patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 271 "pattern-selector.vala"
	self->priv->patterns = (_vala_array_free (self->priv->patterns, self->priv->patterns_length1, (GDestroyNotify) pasang_pattern_unref), NULL);
#line 277 "pattern-selector.vala"
	_pasang_pattern_unref0 (self->priv->recent_pattern);
#line 297 "pattern-selector.vala"
	_g_object_unref0 (self->priv->invisible_button);
#line 302 "pattern-selector.vala"
	_g_object_unref0 (self->priv->pattern_box);
#line 21 "pattern-selector.vala"
	G_OBJECT_CLASS (pasang_pattern_selector_parent_class)->finalize (obj);
#line 2134 "pattern-selector.c"
}

GType
pasang_pattern_selector_get_type (void)
{
	static volatile gsize pasang_pattern_selector_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_pattern_selector_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangPatternSelectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_pattern_selector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangPatternSelector), 0, (GInstanceInitFunc) pasang_pattern_selector_instance_init, NULL };
		GType pasang_pattern_selector_type_id;
		pasang_pattern_selector_type_id = g_type_register_static (gtk_scrolled_window_get_type (), "PasangPatternSelector", &g_define_type_info, 0);
		PasangPatternSelector_private_offset = g_type_add_instance_private (pasang_pattern_selector_type_id, sizeof (PasangPatternSelectorPrivate));
		g_once_init_leave (&pasang_pattern_selector_type_id__volatile, pasang_pattern_selector_type_id);
	}
	return pasang_pattern_selector_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

