// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceAllHTTPRequestRuleFrontendOKCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleFrontendOK
const ReplaceAllHTTPRequestRuleFrontendOKCode int = 200

/*
ReplaceAllHTTPRequestRuleFrontendOK All HTTP Request Rule lines replaced

swagger:response replaceAllHttpRequestRuleFrontendOK
*/
type ReplaceAllHTTPRequestRuleFrontendOK struct {

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleFrontendOK creates ReplaceAllHTTPRequestRuleFrontendOK with default headers values
func NewReplaceAllHTTPRequestRuleFrontendOK() *ReplaceAllHTTPRequestRuleFrontendOK {

	return &ReplaceAllHTTPRequestRuleFrontendOK{}
}

// WithPayload adds the payload to the replace all Http request rule frontend o k response
func (o *ReplaceAllHTTPRequestRuleFrontendOK) WithPayload(payload models.HTTPRequestRules) *ReplaceAllHTTPRequestRuleFrontendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule frontend o k response
func (o *ReplaceAllHTTPRequestRuleFrontendOK) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleFrontendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPRequestRuleFrontendAcceptedCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleFrontendAccepted
const ReplaceAllHTTPRequestRuleFrontendAcceptedCode int = 202

/*
ReplaceAllHTTPRequestRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response replaceAllHttpRequestRuleFrontendAccepted
*/
type ReplaceAllHTTPRequestRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload models.HTTPRequestRules `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleFrontendAccepted creates ReplaceAllHTTPRequestRuleFrontendAccepted with default headers values
func NewReplaceAllHTTPRequestRuleFrontendAccepted() *ReplaceAllHTTPRequestRuleFrontendAccepted {

	return &ReplaceAllHTTPRequestRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the replace all Http request rule frontend accepted response
func (o *ReplaceAllHTTPRequestRuleFrontendAccepted) WithReloadID(reloadID string) *ReplaceAllHTTPRequestRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace all Http request rule frontend accepted response
func (o *ReplaceAllHTTPRequestRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace all Http request rule frontend accepted response
func (o *ReplaceAllHTTPRequestRuleFrontendAccepted) WithPayload(payload models.HTTPRequestRules) *ReplaceAllHTTPRequestRuleFrontendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule frontend accepted response
func (o *ReplaceAllHTTPRequestRuleFrontendAccepted) SetPayload(payload models.HTTPRequestRules) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.HTTPRequestRules{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// ReplaceAllHTTPRequestRuleFrontendBadRequestCode is the HTTP code returned for type ReplaceAllHTTPRequestRuleFrontendBadRequest
const ReplaceAllHTTPRequestRuleFrontendBadRequestCode int = 400

/*
ReplaceAllHTTPRequestRuleFrontendBadRequest Bad request

swagger:response replaceAllHttpRequestRuleFrontendBadRequest
*/
type ReplaceAllHTTPRequestRuleFrontendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleFrontendBadRequest creates ReplaceAllHTTPRequestRuleFrontendBadRequest with default headers values
func NewReplaceAllHTTPRequestRuleFrontendBadRequest() *ReplaceAllHTTPRequestRuleFrontendBadRequest {

	return &ReplaceAllHTTPRequestRuleFrontendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace all Http request rule frontend bad request response
func (o *ReplaceAllHTTPRequestRuleFrontendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPRequestRuleFrontendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all Http request rule frontend bad request response
func (o *ReplaceAllHTTPRequestRuleFrontendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all Http request rule frontend bad request response
func (o *ReplaceAllHTTPRequestRuleFrontendBadRequest) WithPayload(payload *models.Error) *ReplaceAllHTTPRequestRuleFrontendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all Http request rule frontend bad request response
func (o *ReplaceAllHTTPRequestRuleFrontendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleFrontendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceAllHTTPRequestRuleFrontendDefault General Error

swagger:response replaceAllHttpRequestRuleFrontendDefault
*/
type ReplaceAllHTTPRequestRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceAllHTTPRequestRuleFrontendDefault creates ReplaceAllHTTPRequestRuleFrontendDefault with default headers values
func NewReplaceAllHTTPRequestRuleFrontendDefault(code int) *ReplaceAllHTTPRequestRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceAllHTTPRequestRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) WithStatusCode(code int) *ReplaceAllHTTPRequestRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceAllHTTPRequestRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) WithPayload(payload *models.Error) *ReplaceAllHTTPRequestRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace all HTTP request rule frontend default response
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceAllHTTPRequestRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
