// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package stick_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteStickRuleAcceptedCode is the HTTP code returned for type DeleteStickRuleAccepted
const DeleteStickRuleAcceptedCode int = 202

/*
DeleteStickRuleAccepted Configuration change accepted and reload requested

swagger:response deleteStickRuleAccepted
*/
type DeleteStickRuleAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteStickRuleAccepted creates DeleteStickRuleAccepted with default headers values
func NewDeleteStickRuleAccepted() *DeleteStickRuleAccepted {

	return &DeleteStickRuleAccepted{}
}

// WithReloadID adds the reloadId to the delete stick rule accepted response
func (o *DeleteStickRuleAccepted) WithReloadID(reloadID string) *DeleteStickRuleAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete stick rule accepted response
func (o *DeleteStickRuleAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteStickRuleAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteStickRuleNoContentCode is the HTTP code returned for type DeleteStickRuleNoContent
const DeleteStickRuleNoContentCode int = 204

/*
DeleteStickRuleNoContent Stick Rule deleted

swagger:response deleteStickRuleNoContent
*/
type DeleteStickRuleNoContent struct {
}

// NewDeleteStickRuleNoContent creates DeleteStickRuleNoContent with default headers values
func NewDeleteStickRuleNoContent() *DeleteStickRuleNoContent {

	return &DeleteStickRuleNoContent{}
}

// WriteResponse to the client
func (o *DeleteStickRuleNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteStickRuleNotFoundCode is the HTTP code returned for type DeleteStickRuleNotFound
const DeleteStickRuleNotFoundCode int = 404

/*
DeleteStickRuleNotFound The specified resource was not found

swagger:response deleteStickRuleNotFound
*/
type DeleteStickRuleNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteStickRuleNotFound creates DeleteStickRuleNotFound with default headers values
func NewDeleteStickRuleNotFound() *DeleteStickRuleNotFound {

	return &DeleteStickRuleNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete stick rule not found response
func (o *DeleteStickRuleNotFound) WithConfigurationVersion(configurationVersion string) *DeleteStickRuleNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete stick rule not found response
func (o *DeleteStickRuleNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete stick rule not found response
func (o *DeleteStickRuleNotFound) WithPayload(payload *models.Error) *DeleteStickRuleNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete stick rule not found response
func (o *DeleteStickRuleNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteStickRuleNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteStickRuleDefault General Error

swagger:response deleteStickRuleDefault
*/
type DeleteStickRuleDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteStickRuleDefault creates DeleteStickRuleDefault with default headers values
func NewDeleteStickRuleDefault(code int) *DeleteStickRuleDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteStickRuleDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete stick rule default response
func (o *DeleteStickRuleDefault) WithStatusCode(code int) *DeleteStickRuleDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete stick rule default response
func (o *DeleteStickRuleDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete stick rule default response
func (o *DeleteStickRuleDefault) WithConfigurationVersion(configurationVersion string) *DeleteStickRuleDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete stick rule default response
func (o *DeleteStickRuleDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete stick rule default response
func (o *DeleteStickRuleDefault) WithPayload(payload *models.Error) *DeleteStickRuleDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete stick rule default response
func (o *DeleteStickRuleDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteStickRuleDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
