// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package table

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTableOKCode is the HTTP code returned for type GetTableOK
const GetTableOKCode int = 200

/*
GetTableOK Successful operation

swagger:response getTableOK
*/
type GetTableOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Table `json:"body,omitempty"`
}

// NewGetTableOK creates GetTableOK with default headers values
func NewGetTableOK() *GetTableOK {

	return &GetTableOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get table o k response
func (o *GetTableOK) WithConfigurationVersion(configurationVersion string) *GetTableOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get table o k response
func (o *GetTableOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get table o k response
func (o *GetTableOK) WithPayload(payload *models.Table) *GetTableOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get table o k response
func (o *GetTableOK) SetPayload(payload *models.Table) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTableOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTableNotFoundCode is the HTTP code returned for type GetTableNotFound
const GetTableNotFoundCode int = 404

/*
GetTableNotFound The specified resource already exists

swagger:response getTableNotFound
*/
type GetTableNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTableNotFound creates GetTableNotFound with default headers values
func NewGetTableNotFound() *GetTableNotFound {

	return &GetTableNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get table not found response
func (o *GetTableNotFound) WithConfigurationVersion(configurationVersion string) *GetTableNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get table not found response
func (o *GetTableNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get table not found response
func (o *GetTableNotFound) WithPayload(payload *models.Error) *GetTableNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get table not found response
func (o *GetTableNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTableNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTableDefault General Error

swagger:response getTableDefault
*/
type GetTableDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTableDefault creates GetTableDefault with default headers values
func NewGetTableDefault(code int) *GetTableDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTableDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get table default response
func (o *GetTableDefault) WithStatusCode(code int) *GetTableDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get table default response
func (o *GetTableDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get table default response
func (o *GetTableDefault) WithConfigurationVersion(configurationVersion string) *GetTableDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get table default response
func (o *GetTableDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get table default response
func (o *GetTableDefault) WithPayload(payload *models.Error) *GetTableDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get table default response
func (o *GetTableDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTableDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
