// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_check

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetTCPCheckBackendOKCode is the HTTP code returned for type GetTCPCheckBackendOK
const GetTCPCheckBackendOKCode int = 200

/*
GetTCPCheckBackendOK Successful operation

swagger:response getTcpCheckBackendOK
*/
type GetTCPCheckBackendOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.TCPCheck `json:"body,omitempty"`
}

// NewGetTCPCheckBackendOK creates GetTCPCheckBackendOK with default headers values
func NewGetTCPCheckBackendOK() *GetTCPCheckBackendOK {

	return &GetTCPCheckBackendOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp check backend o k response
func (o *GetTCPCheckBackendOK) WithConfigurationVersion(configurationVersion string) *GetTCPCheckBackendOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp check backend o k response
func (o *GetTCPCheckBackendOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp check backend o k response
func (o *GetTCPCheckBackendOK) WithPayload(payload *models.TCPCheck) *GetTCPCheckBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp check backend o k response
func (o *GetTCPCheckBackendOK) SetPayload(payload *models.TCPCheck) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetTCPCheckBackendNotFoundCode is the HTTP code returned for type GetTCPCheckBackendNotFound
const GetTCPCheckBackendNotFoundCode int = 404

/*
GetTCPCheckBackendNotFound The specified resource was not found

swagger:response getTcpCheckBackendNotFound
*/
type GetTCPCheckBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPCheckBackendNotFound creates GetTCPCheckBackendNotFound with default headers values
func NewGetTCPCheckBackendNotFound() *GetTCPCheckBackendNotFound {

	return &GetTCPCheckBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get Tcp check backend not found response
func (o *GetTCPCheckBackendNotFound) WithConfigurationVersion(configurationVersion string) *GetTCPCheckBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get Tcp check backend not found response
func (o *GetTCPCheckBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get Tcp check backend not found response
func (o *GetTCPCheckBackendNotFound) WithPayload(payload *models.Error) *GetTCPCheckBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get Tcp check backend not found response
func (o *GetTCPCheckBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetTCPCheckBackendDefault General Error

swagger:response getTcpCheckBackendDefault
*/
type GetTCPCheckBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTCPCheckBackendDefault creates GetTCPCheckBackendDefault with default headers values
func NewGetTCPCheckBackendDefault(code int) *GetTCPCheckBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTCPCheckBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) WithStatusCode(code int) *GetTCPCheckBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) WithConfigurationVersion(configurationVersion string) *GetTCPCheckBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) WithPayload(payload *models.Error) *GetTCPCheckBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get TCP check backend default response
func (o *GetTCPCheckBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTCPCheckBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
