/*
 * conn.h
 *
 * Copyright (C) 2002 Thomas Graf <tgr@reeler.org>
 *
 * This file belongs to the nstats package, see COPYING for more information.
 *
 */

#ifndef CONN_H_
#define CONN_H_

#include <pcap.h>

void clean_ports(void);
void clean_conns(void);
void fill_ports(void);
void sort_ports(void);
void sort_conns(void);

void calc_conn_rate(void);

void handle_port(int sp, int dp, char *saddr, char *daddr, int type,
            const struct pcap_pkthdr *hdr);

void expire_conns(int secs);

#endif
