/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.prism.NGLine;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.css.StyleableProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;

public class Line
extends Shape {
    private final Line2D shape = new Line2D();
    private final DoubleProperty startX;
    private final DoubleProperty startY;
    private final DoubleProperty endX;
    private final DoubleProperty endY;

    public Line() {
        ((StyleableProperty)((Object)this.fillProperty())).applyStyle(null, null);
        ((StyleableProperty)((Object)this.strokeProperty())).applyStyle(null, Color.BLACK);
        this.startX = new DoublePropertyBase(){

            @Override
            public void invalidated() {
                Line.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                Line.this.impl_geomChanged();
            }

            @Override
            public Object getBean() {
                return Line.this;
            }

            @Override
            public String getName() {
                return "startX";
            }
        };
        this.startY = new DoublePropertyBase(){

            @Override
            public void invalidated() {
                Line.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                Line.this.impl_geomChanged();
            }

            @Override
            public Object getBean() {
                return Line.this;
            }

            @Override
            public String getName() {
                return "startY";
            }
        };
        this.endX = new DoublePropertyBase(){

            @Override
            public void invalidated() {
                Line.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                Line.this.impl_geomChanged();
            }

            @Override
            public Object getBean() {
                return Line.this;
            }

            @Override
            public String getName() {
                return "endX";
            }
        };
        this.endY = new DoublePropertyBase(){

            @Override
            public void invalidated() {
                Line.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                Line.this.impl_geomChanged();
            }

            @Override
            public Object getBean() {
                return Line.this;
            }

            @Override
            public String getName() {
                return "endY";
            }
        };
    }

    public Line(double startX, double startY, double endX, double endY) {
        ((StyleableProperty)((Object)this.fillProperty())).applyStyle(null, null);
        ((StyleableProperty)((Object)this.strokeProperty())).applyStyle(null, Color.BLACK);
        this.startX = new /* invalid duplicate definition of identical inner class */;
        this.startY = new /* invalid duplicate definition of identical inner class */;
        this.endX = new /* invalid duplicate definition of identical inner class */;
        this.endY = new /* invalid duplicate definition of identical inner class */;
        this.setStartX(startX);
        this.setStartY(startY);
        this.setEndX(endX);
        this.setEndY(endY);
    }

    public final void setStartX(double value) {
        this.startX.set(value);
    }

    public final double getStartX() {
        return this.startX.get();
    }

    public final DoubleProperty startXProperty() {
        return this.startX;
    }

    public final void setStartY(double value) {
        this.startY.set(value);
    }

    public final double getStartY() {
        return this.startY.get();
    }

    public final DoubleProperty startYProperty() {
        return this.startY;
    }

    public final void setEndX(double value) {
        this.endX.set(value);
    }

    public final double getEndX() {
        return this.endX.get();
    }

    public final DoubleProperty endXProperty() {
        return this.endX;
    }

    public final void setEndY(double value) {
        this.endY.set(value);
    }

    public final double getEndY() {
        return this.endY.get();
    }

    public final DoubleProperty endYProperty() {
        return this.endY;
    }

    @Override
    @Deprecated
    protected NGNode impl_createPeer() {
        return new NGLine();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        double ecy;
        double ecx;
        if (this.impl_mode == NGShape.Mode.FILL || this.impl_mode == NGShape.Mode.EMPTY || this.getStrokeType() == StrokeType.INSIDE) {
            return bounds.makeEmpty();
        }
        double x1 = this.getStartX();
        double x2 = this.getEndX();
        double y1 = this.getStartY();
        double y2 = this.getEndY();
        double wpad = this.getStrokeWidth();
        if (this.getStrokeType() == StrokeType.CENTERED) {
            wpad /= 2.0;
        }
        if (tx.isTranslateOrIdentity()) {
            double t;
            double xpad;
            double ypad;
            wpad = Math.max(wpad, 0.5);
            if (tx.getType() == 1) {
                double ddx = tx.getMxt();
                double ddy = tx.getMyt();
                x1 += ddx;
                y1 += ddy;
                x2 += ddx;
                y2 += ddy;
            }
            if (y1 == y2 && x1 != x2) {
                ypad = wpad;
                xpad = this.getStrokeLineCap() == StrokeLineCap.BUTT ? 0.0 : wpad;
            } else if (x1 == x2 && y1 != y2) {
                xpad = wpad;
                ypad = this.getStrokeLineCap() == StrokeLineCap.BUTT ? 0.0 : wpad;
            } else {
                if (this.getStrokeLineCap() == StrokeLineCap.SQUARE) {
                    wpad *= Math.sqrt(2.0);
                }
                xpad = ypad = wpad;
            }
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            bounds = bounds.deriveWithNewBounds((float)(x1 -= xpad), (float)(y1 -= ypad), 0.0f, (float)(x2 += xpad), (float)(y2 += ypad), 0.0f);
            return bounds;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double len = Math.sqrt(dx * dx + dy * dy);
        if (len == 0.0) {
            dx = wpad;
            dy = 0.0;
        } else {
            dx = wpad * dx / len;
            dy = wpad * dy / len;
        }
        if (this.getStrokeLineCap() != StrokeLineCap.BUTT) {
            ecx = dx;
            ecy = dy;
        } else {
            ecy = 0.0;
            ecx = 0.0;
        }
        double[] corners = new double[]{x1 - dy - ecx, y1 + dx - ecy, x1 + dy - ecx, y1 - dx - ecy, x2 + dy + ecx, y2 - dx + ecy, x2 - dy + ecx, y2 + dx + ecy};
        tx.transform(corners, 0, corners, 0, 4);
        x1 = Math.min(Math.min(corners[0], corners[2]), Math.min(corners[4], corners[6]));
        y1 = Math.min(Math.min(corners[1], corners[3]), Math.min(corners[5], corners[7]));
        x2 = Math.max(Math.max(corners[0], corners[2]), Math.max(corners[4], corners[6]));
        y2 = Math.max(Math.max(corners[1], corners[3]), Math.max(corners[5], corners[7]));
        bounds = bounds.deriveWithNewBounds((float)(x1 -= 0.5), (float)(y1 -= 0.5), 0.0f, (float)(x2 += 0.5), (float)(y2 += 0.5), 0.0f);
        return bounds;
    }

    @Override
    @Deprecated
    public Line2D impl_configShape() {
        this.shape.setLine((float)this.getStartX(), (float)this.getStartY(), (float)this.getEndX(), (float)this.getEndY());
        return this.shape;
    }

    @Override
    @Deprecated
    public void impl_updatePeer() {
        super.impl_updatePeer();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            NGLine peer = (NGLine)this.impl_getPeer();
            peer.updateLine((float)this.getStartX(), (float)this.getStartY(), (float)this.getEndX(), (float)this.getEndY());
        }
    }

    @Override
    @Deprecated
    protected Paint impl_cssGetFillInitialValue() {
        return null;
    }

    @Override
    @Deprecated
    protected Paint impl_cssGetStrokeInitialValue() {
        return Color.BLACK;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Line[");
        String id = this.getId();
        if (id != null) {
            sb.append("id=").append(id).append(", ");
        }
        sb.append("startX=").append(this.getStartX());
        sb.append(", startY=").append(this.getStartY());
        sb.append(", endX=").append(this.getEndX());
        sb.append(", endY=").append(this.getEndY());
        Paint stroke = this.getStroke();
        if (stroke != null) {
            sb.append(", stroke=").append(stroke);
            sb.append(", strokeWidth=").append(this.getStrokeWidth());
        }
        return sb.append("]").toString();
    }
}

